package software.amazon.awscdk.interfaces.scheduler;

/**
 * A reference to a ScheduleGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.scheduler.*;
 * ScheduleGroupReference scheduleGroupReference = ScheduleGroupReference.builder()
 *         .scheduleGroupArn("scheduleGroupArn")
 *         .scheduleGroupName("scheduleGroupName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.160Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_scheduler.ScheduleGroupReference")
@software.amazon.jsii.Jsii.Proxy(ScheduleGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduleGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ScheduleGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScheduleGroupArn();

    /**
     * The Name of the ScheduleGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScheduleGroupName();

    /**
     * @return a {@link Builder} of {@link ScheduleGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduleGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduleGroupReference> {
        java.lang.String scheduleGroupArn;
        java.lang.String scheduleGroupName;

        /**
         * Sets the value of {@link ScheduleGroupReference#getScheduleGroupArn}
         * @param scheduleGroupArn The ARN of the ScheduleGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleGroupArn(java.lang.String scheduleGroupArn) {
            this.scheduleGroupArn = scheduleGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleGroupReference#getScheduleGroupName}
         * @param scheduleGroupName The Name of the ScheduleGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleGroupName(java.lang.String scheduleGroupName) {
            this.scheduleGroupName = scheduleGroupName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduleGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScheduleGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScheduleGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleGroupReference {
        private final java.lang.String scheduleGroupArn;
        private final java.lang.String scheduleGroupName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scheduleGroupArn = software.amazon.jsii.Kernel.get(this, "scheduleGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduleGroupName = software.amazon.jsii.Kernel.get(this, "scheduleGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scheduleGroupArn = java.util.Objects.requireNonNull(builder.scheduleGroupArn, "scheduleGroupArn is required");
            this.scheduleGroupName = java.util.Objects.requireNonNull(builder.scheduleGroupName, "scheduleGroupName is required");
        }

        @Override
        public final java.lang.String getScheduleGroupArn() {
            return this.scheduleGroupArn;
        }

        @Override
        public final java.lang.String getScheduleGroupName() {
            return this.scheduleGroupName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("scheduleGroupArn", om.valueToTree(this.getScheduleGroupArn()));
            data.set("scheduleGroupName", om.valueToTree(this.getScheduleGroupName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_scheduler.ScheduleGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduleGroupReference.Jsii$Proxy that = (ScheduleGroupReference.Jsii$Proxy) o;

            if (!scheduleGroupArn.equals(that.scheduleGroupArn)) return false;
            return this.scheduleGroupName.equals(that.scheduleGroupName);
        }

        @Override
        public final int hashCode() {
            int result = this.scheduleGroupArn.hashCode();
            result = 31 * result + (this.scheduleGroupName.hashCode());
            return result;
        }
    }
}
