package software.amazon.awscdk.interfaces.securitylake;

/**
 * A reference to a Subscriber resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.securitylake.*;
 * SubscriberReference subscriberReference = SubscriberReference.builder()
 *         .subscriberArn("subscriberArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.186Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_securitylake.SubscriberReference")
@software.amazon.jsii.Jsii.Proxy(SubscriberReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubscriberReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The SubscriberArn of the Subscriber resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubscriberArn();

    /**
     * @return a {@link Builder} of {@link SubscriberReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubscriberReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubscriberReference> {
        java.lang.String subscriberArn;

        /**
         * Sets the value of {@link SubscriberReference#getSubscriberArn}
         * @param subscriberArn The SubscriberArn of the Subscriber resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriberArn(java.lang.String subscriberArn) {
            this.subscriberArn = subscriberArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubscriberReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubscriberReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubscriberReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubscriberReference {
        private final java.lang.String subscriberArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.subscriberArn = software.amazon.jsii.Kernel.get(this, "subscriberArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subscriberArn = java.util.Objects.requireNonNull(builder.subscriberArn, "subscriberArn is required");
        }

        @Override
        public final java.lang.String getSubscriberArn() {
            return this.subscriberArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("subscriberArn", om.valueToTree(this.getSubscriberArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_securitylake.SubscriberReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubscriberReference.Jsii$Proxy that = (SubscriberReference.Jsii$Proxy) o;

            return this.subscriberArn.equals(that.subscriberArn);
        }

        @Override
        public final int hashCode() {
            int result = this.subscriberArn.hashCode();
            return result;
        }
    }
}
