package software.amazon.awscdk.interfaces.servicecatalogappregistry;

/**
 * A reference to a ResourceAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.servicecatalogappregistry.*;
 * ResourceAssociationReference resourceAssociationReference = ResourceAssociationReference.builder()
 *         .applicationArn("applicationArn")
 *         .resourceArn("resourceArn")
 *         .resourceType("resourceType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.198Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_servicecatalogappregistry.ResourceAssociationReference")
@software.amazon.jsii.Jsii.Proxy(ResourceAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourceAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ApplicationArn of the ResourceAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationArn();

    /**
     * The ResourceArn of the ResourceAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

    /**
     * The ResourceType of the ResourceAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

    /**
     * @return a {@link Builder} of {@link ResourceAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourceAssociationReference> {
        java.lang.String applicationArn;
        java.lang.String resourceArn;
        java.lang.String resourceType;

        /**
         * Sets the value of {@link ResourceAssociationReference#getApplicationArn}
         * @param applicationArn The ApplicationArn of the ResourceAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationArn(java.lang.String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        /**
         * Sets the value of {@link ResourceAssociationReference#getResourceArn}
         * @param resourceArn The ResourceArn of the ResourceAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArn(java.lang.String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        /**
         * Sets the value of {@link ResourceAssociationReference#getResourceType}
         * @param resourceType The ResourceType of the ResourceAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourceAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourceAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceAssociationReference {
        private final java.lang.String applicationArn;
        private final java.lang.String resourceArn;
        private final java.lang.String resourceType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationArn = software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationArn = java.util.Objects.requireNonNull(builder.applicationArn, "applicationArn is required");
            this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
        }

        @Override
        public final java.lang.String getApplicationArn() {
            return this.applicationArn;
        }

        @Override
        public final java.lang.String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationArn", om.valueToTree(this.getApplicationArn()));
            data.set("resourceArn", om.valueToTree(this.getResourceArn()));
            data.set("resourceType", om.valueToTree(this.getResourceType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_servicecatalogappregistry.ResourceAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceAssociationReference.Jsii$Proxy that = (ResourceAssociationReference.Jsii$Proxy) o;

            if (!applicationArn.equals(that.applicationArn)) return false;
            if (!resourceArn.equals(that.resourceArn)) return false;
            return this.resourceType.equals(that.resourceType);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationArn.hashCode();
            result = 31 * result + (this.resourceArn.hashCode());
            result = 31 * result + (this.resourceType.hashCode());
            return result;
        }
    }
}
