package software.amazon.awscdk.interfaces.servicediscovery;

/**
 * A reference to a PrivateDnsNamespace resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.servicediscovery.*;
 * PrivateDnsNamespaceReference privateDnsNamespaceReference = PrivateDnsNamespaceReference.builder()
 *         .privateDnsNamespaceArn("privateDnsNamespaceArn")
 *         .privateDnsNamespaceId("privateDnsNamespaceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.201Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_servicediscovery.PrivateDnsNamespaceReference")
@software.amazon.jsii.Jsii.Proxy(PrivateDnsNamespaceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PrivateDnsNamespaceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the PrivateDnsNamespace resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrivateDnsNamespaceArn();

    /**
     * The Id of the PrivateDnsNamespace resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrivateDnsNamespaceId();

    /**
     * @return a {@link Builder} of {@link PrivateDnsNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PrivateDnsNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PrivateDnsNamespaceReference> {
        java.lang.String privateDnsNamespaceArn;
        java.lang.String privateDnsNamespaceId;

        /**
         * Sets the value of {@link PrivateDnsNamespaceReference#getPrivateDnsNamespaceArn}
         * @param privateDnsNamespaceArn The ARN of the PrivateDnsNamespace resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsNamespaceArn(java.lang.String privateDnsNamespaceArn) {
            this.privateDnsNamespaceArn = privateDnsNamespaceArn;
            return this;
        }

        /**
         * Sets the value of {@link PrivateDnsNamespaceReference#getPrivateDnsNamespaceId}
         * @param privateDnsNamespaceId The Id of the PrivateDnsNamespace resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsNamespaceId(java.lang.String privateDnsNamespaceId) {
            this.privateDnsNamespaceId = privateDnsNamespaceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PrivateDnsNamespaceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PrivateDnsNamespaceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PrivateDnsNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrivateDnsNamespaceReference {
        private final java.lang.String privateDnsNamespaceArn;
        private final java.lang.String privateDnsNamespaceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.privateDnsNamespaceArn = software.amazon.jsii.Kernel.get(this, "privateDnsNamespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privateDnsNamespaceId = software.amazon.jsii.Kernel.get(this, "privateDnsNamespaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.privateDnsNamespaceArn = java.util.Objects.requireNonNull(builder.privateDnsNamespaceArn, "privateDnsNamespaceArn is required");
            this.privateDnsNamespaceId = java.util.Objects.requireNonNull(builder.privateDnsNamespaceId, "privateDnsNamespaceId is required");
        }

        @Override
        public final java.lang.String getPrivateDnsNamespaceArn() {
            return this.privateDnsNamespaceArn;
        }

        @Override
        public final java.lang.String getPrivateDnsNamespaceId() {
            return this.privateDnsNamespaceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("privateDnsNamespaceArn", om.valueToTree(this.getPrivateDnsNamespaceArn()));
            data.set("privateDnsNamespaceId", om.valueToTree(this.getPrivateDnsNamespaceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_servicediscovery.PrivateDnsNamespaceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PrivateDnsNamespaceReference.Jsii$Proxy that = (PrivateDnsNamespaceReference.Jsii$Proxy) o;

            if (!privateDnsNamespaceArn.equals(that.privateDnsNamespaceArn)) return false;
            return this.privateDnsNamespaceId.equals(that.privateDnsNamespaceId);
        }

        @Override
        public final int hashCode() {
            int result = this.privateDnsNamespaceArn.hashCode();
            result = 31 * result + (this.privateDnsNamespaceId.hashCode());
            return result;
        }
    }
}
