package software.amazon.awscdk.interfaces.ses;

/**
 * A reference to a ReceiptFilter resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ses.*;
 * ReceiptFilterReference receiptFilterReference = ReceiptFilterReference.builder()
 *         .receiptFilterId("receiptFilterId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.224Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ses.ReceiptFilterReference")
@software.amazon.jsii.Jsii.Proxy(ReceiptFilterReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReceiptFilterReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the ReceiptFilter resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReceiptFilterId();

    /**
     * @return a {@link Builder} of {@link ReceiptFilterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReceiptFilterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReceiptFilterReference> {
        java.lang.String receiptFilterId;

        /**
         * Sets the value of {@link ReceiptFilterReference#getReceiptFilterId}
         * @param receiptFilterId The Id of the ReceiptFilter resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder receiptFilterId(java.lang.String receiptFilterId) {
            this.receiptFilterId = receiptFilterId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReceiptFilterReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReceiptFilterReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReceiptFilterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReceiptFilterReference {
        private final java.lang.String receiptFilterId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.receiptFilterId = software.amazon.jsii.Kernel.get(this, "receiptFilterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.receiptFilterId = java.util.Objects.requireNonNull(builder.receiptFilterId, "receiptFilterId is required");
        }

        @Override
        public final java.lang.String getReceiptFilterId() {
            return this.receiptFilterId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("receiptFilterId", om.valueToTree(this.getReceiptFilterId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ses.ReceiptFilterReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReceiptFilterReference.Jsii$Proxy that = (ReceiptFilterReference.Jsii$Proxy) o;

            return this.receiptFilterId.equals(that.receiptFilterId);
        }

        @Override
        public final int hashCode() {
            int result = this.receiptFilterId.hashCode();
            return result;
        }
    }
}
