package software.amazon.awscdk.interfaces.smsvoice;

/**
 * A reference to a PhoneNumber resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.smsvoice.*;
 * PhoneNumberReference phoneNumberReference = PhoneNumberReference.builder()
 *         .phoneNumberArn("phoneNumberArn")
 *         .phoneNumberId("phoneNumberId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.232Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_smsvoice.PhoneNumberReference")
@software.amazon.jsii.Jsii.Proxy(PhoneNumberReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PhoneNumberReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the PhoneNumber resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPhoneNumberArn();

    /**
     * The PhoneNumberId of the PhoneNumber resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPhoneNumberId();

    /**
     * @return a {@link Builder} of {@link PhoneNumberReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PhoneNumberReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PhoneNumberReference> {
        java.lang.String phoneNumberArn;
        java.lang.String phoneNumberId;

        /**
         * Sets the value of {@link PhoneNumberReference#getPhoneNumberArn}
         * @param phoneNumberArn The ARN of the PhoneNumber resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phoneNumberArn(java.lang.String phoneNumberArn) {
            this.phoneNumberArn = phoneNumberArn;
            return this;
        }

        /**
         * Sets the value of {@link PhoneNumberReference#getPhoneNumberId}
         * @param phoneNumberId The PhoneNumberId of the PhoneNumber resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phoneNumberId(java.lang.String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PhoneNumberReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PhoneNumberReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PhoneNumberReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PhoneNumberReference {
        private final java.lang.String phoneNumberArn;
        private final java.lang.String phoneNumberId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.phoneNumberArn = software.amazon.jsii.Kernel.get(this, "phoneNumberArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.phoneNumberId = software.amazon.jsii.Kernel.get(this, "phoneNumberId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.phoneNumberArn = java.util.Objects.requireNonNull(builder.phoneNumberArn, "phoneNumberArn is required");
            this.phoneNumberId = java.util.Objects.requireNonNull(builder.phoneNumberId, "phoneNumberId is required");
        }

        @Override
        public final java.lang.String getPhoneNumberArn() {
            return this.phoneNumberArn;
        }

        @Override
        public final java.lang.String getPhoneNumberId() {
            return this.phoneNumberId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("phoneNumberArn", om.valueToTree(this.getPhoneNumberArn()));
            data.set("phoneNumberId", om.valueToTree(this.getPhoneNumberId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_smsvoice.PhoneNumberReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PhoneNumberReference.Jsii$Proxy that = (PhoneNumberReference.Jsii$Proxy) o;

            if (!phoneNumberArn.equals(that.phoneNumberArn)) return false;
            return this.phoneNumberId.equals(that.phoneNumberId);
        }

        @Override
        public final int hashCode() {
            int result = this.phoneNumberArn.hashCode();
            result = 31 * result + (this.phoneNumberId.hashCode());
            return result;
        }
    }
}
