package software.amazon.awscdk.interfaces.smsvoice;

/**
 * A reference to a SenderId resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.smsvoice.*;
 * SenderIdReference senderIdReference = SenderIdReference.builder()
 *         .isoCountryCode("isoCountryCode")
 *         .senderId("senderId")
 *         .senderIdArn("senderIdArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.234Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_smsvoice.SenderIdReference")
@software.amazon.jsii.Jsii.Proxy(SenderIdReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SenderIdReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IsoCountryCode of the SenderId resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIsoCountryCode();

    /**
     * The SenderId of the SenderId resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSenderId();

    /**
     * The ARN of the SenderId resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSenderIdArn();

    /**
     * @return a {@link Builder} of {@link SenderIdReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SenderIdReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SenderIdReference> {
        java.lang.String isoCountryCode;
        java.lang.String senderId;
        java.lang.String senderIdArn;

        /**
         * Sets the value of {@link SenderIdReference#getIsoCountryCode}
         * @param isoCountryCode The IsoCountryCode of the SenderId resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isoCountryCode(java.lang.String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        /**
         * Sets the value of {@link SenderIdReference#getSenderId}
         * @param senderId The SenderId of the SenderId resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder senderId(java.lang.String senderId) {
            this.senderId = senderId;
            return this;
        }

        /**
         * Sets the value of {@link SenderIdReference#getSenderIdArn}
         * @param senderIdArn The ARN of the SenderId resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder senderIdArn(java.lang.String senderIdArn) {
            this.senderIdArn = senderIdArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SenderIdReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SenderIdReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SenderIdReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SenderIdReference {
        private final java.lang.String isoCountryCode;
        private final java.lang.String senderId;
        private final java.lang.String senderIdArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.isoCountryCode = software.amazon.jsii.Kernel.get(this, "isoCountryCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.senderId = software.amazon.jsii.Kernel.get(this, "senderId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.senderIdArn = software.amazon.jsii.Kernel.get(this, "senderIdArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.isoCountryCode = java.util.Objects.requireNonNull(builder.isoCountryCode, "isoCountryCode is required");
            this.senderId = java.util.Objects.requireNonNull(builder.senderId, "senderId is required");
            this.senderIdArn = java.util.Objects.requireNonNull(builder.senderIdArn, "senderIdArn is required");
        }

        @Override
        public final java.lang.String getIsoCountryCode() {
            return this.isoCountryCode;
        }

        @Override
        public final java.lang.String getSenderId() {
            return this.senderId;
        }

        @Override
        public final java.lang.String getSenderIdArn() {
            return this.senderIdArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("isoCountryCode", om.valueToTree(this.getIsoCountryCode()));
            data.set("senderId", om.valueToTree(this.getSenderId()));
            data.set("senderIdArn", om.valueToTree(this.getSenderIdArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_smsvoice.SenderIdReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SenderIdReference.Jsii$Proxy that = (SenderIdReference.Jsii$Proxy) o;

            if (!isoCountryCode.equals(that.isoCountryCode)) return false;
            if (!senderId.equals(that.senderId)) return false;
            return this.senderIdArn.equals(that.senderIdArn);
        }

        @Override
        public final int hashCode() {
            int result = this.isoCountryCode.hashCode();
            result = 31 * result + (this.senderId.hashCode());
            result = 31 * result + (this.senderIdArn.hashCode());
            return result;
        }
    }
}
