package software.amazon.awscdk.interfaces.sns;

/**
 * A reference to a TopicPolicy resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.sns.*;
 * TopicPolicyReference topicPolicyReference = TopicPolicyReference.builder()
 *         .topicPolicyId("topicPolicyId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.236Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_sns.TopicPolicyReference")
@software.amazon.jsii.Jsii.Proxy(TopicPolicyReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TopicPolicyReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the TopicPolicy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTopicPolicyId();

    /**
     * @return a {@link Builder} of {@link TopicPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TopicPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TopicPolicyReference> {
        java.lang.String topicPolicyId;

        /**
         * Sets the value of {@link TopicPolicyReference#getTopicPolicyId}
         * @param topicPolicyId The Id of the TopicPolicy resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicPolicyId(java.lang.String topicPolicyId) {
            this.topicPolicyId = topicPolicyId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TopicPolicyReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TopicPolicyReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TopicPolicyReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicPolicyReference {
        private final java.lang.String topicPolicyId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.topicPolicyId = software.amazon.jsii.Kernel.get(this, "topicPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.topicPolicyId = java.util.Objects.requireNonNull(builder.topicPolicyId, "topicPolicyId is required");
        }

        @Override
        public final java.lang.String getTopicPolicyId() {
            return this.topicPolicyId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("topicPolicyId", om.valueToTree(this.getTopicPolicyId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_sns.TopicPolicyReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TopicPolicyReference.Jsii$Proxy that = (TopicPolicyReference.Jsii$Proxy) o;

            return this.topicPolicyId.equals(that.topicPolicyId);
        }

        @Override
        public final int hashCode() {
            int result = this.topicPolicyId.hashCode();
            return result;
        }
    }
}
