package software.amazon.awscdk.interfaces.timestream;

/**
 * A reference to a InfluxDBInstance resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.timestream.*;
 * InfluxDBInstanceReference influxDBInstanceReference = InfluxDBInstanceReference.builder()
 *         .influxDbInstanceArn("influxDbInstanceArn")
 *         .influxDbInstanceId("influxDbInstanceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.272Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_timestream.InfluxDBInstanceReference")
@software.amazon.jsii.Jsii.Proxy(InfluxDBInstanceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InfluxDBInstanceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the InfluxDBInstance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInfluxDbInstanceArn();

    /**
     * The Id of the InfluxDBInstance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInfluxDbInstanceId();

    /**
     * @return a {@link Builder} of {@link InfluxDBInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InfluxDBInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InfluxDBInstanceReference> {
        java.lang.String influxDbInstanceArn;
        java.lang.String influxDbInstanceId;

        /**
         * Sets the value of {@link InfluxDBInstanceReference#getInfluxDbInstanceArn}
         * @param influxDbInstanceArn The ARN of the InfluxDBInstance resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder influxDbInstanceArn(java.lang.String influxDbInstanceArn) {
            this.influxDbInstanceArn = influxDbInstanceArn;
            return this;
        }

        /**
         * Sets the value of {@link InfluxDBInstanceReference#getInfluxDbInstanceId}
         * @param influxDbInstanceId The Id of the InfluxDBInstance resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder influxDbInstanceId(java.lang.String influxDbInstanceId) {
            this.influxDbInstanceId = influxDbInstanceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InfluxDBInstanceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InfluxDBInstanceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InfluxDBInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InfluxDBInstanceReference {
        private final java.lang.String influxDbInstanceArn;
        private final java.lang.String influxDbInstanceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.influxDbInstanceArn = software.amazon.jsii.Kernel.get(this, "influxDbInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.influxDbInstanceId = software.amazon.jsii.Kernel.get(this, "influxDbInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.influxDbInstanceArn = java.util.Objects.requireNonNull(builder.influxDbInstanceArn, "influxDbInstanceArn is required");
            this.influxDbInstanceId = java.util.Objects.requireNonNull(builder.influxDbInstanceId, "influxDbInstanceId is required");
        }

        @Override
        public final java.lang.String getInfluxDbInstanceArn() {
            return this.influxDbInstanceArn;
        }

        @Override
        public final java.lang.String getInfluxDbInstanceId() {
            return this.influxDbInstanceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("influxDbInstanceArn", om.valueToTree(this.getInfluxDbInstanceArn()));
            data.set("influxDbInstanceId", om.valueToTree(this.getInfluxDbInstanceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_timestream.InfluxDBInstanceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InfluxDBInstanceReference.Jsii$Proxy that = (InfluxDBInstanceReference.Jsii$Proxy) o;

            if (!influxDbInstanceArn.equals(that.influxDbInstanceArn)) return false;
            return this.influxDbInstanceId.equals(that.influxDbInstanceId);
        }

        @Override
        public final int hashCode() {
            int result = this.influxDbInstanceArn.hashCode();
            result = 31 * result + (this.influxDbInstanceId.hashCode());
            return result;
        }
    }
}
