package software.amazon.awscdk.interfaces.timestream;

/**
 * A reference to a ScheduledQuery resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.timestream.*;
 * ScheduledQueryReference scheduledQueryReference = ScheduledQueryReference.builder()
 *         .scheduledQueryArn("scheduledQueryArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.272Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_timestream.ScheduledQueryReference")
@software.amazon.jsii.Jsii.Proxy(ScheduledQueryReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduledQueryReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the ScheduledQuery resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScheduledQueryArn();

    /**
     * @return a {@link Builder} of {@link ScheduledQueryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduledQueryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduledQueryReference> {
        java.lang.String scheduledQueryArn;

        /**
         * Sets the value of {@link ScheduledQueryReference#getScheduledQueryArn}
         * @param scheduledQueryArn The Arn of the ScheduledQuery resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledQueryArn(java.lang.String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduledQueryReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScheduledQueryReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScheduledQueryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledQueryReference {
        private final java.lang.String scheduledQueryArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scheduledQueryArn = software.amazon.jsii.Kernel.get(this, "scheduledQueryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scheduledQueryArn = java.util.Objects.requireNonNull(builder.scheduledQueryArn, "scheduledQueryArn is required");
        }

        @Override
        public final java.lang.String getScheduledQueryArn() {
            return this.scheduledQueryArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("scheduledQueryArn", om.valueToTree(this.getScheduledQueryArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_timestream.ScheduledQueryReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduledQueryReference.Jsii$Proxy that = (ScheduledQueryReference.Jsii$Proxy) o;

            return this.scheduledQueryArn.equals(that.scheduledQueryArn);
        }

        @Override
        public final int hashCode() {
            int result = this.scheduledQueryArn.hashCode();
            return result;
        }
    }
}
