package software.amazon.awscdk.interfaces.transfer;

/**
 * A reference to a Agreement resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.transfer.*;
 * AgreementReference agreementReference = AgreementReference.builder()
 *         .agreementArn("agreementArn")
 *         .agreementId("agreementId")
 *         .serverId("serverId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.273Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_transfer.AgreementReference")
@software.amazon.jsii.Jsii.Proxy(AgreementReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AgreementReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Agreement resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgreementArn();

    /**
     * The AgreementId of the Agreement resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgreementId();

    /**
     * The ServerId of the Agreement resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerId();

    /**
     * @return a {@link Builder} of {@link AgreementReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AgreementReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AgreementReference> {
        java.lang.String agreementArn;
        java.lang.String agreementId;
        java.lang.String serverId;

        /**
         * Sets the value of {@link AgreementReference#getAgreementArn}
         * @param agreementArn The ARN of the Agreement resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agreementArn(java.lang.String agreementArn) {
            this.agreementArn = agreementArn;
            return this;
        }

        /**
         * Sets the value of {@link AgreementReference#getAgreementId}
         * @param agreementId The AgreementId of the Agreement resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agreementId(java.lang.String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        /**
         * Sets the value of {@link AgreementReference#getServerId}
         * @param serverId The ServerId of the Agreement resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverId(java.lang.String serverId) {
            this.serverId = serverId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AgreementReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AgreementReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AgreementReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AgreementReference {
        private final java.lang.String agreementArn;
        private final java.lang.String agreementId;
        private final java.lang.String serverId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.agreementArn = software.amazon.jsii.Kernel.get(this, "agreementArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agreementId = software.amazon.jsii.Kernel.get(this, "agreementId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverId = software.amazon.jsii.Kernel.get(this, "serverId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.agreementArn = java.util.Objects.requireNonNull(builder.agreementArn, "agreementArn is required");
            this.agreementId = java.util.Objects.requireNonNull(builder.agreementId, "agreementId is required");
            this.serverId = java.util.Objects.requireNonNull(builder.serverId, "serverId is required");
        }

        @Override
        public final java.lang.String getAgreementArn() {
            return this.agreementArn;
        }

        @Override
        public final java.lang.String getAgreementId() {
            return this.agreementId;
        }

        @Override
        public final java.lang.String getServerId() {
            return this.serverId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("agreementArn", om.valueToTree(this.getAgreementArn()));
            data.set("agreementId", om.valueToTree(this.getAgreementId()));
            data.set("serverId", om.valueToTree(this.getServerId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_transfer.AgreementReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AgreementReference.Jsii$Proxy that = (AgreementReference.Jsii$Proxy) o;

            if (!agreementArn.equals(that.agreementArn)) return false;
            if (!agreementId.equals(that.agreementId)) return false;
            return this.serverId.equals(that.serverId);
        }

        @Override
        public final int hashCode() {
            int result = this.agreementArn.hashCode();
            result = 31 * result + (this.agreementId.hashCode());
            result = 31 * result + (this.serverId.hashCode());
            return result;
        }
    }
}
