package software.amazon.awscdk.interfaces.verifiedpermissions;

/**
 * A reference to a IdentitySource resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.verifiedpermissions.*;
 * IdentitySourceReference identitySourceReference = IdentitySourceReference.builder()
 *         .identitySourceId("identitySourceId")
 *         .policyStoreId("policyStoreId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.279Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_verifiedpermissions.IdentitySourceReference")
@software.amazon.jsii.Jsii.Proxy(IdentitySourceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IdentitySourceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IdentitySourceId of the IdentitySource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentitySourceId();

    /**
     * The PolicyStoreId of the IdentitySource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyStoreId();

    /**
     * @return a {@link Builder} of {@link IdentitySourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdentitySourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IdentitySourceReference> {
        java.lang.String identitySourceId;
        java.lang.String policyStoreId;

        /**
         * Sets the value of {@link IdentitySourceReference#getIdentitySourceId}
         * @param identitySourceId The IdentitySourceId of the IdentitySource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySourceId(java.lang.String identitySourceId) {
            this.identitySourceId = identitySourceId;
            return this;
        }

        /**
         * Sets the value of {@link IdentitySourceReference#getPolicyStoreId}
         * @param policyStoreId The PolicyStoreId of the IdentitySource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStoreId(java.lang.String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdentitySourceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IdentitySourceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdentitySourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentitySourceReference {
        private final java.lang.String identitySourceId;
        private final java.lang.String policyStoreId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identitySourceId = software.amazon.jsii.Kernel.get(this, "identitySourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyStoreId = software.amazon.jsii.Kernel.get(this, "policyStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identitySourceId = java.util.Objects.requireNonNull(builder.identitySourceId, "identitySourceId is required");
            this.policyStoreId = java.util.Objects.requireNonNull(builder.policyStoreId, "policyStoreId is required");
        }

        @Override
        public final java.lang.String getIdentitySourceId() {
            return this.identitySourceId;
        }

        @Override
        public final java.lang.String getPolicyStoreId() {
            return this.policyStoreId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identitySourceId", om.valueToTree(this.getIdentitySourceId()));
            data.set("policyStoreId", om.valueToTree(this.getPolicyStoreId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_verifiedpermissions.IdentitySourceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdentitySourceReference.Jsii$Proxy that = (IdentitySourceReference.Jsii$Proxy) o;

            if (!identitySourceId.equals(that.identitySourceId)) return false;
            return this.policyStoreId.equals(that.policyStoreId);
        }

        @Override
        public final int hashCode() {
            int result = this.identitySourceId.hashCode();
            result = 31 * result + (this.policyStoreId.hashCode());
            return result;
        }
    }
}
