package software.amazon.awscdk.interfaces.wafv2;

/**
 * A reference to a IPSet resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.wafv2.*;
 * IPSetReference iPSetReference = Map.of(
 *         "ipSetArn", "ipSetArn",
 *         "ipSetId", "ipSetId",
 *         "ipSetName", "ipSetName",
 *         "scope", "scope");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.313Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_wafv2.IPSetReference")
@software.amazon.jsii.Jsii.Proxy(IPSetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPSetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the IPSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpSetArn();

    /**
     * The Id of the IPSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpSetId();

    /**
     * The Name of the IPSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpSetName();

    /**
     * The Scope of the IPSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScope();

    /**
     * @return a {@link Builder} of {@link IPSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IPSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IPSetReference> {
        java.lang.String ipSetArn;
        java.lang.String ipSetId;
        java.lang.String ipSetName;
        java.lang.String scope;

        /**
         * Sets the value of {@link IPSetReference#getIpSetArn}
         * @param ipSetArn The ARN of the IPSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipSetArn(java.lang.String ipSetArn) {
            this.ipSetArn = ipSetArn;
            return this;
        }

        /**
         * Sets the value of {@link IPSetReference#getIpSetId}
         * @param ipSetId The Id of the IPSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipSetId(java.lang.String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        /**
         * Sets the value of {@link IPSetReference#getIpSetName}
         * @param ipSetName The Name of the IPSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipSetName(java.lang.String ipSetName) {
            this.ipSetName = ipSetName;
            return this;
        }

        /**
         * Sets the value of {@link IPSetReference#getScope}
         * @param scope The Scope of the IPSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IPSetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IPSetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IPSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IPSetReference {
        private final java.lang.String ipSetArn;
        private final java.lang.String ipSetId;
        private final java.lang.String ipSetName;
        private final java.lang.String scope;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ipSetArn = software.amazon.jsii.Kernel.get(this, "ipSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipSetId = software.amazon.jsii.Kernel.get(this, "ipSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipSetName = software.amazon.jsii.Kernel.get(this, "ipSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ipSetArn = java.util.Objects.requireNonNull(builder.ipSetArn, "ipSetArn is required");
            this.ipSetId = java.util.Objects.requireNonNull(builder.ipSetId, "ipSetId is required");
            this.ipSetName = java.util.Objects.requireNonNull(builder.ipSetName, "ipSetName is required");
            this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
        }

        @Override
        public final java.lang.String getIpSetArn() {
            return this.ipSetArn;
        }

        @Override
        public final java.lang.String getIpSetId() {
            return this.ipSetId;
        }

        @Override
        public final java.lang.String getIpSetName() {
            return this.ipSetName;
        }

        @Override
        public final java.lang.String getScope() {
            return this.scope;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ipSetArn", om.valueToTree(this.getIpSetArn()));
            data.set("ipSetId", om.valueToTree(this.getIpSetId()));
            data.set("ipSetName", om.valueToTree(this.getIpSetName()));
            data.set("scope", om.valueToTree(this.getScope()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_wafv2.IPSetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IPSetReference.Jsii$Proxy that = (IPSetReference.Jsii$Proxy) o;

            if (!ipSetArn.equals(that.ipSetArn)) return false;
            if (!ipSetId.equals(that.ipSetId)) return false;
            if (!ipSetName.equals(that.ipSetName)) return false;
            return this.scope.equals(that.scope);
        }

        @Override
        public final int hashCode() {
            int result = this.ipSetArn.hashCode();
            result = 31 * result + (this.ipSetId.hashCode());
            result = 31 * result + (this.ipSetName.hashCode());
            result = 31 * result + (this.scope.hashCode());
            return result;
        }
    }
}
