package software.amazon.awscdk.interfaces.wafv2;

/**
 * A reference to a RuleGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.wafv2.*;
 * RuleGroupReference ruleGroupReference = RuleGroupReference.builder()
 *         .ruleGroupArn("ruleGroupArn")
 *         .ruleGroupId("ruleGroupId")
 *         .ruleGroupName("ruleGroupName")
 *         .scope("scope")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.315Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_wafv2.RuleGroupReference")
@software.amazon.jsii.Jsii.Proxy(RuleGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RuleGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the RuleGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleGroupArn();

    /**
     * The Id of the RuleGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleGroupId();

    /**
     * The Name of the RuleGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleGroupName();

    /**
     * The Scope of the RuleGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScope();

    /**
     * @return a {@link Builder} of {@link RuleGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RuleGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RuleGroupReference> {
        java.lang.String ruleGroupArn;
        java.lang.String ruleGroupId;
        java.lang.String ruleGroupName;
        java.lang.String scope;

        /**
         * Sets the value of {@link RuleGroupReference#getRuleGroupArn}
         * @param ruleGroupArn The ARN of the RuleGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleGroupArn(java.lang.String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link RuleGroupReference#getRuleGroupId}
         * @param ruleGroupId The Id of the RuleGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleGroupId(java.lang.String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
            return this;
        }

        /**
         * Sets the value of {@link RuleGroupReference#getRuleGroupName}
         * @param ruleGroupName The Name of the RuleGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleGroupName(java.lang.String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        /**
         * Sets the value of {@link RuleGroupReference#getScope}
         * @param scope The Scope of the RuleGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuleGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RuleGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RuleGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleGroupReference {
        private final java.lang.String ruleGroupArn;
        private final java.lang.String ruleGroupId;
        private final java.lang.String ruleGroupName;
        private final java.lang.String scope;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ruleGroupArn = software.amazon.jsii.Kernel.get(this, "ruleGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleGroupId = software.amazon.jsii.Kernel.get(this, "ruleGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleGroupName = software.amazon.jsii.Kernel.get(this, "ruleGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ruleGroupArn = java.util.Objects.requireNonNull(builder.ruleGroupArn, "ruleGroupArn is required");
            this.ruleGroupId = java.util.Objects.requireNonNull(builder.ruleGroupId, "ruleGroupId is required");
            this.ruleGroupName = java.util.Objects.requireNonNull(builder.ruleGroupName, "ruleGroupName is required");
            this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
        }

        @Override
        public final java.lang.String getRuleGroupArn() {
            return this.ruleGroupArn;
        }

        @Override
        public final java.lang.String getRuleGroupId() {
            return this.ruleGroupId;
        }

        @Override
        public final java.lang.String getRuleGroupName() {
            return this.ruleGroupName;
        }

        @Override
        public final java.lang.String getScope() {
            return this.scope;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ruleGroupArn", om.valueToTree(this.getRuleGroupArn()));
            data.set("ruleGroupId", om.valueToTree(this.getRuleGroupId()));
            data.set("ruleGroupName", om.valueToTree(this.getRuleGroupName()));
            data.set("scope", om.valueToTree(this.getScope()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_wafv2.RuleGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RuleGroupReference.Jsii$Proxy that = (RuleGroupReference.Jsii$Proxy) o;

            if (!ruleGroupArn.equals(that.ruleGroupArn)) return false;
            if (!ruleGroupId.equals(that.ruleGroupId)) return false;
            if (!ruleGroupName.equals(that.ruleGroupName)) return false;
            return this.scope.equals(that.scope);
        }

        @Override
        public final int hashCode() {
            int result = this.ruleGroupArn.hashCode();
            result = 31 * result + (this.ruleGroupId.hashCode());
            result = 31 * result + (this.ruleGroupName.hashCode());
            result = 31 * result + (this.scope.hashCode());
            return result;
        }
    }
}
