package software.amazon.awscdk.interfaces.wisdom;

/**
 * A reference to a AIAgent resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.wisdom.*;
 * AIAgentReference aIAgentReference = AIAgentReference.builder()
 *         .aiAgentArn("aiAgentArn")
 *         .aiAgentId("aiAgentId")
 *         .assistantId("assistantId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.317Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_wisdom.AIAgentReference")
@software.amazon.jsii.Jsii.Proxy(AIAgentReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AIAgentReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AIAgent resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAiAgentArn();

    /**
     * The AIAgentId of the AIAgent resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAiAgentId();

    /**
     * The AssistantId of the AIAgent resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantId();

    /**
     * @return a {@link Builder} of {@link AIAgentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AIAgentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AIAgentReference> {
        java.lang.String aiAgentArn;
        java.lang.String aiAgentId;
        java.lang.String assistantId;

        /**
         * Sets the value of {@link AIAgentReference#getAiAgentArn}
         * @param aiAgentArn The ARN of the AIAgent resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aiAgentArn(java.lang.String aiAgentArn) {
            this.aiAgentArn = aiAgentArn;
            return this;
        }

        /**
         * Sets the value of {@link AIAgentReference#getAiAgentId}
         * @param aiAgentId The AIAgentId of the AIAgent resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aiAgentId(java.lang.String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        /**
         * Sets the value of {@link AIAgentReference#getAssistantId}
         * @param assistantId The AssistantId of the AIAgent resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(java.lang.String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AIAgentReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AIAgentReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AIAgentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AIAgentReference {
        private final java.lang.String aiAgentArn;
        private final java.lang.String aiAgentId;
        private final java.lang.String assistantId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aiAgentArn = software.amazon.jsii.Kernel.get(this, "aiAgentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.aiAgentId = software.amazon.jsii.Kernel.get(this, "aiAgentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assistantId = software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aiAgentArn = java.util.Objects.requireNonNull(builder.aiAgentArn, "aiAgentArn is required");
            this.aiAgentId = java.util.Objects.requireNonNull(builder.aiAgentId, "aiAgentId is required");
            this.assistantId = java.util.Objects.requireNonNull(builder.assistantId, "assistantId is required");
        }

        @Override
        public final java.lang.String getAiAgentArn() {
            return this.aiAgentArn;
        }

        @Override
        public final java.lang.String getAiAgentId() {
            return this.aiAgentId;
        }

        @Override
        public final java.lang.String getAssistantId() {
            return this.assistantId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aiAgentArn", om.valueToTree(this.getAiAgentArn()));
            data.set("aiAgentId", om.valueToTree(this.getAiAgentId()));
            data.set("assistantId", om.valueToTree(this.getAssistantId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_wisdom.AIAgentReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AIAgentReference.Jsii$Proxy that = (AIAgentReference.Jsii$Proxy) o;

            if (!aiAgentArn.equals(that.aiAgentArn)) return false;
            if (!aiAgentId.equals(that.aiAgentId)) return false;
            return this.assistantId.equals(that.assistantId);
        }

        @Override
        public final int hashCode() {
            int result = this.aiAgentArn.hashCode();
            result = 31 * result + (this.aiAgentId.hashCode());
            result = 31 * result + (this.assistantId.hashCode());
            return result;
        }
    }
}
