package software.amazon.awscdk.interfaces.wisdom;

/**
 * A reference to a KnowledgeBase resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.wisdom.*;
 * KnowledgeBaseReference knowledgeBaseReference = KnowledgeBaseReference.builder()
 *         .knowledgeBaseArn("knowledgeBaseArn")
 *         .knowledgeBaseId("knowledgeBaseId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.323Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_wisdom.KnowledgeBaseReference")
@software.amazon.jsii.Jsii.Proxy(KnowledgeBaseReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KnowledgeBaseReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the KnowledgeBase resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseArn();

    /**
     * The KnowledgeBaseId of the KnowledgeBase resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseId();

    /**
     * @return a {@link Builder} of {@link KnowledgeBaseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KnowledgeBaseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KnowledgeBaseReference> {
        java.lang.String knowledgeBaseArn;
        java.lang.String knowledgeBaseId;

        /**
         * Sets the value of {@link KnowledgeBaseReference#getKnowledgeBaseArn}
         * @param knowledgeBaseArn The ARN of the KnowledgeBase resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseArn(java.lang.String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        /**
         * Sets the value of {@link KnowledgeBaseReference#getKnowledgeBaseId}
         * @param knowledgeBaseId The KnowledgeBaseId of the KnowledgeBase resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseId(java.lang.String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KnowledgeBaseReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KnowledgeBaseReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KnowledgeBaseReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KnowledgeBaseReference {
        private final java.lang.String knowledgeBaseArn;
        private final java.lang.String knowledgeBaseId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.knowledgeBaseArn = software.amazon.jsii.Kernel.get(this, "knowledgeBaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.knowledgeBaseId = software.amazon.jsii.Kernel.get(this, "knowledgeBaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.knowledgeBaseArn = java.util.Objects.requireNonNull(builder.knowledgeBaseArn, "knowledgeBaseArn is required");
            this.knowledgeBaseId = java.util.Objects.requireNonNull(builder.knowledgeBaseId, "knowledgeBaseId is required");
        }

        @Override
        public final java.lang.String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        @Override
        public final java.lang.String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("knowledgeBaseArn", om.valueToTree(this.getKnowledgeBaseArn()));
            data.set("knowledgeBaseId", om.valueToTree(this.getKnowledgeBaseId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_wisdom.KnowledgeBaseReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KnowledgeBaseReference.Jsii$Proxy that = (KnowledgeBaseReference.Jsii$Proxy) o;

            if (!knowledgeBaseArn.equals(that.knowledgeBaseArn)) return false;
            return this.knowledgeBaseId.equals(that.knowledgeBaseId);
        }

        @Override
        public final int hashCode() {
            int result = this.knowledgeBaseArn.hashCode();
            result = 31 * result + (this.knowledgeBaseId.hashCode());
            return result;
        }
    }
}
