package software.amazon.awscdk.interfaces.workspacesinstances;

/**
 * A reference to a VolumeAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.workspacesinstances.*;
 * VolumeAssociationReference volumeAssociationReference = VolumeAssociationReference.builder()
 *         .device("device")
 *         .volumeId("volumeId")
 *         .workspaceInstanceId("workspaceInstanceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.327Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_workspacesinstances.VolumeAssociationReference")
@software.amazon.jsii.Jsii.Proxy(VolumeAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VolumeAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Device of the VolumeAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDevice();

    /**
     * The VolumeId of the VolumeAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVolumeId();

    /**
     * The WorkspaceInstanceId of the VolumeAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkspaceInstanceId();

    /**
     * @return a {@link Builder} of {@link VolumeAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VolumeAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VolumeAssociationReference> {
        java.lang.String device;
        java.lang.String volumeId;
        java.lang.String workspaceInstanceId;

        /**
         * Sets the value of {@link VolumeAssociationReference#getDevice}
         * @param device The Device of the VolumeAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder device(java.lang.String device) {
            this.device = device;
            return this;
        }

        /**
         * Sets the value of {@link VolumeAssociationReference#getVolumeId}
         * @param volumeId The VolumeId of the VolumeAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeId(java.lang.String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        /**
         * Sets the value of {@link VolumeAssociationReference#getWorkspaceInstanceId}
         * @param workspaceInstanceId The WorkspaceInstanceId of the VolumeAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceInstanceId(java.lang.String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VolumeAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VolumeAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VolumeAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeAssociationReference {
        private final java.lang.String device;
        private final java.lang.String volumeId;
        private final java.lang.String workspaceInstanceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.device = software.amazon.jsii.Kernel.get(this, "device", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumeId = software.amazon.jsii.Kernel.get(this, "volumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workspaceInstanceId = software.amazon.jsii.Kernel.get(this, "workspaceInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.device = java.util.Objects.requireNonNull(builder.device, "device is required");
            this.volumeId = java.util.Objects.requireNonNull(builder.volumeId, "volumeId is required");
            this.workspaceInstanceId = java.util.Objects.requireNonNull(builder.workspaceInstanceId, "workspaceInstanceId is required");
        }

        @Override
        public final java.lang.String getDevice() {
            return this.device;
        }

        @Override
        public final java.lang.String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final java.lang.String getWorkspaceInstanceId() {
            return this.workspaceInstanceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("device", om.valueToTree(this.getDevice()));
            data.set("volumeId", om.valueToTree(this.getVolumeId()));
            data.set("workspaceInstanceId", om.valueToTree(this.getWorkspaceInstanceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_workspacesinstances.VolumeAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VolumeAssociationReference.Jsii$Proxy that = (VolumeAssociationReference.Jsii$Proxy) o;

            if (!device.equals(that.device)) return false;
            if (!volumeId.equals(that.volumeId)) return false;
            return this.workspaceInstanceId.equals(that.workspaceInstanceId);
        }

        @Override
        public final int hashCode() {
            int result = this.device.hashCode();
            result = 31 * result + (this.volumeId.hashCode());
            result = 31 * result + (this.workspaceInstanceId.hashCode());
            return result;
        }
    }
}
