package software.amazon.awscdk.interfaces.workspacesweb;

/**
 * A reference to a IdentityProvider resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.workspacesweb.*;
 * IdentityProviderReference identityProviderReference = IdentityProviderReference.builder()
 *         .identityProviderArn("identityProviderArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.342Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_workspacesweb.IdentityProviderReference")
@software.amazon.jsii.Jsii.Proxy(IdentityProviderReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IdentityProviderReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IdentityProviderArn of the IdentityProvider resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityProviderArn();

    /**
     * @return a {@link Builder} of {@link IdentityProviderReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdentityProviderReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IdentityProviderReference> {
        java.lang.String identityProviderArn;

        /**
         * Sets the value of {@link IdentityProviderReference#getIdentityProviderArn}
         * @param identityProviderArn The IdentityProviderArn of the IdentityProvider resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderArn(java.lang.String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdentityProviderReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IdentityProviderReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdentityProviderReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityProviderReference {
        private final java.lang.String identityProviderArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identityProviderArn = software.amazon.jsii.Kernel.get(this, "identityProviderArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identityProviderArn = java.util.Objects.requireNonNull(builder.identityProviderArn, "identityProviderArn is required");
        }

        @Override
        public final java.lang.String getIdentityProviderArn() {
            return this.identityProviderArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identityProviderArn", om.valueToTree(this.getIdentityProviderArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_workspacesweb.IdentityProviderReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdentityProviderReference.Jsii$Proxy that = (IdentityProviderReference.Jsii$Proxy) o;

            return this.identityProviderArn.equals(that.identityProviderArn);
        }

        @Override
        public final int hashCode() {
            int result = this.identityProviderArn.hashCode();
            return result;
        }
    }
}
