package software.amazon.awscdk.services.apigateway;

/**
 * A Deployment of a REST API.
 * <p>
 * An immutable representation of a RestApi resource that can be called by users
 * using Stages. A deployment must be associated with a Stage for it to be
 * callable over the Internet.
 * <p>
 * Normally, you don't need to define deployments manually. The RestApi
 * construct manages a Deployment resource that represents the latest model. It
 * can be accessed through <code>restApi.latestDeployment</code> (unless <code>deploy: false</code> is
 * set when defining the <code>RestApi</code>).
 * <p>
 * If you manually define this resource, you will need to know that since
 * deployments are immutable, as long as the resource's logical ID doesn't
 * change, the deployment will represent the snapshot in time in which the
 * resource was created. This means that if you modify the RestApi model (i.e.
 * add methods or resources), these changes will not be reflected unless a new
 * deployment resource is created.
 * <p>
 * To achieve this behavior, the method <code>addToLogicalId(data)</code> can be used to
 * augment the logical ID generated for the deployment resource such that it
 * will include arbitrary data. This is done automatically for the
 * <code>restApi.latestDeployment</code> deployment.
 * <p>
 * Furthermore, since a deployment does not reference any of the REST API
 * resources and methods, CloudFormation will likely provision it before these
 * resources are created, which means that it will represent a "half-baked"
 * model. Use the <code>node.addDependency(dep)</code> method to circumvent that. This is done
 * automatically for the <code>restApi.latestDeployment</code> deployment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // production stage
 * LogGroup prodLogGroup = new LogGroup(this, "PrdLogs");
 * RestApi api = RestApi.Builder.create(this, "books")
 *         .deployOptions(StageOptions.builder()
 *                 .accessLogDestination(new LogGroupLogDestination(prodLogGroup))
 *                 .accessLogFormat(AccessLogFormat.jsonWithStandardFields())
 *                 .build())
 *         .build();
 * Deployment deployment = Deployment.Builder.create(this, "Deployment").api(api).build();
 * // development stage
 * LogGroup devLogGroup = new LogGroup(this, "DevLogs");
 * Stage.Builder.create(this, "dev")
 *         .deployment(deployment)
 *         .accessLogDestination(new LogGroupLogDestination(devLogGroup))
 *         .accessLogFormat(AccessLogFormat.jsonWithStandardFields(JsonWithStandardFieldProps.builder()
 *                 .caller(false)
 *                 .httpMethod(true)
 *                 .ip(true)
 *                 .protocol(true)
 *                 .requestTime(true)
 *                 .resourcePath(true)
 *                 .responseLength(true)
 *                 .status(true)
 *                 .user(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:13.281Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.Deployment")
public class Deployment extends software.amazon.awscdk.Resource {

    protected Deployment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Deployment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.Deployment.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Deployment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.DeploymentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds a component to the hash that determines this Deployment resource's logical ID.
     * <p>
     * This should be called by constructs of the API Gateway model that want to
     * invalidate the deployment when their settings change. The component will
     * be resolved during synthesis so tokens are welcome.
     * <p>
     * @param data This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToLogicalId(final @org.jetbrains.annotations.NotNull java.lang.Object data) {
        software.amazon.jsii.Kernel.call(this, "addToLogicalId", software.amazon.jsii.NativeType.VOID, new Object[] { data });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi getApi() {
        return software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentId() {
        return software.amazon.jsii.Kernel.get(this, "deploymentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stage of the API gateway deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.Deployment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.Deployment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.DeploymentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.DeploymentProps.Builder();
        }

        /**
         * The Rest API to deploy.
         * <p>
         * @return {@code this}
         * @param api The Rest API to deploy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(final software.amazon.awscdk.services.apigateway.IRestApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * A description of the purpose of the API Gateway deployment.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the purpose of the API Gateway deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * When an API Gateway model is updated, a new deployment will automatically be created.
         * <p>
         * If this is true, the old API Gateway Deployment resource will not be deleted.
         * This will allow manually reverting back to a previous deployment in case for example
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param retainDeployments When an API Gateway model is updated, a new deployment will automatically be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeployments(final java.lang.Boolean retainDeployments) {
            this.props.retainDeployments(retainDeployments);
            return this;
        }

        /**
         * The name of the stage the API Gateway deployment deploys to.
         * <p>
         * Default: - No stage name. If the `stageName` property is set but a stage with the
         * corresponding name does not exist, a new stage resource will be created with the
         * provided stage name.
         * <p>
         * @return {@code this}
         * @param stageName The name of the stage the API Gateway deployment deploys to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(final java.lang.String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigateway.Deployment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.Deployment build() {
            return new software.amazon.awscdk.services.apigateway.Deployment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
