package software.amazon.awscdk.services.apigateway;

/**
 * The response transfer mode of the integration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function handler;
 * LambdaIntegration.Builder.create(handler)
 *         .responseTransferMode(ResponseTransferMode.STREAM)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:13.363Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.ResponseTransferMode")
public enum ResponseTransferMode {
    /**
     * API Gateway waits to receive the complete response before beginning transmission.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUFFERED,
    /**
     * API Gateway streams the response back to you as it is received from the integration.
     * <p>
     * This is only supported for AWS_PROXY and HTTP_PROXY integration types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STREAM,
}
