package software.amazon.awscdk.services.apigatewayv2;

/**
 * Custom domain resource for the API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.certificatemanager.*;
 * Bucket bucket;
 * String certArn = "arn:aws:acm:us-east-1:111111111111:certificate";
 * String domainName = "example.com";
 * DomainName.Builder.create(this, "DomainName")
 *         .domainName(domainName)
 *         .certificate(Certificate.fromCertificateArn(this, "cert", certArn))
 *         .mtls(MTLSConfig.builder()
 *                 .bucket(bucket)
 *                 .key("someca.pem")
 *                 .version("version")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:13.515Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.DomainName")
public class DomainName extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.IDomainName {

    protected DomainName(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DomainName(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.DomainName.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DomainName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.DomainNameProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import from attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IDomainName fromDomainNameAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.DomainNameAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.DomainName.class, "fromDomainNameAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IDomainName.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Adds an endpoint to a domain name.
     * <p>
     * @param options domain name endpoint properties to be set. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.EndpointOptions options) {
        software.amazon.jsii.Kernel.call(this, "addEndpoint", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The custom domain name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain name associated with the regional endpoint for this custom domain name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRegionalDomainName() {
        return software.amazon.jsii.Kernel.get(this, "regionalDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRegionalHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "regionalHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.DomainName}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.DomainName> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.DomainNameProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.DomainNameProps.Builder();
        }

        /**
         * The ACM certificate for this domain name.
         * <p>
         * Certificate can be both ACM issued or imported.
         * <p>
         * @return {@code this}
         * @param certificate The ACM certificate for this domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(final software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.props.certificate(certificate);
            return this;
        }

        /**
         * The user-friendly name of the certificate that will be used by the endpoint for this domain name.
         * <p>
         * Default: - No friendly certificate name
         * <p>
         * @return {@code this}
         * @param certificateName The user-friendly name of the certificate that will be used by the endpoint for this domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateName(final java.lang.String certificateName) {
            this.props.certificateName(certificateName);
            return this;
        }

        /**
         * The type of endpoint for this DomainName.
         * <p>
         * Default: EndpointType.REGIONAL
         * <p>
         * @return {@code this}
         * @param endpointType The type of endpoint for this DomainName. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(final software.amazon.awscdk.services.apigatewayv2.EndpointType endpointType) {
            this.props.endpointType(endpointType);
            return this;
        }

        /**
         * The IP address types that can invoke the API.
         * <p>
         * Default: undefined - AWS default is IPV4
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-ip-address-type.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-ip-address-type.html</a>
         * @param ipAddressType The IP address types that can invoke the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final software.amazon.awscdk.services.apigatewayv2.IpAddressType ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        /**
         * A public certificate issued by ACM to validate that you own a custom domain.
         * <p>
         * This parameter is required
         * only when you configure mutual TLS authentication and you specify an ACM imported or private CA certificate
         * for <code>certificate</code>. The ownership certificate validates that you have permissions to use the domain name.
         * <p>
         * Default: - only required when configuring mTLS
         * <p>
         * @return {@code this}
         * @param ownershipCertificate A public certificate issued by ACM to validate that you own a custom domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownershipCertificate(final software.amazon.awscdk.services.certificatemanager.ICertificate ownershipCertificate) {
            this.props.ownershipCertificate(ownershipCertificate);
            return this;
        }

        /**
         * The Transport Layer Security (TLS) version + cipher suite for this domain name.
         * <p>
         * Default: SecurityPolicy.TLS_1_2
         * <p>
         * @return {@code this}
         * @param securityPolicy The Transport Layer Security (TLS) version + cipher suite for this domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicy(final software.amazon.awscdk.services.apigatewayv2.SecurityPolicy securityPolicy) {
            this.props.securityPolicy(securityPolicy);
            return this;
        }

        /**
         * The custom domain name.
         * <p>
         * @return {@code this}
         * @param domainName The custom domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * The mutual TLS authentication configuration for a custom domain name.
         * <p>
         * Default: - mTLS is not configured.
         * <p>
         * @return {@code this}
         * @param mtls The mutual TLS authentication configuration for a custom domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mtls(final software.amazon.awscdk.services.apigatewayv2.MTLSConfig mtls) {
            this.props.mtls(mtls);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.DomainName}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.DomainName build() {
            return new software.amazon.awscdk.services.apigatewayv2.DomainName(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
