package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties for defining an API Gateway Usage Plan for WebSocket APIs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * WebSocketApi api = new WebSocketApi(this, "my-api");
 * WebSocketStage stage = WebSocketStage.Builder.create(this, "my-stage")
 *         .webSocketApi(api)
 *         .stageName("dev")
 *         .build();
 * UsagePlan usagePlan = UsagePlan.Builder.create(this, "my-usage-plan")
 *         .usagePlanName("Basic")
 *         .build();
 * usagePlan.addApiStage(UsagePlanPerApiStage.builder()
 *         .api(api)
 *         .stage(stage)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:13.577Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.UsagePlanProps")
@software.amazon.jsii.Jsii.Proxy(UsagePlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UsagePlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * API Stages to be associated with the usage plan.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage> getApiStages() {
        return null;
    }

    /**
     * Represents usage plan purpose.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Number of requests clients can make in a given time period.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.QuotaSettings getQuota() {
        return null;
    }

    /**
     * Overall throttle settings for the API.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.ThrottleSettings getThrottle() {
        return null;
    }

    /**
     * Name for this usage plan.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUsagePlanName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UsagePlanProps> {
        java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage> apiStages;
        java.lang.String description;
        software.amazon.awscdk.services.apigatewayv2.QuotaSettings quota;
        software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle;
        java.lang.String usagePlanName;

        /**
         * Sets the value of {@link UsagePlanProps#getApiStages}
         * @param apiStages API Stages to be associated with the usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder apiStages(java.util.List<? extends software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage> apiStages) {
            this.apiStages = (java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage>)apiStages;
            return this;
        }

        /**
         * Sets the value of {@link UsagePlanProps#getDescription}
         * @param description Represents usage plan purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link UsagePlanProps#getQuota}
         * @param quota Number of requests clients can make in a given time period.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(software.amazon.awscdk.services.apigatewayv2.QuotaSettings quota) {
            this.quota = quota;
            return this;
        }

        /**
         * Sets the value of {@link UsagePlanProps#getThrottle}
         * @param throttle Overall throttle settings for the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Sets the value of {@link UsagePlanProps#getUsagePlanName}
         * @param usagePlanName Name for this usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usagePlanName(java.lang.String usagePlanName) {
            this.usagePlanName = usagePlanName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UsagePlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UsagePlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UsagePlanProps {
        private final java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage> apiStages;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.apigatewayv2.QuotaSettings quota;
        private final software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle;
        private final java.lang.String usagePlanName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiStages = software.amazon.jsii.Kernel.get(this, "apiStages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.quota = software.amazon.jsii.Kernel.get(this, "quota", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.QuotaSettings.class));
            this.throttle = software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ThrottleSettings.class));
            this.usagePlanName = software.amazon.jsii.Kernel.get(this, "usagePlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiStages = (java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage>)builder.apiStages;
            this.description = builder.description;
            this.quota = builder.quota;
            this.throttle = builder.throttle;
            this.usagePlanName = builder.usagePlanName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage> getApiStages() {
            return this.apiStages;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.QuotaSettings getQuota() {
            return this.quota;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        public final java.lang.String getUsagePlanName() {
            return this.usagePlanName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiStages() != null) {
                data.set("apiStages", om.valueToTree(this.getApiStages()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getQuota() != null) {
                data.set("quota", om.valueToTree(this.getQuota()));
            }
            if (this.getThrottle() != null) {
                data.set("throttle", om.valueToTree(this.getThrottle()));
            }
            if (this.getUsagePlanName() != null) {
                data.set("usagePlanName", om.valueToTree(this.getUsagePlanName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.UsagePlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UsagePlanProps.Jsii$Proxy that = (UsagePlanProps.Jsii$Proxy) o;

            if (this.apiStages != null ? !this.apiStages.equals(that.apiStages) : that.apiStages != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.quota != null ? !this.quota.equals(that.quota) : that.quota != null) return false;
            if (this.throttle != null ? !this.throttle.equals(that.throttle) : that.throttle != null) return false;
            return this.usagePlanName != null ? this.usagePlanName.equals(that.usagePlanName) : that.usagePlanName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiStages != null ? this.apiStages.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.quota != null ? this.quota.hashCode() : 0);
            result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
            result = 31 * result + (this.usagePlanName != null ? this.usagePlanName.hashCode() : 0);
            return result;
        }
    }
}
