package software.amazon.awscdk.services.appmesh;

/**
 * Used to generate host name matching methods.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualGateway gateway;
 * VirtualService virtualService;
 * gateway.addGatewayRoute("gateway-route-grpc", GatewayRouteBaseProps.builder()
 *         .routeSpec(GatewayRouteSpec.grpc(GrpcGatewayRouteSpecOptions.builder()
 *                 .routeTarget(virtualService)
 *                 .match(GrpcGatewayRouteMatch.builder()
 *                         .hostname(GatewayRouteHostnameMatch.endsWith(".example.com"))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:14.154Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.GatewayRouteHostnameMatch")
public abstract class GatewayRouteHostnameMatch extends software.amazon.jsii.JsiiObject {

    protected GatewayRouteHostnameMatch(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GatewayRouteHostnameMatch(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected GatewayRouteHostnameMatch() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * The value of the host name with the given name must end with the specified characters.
     * <p>
     * @param suffix The specified ending characters of the host name to match on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch endsWith(final @org.jetbrains.annotations.NotNull java.lang.String suffix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch.class, "endsWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch.class), new Object[] { java.util.Objects.requireNonNull(suffix, "suffix is required") });
    }

    /**
     * The value of the host name must match the specified value exactly.
     * <p>
     * @param name The exact host name to match on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch exactly(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch.class, "exactly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Returns the gateway route host name match configuration.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatchConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatch {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Returns the gateway route host name match configuration.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatchConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRouteHostnameMatchConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
