package software.amazon.awscdk.services.appmesh;

/**
 * The criterion for determining a request match for this Route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-http", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.http(HttpRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder()
 *                         .virtualNode(node)
 *                         .weight(50)
 *                         .build(), WeightedTarget.builder()
 *                         .virtualNode(node)
 *                         .weight(50)
 *                         .build()))
 *                 .match(HttpRouteMatch.builder()
 *                         .path(HttpRoutePathMatch.startsWith("/path-to-app"))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:14.172Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HttpRouteMatch")
@software.amazon.jsii.Jsii.Proxy(HttpRouteMatch.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpRouteMatch extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the client request headers to match on.
     * <p>
     * All specified headers
     * must match for the route to match.
     * <p>
     * Default: - do not match on headers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> getHeaders() {
        return null;
    }

    /**
     * The HTTP client request method to match on.
     * <p>
     * Default: - do not match on request method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.HttpRouteMethod getMethod() {
        return null;
    }

    /**
     * Specifies how is the request matched based on the path part of its URL.
     * <p>
     * Default: - matches requests with all paths
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.HttpRoutePathMatch getPath() {
        return null;
    }

    /**
     * The port to match from the request.
     * <p>
     * Default: - do not match on port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The client request protocol to match on.
     * <p>
     * Applicable only for HTTP2 routes.
     * <p>
     * Default: - do not match on HTTP2 request protocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.HttpRouteProtocol getProtocol() {
        return null;
    }

    /**
     * The query parameters to match on.
     * <p>
     * All specified query parameters must match for the route to match.
     * <p>
     * Default: - do not match on query parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch> getQueryParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpRouteMatch> {
        java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> headers;
        software.amazon.awscdk.services.appmesh.HttpRouteMethod method;
        software.amazon.awscdk.services.appmesh.HttpRoutePathMatch path;
        java.lang.Number port;
        software.amazon.awscdk.services.appmesh.HttpRouteProtocol protocol;
        java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch> queryParameters;

        /**
         * Sets the value of {@link HttpRouteMatch#getHeaders}
         * @param headers Specifies the client request headers to match on.
         *                All specified headers
         *                must match for the route to match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder headers(java.util.List<? extends software.amazon.awscdk.services.appmesh.HeaderMatch> headers) {
            this.headers = (java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch>)headers;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteMatch#getMethod}
         * @param method The HTTP client request method to match on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.appmesh.HttpRouteMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteMatch#getPath}
         * @param path Specifies how is the request matched based on the path part of its URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(software.amazon.awscdk.services.appmesh.HttpRoutePathMatch path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteMatch#getPort}
         * @param port The port to match from the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteMatch#getProtocol}
         * @param protocol The client request protocol to match on.
         *                 Applicable only for HTTP2 routes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.appmesh.HttpRouteProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteMatch#getQueryParameters}
         * @param queryParameters The query parameters to match on.
         *                        All specified query parameters must match for the route to match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder queryParameters(java.util.List<? extends software.amazon.awscdk.services.appmesh.QueryParameterMatch> queryParameters) {
            this.queryParameters = (java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch>)queryParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpRouteMatch}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpRouteMatch build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpRouteMatch}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRouteMatch {
        private final java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> headers;
        private final software.amazon.awscdk.services.appmesh.HttpRouteMethod method;
        private final software.amazon.awscdk.services.appmesh.HttpRoutePathMatch path;
        private final java.lang.Number port;
        private final software.amazon.awscdk.services.appmesh.HttpRouteProtocol protocol;
        private final java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch> queryParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HeaderMatch.class)));
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpRouteMethod.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpRoutePathMatch.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpRouteProtocol.class));
            this.queryParameters = software.amazon.jsii.Kernel.get(this, "queryParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.QueryParameterMatch.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.headers = (java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch>)builder.headers;
            this.method = builder.method;
            this.path = builder.path;
            this.port = builder.port;
            this.protocol = builder.protocol;
            this.queryParameters = (java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch>)builder.queryParameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.HeaderMatch> getHeaders() {
            return this.headers;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.HttpRouteMethod getMethod() {
            return this.method;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.HttpRoutePathMatch getPath() {
            return this.path;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.HttpRouteProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.QueryParameterMatch> getQueryParameters() {
            return this.queryParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHeaders() != null) {
                data.set("headers", om.valueToTree(this.getHeaders()));
            }
            if (this.getMethod() != null) {
                data.set("method", om.valueToTree(this.getMethod()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getQueryParameters() != null) {
                data.set("queryParameters", om.valueToTree(this.getQueryParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.HttpRouteMatch"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpRouteMatch.Jsii$Proxy that = (HttpRouteMatch.Jsii$Proxy) o;

            if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
            if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            return this.queryParameters != null ? this.queryParameters.equals(that.queryParameters) : that.queryParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.headers != null ? this.headers.hashCode() : 0;
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.queryParameters != null ? this.queryParameters.hashCode() : 0);
            return result;
        }
    }
}
