package software.amazon.awscdk.services.appstream;

/**
 * Properties for defining a <code>CfnStackUserAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appstream.*;
 * CfnStackUserAssociationProps cfnStackUserAssociationProps = CfnStackUserAssociationProps.builder()
 *         .authenticationType("authenticationType")
 *         .stackName("stackName")
 *         .userName("userName")
 *         // the properties below are optional
 *         .sendEmailNotification(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:14.330Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appstream.CfnStackUserAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnStackUserAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStackUserAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The authentication type for the user who is associated with the stack.
     * <p>
     * You must specify USERPOOL.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-authenticationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType();

    /**
     * The name of the stack that is associated with the user.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-stackname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-stackname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackName();

    /**
     * The email address of the user who is associated with the stack.
     * <p>
     * <blockquote>
     * <p>
     * Users' email addresses are case-sensitive.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-username</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserName();

    /**
     * Specifies whether a welcome email is sent to a user after the user is created in the user pool.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-sendemailnotification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-sendemailnotification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSendEmailNotification() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStackUserAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStackUserAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStackUserAssociationProps> {
        java.lang.String authenticationType;
        java.lang.String stackName;
        java.lang.String userName;
        java.lang.Object sendEmailNotification;

        /**
         * Sets the value of {@link CfnStackUserAssociationProps#getAuthenticationType}
         * @param authenticationType The authentication type for the user who is associated with the stack. This parameter is required.
         *                           You must specify USERPOOL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(java.lang.String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackUserAssociationProps#getStackName}
         * @param stackName The name of the stack that is associated with the user. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(java.lang.String stackName) {
            this.stackName = stackName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackUserAssociationProps#getUserName}
         * @param userName The email address of the user who is associated with the stack. This parameter is required.
         *                 <blockquote>
         *                 <p>
         *                 Users' email addresses are case-sensitive.
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userName(java.lang.String userName) {
            this.userName = userName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackUserAssociationProps#getSendEmailNotification}
         * @param sendEmailNotification Specifies whether a welcome email is sent to a user after the user is created in the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendEmailNotification(java.lang.Boolean sendEmailNotification) {
            this.sendEmailNotification = sendEmailNotification;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackUserAssociationProps#getSendEmailNotification}
         * @param sendEmailNotification Specifies whether a welcome email is sent to a user after the user is created in the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendEmailNotification(software.amazon.awscdk.IResolvable sendEmailNotification) {
            this.sendEmailNotification = sendEmailNotification;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStackUserAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStackUserAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStackUserAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStackUserAssociationProps {
        private final java.lang.String authenticationType;
        private final java.lang.String stackName;
        private final java.lang.String userName;
        private final java.lang.Object sendEmailNotification;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackName = software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userName = software.amazon.jsii.Kernel.get(this, "userName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sendEmailNotification = software.amazon.jsii.Kernel.get(this, "sendEmailNotification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authenticationType = java.util.Objects.requireNonNull(builder.authenticationType, "authenticationType is required");
            this.stackName = java.util.Objects.requireNonNull(builder.stackName, "stackName is required");
            this.userName = java.util.Objects.requireNonNull(builder.userName, "userName is required");
            this.sendEmailNotification = builder.sendEmailNotification;
        }

        @Override
        public final java.lang.String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final java.lang.String getStackName() {
            return this.stackName;
        }

        @Override
        public final java.lang.String getUserName() {
            return this.userName;
        }

        @Override
        public final java.lang.Object getSendEmailNotification() {
            return this.sendEmailNotification;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
            data.set("stackName", om.valueToTree(this.getStackName()));
            data.set("userName", om.valueToTree(this.getUserName()));
            if (this.getSendEmailNotification() != null) {
                data.set("sendEmailNotification", om.valueToTree(this.getSendEmailNotification()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appstream.CfnStackUserAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStackUserAssociationProps.Jsii$Proxy that = (CfnStackUserAssociationProps.Jsii$Proxy) o;

            if (!authenticationType.equals(that.authenticationType)) return false;
            if (!stackName.equals(that.stackName)) return false;
            if (!userName.equals(that.userName)) return false;
            return this.sendEmailNotification != null ? this.sendEmailNotification.equals(that.sendEmailNotification) : that.sendEmailNotification == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authenticationType.hashCode();
            result = 31 * result + (this.stackName.hashCode());
            result = 31 * result + (this.userName.hashCode());
            result = 31 * result + (this.sendEmailNotification != null ? this.sendEmailNotification.hashCode() : 0);
            return result;
        }
    }
}
