package software.amazon.awscdk.services.appsync;

/**
 * the CDK properties for AppSync Functions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * AppsyncFunction appsyncFunction = AppsyncFunction.Builder.create(this, "function")
 *         .name("appsync_function")
 *         .api(api)
 *         .dataSource(api.addNoneDataSource("none"))
 *         .requestMappingTemplate(MappingTemplate.fromFile("request.vtl"))
 *         .responseMappingTemplate(MappingTemplate.fromFile("response.vtl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:14.364Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppsyncFunctionProps")
@software.amazon.jsii.Jsii.Proxy(AppsyncFunctionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AppsyncFunctionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appsync.BaseAppsyncFunctionProps {

    /**
     * the GraphQL Api linked to this AppSync Function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi getApi();

    /**
     * the data source linked to this AppSync Function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.BaseDataSource getDataSource();

    /**
     * @return a {@link Builder} of {@link AppsyncFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppsyncFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AppsyncFunctionProps> {
        software.amazon.awscdk.services.appsync.IGraphqlApi api;
        software.amazon.awscdk.services.appsync.BaseDataSource dataSource;
        java.lang.String name;
        software.amazon.awscdk.services.appsync.Code code;
        java.lang.String description;
        java.lang.Number maxBatchSize;
        software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate;
        software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate;
        software.amazon.awscdk.services.appsync.FunctionRuntime runtime;

        /**
         * Sets the value of {@link AppsyncFunctionProps#getApi}
         * @param api the GraphQL Api linked to this AppSync Function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(software.amazon.awscdk.services.appsync.IGraphqlApi api) {
            this.api = api;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getDataSource}
         * @param dataSource the data source linked to this AppSync Function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSource(software.amazon.awscdk.services.appsync.BaseDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getName}
         * @param name the name of the AppSync Function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getCode}
         * @param code The function code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.services.appsync.Code code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getDescription}
         * @param description the description for this AppSync Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getMaxBatchSize}
         * @param maxBatchSize The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a BatchInvoke operation.
         *                     Can only be set when using LambdaDataSource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchSize(java.lang.Number maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getRequestMappingTemplate}
         * @param requestMappingTemplate the request mapping template for the AppSync Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestMappingTemplate(software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getResponseMappingTemplate}
         * @param responseMappingTemplate the response mapping template for the AppSync Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseMappingTemplate(software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link AppsyncFunctionProps#getRuntime}
         * @param runtime The functions runtime.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(software.amazon.awscdk.services.appsync.FunctionRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppsyncFunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AppsyncFunctionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppsyncFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppsyncFunctionProps {
        private final software.amazon.awscdk.services.appsync.IGraphqlApi api;
        private final software.amazon.awscdk.services.appsync.BaseDataSource dataSource;
        private final java.lang.String name;
        private final software.amazon.awscdk.services.appsync.Code code;
        private final java.lang.String description;
        private final java.lang.Number maxBatchSize;
        private final software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate;
        private final software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate;
        private final software.amazon.awscdk.services.appsync.FunctionRuntime runtime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.api = software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IGraphqlApi.class));
            this.dataSource = software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.BaseDataSource.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Code.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxBatchSize = software.amazon.jsii.Kernel.get(this, "maxBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.requestMappingTemplate = software.amazon.jsii.Kernel.get(this, "requestMappingTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
            this.responseMappingTemplate = software.amazon.jsii.Kernel.get(this, "responseMappingTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
            this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.FunctionRuntime.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.api = java.util.Objects.requireNonNull(builder.api, "api is required");
            this.dataSource = java.util.Objects.requireNonNull(builder.dataSource, "dataSource is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.code = builder.code;
            this.description = builder.description;
            this.maxBatchSize = builder.maxBatchSize;
            this.requestMappingTemplate = builder.requestMappingTemplate;
            this.responseMappingTemplate = builder.responseMappingTemplate;
            this.runtime = builder.runtime;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.IGraphqlApi getApi() {
            return this.api;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.BaseDataSource getDataSource() {
            return this.dataSource;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.Code getCode() {
            return this.code;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.MappingTemplate getRequestMappingTemplate() {
            return this.requestMappingTemplate;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.MappingTemplate getResponseMappingTemplate() {
            return this.responseMappingTemplate;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.FunctionRuntime getRuntime() {
            return this.runtime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("api", om.valueToTree(this.getApi()));
            data.set("dataSource", om.valueToTree(this.getDataSource()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getCode() != null) {
                data.set("code", om.valueToTree(this.getCode()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMaxBatchSize() != null) {
                data.set("maxBatchSize", om.valueToTree(this.getMaxBatchSize()));
            }
            if (this.getRequestMappingTemplate() != null) {
                data.set("requestMappingTemplate", om.valueToTree(this.getRequestMappingTemplate()));
            }
            if (this.getResponseMappingTemplate() != null) {
                data.set("responseMappingTemplate", om.valueToTree(this.getResponseMappingTemplate()));
            }
            if (this.getRuntime() != null) {
                data.set("runtime", om.valueToTree(this.getRuntime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.AppsyncFunctionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppsyncFunctionProps.Jsii$Proxy that = (AppsyncFunctionProps.Jsii$Proxy) o;

            if (!api.equals(that.api)) return false;
            if (!dataSource.equals(that.dataSource)) return false;
            if (!name.equals(that.name)) return false;
            if (this.code != null ? !this.code.equals(that.code) : that.code != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.maxBatchSize != null ? !this.maxBatchSize.equals(that.maxBatchSize) : that.maxBatchSize != null) return false;
            if (this.requestMappingTemplate != null ? !this.requestMappingTemplate.equals(that.requestMappingTemplate) : that.requestMappingTemplate != null) return false;
            if (this.responseMappingTemplate != null ? !this.responseMappingTemplate.equals(that.responseMappingTemplate) : that.responseMappingTemplate != null) return false;
            return this.runtime != null ? this.runtime.equals(that.runtime) : that.runtime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.api.hashCode();
            result = 31 * result + (this.dataSource.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.maxBatchSize != null ? this.maxBatchSize.hashCode() : 0);
            result = 31 * result + (this.requestMappingTemplate != null ? this.requestMappingTemplate.hashCode() : 0);
            result = 31 * result + (this.responseMappingTemplate != null ? this.responseMappingTemplate.hashCode() : 0);
            result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
            return result;
        }
    }
}
