package software.amazon.awscdk.services.appsync;

/**
 * Authorization configuration for the Channel Namespace.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EventApi api;
 * ChannelNamespace.Builder.create(this, "Namespace")
 *         .api(api)
 *         .authorizationConfig(NamespaceAuthConfig.builder()
 *                 // Override publishing authorization to API Key
 *                 .publishAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 // Override subscribing authorization to Lambda
 *                 .subscribeAuthModeTypes(List.of(AppSyncAuthorizationType.LAMBDA))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:14.536Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.NamespaceAuthConfig")
@software.amazon.jsii.Jsii.Proxy(NamespaceAuthConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NamespaceAuthConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The publish auth modes for this Event Api.
     * <p>
     * Default: - API Key authorization
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getPublishAuthModeTypes() {
        return null;
    }

    /**
     * The subscribe auth modes for this Event Api.
     * <p>
     * Default: - API Key authorization
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getSubscribeAuthModeTypes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NamespaceAuthConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NamespaceAuthConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NamespaceAuthConfig> {
        java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> publishAuthModeTypes;
        java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> subscribeAuthModeTypes;

        /**
         * Sets the value of {@link NamespaceAuthConfig#getPublishAuthModeTypes}
         * @param publishAuthModeTypes The publish auth modes for this Event Api.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder publishAuthModeTypes(java.util.List<? extends software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> publishAuthModeTypes) {
            this.publishAuthModeTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)publishAuthModeTypes;
            return this;
        }

        /**
         * Sets the value of {@link NamespaceAuthConfig#getSubscribeAuthModeTypes}
         * @param subscribeAuthModeTypes The subscribe auth modes for this Event Api.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder subscribeAuthModeTypes(java.util.List<? extends software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> subscribeAuthModeTypes) {
            this.subscribeAuthModeTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)subscribeAuthModeTypes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NamespaceAuthConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NamespaceAuthConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NamespaceAuthConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NamespaceAuthConfig {
        private final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> publishAuthModeTypes;
        private final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> subscribeAuthModeTypes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.publishAuthModeTypes = software.amazon.jsii.Kernel.get(this, "publishAuthModeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class)));
            this.subscribeAuthModeTypes = software.amazon.jsii.Kernel.get(this, "subscribeAuthModeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.publishAuthModeTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)builder.publishAuthModeTypes;
            this.subscribeAuthModeTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)builder.subscribeAuthModeTypes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getPublishAuthModeTypes() {
            return this.publishAuthModeTypes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getSubscribeAuthModeTypes() {
            return this.subscribeAuthModeTypes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPublishAuthModeTypes() != null) {
                data.set("publishAuthModeTypes", om.valueToTree(this.getPublishAuthModeTypes()));
            }
            if (this.getSubscribeAuthModeTypes() != null) {
                data.set("subscribeAuthModeTypes", om.valueToTree(this.getSubscribeAuthModeTypes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.NamespaceAuthConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NamespaceAuthConfig.Jsii$Proxy that = (NamespaceAuthConfig.Jsii$Proxy) o;

            if (this.publishAuthModeTypes != null ? !this.publishAuthModeTypes.equals(that.publishAuthModeTypes) : that.publishAuthModeTypes != null) return false;
            return this.subscribeAuthModeTypes != null ? this.subscribeAuthModeTypes.equals(that.subscribeAuthModeTypes) : that.subscribeAuthModeTypes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.publishAuthModeTypes != null ? this.publishAuthModeTypes.hashCode() : 0;
            result = 31 * result + (this.subscribeAuthModeTypes != null ? this.subscribeAuthModeTypes.hashCode() : 0);
            return result;
        }
    }
}
