package software.amazon.awscdk.services.aps;

/**
 * Properties for defining a <code>CfnAnomalyDetector</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.aps.*;
 * CfnAnomalyDetectorProps cfnAnomalyDetectorProps = CfnAnomalyDetectorProps.builder()
 *         .alias("alias")
 *         .configuration(AnomalyDetectorConfigurationProperty.builder()
 *                 .randomCutForest(RandomCutForestConfigurationProperty.builder()
 *                         .query("query")
 *                         // the properties below are optional
 *                         .ignoreNearExpectedFromAbove(IgnoreNearExpectedProperty.builder()
 *                                 .amount(123)
 *                                 .ratio(123)
 *                                 .build())
 *                         .ignoreNearExpectedFromBelow(IgnoreNearExpectedProperty.builder()
 *                                 .amount(123)
 *                                 .ratio(123)
 *                                 .build())
 *                         .sampleSize(123)
 *                         .shingleSize(123)
 *                         .build())
 *                 .build())
 *         .workspace("workspace")
 *         // the properties below are optional
 *         .evaluationIntervalInSeconds(123)
 *         .labels(List.of(LabelProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .missingDataAction(MissingDataActionProperty.builder()
 *                 .markAsAnomaly(false)
 *                 .skip(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:14.589Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnAnomalyDetectorProps")
@software.amazon.jsii.Jsii.Proxy(CfnAnomalyDetectorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAnomalyDetectorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The user-friendly name of the anomaly detector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-alias</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAlias();

    /**
     * The algorithm configuration of the anomaly detector.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnAnomalyDetector.AnomalyDetectorConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration();

    /**
     * An Amazon Managed Service for Prometheus workspace is a logical and isolated Prometheus server dedicated to ingesting, storing, and querying your Prometheus-compatible metrics.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-workspace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-workspace</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkspace();

    /**
     * The frequency, in seconds, at which the anomaly detector evaluates metrics.
     * <p>
     * Default: - 60
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-evaluationintervalinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-evaluationintervalinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getEvaluationIntervalInSeconds() {
        return null;
    }

    /**
     * The Amazon Managed Service for Prometheus metric labels associated with the anomaly detector.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnAnomalyDetector.LabelProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-labels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-labels</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLabels() {
        return null;
    }

    /**
     * The action taken when data is missing during evaluation.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnAnomalyDetector.MissingDataActionProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-missingdataaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-missingdataaction</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMissingDataAction() {
        return null;
    }

    /**
     * The tags applied to the anomaly detector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-anomalydetector.html#cfn-aps-anomalydetector-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAnomalyDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAnomalyDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAnomalyDetectorProps> {
        java.lang.String alias;
        java.lang.Object configuration;
        java.lang.String workspace;
        java.lang.Number evaluationIntervalInSeconds;
        java.lang.Object labels;
        java.lang.Object missingDataAction;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getAlias}
         * @param alias The user-friendly name of the anomaly detector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(java.lang.String alias) {
            this.alias = alias;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getConfiguration}
         * @param configuration The algorithm configuration of the anomaly detector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getConfiguration}
         * @param configuration The algorithm configuration of the anomaly detector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.aps.CfnAnomalyDetector.AnomalyDetectorConfigurationProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getWorkspace}
         * @param workspace An Amazon Managed Service for Prometheus workspace is a logical and isolated Prometheus server dedicated to ingesting, storing, and querying your Prometheus-compatible metrics. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspace(java.lang.String workspace) {
            this.workspace = workspace;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getEvaluationIntervalInSeconds}
         * @param evaluationIntervalInSeconds The frequency, in seconds, at which the anomaly detector evaluates metrics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationIntervalInSeconds(java.lang.Number evaluationIntervalInSeconds) {
            this.evaluationIntervalInSeconds = evaluationIntervalInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getLabels}
         * @param labels The Amazon Managed Service for Prometheus metric labels associated with the anomaly detector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(software.amazon.awscdk.IResolvable labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getLabels}
         * @param labels The Amazon Managed Service for Prometheus metric labels associated with the anomaly detector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.List<? extends java.lang.Object> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getMissingDataAction}
         * @param missingDataAction The action taken when data is missing during evaluation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder missingDataAction(software.amazon.awscdk.IResolvable missingDataAction) {
            this.missingDataAction = missingDataAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getMissingDataAction}
         * @param missingDataAction The action taken when data is missing during evaluation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder missingDataAction(software.amazon.awscdk.services.aps.CfnAnomalyDetector.MissingDataActionProperty missingDataAction) {
            this.missingDataAction = missingDataAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalyDetectorProps#getTags}
         * @param tags The tags applied to the anomaly detector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAnomalyDetectorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAnomalyDetectorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAnomalyDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAnomalyDetectorProps {
        private final java.lang.String alias;
        private final java.lang.Object configuration;
        private final java.lang.String workspace;
        private final java.lang.Number evaluationIntervalInSeconds;
        private final java.lang.Object labels;
        private final java.lang.Object missingDataAction;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.workspace = software.amazon.jsii.Kernel.get(this, "workspace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.evaluationIntervalInSeconds = software.amazon.jsii.Kernel.get(this, "evaluationIntervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.missingDataAction = software.amazon.jsii.Kernel.get(this, "missingDataAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
            this.workspace = java.util.Objects.requireNonNull(builder.workspace, "workspace is required");
            this.evaluationIntervalInSeconds = builder.evaluationIntervalInSeconds;
            this.labels = builder.labels;
            this.missingDataAction = builder.missingDataAction;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAlias() {
            return this.alias;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getWorkspace() {
            return this.workspace;
        }

        @Override
        public final java.lang.Number getEvaluationIntervalInSeconds() {
            return this.evaluationIntervalInSeconds;
        }

        @Override
        public final java.lang.Object getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.Object getMissingDataAction() {
            return this.missingDataAction;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alias", om.valueToTree(this.getAlias()));
            data.set("configuration", om.valueToTree(this.getConfiguration()));
            data.set("workspace", om.valueToTree(this.getWorkspace()));
            if (this.getEvaluationIntervalInSeconds() != null) {
                data.set("evaluationIntervalInSeconds", om.valueToTree(this.getEvaluationIntervalInSeconds()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getMissingDataAction() != null) {
                data.set("missingDataAction", om.valueToTree(this.getMissingDataAction()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnAnomalyDetectorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAnomalyDetectorProps.Jsii$Proxy that = (CfnAnomalyDetectorProps.Jsii$Proxy) o;

            if (!alias.equals(that.alias)) return false;
            if (!configuration.equals(that.configuration)) return false;
            if (!workspace.equals(that.workspace)) return false;
            if (this.evaluationIntervalInSeconds != null ? !this.evaluationIntervalInSeconds.equals(that.evaluationIntervalInSeconds) : that.evaluationIntervalInSeconds != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.missingDataAction != null ? !this.missingDataAction.equals(that.missingDataAction) : that.missingDataAction != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alias.hashCode();
            result = 31 * result + (this.configuration.hashCode());
            result = 31 * result + (this.workspace.hashCode());
            result = 31 * result + (this.evaluationIntervalInSeconds != null ? this.evaluationIntervalInSeconds.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.missingDataAction != null ? this.missingDataAction.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
