package software.amazon.awscdk.services.aps;

/**
 * Properties for defining a <code>CfnWorkspace</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.aps.*;
 * CfnWorkspaceProps cfnWorkspaceProps = CfnWorkspaceProps.builder()
 *         .alertManagerDefinition("alertManagerDefinition")
 *         .alias("alias")
 *         .kmsKeyArn("kmsKeyArn")
 *         .loggingConfiguration(LoggingConfigurationProperty.builder()
 *                 .logGroupArn("logGroupArn")
 *                 .build())
 *         .queryLoggingConfiguration(QueryLoggingConfigurationProperty.builder()
 *                 .destinations(List.of(LoggingDestinationProperty.builder()
 *                         .cloudWatchLogs(CloudWatchLogDestinationProperty.builder()
 *                                 .logGroupArn("logGroupArn")
 *                                 .build())
 *                         .filters(LoggingFilterProperty.builder()
 *                                 .qspThreshold(123)
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workspaceConfiguration(WorkspaceConfigurationProperty.builder()
 *                 .limitsPerLabelSets(List.of(LimitsPerLabelSetProperty.builder()
 *                         .labelSet(List.of(LabelProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .limits(LimitsPerLabelSetEntryProperty.builder()
 *                                 .maxSeries(123)
 *                                 .build())
 *                         .build()))
 *                 .retentionPeriodInDays(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:14.623Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnWorkspaceProps")
@software.amazon.jsii.Jsii.Proxy(CfnWorkspaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWorkspaceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The alert manager definition, a YAML configuration for the alert manager in your Amazon Managed Service for Prometheus workspace.
     * <p>
     * For details about the alert manager definition, see <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alertmanager-config.html">Creating an alert manager configuration files</a> in the <em>Amazon Managed Service for Prometheus User Guide</em> .
     * <p>
     * The following example shows part of a CloudFormation YAML file with an embedded alert manager definition (following the <code>- |-</code> ).
     * <p>
     * <code>Workspace: Type: AWS::APS::Workspace .... Properties: .... AlertManagerDefinition: Fn::Sub: - |- alertmanager_config: | templates: - 'default_template' route: receiver: example-sns receivers: - name: example-sns sns_configs: - topic_arn: 'arn:aws:sns:${AWS::Region}:${AWS::AccountId}:${TopicName}' -</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-alertmanagerdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-alertmanagerdefinition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlertManagerDefinition() {
        return null;
    }

    /**
     * The alias that is assigned to this workspace to help identify it.
     * <p>
     * It does not need to be unique.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-alias</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlias() {
        return null;
    }

    /**
     * (optional) The ARN for a customer managed AWS  key to use for encrypting data within your workspace.
     * <p>
     * For more information about using your own key in your workspace, see <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/encryption-at-rest-Amazon-Service-Prometheus.html">Encryption at rest</a> in the <em>Amazon Managed Service for Prometheus User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-kmskeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * Contains information about the logging configuration for the workspace.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.LoggingConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-loggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-loggingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfiguration() {
        return null;
    }

    /**
     * The definition of logging configuration in an Amazon Managed Service for Prometheus workspace.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.QueryLoggingConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-queryloggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-queryloggingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getQueryLoggingConfiguration() {
        return null;
    }

    /**
     * The list of tag keys and values that are associated with the workspace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Use this structure to define label sets and the ingestion limits for time series that match label sets, and to specify the retention period of the workspace.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.aps.CfnWorkspace.WorkspaceConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-workspaceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-workspace.html#cfn-aps-workspace-workspaceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWorkspaceConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWorkspaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWorkspaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWorkspaceProps> {
        java.lang.String alertManagerDefinition;
        java.lang.String alias;
        java.lang.String kmsKeyArn;
        java.lang.Object loggingConfiguration;
        java.lang.Object queryLoggingConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object workspaceConfiguration;

        /**
         * Sets the value of {@link CfnWorkspaceProps#getAlertManagerDefinition}
         * @param alertManagerDefinition The alert manager definition, a YAML configuration for the alert manager in your Amazon Managed Service for Prometheus workspace.
         *                               For details about the alert manager definition, see <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alertmanager-config.html">Creating an alert manager configuration files</a> in the <em>Amazon Managed Service for Prometheus User Guide</em> .
         *                               <p>
         *                               The following example shows part of a CloudFormation YAML file with an embedded alert manager definition (following the <code>- |-</code> ).
         *                               <p>
         *                               <code>Workspace: Type: AWS::APS::Workspace .... Properties: .... AlertManagerDefinition: Fn::Sub: - |- alertmanager_config: | templates: - 'default_template' route: receiver: example-sns receivers: - name: example-sns sns_configs: - topic_arn: 'arn:aws:sns:${AWS::Region}:${AWS::AccountId}:${TopicName}' -</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alertManagerDefinition(java.lang.String alertManagerDefinition) {
            this.alertManagerDefinition = alertManagerDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getAlias}
         * @param alias The alias that is assigned to this workspace to help identify it.
         *              It does not need to be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(java.lang.String alias) {
            this.alias = alias;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getKmsKeyArn}
         * @param kmsKeyArn (optional) The ARN for a customer managed AWS  key to use for encrypting data within your workspace.
         *                  For more information about using your own key in your workspace, see <a href="https://docs.aws.amazon.com/prometheus/latest/userguide/encryption-at-rest-Amazon-Service-Prometheus.html">Encryption at rest</a> in the <em>Amazon Managed Service for Prometheus User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getLoggingConfiguration}
         * @param loggingConfiguration Contains information about the logging configuration for the workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(software.amazon.awscdk.IResolvable loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getLoggingConfiguration}
         * @param loggingConfiguration Contains information about the logging configuration for the workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(software.amazon.awscdk.services.aps.CfnWorkspace.LoggingConfigurationProperty loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getQueryLoggingConfiguration}
         * @param queryLoggingConfiguration The definition of logging configuration in an Amazon Managed Service for Prometheus workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLoggingConfiguration(software.amazon.awscdk.IResolvable queryLoggingConfiguration) {
            this.queryLoggingConfiguration = queryLoggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getQueryLoggingConfiguration}
         * @param queryLoggingConfiguration The definition of logging configuration in an Amazon Managed Service for Prometheus workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLoggingConfiguration(software.amazon.awscdk.services.aps.CfnWorkspace.QueryLoggingConfigurationProperty queryLoggingConfiguration) {
            this.queryLoggingConfiguration = queryLoggingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getTags}
         * @param tags The list of tag keys and values that are associated with the workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getWorkspaceConfiguration}
         * @param workspaceConfiguration Use this structure to define label sets and the ingestion limits for time series that match label sets, and to specify the retention period of the workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceConfiguration(software.amazon.awscdk.IResolvable workspaceConfiguration) {
            this.workspaceConfiguration = workspaceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkspaceProps#getWorkspaceConfiguration}
         * @param workspaceConfiguration Use this structure to define label sets and the ingestion limits for time series that match label sets, and to specify the retention period of the workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceConfiguration(software.amazon.awscdk.services.aps.CfnWorkspace.WorkspaceConfigurationProperty workspaceConfiguration) {
            this.workspaceConfiguration = workspaceConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWorkspaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWorkspaceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWorkspaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWorkspaceProps {
        private final java.lang.String alertManagerDefinition;
        private final java.lang.String alias;
        private final java.lang.String kmsKeyArn;
        private final java.lang.Object loggingConfiguration;
        private final java.lang.Object queryLoggingConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object workspaceConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alertManagerDefinition = software.amazon.jsii.Kernel.get(this, "alertManagerDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingConfiguration = software.amazon.jsii.Kernel.get(this, "loggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.queryLoggingConfiguration = software.amazon.jsii.Kernel.get(this, "queryLoggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.workspaceConfiguration = software.amazon.jsii.Kernel.get(this, "workspaceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alertManagerDefinition = builder.alertManagerDefinition;
            this.alias = builder.alias;
            this.kmsKeyArn = builder.kmsKeyArn;
            this.loggingConfiguration = builder.loggingConfiguration;
            this.queryLoggingConfiguration = builder.queryLoggingConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.workspaceConfiguration = builder.workspaceConfiguration;
        }

        @Override
        public final java.lang.String getAlertManagerDefinition() {
            return this.alertManagerDefinition;
        }

        @Override
        public final java.lang.String getAlias() {
            return this.alias;
        }

        @Override
        public final java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final java.lang.Object getLoggingConfiguration() {
            return this.loggingConfiguration;
        }

        @Override
        public final java.lang.Object getQueryLoggingConfiguration() {
            return this.queryLoggingConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getWorkspaceConfiguration() {
            return this.workspaceConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAlertManagerDefinition() != null) {
                data.set("alertManagerDefinition", om.valueToTree(this.getAlertManagerDefinition()));
            }
            if (this.getAlias() != null) {
                data.set("alias", om.valueToTree(this.getAlias()));
            }
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getLoggingConfiguration() != null) {
                data.set("loggingConfiguration", om.valueToTree(this.getLoggingConfiguration()));
            }
            if (this.getQueryLoggingConfiguration() != null) {
                data.set("queryLoggingConfiguration", om.valueToTree(this.getQueryLoggingConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkspaceConfiguration() != null) {
                data.set("workspaceConfiguration", om.valueToTree(this.getWorkspaceConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnWorkspaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWorkspaceProps.Jsii$Proxy that = (CfnWorkspaceProps.Jsii$Proxy) o;

            if (this.alertManagerDefinition != null ? !this.alertManagerDefinition.equals(that.alertManagerDefinition) : that.alertManagerDefinition != null) return false;
            if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            if (this.loggingConfiguration != null ? !this.loggingConfiguration.equals(that.loggingConfiguration) : that.loggingConfiguration != null) return false;
            if (this.queryLoggingConfiguration != null ? !this.queryLoggingConfiguration.equals(that.queryLoggingConfiguration) : that.queryLoggingConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.workspaceConfiguration != null ? this.workspaceConfiguration.equals(that.workspaceConfiguration) : that.workspaceConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alertManagerDefinition != null ? this.alertManagerDefinition.hashCode() : 0;
            result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.loggingConfiguration != null ? this.loggingConfiguration.hashCode() : 0);
            result = 31 * result + (this.queryLoggingConfiguration != null ? this.queryLoggingConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workspaceConfiguration != null ? this.workspaceConfiguration.hashCode() : 0);
            return result;
        }
    }
}
