package software.amazon.awscdk.services.athena;

/**
 * The AWS::Athena::WorkGroup resource specifies an Amazon Athena workgroup, which contains a name, description, creation time, state, and other configuration, listed under <code>WorkGroupConfiguration</code> .
 * <p>
 * Each workgroup enables you to isolate queries for you or your group from other queries in the same account. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/APIReference/API_CreateWorkGroup.html">CreateWorkGroup</a> in the <em>Amazon Athena API Reference</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.athena.*;
 * CfnWorkGroup cfnWorkGroup = CfnWorkGroup.Builder.create(this, "MyCfnWorkGroup")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .recursiveDeleteOption(false)
 *         .state("state")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workGroupConfiguration(WorkGroupConfigurationProperty.builder()
 *                 .additionalConfiguration("additionalConfiguration")
 *                 .bytesScannedCutoffPerQuery(123)
 *                 .customerContentEncryptionConfiguration(CustomerContentEncryptionConfigurationProperty.builder()
 *                         .kmsKey("kmsKey")
 *                         .build())
 *                 .enforceWorkGroupConfiguration(false)
 *                 .engineConfiguration(EngineConfigurationProperty.builder()
 *                         .additionalConfigs(Map.of(
 *                                 "additionalConfigsKey", "additionalConfigs"))
 *                         .classifications(List.of(ClassificationProperty.builder()
 *                                 .name("name")
 *                                 .properties(Map.of(
 *                                         "propertiesKey", "properties"))
 *                                 .build()))
 *                         .coordinatorDpuSize(123)
 *                         .defaultExecutorDpuSize(123)
 *                         .maxConcurrentDpus(123)
 *                         .sparkProperties(Map.of(
 *                                 "sparkPropertiesKey", "sparkProperties"))
 *                         .build())
 *                 .engineVersion(EngineVersionProperty.builder()
 *                         .effectiveEngineVersion("effectiveEngineVersion")
 *                         .selectedEngineVersion("selectedEngineVersion")
 *                         .build())
 *                 .executionRole("executionRole")
 *                 .managedQueryResultsConfiguration(ManagedQueryResultsConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .encryptionConfiguration(ManagedStorageEncryptionConfigurationProperty.builder()
 *                                 .kmsKey("kmsKey")
 *                                 .build())
 *                         .build())
 *                 .monitoringConfiguration(MonitoringConfigurationProperty.builder()
 *                         .cloudWatchLoggingConfiguration(CloudWatchLoggingConfigurationProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroup("logGroup")
 *                                 .logStreamNamePrefix("logStreamNamePrefix")
 *                                 .logTypes(Map.of(
 *                                         "logTypesKey", List.of("logTypes")))
 *                                 .build())
 *                         .managedLoggingConfiguration(ManagedLoggingConfigurationProperty.builder()
 *                                 .enabled(false)
 *                                 .kmsKey("kmsKey")
 *                                 .build())
 *                         .s3LoggingConfiguration(S3LoggingConfigurationProperty.builder()
 *                                 .enabled(false)
 *                                 .kmsKey("kmsKey")
 *                                 .logLocation("logLocation")
 *                                 .build())
 *                         .build())
 *                 .publishCloudWatchMetricsEnabled(false)
 *                 .requesterPaysEnabled(false)
 *                 .resultConfiguration(ResultConfigurationProperty.builder()
 *                         .aclConfiguration(AclConfigurationProperty.builder()
 *                                 .s3AclOption("s3AclOption")
 *                                 .build())
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .encryptionOption("encryptionOption")
 *                                 // the properties below are optional
 *                                 .kmsKey("kmsKey")
 *                                 .build())
 *                         .expectedBucketOwner("expectedBucketOwner")
 *                         .outputLocation("outputLocation")
 *                         .build())
 *                 .build())
 *         .workGroupConfigurationUpdates(WorkGroupConfigurationUpdatesProperty.builder()
 *                 .additionalConfiguration("additionalConfiguration")
 *                 .bytesScannedCutoffPerQuery(123)
 *                 .customerContentEncryptionConfiguration(CustomerContentEncryptionConfigurationProperty.builder()
 *                         .kmsKey("kmsKey")
 *                         .build())
 *                 .enforceWorkGroupConfiguration(false)
 *                 .engineConfiguration(EngineConfigurationProperty.builder()
 *                         .additionalConfigs(Map.of(
 *                                 "additionalConfigsKey", "additionalConfigs"))
 *                         .classifications(List.of(ClassificationProperty.builder()
 *                                 .name("name")
 *                                 .properties(Map.of(
 *                                         "propertiesKey", "properties"))
 *                                 .build()))
 *                         .coordinatorDpuSize(123)
 *                         .defaultExecutorDpuSize(123)
 *                         .maxConcurrentDpus(123)
 *                         .sparkProperties(Map.of(
 *                                 "sparkPropertiesKey", "sparkProperties"))
 *                         .build())
 *                 .engineVersion(EngineVersionProperty.builder()
 *                         .effectiveEngineVersion("effectiveEngineVersion")
 *                         .selectedEngineVersion("selectedEngineVersion")
 *                         .build())
 *                 .executionRole("executionRole")
 *                 .managedQueryResultsConfiguration(ManagedQueryResultsConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .encryptionConfiguration(ManagedStorageEncryptionConfigurationProperty.builder()
 *                                 .kmsKey("kmsKey")
 *                                 .build())
 *                         .build())
 *                 .monitoringConfiguration(MonitoringConfigurationProperty.builder()
 *                         .cloudWatchLoggingConfiguration(CloudWatchLoggingConfigurationProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroup("logGroup")
 *                                 .logStreamNamePrefix("logStreamNamePrefix")
 *                                 .logTypes(Map.of(
 *                                         "logTypesKey", List.of("logTypes")))
 *                                 .build())
 *                         .managedLoggingConfiguration(ManagedLoggingConfigurationProperty.builder()
 *                                 .enabled(false)
 *                                 .kmsKey("kmsKey")
 *                                 .build())
 *                         .s3LoggingConfiguration(S3LoggingConfigurationProperty.builder()
 *                                 .enabled(false)
 *                                 .kmsKey("kmsKey")
 *                                 .logLocation("logLocation")
 *                                 .build())
 *                         .build())
 *                 .publishCloudWatchMetricsEnabled(false)
 *                 .removeBytesScannedCutoffPerQuery(false)
 *                 .removeCustomerContentEncryptionConfiguration(false)
 *                 .requesterPaysEnabled(false)
 *                 .resultConfigurationUpdates(ResultConfigurationUpdatesProperty.builder()
 *                         .aclConfiguration(AclConfigurationProperty.builder()
 *                                 .s3AclOption("s3AclOption")
 *                                 .build())
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .encryptionOption("encryptionOption")
 *                                 // the properties below are optional
 *                                 .kmsKey("kmsKey")
 *                                 .build())
 *                         .expectedBucketOwner("expectedBucketOwner")
 *                         .outputLocation("outputLocation")
 *                         .removeAclConfiguration(false)
 *                         .removeEncryptionConfiguration(false)
 *                         .removeExpectedBucketOwner(false)
 *                         .removeOutputLocation(false)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:14.681Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup")
public class CfnWorkGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.athena.IWorkGroupRef, software.amazon.awscdk.ITaggable {

    protected CfnWorkGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.athena.CfnWorkGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::Athena::WorkGroup</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.athena.CfnWorkGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForWorkGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.athena.IWorkGroupRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.athena.CfnWorkGroup.class, "arnForWorkGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Creates a new IWorkGroupRef from a workGroupName.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param workGroupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.athena.IWorkGroupRef fromWorkGroupName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String workGroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.athena.CfnWorkGroup.class, "fromWorkGroupName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.athena.IWorkGroupRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(workGroupName, "workGroupName is required") });
    }

    /**
     * Checks whether the given object is a CfnWorkGroup.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnWorkGroup(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.athena.CfnWorkGroup.class, "isCfnWorkGroup", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The date and time the workgroup was created, as a UNIX timestamp in seconds.
     * <p>
     * For example: <code>1582761016</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Read only.
     * <p>
     * The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a CreateWorkGroup or UpdateWorkGroup operation, the EffectiveEngineVersion field is ignored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkGroupConfigurationEngineVersionEffectiveEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkGroupConfigurationEngineVersionEffectiveEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Read only.
     * <p>
     * The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the <code>EffectiveEngineVersion</code> field is ignored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkGroupConfigurationUpdatesEngineVersionEffectiveEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkGroupConfigurationUpdatesEngineVersionEffectiveEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A reference to a WorkGroup resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.athena.WorkGroupReference getWorkGroupRef() {
        return software.amazon.jsii.Kernel.get(this, "workGroupRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.athena.WorkGroupReference.class));
    }

    /**
     * The workgroup name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The workgroup name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The workgroup description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The workgroup description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecursiveDeleteOption() {
        return software.amazon.jsii.Kernel.get(this, "recursiveDeleteOption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecursiveDeleteOption(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "recursiveDeleteOption", value);
    }

    /**
     * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecursiveDeleteOption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recursiveDeleteOption", value);
    }

    /**
     * The state of the workgroup: ENABLED or DISABLED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the workgroup: ENABLED or DISABLED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "state", value);
    }

    /**
     * The tags (key-value pairs) to associate with this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags (key-value pairs) to associate with this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWorkGroupConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "workGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkGroupConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workGroupConfiguration", value);
    }

    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkGroupConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "workGroupConfiguration", value);
    }

    /**
     * (deprecated) The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationUpdatesProperty}
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.Object getWorkGroupConfigurationUpdates() {
        return software.amazon.jsii.Kernel.get(this, "workGroupConfigurationUpdates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (deprecated) The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setWorkGroupConfigurationUpdates(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workGroupConfigurationUpdates", value);
    }

    /**
     * (deprecated) The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setWorkGroupConfigurationUpdates(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationUpdatesProperty value) {
        software.amazon.jsii.Kernel.set(this, "workGroupConfigurationUpdates", value);
    }
    /**
     * Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results, including data files inserted by Athena as the result of statements like CTAS or INSERT INTO.
     * <p>
     * When Athena stores query results in Amazon S3, the canned ACL is set with the <code>x-amz-acl</code> request header. For more information about S3 Object Ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html#object-ownership-overview">Object Ownership settings</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * AclConfigurationProperty aclConfigurationProperty = AclConfigurationProperty.builder()
     *         .s3AclOption("s3AclOption")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-aclconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-aclconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.AclConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AclConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AclConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 canned ACL that Athena should specify when storing query results, including data files inserted by Athena as the result of statements like CTAS or INSERT INTO.
         * <p>
         * Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code> . If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned ACL</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-aclconfiguration.html#cfn-athena-workgroup-aclconfiguration-s3acloption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-aclconfiguration.html#cfn-athena-workgroup-aclconfiguration-s3acloption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3AclOption();

        /**
         * @return a {@link Builder} of {@link AclConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AclConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AclConfigurationProperty> {
            java.lang.String s3AclOption;

            /**
             * Sets the value of {@link AclConfigurationProperty#getS3AclOption}
             * @param s3AclOption The Amazon S3 canned ACL that Athena should specify when storing query results, including data files inserted by Athena as the result of statements like CTAS or INSERT INTO. This parameter is required.
             *                    Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code> . If a query runs in a workgroup and the workgroup overrides client-side settings, then the Amazon S3 canned ACL specified in the workgroup's settings is used for all queries that run in the workgroup. For more information about Amazon S3 canned ACLs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">Canned ACL</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3AclOption(java.lang.String s3AclOption) {
                this.s3AclOption = s3AclOption;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AclConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AclConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AclConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AclConfigurationProperty {
            private final java.lang.String s3AclOption;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3AclOption = software.amazon.jsii.Kernel.get(this, "s3AclOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3AclOption = java.util.Objects.requireNonNull(builder.s3AclOption, "s3AclOption is required");
            }

            @Override
            public final java.lang.String getS3AclOption() {
                return this.s3AclOption;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3AclOption", om.valueToTree(this.getS3AclOption()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.AclConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AclConfigurationProperty.Jsii$Proxy that = (AclConfigurationProperty.Jsii$Proxy) o;

                return this.s3AclOption.equals(that.s3AclOption);
            }

            @Override
            public final int hashCode() {
                int result = this.s3AclOption.hashCode();
                return result;
            }
        }
    }
    /**
     * A classification refers to a set of specific configurations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * ClassificationProperty classificationProperty = ClassificationProperty.builder()
     *         .name("name")
     *         .properties(Map.of(
     *                 "propertiesKey", "properties"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-classification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-classification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.ClassificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ClassificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClassificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the configuration classification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-classification.html#cfn-athena-workgroup-classification-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-classification.html#cfn-athena-workgroup-classification-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * A set of properties specified within a configuration classification.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-classification.html#cfn-athena-workgroup-classification-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-classification.html#cfn-athena-workgroup-classification-properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClassificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClassificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClassificationProperty> {
            java.lang.String name;
            java.lang.Object properties;

            /**
             * Sets the value of {@link ClassificationProperty#getName}
             * @param name The name of the configuration classification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ClassificationProperty#getProperties}
             * @param properties A set of properties specified within a configuration classification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(java.util.Map<java.lang.String, java.lang.String> properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link ClassificationProperty#getProperties}
             * @param properties A set of properties specified within a configuration classification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClassificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClassificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClassificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClassificationProperty {
            private final java.lang.String name;
            private final java.lang.Object properties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.properties = builder.properties;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getProperties() != null) {
                    data.set("properties", om.valueToTree(this.getProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.ClassificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClassificationProperty.Jsii$Proxy that = (ClassificationProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for delivering logs to Amazon CloudWatch log groups.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * CloudWatchLoggingConfigurationProperty cloudWatchLoggingConfigurationProperty = CloudWatchLoggingConfigurationProperty.builder()
     *         .enabled(false)
     *         .logGroup("logGroup")
     *         .logStreamNamePrefix("logStreamNamePrefix")
     *         .logTypes(Map.of(
     *                 "logTypesKey", List.of("logTypes")))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-cloudwatchloggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-cloudwatchloggingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.CloudWatchLoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables CloudWatch logging.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-cloudwatchloggingconfiguration.html#cfn-athena-workgroup-cloudwatchloggingconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-cloudwatchloggingconfiguration.html#cfn-athena-workgroup-cloudwatchloggingconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The name of the log group in Amazon CloudWatch Logs where you want to publish your logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-cloudwatchloggingconfiguration.html#cfn-athena-workgroup-cloudwatchloggingconfiguration-loggroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-cloudwatchloggingconfiguration.html#cfn-athena-workgroup-cloudwatchloggingconfiguration-loggroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogGroup() {
            return null;
        }

        /**
         * Prefix for the CloudWatch log stream name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-cloudwatchloggingconfiguration.html#cfn-athena-workgroup-cloudwatchloggingconfiguration-logstreamnameprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-cloudwatchloggingconfiguration.html#cfn-athena-workgroup-cloudwatchloggingconfiguration-logstreamnameprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogStreamNamePrefix() {
            return null;
        }

        /**
         * The types of logs that you want to publish to CloudWatch.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, List<{@link java.lang.String}>>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-cloudwatchloggingconfiguration.html#cfn-athena-workgroup-cloudwatchloggingconfiguration-logtypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-cloudwatchloggingconfiguration.html#cfn-athena-workgroup-cloudwatchloggingconfiguration-logtypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLoggingConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.String logGroup;
            java.lang.String logStreamNamePrefix;
            java.lang.Object logTypes;

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getEnabled}
             * @param enabled Enables CloudWatch logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getEnabled}
             * @param enabled Enables CloudWatch logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getLogGroup}
             * @param logGroup The name of the log group in Amazon CloudWatch Logs where you want to publish your logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroup(java.lang.String logGroup) {
                this.logGroup = logGroup;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getLogStreamNamePrefix}
             * @param logStreamNamePrefix Prefix for the CloudWatch log stream name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logStreamNamePrefix(java.lang.String logStreamNamePrefix) {
                this.logStreamNamePrefix = logStreamNamePrefix;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getLogTypes}
             * @param logTypes The types of logs that you want to publish to CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logTypes(software.amazon.awscdk.IResolvable logTypes) {
                this.logTypes = logTypes;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getLogTypes}
             * @param logTypes The types of logs that you want to publish to CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logTypes(java.util.Map<java.lang.String, ? extends java.util.List<java.lang.String>> logTypes) {
                this.logTypes = logTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLoggingConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String logGroup;
            private final java.lang.String logStreamNamePrefix;
            private final java.lang.Object logTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logStreamNamePrefix = software.amazon.jsii.Kernel.get(this, "logStreamNamePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logTypes = software.amazon.jsii.Kernel.get(this, "logTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.logGroup = builder.logGroup;
                this.logStreamNamePrefix = builder.logStreamNamePrefix;
                this.logTypes = builder.logTypes;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getLogGroup() {
                return this.logGroup;
            }

            @Override
            public final java.lang.String getLogStreamNamePrefix() {
                return this.logStreamNamePrefix;
            }

            @Override
            public final java.lang.Object getLogTypes() {
                return this.logTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getLogGroup() != null) {
                    data.set("logGroup", om.valueToTree(this.getLogGroup()));
                }
                if (this.getLogStreamNamePrefix() != null) {
                    data.set("logStreamNamePrefix", om.valueToTree(this.getLogStreamNamePrefix()));
                }
                if (this.getLogTypes() != null) {
                    data.set("logTypes", om.valueToTree(this.getLogTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.CloudWatchLoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLoggingConfigurationProperty.Jsii$Proxy that = (CloudWatchLoggingConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
                if (this.logStreamNamePrefix != null ? !this.logStreamNamePrefix.equals(that.logStreamNamePrefix) : that.logStreamNamePrefix != null) return false;
                return this.logTypes != null ? this.logTypes.equals(that.logTypes) : that.logTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
                result = 31 * result + (this.logStreamNamePrefix != null ? this.logStreamNamePrefix.hashCode() : 0);
                result = 31 * result + (this.logTypes != null ? this.logTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the customer managed KMS key that is used to encrypt the user's data stores in Athena.
     * <p>
     * When an AWS managed key is used, this value is null. This setting does not apply to Athena SQL workgroups.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * CustomerContentEncryptionConfigurationProperty customerContentEncryptionConfigurationProperty = CustomerContentEncryptionConfigurationProperty.builder()
     *         .kmsKey("kmsKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-customercontentencryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-customercontentencryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.CustomerContentEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomerContentEncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomerContentEncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The customer managed KMS key that is used to encrypt the user's data stores in Athena.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-customercontentencryptionconfiguration.html#cfn-athena-workgroup-customercontentencryptionconfiguration-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-customercontentencryptionconfiguration.html#cfn-athena-workgroup-customercontentencryptionconfiguration-kmskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKmsKey();

        /**
         * @return a {@link Builder} of {@link CustomerContentEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomerContentEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomerContentEncryptionConfigurationProperty> {
            java.lang.String kmsKey;

            /**
             * Sets the value of {@link CustomerContentEncryptionConfigurationProperty#getKmsKey}
             * @param kmsKey The customer managed KMS key that is used to encrypt the user's data stores in Athena. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKey(java.lang.String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomerContentEncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomerContentEncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomerContentEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomerContentEncryptionConfigurationProperty {
            private final java.lang.String kmsKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKey = java.util.Objects.requireNonNull(builder.kmsKey, "kmsKey is required");
            }

            @Override
            public final java.lang.String getKmsKey() {
                return this.kmsKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kmsKey", om.valueToTree(this.getKmsKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.CustomerContentEncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomerContentEncryptionConfigurationProperty.Jsii$Proxy that = (CustomerContentEncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.kmsKey.equals(that.kmsKey);
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKey.hashCode();
                return result;
            }
        }
    }
    /**
     * If query results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE_KMS</code> or <code>CSE_KMS</code> ) and key information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * EncryptionConfigurationProperty encryptionConfigurationProperty = EncryptionConfigurationProperty.builder()
     *         .encryptionOption("encryptionOption")
     *         // the properties below are optional
     *         .kmsKey("kmsKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys ( <code>SSE_S3</code> ), server-side encryption with KMS-managed keys ( <code>SSE_KMS</code> ), or client-side encryption with KMS-managed keys ( <code>CSE_KMS</code> ) is used.
         * <p>
         * If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html#cfn-athena-workgroup-encryptionconfiguration-encryptionoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html#cfn-athena-workgroup-encryptionconfiguration-encryptionoption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionOption();

        /**
         * For <code>SSE_KMS</code> and <code>CSE_KMS</code> , this is the KMS key ARN or ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html#cfn-athena-workgroup-encryptionconfiguration-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html#cfn-athena-workgroup-encryptionconfiguration-kmskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            java.lang.String encryptionOption;
            java.lang.String kmsKey;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getEncryptionOption}
             * @param encryptionOption Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys ( <code>SSE_S3</code> ), server-side encryption with KMS-managed keys ( <code>SSE_KMS</code> ), or client-side encryption with KMS-managed keys ( <code>CSE_KMS</code> ) is used. This parameter is required.
             *                         If a query runs in a workgroup and the workgroup overrides client-side settings, then the workgroup's setting for encryption is used. It specifies whether query results must be encrypted, for all queries that run in this workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionOption(java.lang.String encryptionOption) {
                this.encryptionOption = encryptionOption;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getKmsKey}
             * @param kmsKey For <code>SSE_KMS</code> and <code>CSE_KMS</code> , this is the KMS key ARN or ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKey(java.lang.String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.String encryptionOption;
            private final java.lang.String kmsKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionOption = software.amazon.jsii.Kernel.get(this, "encryptionOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionOption = java.util.Objects.requireNonNull(builder.encryptionOption, "encryptionOption is required");
                this.kmsKey = builder.kmsKey;
            }

            @Override
            public final java.lang.String getEncryptionOption() {
                return this.encryptionOption;
            }

            @Override
            public final java.lang.String getKmsKey() {
                return this.kmsKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionOption", om.valueToTree(this.getEncryptionOption()));
                if (this.getKmsKey() != null) {
                    data.set("kmsKey", om.valueToTree(this.getKmsKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                if (!encryptionOption.equals(that.encryptionOption)) return false;
                return this.kmsKey != null ? this.kmsKey.equals(that.kmsKey) : that.kmsKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionOption.hashCode();
                result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The engine configuration for the workgroup, which includes the minimum/maximum number of Data Processing Units (DPU) that queries should use when running in provisioned capacity.
     * <p>
     * If not specified, Athena uses default values (Default value for min is 4 and for max is Minimum of 124 and allocated DPUs).
     * <p>
     * To specify DPU values for PC queries the WG containing EngineConfiguration should have the following values: The name of the Classifications should be <code>athena-query-engine-properties</code> , with the only allowed properties as <code>max-dpu-count</code> and <code>min-dpu-count</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * EngineConfigurationProperty engineConfigurationProperty = EngineConfigurationProperty.builder()
     *         .additionalConfigs(Map.of(
     *                 "additionalConfigsKey", "additionalConfigs"))
     *         .classifications(List.of(ClassificationProperty.builder()
     *                 .name("name")
     *                 .properties(Map.of(
     *                         "propertiesKey", "properties"))
     *                 .build()))
     *         .coordinatorDpuSize(123)
     *         .defaultExecutorDpuSize(123)
     *         .maxConcurrentDpus(123)
     *         .sparkProperties(Map.of(
     *                 "sparkPropertiesKey", "sparkProperties"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.EngineConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EngineConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EngineConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains additional notebook engine <code>MAP&lt;string, string&gt;</code> parameter mappings in the form of key-value pairs.
         * <p>
         * To specify an Athena notebook that the Jupyter server will download and serve, specify a value for the <code>StartSessionRequest$NotebookVersion</code> field, and then add a key named <code>NotebookId</code> to <code>AdditionalConfigs</code> that has the value of the Athena notebook ID.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-additionalconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-additionalconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalConfigs() {
            return null;
        }

        /**
         * The configuration classifications that can be specified for the engine.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.ClassificationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-classifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-classifications</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClassifications() {
            return null;
        }

        /**
         * The number of DPUs to use for the coordinator.
         * <p>
         * A coordinator is a special executor that orchestrates processing work and manages other executors in a notebook session. The default is 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-coordinatordpusize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-coordinatordpusize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCoordinatorDpuSize() {
            return null;
        }

        /**
         * The default number of DPUs to use for executors.
         * <p>
         * An executor is the smallest unit of compute that a notebook session can request from Athena. The default is 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-defaultexecutordpusize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-defaultexecutordpusize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultExecutorDpuSize() {
            return null;
        }

        /**
         * The maximum number of DPUs that can run concurrently.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-maxconcurrentdpus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-maxconcurrentdpus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentDpus() {
            return null;
        }

        /**
         * Specifies custom jar files and Spark properties for use cases like cluster encryption, table formats, and general Spark tuning.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-sparkproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineconfiguration.html#cfn-athena-workgroup-engineconfiguration-sparkproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSparkProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EngineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EngineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EngineConfigurationProperty> {
            java.lang.Object additionalConfigs;
            java.lang.Object classifications;
            java.lang.Number coordinatorDpuSize;
            java.lang.Number defaultExecutorDpuSize;
            java.lang.Number maxConcurrentDpus;
            java.lang.Object sparkProperties;

            /**
             * Sets the value of {@link EngineConfigurationProperty#getAdditionalConfigs}
             * @param additionalConfigs Contains additional notebook engine <code>MAP&lt;string, string&gt;</code> parameter mappings in the form of key-value pairs.
             *                          To specify an Athena notebook that the Jupyter server will download and serve, specify a value for the <code>StartSessionRequest$NotebookVersion</code> field, and then add a key named <code>NotebookId</code> to <code>AdditionalConfigs</code> that has the value of the Athena notebook ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalConfigs(java.util.Map<java.lang.String, java.lang.String> additionalConfigs) {
                this.additionalConfigs = additionalConfigs;
                return this;
            }

            /**
             * Sets the value of {@link EngineConfigurationProperty#getAdditionalConfigs}
             * @param additionalConfigs Contains additional notebook engine <code>MAP&lt;string, string&gt;</code> parameter mappings in the form of key-value pairs.
             *                          To specify an Athena notebook that the Jupyter server will download and serve, specify a value for the <code>StartSessionRequest$NotebookVersion</code> field, and then add a key named <code>NotebookId</code> to <code>AdditionalConfigs</code> that has the value of the Athena notebook ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalConfigs(software.amazon.awscdk.IResolvable additionalConfigs) {
                this.additionalConfigs = additionalConfigs;
                return this;
            }

            /**
             * Sets the value of {@link EngineConfigurationProperty#getClassifications}
             * @param classifications The configuration classifications that can be specified for the engine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classifications(software.amazon.awscdk.IResolvable classifications) {
                this.classifications = classifications;
                return this;
            }

            /**
             * Sets the value of {@link EngineConfigurationProperty#getClassifications}
             * @param classifications The configuration classifications that can be specified for the engine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classifications(java.util.List<? extends java.lang.Object> classifications) {
                this.classifications = classifications;
                return this;
            }

            /**
             * Sets the value of {@link EngineConfigurationProperty#getCoordinatorDpuSize}
             * @param coordinatorDpuSize The number of DPUs to use for the coordinator.
             *                           A coordinator is a special executor that orchestrates processing work and manages other executors in a notebook session. The default is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coordinatorDpuSize(java.lang.Number coordinatorDpuSize) {
                this.coordinatorDpuSize = coordinatorDpuSize;
                return this;
            }

            /**
             * Sets the value of {@link EngineConfigurationProperty#getDefaultExecutorDpuSize}
             * @param defaultExecutorDpuSize The default number of DPUs to use for executors.
             *                               An executor is the smallest unit of compute that a notebook session can request from Athena. The default is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultExecutorDpuSize(java.lang.Number defaultExecutorDpuSize) {
                this.defaultExecutorDpuSize = defaultExecutorDpuSize;
                return this;
            }

            /**
             * Sets the value of {@link EngineConfigurationProperty#getMaxConcurrentDpus}
             * @param maxConcurrentDpus The maximum number of DPUs that can run concurrently.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConcurrentDpus(java.lang.Number maxConcurrentDpus) {
                this.maxConcurrentDpus = maxConcurrentDpus;
                return this;
            }

            /**
             * Sets the value of {@link EngineConfigurationProperty#getSparkProperties}
             * @param sparkProperties Specifies custom jar files and Spark properties for use cases like cluster encryption, table formats, and general Spark tuning.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sparkProperties(java.util.Map<java.lang.String, java.lang.String> sparkProperties) {
                this.sparkProperties = sparkProperties;
                return this;
            }

            /**
             * Sets the value of {@link EngineConfigurationProperty#getSparkProperties}
             * @param sparkProperties Specifies custom jar files and Spark properties for use cases like cluster encryption, table formats, and general Spark tuning.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sparkProperties(software.amazon.awscdk.IResolvable sparkProperties) {
                this.sparkProperties = sparkProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EngineConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EngineConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EngineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EngineConfigurationProperty {
            private final java.lang.Object additionalConfigs;
            private final java.lang.Object classifications;
            private final java.lang.Number coordinatorDpuSize;
            private final java.lang.Number defaultExecutorDpuSize;
            private final java.lang.Number maxConcurrentDpus;
            private final java.lang.Object sparkProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalConfigs = software.amazon.jsii.Kernel.get(this, "additionalConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.classifications = software.amazon.jsii.Kernel.get(this, "classifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.coordinatorDpuSize = software.amazon.jsii.Kernel.get(this, "coordinatorDpuSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.defaultExecutorDpuSize = software.amazon.jsii.Kernel.get(this, "defaultExecutorDpuSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxConcurrentDpus = software.amazon.jsii.Kernel.get(this, "maxConcurrentDpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sparkProperties = software.amazon.jsii.Kernel.get(this, "sparkProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalConfigs = builder.additionalConfigs;
                this.classifications = builder.classifications;
                this.coordinatorDpuSize = builder.coordinatorDpuSize;
                this.defaultExecutorDpuSize = builder.defaultExecutorDpuSize;
                this.maxConcurrentDpus = builder.maxConcurrentDpus;
                this.sparkProperties = builder.sparkProperties;
            }

            @Override
            public final java.lang.Object getAdditionalConfigs() {
                return this.additionalConfigs;
            }

            @Override
            public final java.lang.Object getClassifications() {
                return this.classifications;
            }

            @Override
            public final java.lang.Number getCoordinatorDpuSize() {
                return this.coordinatorDpuSize;
            }

            @Override
            public final java.lang.Number getDefaultExecutorDpuSize() {
                return this.defaultExecutorDpuSize;
            }

            @Override
            public final java.lang.Number getMaxConcurrentDpus() {
                return this.maxConcurrentDpus;
            }

            @Override
            public final java.lang.Object getSparkProperties() {
                return this.sparkProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalConfigs() != null) {
                    data.set("additionalConfigs", om.valueToTree(this.getAdditionalConfigs()));
                }
                if (this.getClassifications() != null) {
                    data.set("classifications", om.valueToTree(this.getClassifications()));
                }
                if (this.getCoordinatorDpuSize() != null) {
                    data.set("coordinatorDpuSize", om.valueToTree(this.getCoordinatorDpuSize()));
                }
                if (this.getDefaultExecutorDpuSize() != null) {
                    data.set("defaultExecutorDpuSize", om.valueToTree(this.getDefaultExecutorDpuSize()));
                }
                if (this.getMaxConcurrentDpus() != null) {
                    data.set("maxConcurrentDpus", om.valueToTree(this.getMaxConcurrentDpus()));
                }
                if (this.getSparkProperties() != null) {
                    data.set("sparkProperties", om.valueToTree(this.getSparkProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.EngineConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EngineConfigurationProperty.Jsii$Proxy that = (EngineConfigurationProperty.Jsii$Proxy) o;

                if (this.additionalConfigs != null ? !this.additionalConfigs.equals(that.additionalConfigs) : that.additionalConfigs != null) return false;
                if (this.classifications != null ? !this.classifications.equals(that.classifications) : that.classifications != null) return false;
                if (this.coordinatorDpuSize != null ? !this.coordinatorDpuSize.equals(that.coordinatorDpuSize) : that.coordinatorDpuSize != null) return false;
                if (this.defaultExecutorDpuSize != null ? !this.defaultExecutorDpuSize.equals(that.defaultExecutorDpuSize) : that.defaultExecutorDpuSize != null) return false;
                if (this.maxConcurrentDpus != null ? !this.maxConcurrentDpus.equals(that.maxConcurrentDpus) : that.maxConcurrentDpus != null) return false;
                return this.sparkProperties != null ? this.sparkProperties.equals(that.sparkProperties) : that.sparkProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalConfigs != null ? this.additionalConfigs.hashCode() : 0;
                result = 31 * result + (this.classifications != null ? this.classifications.hashCode() : 0);
                result = 31 * result + (this.coordinatorDpuSize != null ? this.coordinatorDpuSize.hashCode() : 0);
                result = 31 * result + (this.defaultExecutorDpuSize != null ? this.defaultExecutorDpuSize.hashCode() : 0);
                result = 31 * result + (this.maxConcurrentDpus != null ? this.maxConcurrentDpus.hashCode() : 0);
                result = 31 * result + (this.sparkProperties != null ? this.sparkProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Athena engine version for running queries, or the PySpark engine version for running sessions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * EngineVersionProperty engineVersionProperty = EngineVersionProperty.builder()
     *         .effectiveEngineVersion("effectiveEngineVersion")
     *         .selectedEngineVersion("selectedEngineVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.EngineVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(EngineVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EngineVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Read only.
         * <p>
         * The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the <code>EffectiveEngineVersion</code> field is ignored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html#cfn-athena-workgroup-engineversion-effectiveengineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html#cfn-athena-workgroup-engineversion-effectiveengineversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEffectiveEngineVersion() {
            return null;
        }

        /**
         * The engine version requested by the user.
         * <p>
         * Possible values are determined by the output of <code>ListEngineVersions</code> , including AUTO. The default is AUTO.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html#cfn-athena-workgroup-engineversion-selectedengineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html#cfn-athena-workgroup-engineversion-selectedengineversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelectedEngineVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EngineVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EngineVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EngineVersionProperty> {
            java.lang.String effectiveEngineVersion;
            java.lang.String selectedEngineVersion;

            /**
             * Sets the value of {@link EngineVersionProperty#getEffectiveEngineVersion}
             * @param effectiveEngineVersion Read only.
             *                               The engine version on which the query runs. If the user requests a valid engine version other than Auto, the effective engine version is the same as the engine version that the user requested. If the user requests Auto, the effective engine version is chosen by Athena. When a request to update the engine version is made by a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the <code>EffectiveEngineVersion</code> field is ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder effectiveEngineVersion(java.lang.String effectiveEngineVersion) {
                this.effectiveEngineVersion = effectiveEngineVersion;
                return this;
            }

            /**
             * Sets the value of {@link EngineVersionProperty#getSelectedEngineVersion}
             * @param selectedEngineVersion The engine version requested by the user.
             *                              Possible values are determined by the output of <code>ListEngineVersions</code> , including AUTO. The default is AUTO.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectedEngineVersion(java.lang.String selectedEngineVersion) {
                this.selectedEngineVersion = selectedEngineVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EngineVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EngineVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EngineVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EngineVersionProperty {
            private final java.lang.String effectiveEngineVersion;
            private final java.lang.String selectedEngineVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.effectiveEngineVersion = software.amazon.jsii.Kernel.get(this, "effectiveEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selectedEngineVersion = software.amazon.jsii.Kernel.get(this, "selectedEngineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.effectiveEngineVersion = builder.effectiveEngineVersion;
                this.selectedEngineVersion = builder.selectedEngineVersion;
            }

            @Override
            public final java.lang.String getEffectiveEngineVersion() {
                return this.effectiveEngineVersion;
            }

            @Override
            public final java.lang.String getSelectedEngineVersion() {
                return this.selectedEngineVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEffectiveEngineVersion() != null) {
                    data.set("effectiveEngineVersion", om.valueToTree(this.getEffectiveEngineVersion()));
                }
                if (this.getSelectedEngineVersion() != null) {
                    data.set("selectedEngineVersion", om.valueToTree(this.getSelectedEngineVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.EngineVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EngineVersionProperty.Jsii$Proxy that = (EngineVersionProperty.Jsii$Proxy) o;

                if (this.effectiveEngineVersion != null ? !this.effectiveEngineVersion.equals(that.effectiveEngineVersion) : that.effectiveEngineVersion != null) return false;
                return this.selectedEngineVersion != null ? this.selectedEngineVersion.equals(that.selectedEngineVersion) : that.selectedEngineVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.effectiveEngineVersion != null ? this.effectiveEngineVersion.hashCode() : 0;
                result = 31 * result + (this.selectedEngineVersion != null ? this.selectedEngineVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for delivering logs to Amazon S3 buckets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * ManagedLoggingConfigurationProperty managedLoggingConfigurationProperty = ManagedLoggingConfigurationProperty.builder()
     *         .enabled(false)
     *         .kmsKey("kmsKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedloggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedloggingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.ManagedLoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedLoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedLoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables mamanged log persistence.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedloggingconfiguration.html#cfn-athena-workgroup-managedloggingconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedloggingconfiguration.html#cfn-athena-workgroup-managedloggingconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The KMS key ARN to encrypt the logs stored in managed log persistence.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedloggingconfiguration.html#cfn-athena-workgroup-managedloggingconfiguration-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedloggingconfiguration.html#cfn-athena-workgroup-managedloggingconfiguration-kmskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedLoggingConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.String kmsKey;

            /**
             * Sets the value of {@link ManagedLoggingConfigurationProperty#getEnabled}
             * @param enabled Enables mamanged log persistence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ManagedLoggingConfigurationProperty#getEnabled}
             * @param enabled Enables mamanged log persistence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ManagedLoggingConfigurationProperty#getKmsKey}
             * @param kmsKey The KMS key ARN to encrypt the logs stored in managed log persistence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKey(java.lang.String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedLoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedLoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedLoggingConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String kmsKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.kmsKey = builder.kmsKey;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getKmsKey() {
                return this.kmsKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getKmsKey() != null) {
                    data.set("kmsKey", om.valueToTree(this.getKmsKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.ManagedLoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedLoggingConfigurationProperty.Jsii$Proxy that = (ManagedLoggingConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.kmsKey != null ? this.kmsKey.equals(that.kmsKey) : that.kmsKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for storing results in Athena owned storage, which includes whether this feature is enabled;
     * <p>
     * whether encryption configuration, if any, is used for encrypting query results.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * ManagedQueryResultsConfigurationProperty managedQueryResultsConfigurationProperty = ManagedQueryResultsConfigurationProperty.builder()
     *         .enabled(false)
     *         .encryptionConfiguration(ManagedStorageEncryptionConfigurationProperty.builder()
     *                 .kmsKey("kmsKey")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedqueryresultsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedqueryresultsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.ManagedQueryResultsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedQueryResultsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedQueryResultsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If set to true, allows you to store query results in Athena owned storage.
         * <p>
         * If set to false, workgroup member stores query results in location specified under <code>ResultConfiguration$OutputLocation</code> . The default is false. A workgroup cannot have the <code>ResultConfiguration$OutputLocation</code> parameter when you set this field to true.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedqueryresultsconfiguration.html#cfn-athena-workgroup-managedqueryresultsconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedqueryresultsconfiguration.html#cfn-athena-workgroup-managedqueryresultsconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * If you encrypt query and calculation results in Athena owned storage, this field indicates the encryption option (for example, SSE_KMS or CSE_KMS) and key information.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.ManagedStorageEncryptionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedqueryresultsconfiguration.html#cfn-athena-workgroup-managedqueryresultsconfiguration-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedqueryresultsconfiguration.html#cfn-athena-workgroup-managedqueryresultsconfiguration-encryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedQueryResultsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedQueryResultsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedQueryResultsConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.Object encryptionConfiguration;

            /**
             * Sets the value of {@link ManagedQueryResultsConfigurationProperty#getEnabled}
             * @param enabled If set to true, allows you to store query results in Athena owned storage.
             *                If set to false, workgroup member stores query results in location specified under <code>ResultConfiguration$OutputLocation</code> . The default is false. A workgroup cannot have the <code>ResultConfiguration$OutputLocation</code> parameter when you set this field to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ManagedQueryResultsConfigurationProperty#getEnabled}
             * @param enabled If set to true, allows you to store query results in Athena owned storage.
             *                If set to false, workgroup member stores query results in location specified under <code>ResultConfiguration$OutputLocation</code> . The default is false. A workgroup cannot have the <code>ResultConfiguration$OutputLocation</code> parameter when you set this field to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ManagedQueryResultsConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration If you encrypt query and calculation results in Athena owned storage, this field indicates the encryption option (for example, SSE_KMS or CSE_KMS) and key information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ManagedQueryResultsConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration If you encrypt query and calculation results in Athena owned storage, this field indicates the encryption option (for example, SSE_KMS or CSE_KMS) and key information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.ManagedStorageEncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedQueryResultsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedQueryResultsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedQueryResultsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedQueryResultsConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object encryptionConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.encryptionConfiguration = builder.encryptionConfiguration;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.ManagedQueryResultsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedQueryResultsConfigurationProperty.Jsii$Proxy that = (ManagedQueryResultsConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.encryptionConfiguration != null ? this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Indicates the encryption configuration for Athena Managed Storage.
     * <p>
     * If not setting this field, Managed Storage will encrypt the query results with Athena's encryption key
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * ManagedStorageEncryptionConfigurationProperty managedStorageEncryptionConfigurationProperty = ManagedStorageEncryptionConfigurationProperty.builder()
     *         .kmsKey("kmsKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedstorageencryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedstorageencryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.ManagedStorageEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedStorageEncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedStorageEncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For SSE-KMS and CSE-KMS, this is the KMS key ARN or ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedstorageencryptionconfiguration.html#cfn-athena-workgroup-managedstorageencryptionconfiguration-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-managedstorageencryptionconfiguration.html#cfn-athena-workgroup-managedstorageencryptionconfiguration-kmskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedStorageEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedStorageEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedStorageEncryptionConfigurationProperty> {
            java.lang.String kmsKey;

            /**
             * Sets the value of {@link ManagedStorageEncryptionConfigurationProperty#getKmsKey}
             * @param kmsKey For SSE-KMS and CSE-KMS, this is the KMS key ARN or ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKey(java.lang.String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedStorageEncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedStorageEncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedStorageEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedStorageEncryptionConfigurationProperty {
            private final java.lang.String kmsKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKey = builder.kmsKey;
            }

            @Override
            public final java.lang.String getKmsKey() {
                return this.kmsKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKey() != null) {
                    data.set("kmsKey", om.valueToTree(this.getKmsKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.ManagedStorageEncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedStorageEncryptionConfigurationProperty.Jsii$Proxy that = (ManagedStorageEncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.kmsKey != null ? this.kmsKey.equals(that.kmsKey) : that.kmsKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKey != null ? this.kmsKey.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets, Amazon CloudWatch log groups etc.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * MonitoringConfigurationProperty monitoringConfigurationProperty = MonitoringConfigurationProperty.builder()
     *         .cloudWatchLoggingConfiguration(CloudWatchLoggingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .logGroup("logGroup")
     *                 .logStreamNamePrefix("logStreamNamePrefix")
     *                 .logTypes(Map.of(
     *                         "logTypesKey", List.of("logTypes")))
     *                 .build())
     *         .managedLoggingConfiguration(ManagedLoggingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .kmsKey("kmsKey")
     *                 .build())
     *         .s3LoggingConfiguration(S3LoggingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .kmsKey("kmsKey")
     *                 .logLocation("logLocation")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-monitoringconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-monitoringconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.MonitoringConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for delivering logs to Amazon CloudWatch log groups.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.CloudWatchLoggingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-monitoringconfiguration.html#cfn-athena-workgroup-monitoringconfiguration-cloudwatchloggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-monitoringconfiguration.html#cfn-athena-workgroup-monitoringconfiguration-cloudwatchloggingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingConfiguration() {
            return null;
        }

        /**
         * Configuration settings for managed log persistence.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.ManagedLoggingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-monitoringconfiguration.html#cfn-athena-workgroup-monitoringconfiguration-managedloggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-monitoringconfiguration.html#cfn-athena-workgroup-monitoringconfiguration-managedloggingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedLoggingConfiguration() {
            return null;
        }

        /**
         * Configuration settings for delivering logs to Amazon S3 buckets.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.S3LoggingConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-monitoringconfiguration.html#cfn-athena-workgroup-monitoringconfiguration-s3loggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-monitoringconfiguration.html#cfn-athena-workgroup-monitoringconfiguration-s3loggingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3LoggingConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringConfigurationProperty> {
            java.lang.Object cloudWatchLoggingConfiguration;
            java.lang.Object managedLoggingConfiguration;
            java.lang.Object s3LoggingConfiguration;

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getCloudWatchLoggingConfiguration}
             * @param cloudWatchLoggingConfiguration Configuration settings for delivering logs to Amazon CloudWatch log groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingConfiguration(software.amazon.awscdk.IResolvable cloudWatchLoggingConfiguration) {
                this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getCloudWatchLoggingConfiguration}
             * @param cloudWatchLoggingConfiguration Configuration settings for delivering logs to Amazon CloudWatch log groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.CloudWatchLoggingConfigurationProperty cloudWatchLoggingConfiguration) {
                this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getManagedLoggingConfiguration}
             * @param managedLoggingConfiguration Configuration settings for managed log persistence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedLoggingConfiguration(software.amazon.awscdk.IResolvable managedLoggingConfiguration) {
                this.managedLoggingConfiguration = managedLoggingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getManagedLoggingConfiguration}
             * @param managedLoggingConfiguration Configuration settings for managed log persistence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedLoggingConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.ManagedLoggingConfigurationProperty managedLoggingConfiguration) {
                this.managedLoggingConfiguration = managedLoggingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getS3LoggingConfiguration}
             * @param s3LoggingConfiguration Configuration settings for delivering logs to Amazon S3 buckets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3LoggingConfiguration(software.amazon.awscdk.IResolvable s3LoggingConfiguration) {
                this.s3LoggingConfiguration = s3LoggingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getS3LoggingConfiguration}
             * @param s3LoggingConfiguration Configuration settings for delivering logs to Amazon S3 buckets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3LoggingConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.S3LoggingConfigurationProperty s3LoggingConfiguration) {
                this.s3LoggingConfiguration = s3LoggingConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringConfigurationProperty {
            private final java.lang.Object cloudWatchLoggingConfiguration;
            private final java.lang.Object managedLoggingConfiguration;
            private final java.lang.Object s3LoggingConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLoggingConfiguration = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.managedLoggingConfiguration = software.amazon.jsii.Kernel.get(this, "managedLoggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3LoggingConfiguration = software.amazon.jsii.Kernel.get(this, "s3LoggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLoggingConfiguration = builder.cloudWatchLoggingConfiguration;
                this.managedLoggingConfiguration = builder.managedLoggingConfiguration;
                this.s3LoggingConfiguration = builder.s3LoggingConfiguration;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingConfiguration() {
                return this.cloudWatchLoggingConfiguration;
            }

            @Override
            public final java.lang.Object getManagedLoggingConfiguration() {
                return this.managedLoggingConfiguration;
            }

            @Override
            public final java.lang.Object getS3LoggingConfiguration() {
                return this.s3LoggingConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLoggingConfiguration() != null) {
                    data.set("cloudWatchLoggingConfiguration", om.valueToTree(this.getCloudWatchLoggingConfiguration()));
                }
                if (this.getManagedLoggingConfiguration() != null) {
                    data.set("managedLoggingConfiguration", om.valueToTree(this.getManagedLoggingConfiguration()));
                }
                if (this.getS3LoggingConfiguration() != null) {
                    data.set("s3LoggingConfiguration", om.valueToTree(this.getS3LoggingConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.MonitoringConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringConfigurationProperty.Jsii$Proxy that = (MonitoringConfigurationProperty.Jsii$Proxy) o;

                if (this.cloudWatchLoggingConfiguration != null ? !this.cloudWatchLoggingConfiguration.equals(that.cloudWatchLoggingConfiguration) : that.cloudWatchLoggingConfiguration != null) return false;
                if (this.managedLoggingConfiguration != null ? !this.managedLoggingConfiguration.equals(that.managedLoggingConfiguration) : that.managedLoggingConfiguration != null) return false;
                return this.s3LoggingConfiguration != null ? this.s3LoggingConfiguration.equals(that.s3LoggingConfiguration) : that.s3LoggingConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLoggingConfiguration != null ? this.cloudWatchLoggingConfiguration.hashCode() : 0;
                result = 31 * result + (this.managedLoggingConfiguration != null ? this.managedLoggingConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3LoggingConfiguration != null ? this.s3LoggingConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The location in Amazon S3 where query and calculation results are stored and the encryption option, if any, used for query and calculation results.
     * <p>
     * These are known as "client-side settings". If workgroup settings override client-side settings, then the query uses the workgroup settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * ResultConfigurationProperty resultConfigurationProperty = ResultConfigurationProperty.builder()
     *         .aclConfiguration(AclConfigurationProperty.builder()
     *                 .s3AclOption("s3AclOption")
     *                 .build())
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .encryptionOption("encryptionOption")
     *                 // the properties below are optional
     *                 .kmsKey("kmsKey")
     *                 .build())
     *         .expectedBucketOwner("expectedBucketOwner")
     *         .outputLocation("outputLocation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.ResultConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ResultConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResultConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results.
         * <p>
         * Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code> . This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.AclConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-aclconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-aclconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAclConfiguration() {
            return null;
        }

        /**
         * If query results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE_KMS</code> or <code>CSE_KMS</code> ) and key information.
         * <p>
         * This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.EncryptionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-encryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * The account ID that you expect to be the owner of the Amazon S3 bucket specified by <code>ResultConfiguration:OutputLocation</code> .
         * <p>
         * If set, Athena uses the value for <code>ExpectedBucketOwner</code> when it makes Amazon S3 calls to your specified output location. If the <code>ExpectedBucketOwner</code> account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
         * <p>
         * This is a client-side setting. If workgroup settings override client-side settings, then the query uses the <code>ExpectedBucketOwner</code> setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-expectedbucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-expectedbucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpectedBucketOwner() {
            return null;
        }

        /**
         * The location in Amazon S3 where your query results are stored, such as <code>s3://path/to/query/bucket/</code> .
         * <p>
         * To run a query, you must specify the query results location using either a client-side setting for individual queries or a location specified by the workgroup. If workgroup settings override client-side settings, then the query uses the location specified for the workgroup. If no query location is set, Athena issues an error. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Work with query results and recent queries</a> and <code>EnforceWorkGroupConfiguration</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-outputlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-outputlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResultConfigurationProperty> {
            java.lang.Object aclConfiguration;
            java.lang.Object encryptionConfiguration;
            java.lang.String expectedBucketOwner;
            java.lang.String outputLocation;

            /**
             * Sets the value of {@link ResultConfigurationProperty#getAclConfiguration}
             * @param aclConfiguration Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results.
             *                         Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code> . This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclConfiguration(software.amazon.awscdk.IResolvable aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getAclConfiguration}
             * @param aclConfiguration Indicates that an Amazon S3 canned ACL should be set to control ownership of stored query results.
             *                         Currently the only supported canned ACL is <code>BUCKET_OWNER_FULL_CONTROL</code> . This is a client-side setting. If workgroup settings override client-side settings, then the query uses the ACL configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.AclConfigurationProperty aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration If query results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE_KMS</code> or <code>CSE_KMS</code> ) and key information.
             *                                This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration If query results are encrypted in Amazon S3, indicates the encryption option used (for example, <code>SSE_KMS</code> or <code>CSE_KMS</code> ) and key information.
             *                                This is a client-side setting. If workgroup settings override client-side settings, then the query uses the encryption configuration that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getExpectedBucketOwner}
             * @param expectedBucketOwner The account ID that you expect to be the owner of the Amazon S3 bucket specified by <code>ResultConfiguration:OutputLocation</code> .
             *                            If set, Athena uses the value for <code>ExpectedBucketOwner</code> when it makes Amazon S3 calls to your specified output location. If the <code>ExpectedBucketOwner</code> account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
             *                            <p>
             *                            This is a client-side setting. If workgroup settings override client-side settings, then the query uses the <code>ExpectedBucketOwner</code> setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <code>EnforceWorkGroupConfiguration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expectedBucketOwner(java.lang.String expectedBucketOwner) {
                this.expectedBucketOwner = expectedBucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationProperty#getOutputLocation}
             * @param outputLocation The location in Amazon S3 where your query results are stored, such as <code>s3://path/to/query/bucket/</code> .
             *                       To run a query, you must specify the query results location using either a client-side setting for individual queries or a location specified by the workgroup. If workgroup settings override client-side settings, then the query uses the location specified for the workgroup. If no query location is set, Athena issues an error. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Work with query results and recent queries</a> and <code>EnforceWorkGroupConfiguration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputLocation(java.lang.String outputLocation) {
                this.outputLocation = outputLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResultConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResultConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResultConfigurationProperty {
            private final java.lang.Object aclConfiguration;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String expectedBucketOwner;
            private final java.lang.String outputLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aclConfiguration = software.amazon.jsii.Kernel.get(this, "aclConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.expectedBucketOwner = software.amazon.jsii.Kernel.get(this, "expectedBucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputLocation = software.amazon.jsii.Kernel.get(this, "outputLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aclConfiguration = builder.aclConfiguration;
                this.encryptionConfiguration = builder.encryptionConfiguration;
                this.expectedBucketOwner = builder.expectedBucketOwner;
                this.outputLocation = builder.outputLocation;
            }

            @Override
            public final java.lang.Object getAclConfiguration() {
                return this.aclConfiguration;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getExpectedBucketOwner() {
                return this.expectedBucketOwner;
            }

            @Override
            public final java.lang.String getOutputLocation() {
                return this.outputLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAclConfiguration() != null) {
                    data.set("aclConfiguration", om.valueToTree(this.getAclConfiguration()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getExpectedBucketOwner() != null) {
                    data.set("expectedBucketOwner", om.valueToTree(this.getExpectedBucketOwner()));
                }
                if (this.getOutputLocation() != null) {
                    data.set("outputLocation", om.valueToTree(this.getOutputLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.ResultConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResultConfigurationProperty.Jsii$Proxy that = (ResultConfigurationProperty.Jsii$Proxy) o;

                if (this.aclConfiguration != null ? !this.aclConfiguration.equals(that.aclConfiguration) : that.aclConfiguration != null) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                if (this.expectedBucketOwner != null ? !this.expectedBucketOwner.equals(that.expectedBucketOwner) : that.expectedBucketOwner != null) return false;
                return this.outputLocation != null ? this.outputLocation.equals(that.outputLocation) : that.outputLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aclConfiguration != null ? this.aclConfiguration.hashCode() : 0;
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.expectedBucketOwner != null ? this.expectedBucketOwner.hashCode() : 0);
                result = 31 * result + (this.outputLocation != null ? this.outputLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The information about the updates in the query results, such as output location and encryption configuration for the query results.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * ResultConfigurationUpdatesProperty resultConfigurationUpdatesProperty = ResultConfigurationUpdatesProperty.builder()
     *         .aclConfiguration(AclConfigurationProperty.builder()
     *                 .s3AclOption("s3AclOption")
     *                 .build())
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .encryptionOption("encryptionOption")
     *                 // the properties below are optional
     *                 .kmsKey("kmsKey")
     *                 .build())
     *         .expectedBucketOwner("expectedBucketOwner")
     *         .outputLocation("outputLocation")
     *         .removeAclConfiguration(false)
     *         .removeEncryptionConfiguration(false)
     *         .removeExpectedBucketOwner(false)
     *         .removeOutputLocation(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.ResultConfigurationUpdatesProperty")
    @software.amazon.jsii.Jsii.Proxy(ResultConfigurationUpdatesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResultConfigurationUpdatesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ACL configuration for the query results.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.AclConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-aclconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-aclconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAclConfiguration() {
            return null;
        }

        /**
         * The encryption configuration for the query results.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.EncryptionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-encryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * The AWS account ID that you expect to be the owner of the Amazon S3 bucket specified by <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-outputlocation"></a> . If set, Athena uses the value for <code>ExpectedBucketOwner</code> when it makes Amazon S3 calls to your specified output location. If the <code>ExpectedBucketOwner</code> AWS account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
         * <p>
         * If workgroup settings override client-side settings, then the query uses the <code>ExpectedBucketOwner</code> setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-enforceworkgroupconfiguration"></a> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-expectedbucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-expectedbucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpectedBucketOwner() {
            return null;
        }

        /**
         * The location in Amazon S3 where your query results are stored, such as <code>s3://path/to/query/bucket/</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <code>EnforceWorkGroupConfiguration</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-outputlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-outputlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputLocation() {
            return null;
        }

        /**
         * If set to <code>true</code> , indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null.
         * <p>
         * If set to <code>false</code> or not set, and a value is present in the <code>AclConfiguration</code> of <code>ResultConfigurationUpdates</code> , the <code>AclConfiguration</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeaclconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeaclconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveAclConfiguration() {
            return null;
        }

        /**
         * If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null.
         * <p>
         * If set to "false" or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeencryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveEncryptionConfiguration() {
            return null;
        }

        /**
         * If set to "true", removes the AWS account ID previously specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-expectedbucketowner"></a> . If set to "false" or not set, and a value is present in the <code>ExpectedBucketOwner</code> in <code>ResultConfigurationUpdates</code> (the client-side setting), the <code>ExpectedBucketOwner</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeexpectedbucketowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeexpectedbucketowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveExpectedBucketOwner() {
            return null;
        }

        /**
         * If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null.
         * <p>
         * If set to "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeoutputlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html#cfn-athena-workgroup-resultconfigurationupdates-removeoutputlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveOutputLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResultConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResultConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResultConfigurationUpdatesProperty> {
            java.lang.Object aclConfiguration;
            java.lang.Object encryptionConfiguration;
            java.lang.String expectedBucketOwner;
            java.lang.String outputLocation;
            java.lang.Object removeAclConfiguration;
            java.lang.Object removeEncryptionConfiguration;
            java.lang.Object removeExpectedBucketOwner;
            java.lang.Object removeOutputLocation;

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getAclConfiguration}
             * @param aclConfiguration The ACL configuration for the query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclConfiguration(software.amazon.awscdk.IResolvable aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getAclConfiguration}
             * @param aclConfiguration The ACL configuration for the query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.AclConfigurationProperty aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption configuration for the query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption configuration for the query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getExpectedBucketOwner}
             * @param expectedBucketOwner The AWS account ID that you expect to be the owner of the Amazon S3 bucket specified by <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-outputlocation"></a> . If set, Athena uses the value for <code>ExpectedBucketOwner</code> when it makes Amazon S3 calls to your specified output location. If the <code>ExpectedBucketOwner</code> AWS account ID does not match the actual owner of the Amazon S3 bucket, the call fails with a permissions error.
             *                            If workgroup settings override client-side settings, then the query uses the <code>ExpectedBucketOwner</code> setting that is specified for the workgroup, and also uses the location for storing query results specified in the workgroup. See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-enforceworkgroupconfiguration"></a> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expectedBucketOwner(java.lang.String expectedBucketOwner) {
                this.expectedBucketOwner = expectedBucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getOutputLocation}
             * @param outputLocation The location in Amazon S3 where your query results are stored, such as <code>s3://path/to/query/bucket/</code> .
             *                       For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> If workgroup settings override client-side settings, then the query uses the location for the query results and the encryption configuration that are specified for the workgroup. The "workgroup settings override" is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <code>EnforceWorkGroupConfiguration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputLocation(java.lang.String outputLocation) {
                this.outputLocation = outputLocation;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveAclConfiguration}
             * @param removeAclConfiguration If set to <code>true</code> , indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null.
             *                               If set to <code>false</code> or not set, and a value is present in the <code>AclConfiguration</code> of <code>ResultConfigurationUpdates</code> , the <code>AclConfiguration</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeAclConfiguration(java.lang.Boolean removeAclConfiguration) {
                this.removeAclConfiguration = removeAclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveAclConfiguration}
             * @param removeAclConfiguration If set to <code>true</code> , indicates that the previously-specified ACL configuration for queries in this workgroup should be ignored and set to null.
             *                               If set to <code>false</code> or not set, and a value is present in the <code>AclConfiguration</code> of <code>ResultConfigurationUpdates</code> , the <code>AclConfiguration</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeAclConfiguration(software.amazon.awscdk.IResolvable removeAclConfiguration) {
                this.removeAclConfiguration = removeAclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveEncryptionConfiguration}
             * @param removeEncryptionConfiguration If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null.
             *                                      If set to "false" or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeEncryptionConfiguration(java.lang.Boolean removeEncryptionConfiguration) {
                this.removeEncryptionConfiguration = removeEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveEncryptionConfiguration}
             * @param removeEncryptionConfiguration If set to "true", indicates that the previously-specified encryption configuration (also known as the client-side setting) for queries in this workgroup should be ignored and set to null.
             *                                      If set to "false" or not set, and a value is present in the EncryptionConfiguration in ResultConfigurationUpdates (the client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeEncryptionConfiguration(software.amazon.awscdk.IResolvable removeEncryptionConfiguration) {
                this.removeEncryptionConfiguration = removeEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveExpectedBucketOwner}
             * @param removeExpectedBucketOwner If set to "true", removes the AWS account ID previously specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-expectedbucketowner"></a> . If set to "false" or not set, and a value is present in the <code>ExpectedBucketOwner</code> in <code>ResultConfigurationUpdates</code> (the client-side setting), the <code>ExpectedBucketOwner</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeExpectedBucketOwner(java.lang.Boolean removeExpectedBucketOwner) {
                this.removeExpectedBucketOwner = removeExpectedBucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveExpectedBucketOwner}
             * @param removeExpectedBucketOwner If set to "true", removes the AWS account ID previously specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/TemplateReference/aws-properties-athena-workgroup-resultconfiguration.html#cfn-athena-workgroup-resultconfiguration-expectedbucketowner"></a> . If set to "false" or not set, and a value is present in the <code>ExpectedBucketOwner</code> in <code>ResultConfigurationUpdates</code> (the client-side setting), the <code>ExpectedBucketOwner</code> in the workgroup's <code>ResultConfiguration</code> is updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeExpectedBucketOwner(software.amazon.awscdk.IResolvable removeExpectedBucketOwner) {
                this.removeExpectedBucketOwner = removeExpectedBucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveOutputLocation}
             * @param removeOutputLocation If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null.
             *                             If set to "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeOutputLocation(java.lang.Boolean removeOutputLocation) {
                this.removeOutputLocation = removeOutputLocation;
                return this;
            }

            /**
             * Sets the value of {@link ResultConfigurationUpdatesProperty#getRemoveOutputLocation}
             * @param removeOutputLocation If set to "true", indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null.
             *                             If set to "false" or not set, and a value is present in the OutputLocation in ResultConfigurationUpdates (the client-side setting), the OutputLocation in the workgroup's ResultConfiguration will be updated with the new value. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override Client-Side Settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeOutputLocation(software.amazon.awscdk.IResolvable removeOutputLocation) {
                this.removeOutputLocation = removeOutputLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResultConfigurationUpdatesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResultConfigurationUpdatesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResultConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResultConfigurationUpdatesProperty {
            private final java.lang.Object aclConfiguration;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String expectedBucketOwner;
            private final java.lang.String outputLocation;
            private final java.lang.Object removeAclConfiguration;
            private final java.lang.Object removeEncryptionConfiguration;
            private final java.lang.Object removeExpectedBucketOwner;
            private final java.lang.Object removeOutputLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aclConfiguration = software.amazon.jsii.Kernel.get(this, "aclConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.expectedBucketOwner = software.amazon.jsii.Kernel.get(this, "expectedBucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputLocation = software.amazon.jsii.Kernel.get(this, "outputLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.removeAclConfiguration = software.amazon.jsii.Kernel.get(this, "removeAclConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "removeEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeExpectedBucketOwner = software.amazon.jsii.Kernel.get(this, "removeExpectedBucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeOutputLocation = software.amazon.jsii.Kernel.get(this, "removeOutputLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aclConfiguration = builder.aclConfiguration;
                this.encryptionConfiguration = builder.encryptionConfiguration;
                this.expectedBucketOwner = builder.expectedBucketOwner;
                this.outputLocation = builder.outputLocation;
                this.removeAclConfiguration = builder.removeAclConfiguration;
                this.removeEncryptionConfiguration = builder.removeEncryptionConfiguration;
                this.removeExpectedBucketOwner = builder.removeExpectedBucketOwner;
                this.removeOutputLocation = builder.removeOutputLocation;
            }

            @Override
            public final java.lang.Object getAclConfiguration() {
                return this.aclConfiguration;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getExpectedBucketOwner() {
                return this.expectedBucketOwner;
            }

            @Override
            public final java.lang.String getOutputLocation() {
                return this.outputLocation;
            }

            @Override
            public final java.lang.Object getRemoveAclConfiguration() {
                return this.removeAclConfiguration;
            }

            @Override
            public final java.lang.Object getRemoveEncryptionConfiguration() {
                return this.removeEncryptionConfiguration;
            }

            @Override
            public final java.lang.Object getRemoveExpectedBucketOwner() {
                return this.removeExpectedBucketOwner;
            }

            @Override
            public final java.lang.Object getRemoveOutputLocation() {
                return this.removeOutputLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAclConfiguration() != null) {
                    data.set("aclConfiguration", om.valueToTree(this.getAclConfiguration()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getExpectedBucketOwner() != null) {
                    data.set("expectedBucketOwner", om.valueToTree(this.getExpectedBucketOwner()));
                }
                if (this.getOutputLocation() != null) {
                    data.set("outputLocation", om.valueToTree(this.getOutputLocation()));
                }
                if (this.getRemoveAclConfiguration() != null) {
                    data.set("removeAclConfiguration", om.valueToTree(this.getRemoveAclConfiguration()));
                }
                if (this.getRemoveEncryptionConfiguration() != null) {
                    data.set("removeEncryptionConfiguration", om.valueToTree(this.getRemoveEncryptionConfiguration()));
                }
                if (this.getRemoveExpectedBucketOwner() != null) {
                    data.set("removeExpectedBucketOwner", om.valueToTree(this.getRemoveExpectedBucketOwner()));
                }
                if (this.getRemoveOutputLocation() != null) {
                    data.set("removeOutputLocation", om.valueToTree(this.getRemoveOutputLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.ResultConfigurationUpdatesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResultConfigurationUpdatesProperty.Jsii$Proxy that = (ResultConfigurationUpdatesProperty.Jsii$Proxy) o;

                if (this.aclConfiguration != null ? !this.aclConfiguration.equals(that.aclConfiguration) : that.aclConfiguration != null) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                if (this.expectedBucketOwner != null ? !this.expectedBucketOwner.equals(that.expectedBucketOwner) : that.expectedBucketOwner != null) return false;
                if (this.outputLocation != null ? !this.outputLocation.equals(that.outputLocation) : that.outputLocation != null) return false;
                if (this.removeAclConfiguration != null ? !this.removeAclConfiguration.equals(that.removeAclConfiguration) : that.removeAclConfiguration != null) return false;
                if (this.removeEncryptionConfiguration != null ? !this.removeEncryptionConfiguration.equals(that.removeEncryptionConfiguration) : that.removeEncryptionConfiguration != null) return false;
                if (this.removeExpectedBucketOwner != null ? !this.removeExpectedBucketOwner.equals(that.removeExpectedBucketOwner) : that.removeExpectedBucketOwner != null) return false;
                return this.removeOutputLocation != null ? this.removeOutputLocation.equals(that.removeOutputLocation) : that.removeOutputLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aclConfiguration != null ? this.aclConfiguration.hashCode() : 0;
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.expectedBucketOwner != null ? this.expectedBucketOwner.hashCode() : 0);
                result = 31 * result + (this.outputLocation != null ? this.outputLocation.hashCode() : 0);
                result = 31 * result + (this.removeAclConfiguration != null ? this.removeAclConfiguration.hashCode() : 0);
                result = 31 * result + (this.removeEncryptionConfiguration != null ? this.removeEncryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.removeExpectedBucketOwner != null ? this.removeExpectedBucketOwner.hashCode() : 0);
                result = 31 * result + (this.removeOutputLocation != null ? this.removeOutputLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for delivering logs to Amazon S3 buckets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * S3LoggingConfigurationProperty s3LoggingConfigurationProperty = S3LoggingConfigurationProperty.builder()
     *         .enabled(false)
     *         .kmsKey("kmsKey")
     *         .logLocation("logLocation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-s3loggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-s3loggingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.S3LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables S3 log delivery.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-s3loggingconfiguration.html#cfn-athena-workgroup-s3loggingconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-s3loggingconfiguration.html#cfn-athena-workgroup-s3loggingconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-s3loggingconfiguration.html#cfn-athena-workgroup-s3loggingconfiguration-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-s3loggingconfiguration.html#cfn-athena-workgroup-s3loggingconfiguration-kmskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
            return null;
        }

        /**
         * The Amazon S3 destination URI for log publishing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-s3loggingconfiguration.html#cfn-athena-workgroup-s3loggingconfiguration-loglocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-s3loggingconfiguration.html#cfn-athena-workgroup-s3loggingconfiguration-loglocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LoggingConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.String kmsKey;
            java.lang.String logLocation;

            /**
             * Sets the value of {@link S3LoggingConfigurationProperty#getEnabled}
             * @param enabled Enables S3 log delivery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link S3LoggingConfigurationProperty#getEnabled}
             * @param enabled Enables S3 log delivery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link S3LoggingConfigurationProperty#getKmsKey}
             * @param kmsKey The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKey(java.lang.String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            /**
             * Sets the value of {@link S3LoggingConfigurationProperty#getLogLocation}
             * @param logLocation The Amazon S3 destination URI for log publishing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logLocation(java.lang.String logLocation) {
                this.logLocation = logLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LoggingConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String kmsKey;
            private final java.lang.String logLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logLocation = software.amazon.jsii.Kernel.get(this, "logLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.kmsKey = builder.kmsKey;
                this.logLocation = builder.logLocation;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getKmsKey() {
                return this.kmsKey;
            }

            @Override
            public final java.lang.String getLogLocation() {
                return this.logLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getKmsKey() != null) {
                    data.set("kmsKey", om.valueToTree(this.getKmsKey()));
                }
                if (this.getLogLocation() != null) {
                    data.set("logLocation", om.valueToTree(this.getLogLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.S3LoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LoggingConfigurationProperty.Jsii$Proxy that = (S3LoggingConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
                return this.logLocation != null ? this.logLocation.equals(that.logLocation) : that.logLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
                result = 31 * result + (this.logLocation != null ? this.logLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
     * <p>
     * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * WorkGroupConfigurationProperty workGroupConfigurationProperty = WorkGroupConfigurationProperty.builder()
     *         .additionalConfiguration("additionalConfiguration")
     *         .bytesScannedCutoffPerQuery(123)
     *         .customerContentEncryptionConfiguration(CustomerContentEncryptionConfigurationProperty.builder()
     *                 .kmsKey("kmsKey")
     *                 .build())
     *         .enforceWorkGroupConfiguration(false)
     *         .engineConfiguration(EngineConfigurationProperty.builder()
     *                 .additionalConfigs(Map.of(
     *                         "additionalConfigsKey", "additionalConfigs"))
     *                 .classifications(List.of(ClassificationProperty.builder()
     *                         .name("name")
     *                         .properties(Map.of(
     *                                 "propertiesKey", "properties"))
     *                         .build()))
     *                 .coordinatorDpuSize(123)
     *                 .defaultExecutorDpuSize(123)
     *                 .maxConcurrentDpus(123)
     *                 .sparkProperties(Map.of(
     *                         "sparkPropertiesKey", "sparkProperties"))
     *                 .build())
     *         .engineVersion(EngineVersionProperty.builder()
     *                 .effectiveEngineVersion("effectiveEngineVersion")
     *                 .selectedEngineVersion("selectedEngineVersion")
     *                 .build())
     *         .executionRole("executionRole")
     *         .managedQueryResultsConfiguration(ManagedQueryResultsConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .encryptionConfiguration(ManagedStorageEncryptionConfigurationProperty.builder()
     *                         .kmsKey("kmsKey")
     *                         .build())
     *                 .build())
     *         .monitoringConfiguration(MonitoringConfigurationProperty.builder()
     *                 .cloudWatchLoggingConfiguration(CloudWatchLoggingConfigurationProperty.builder()
     *                         .enabled(false)
     *                         .logGroup("logGroup")
     *                         .logStreamNamePrefix("logStreamNamePrefix")
     *                         .logTypes(Map.of(
     *                                 "logTypesKey", List.of("logTypes")))
     *                         .build())
     *                 .managedLoggingConfiguration(ManagedLoggingConfigurationProperty.builder()
     *                         .enabled(false)
     *                         .kmsKey("kmsKey")
     *                         .build())
     *                 .s3LoggingConfiguration(S3LoggingConfigurationProperty.builder()
     *                         .enabled(false)
     *                         .kmsKey("kmsKey")
     *                         .logLocation("logLocation")
     *                         .build())
     *                 .build())
     *         .publishCloudWatchMetricsEnabled(false)
     *         .requesterPaysEnabled(false)
     *         .resultConfiguration(ResultConfigurationProperty.builder()
     *                 .aclConfiguration(AclConfigurationProperty.builder()
     *                         .s3AclOption("s3AclOption")
     *                         .build())
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .encryptionOption("encryptionOption")
     *                         // the properties below are optional
     *                         .kmsKey("kmsKey")
     *                         .build())
     *                 .expectedBucketOwner("expectedBucketOwner")
     *                 .outputLocation("outputLocation")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.WorkGroupConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkGroupConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkGroupConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a user defined JSON string that is passed to the session engine.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-additionalconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-additionalconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalConfiguration() {
            return null;
        }

        /**
         * The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         * <p>
         * No default is defined.
         * <p>
         * <blockquote>
         * <p>
         * This property currently supports integer types. Support for long values is planned.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-bytesscannedcutoffperquery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-bytesscannedcutoffperquery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBytesScannedCutoffPerQuery() {
            return null;
        }

        /**
         * Specifies the KMS key that is used to encrypt the user's data stores in Athena.
         * <p>
         * This setting does not apply to Athena SQL workgroups.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.CustomerContentEncryptionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-customercontentencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-customercontentencryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerContentEncryptionConfiguration() {
            return null;
        }

        /**
         * If set to "true", the settings for the workgroup override client-side settings.
         * <p>
         * If set to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-enforceworkgroupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-enforceworkgroupconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnforceWorkGroupConfiguration() {
            return null;
        }

        /**
         * The engine configuration for running queries.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.EngineConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-engineconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-engineconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEngineConfiguration() {
            return null;
        }

        /**
         * The engine version that all queries running on the workgroup use.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.EngineVersionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-engineversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEngineVersion() {
            return null;
        }

        /**
         * Role used to access user resources in an Athena for Apache Spark session.
         * <p>
         * This property applies only to Spark-enabled workgroups in Athena.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-executionrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRole() {
            return null;
        }

        /**
         * The configuration for storing results in Athena owned storage, which includes whether this feature is enabled;
         * <p>
         * whether encryption configuration, if any, is used for encrypting query results.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.ManagedQueryResultsConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-managedqueryresultsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-managedqueryresultsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedQueryResultsConfiguration() {
            return null;
        }

        /**
         * Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets, Amazon CloudWatch log groups etc.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.MonitoringConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-monitoringconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-monitoringconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoringConfiguration() {
            return null;
        }

        /**
         * Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-publishcloudwatchmetricsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-publishcloudwatchmetricsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPublishCloudWatchMetricsEnabled() {
            return null;
        }

        /**
         * If set to <code>true</code> , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
         * <p>
         * If set to <code>false</code> , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code> . For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <em>Amazon Simple Storage Service Developer Guide</em> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-requesterpaysenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-requesterpaysenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequesterPaysEnabled() {
            return null;
        }

        /**
         * Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Work with query results and recent queries</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.ResultConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-resultconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html#cfn-athena-workgroup-workgroupconfiguration-resultconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResultConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkGroupConfigurationProperty> {
            java.lang.String additionalConfiguration;
            java.lang.Number bytesScannedCutoffPerQuery;
            java.lang.Object customerContentEncryptionConfiguration;
            java.lang.Object enforceWorkGroupConfiguration;
            java.lang.Object engineConfiguration;
            java.lang.Object engineVersion;
            java.lang.String executionRole;
            java.lang.Object managedQueryResultsConfiguration;
            java.lang.Object monitoringConfiguration;
            java.lang.Object publishCloudWatchMetricsEnabled;
            java.lang.Object requesterPaysEnabled;
            java.lang.Object resultConfiguration;

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getAdditionalConfiguration}
             * @param additionalConfiguration Specifies a user defined JSON string that is passed to the session engine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalConfiguration(java.lang.String additionalConfiguration) {
                this.additionalConfiguration = additionalConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getBytesScannedCutoffPerQuery}
             * @param bytesScannedCutoffPerQuery The upper limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
             *                                   No default is defined.
             *                                   <p>
             *                                   <blockquote>
             *                                   <p>
             *                                   This property currently supports integer types. Support for long values is planned.
             *                                   <p>
             *                                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bytesScannedCutoffPerQuery(java.lang.Number bytesScannedCutoffPerQuery) {
                this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getCustomerContentEncryptionConfiguration}
             * @param customerContentEncryptionConfiguration Specifies the KMS key that is used to encrypt the user's data stores in Athena.
             *                                               This setting does not apply to Athena SQL workgroups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerContentEncryptionConfiguration(software.amazon.awscdk.IResolvable customerContentEncryptionConfiguration) {
                this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getCustomerContentEncryptionConfiguration}
             * @param customerContentEncryptionConfiguration Specifies the KMS key that is used to encrypt the user's data stores in Athena.
             *                                               This setting does not apply to Athena SQL workgroups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerContentEncryptionConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.CustomerContentEncryptionConfigurationProperty customerContentEncryptionConfiguration) {
                this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEnforceWorkGroupConfiguration}
             * @param enforceWorkGroupConfiguration If set to "true", the settings for the workgroup override client-side settings.
             *                                      If set to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceWorkGroupConfiguration(java.lang.Boolean enforceWorkGroupConfiguration) {
                this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEnforceWorkGroupConfiguration}
             * @param enforceWorkGroupConfiguration If set to "true", the settings for the workgroup override client-side settings.
             *                                      If set to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Override client-side settings</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceWorkGroupConfiguration(software.amazon.awscdk.IResolvable enforceWorkGroupConfiguration) {
                this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEngineConfiguration}
             * @param engineConfiguration The engine configuration for running queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineConfiguration(software.amazon.awscdk.IResolvable engineConfiguration) {
                this.engineConfiguration = engineConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEngineConfiguration}
             * @param engineConfiguration The engine configuration for running queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.EngineConfigurationProperty engineConfiguration) {
                this.engineConfiguration = engineConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEngineVersion}
             * @param engineVersion The engine version that all queries running on the workgroup use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineVersion(software.amazon.awscdk.IResolvable engineVersion) {
                this.engineVersion = engineVersion;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getEngineVersion}
             * @param engineVersion The engine version that all queries running on the workgroup use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineVersion(software.amazon.awscdk.services.athena.CfnWorkGroup.EngineVersionProperty engineVersion) {
                this.engineVersion = engineVersion;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getExecutionRole}
             * @param executionRole Role used to access user resources in an Athena for Apache Spark session.
             *                      This property applies only to Spark-enabled workgroups in Athena.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getManagedQueryResultsConfiguration}
             * @param managedQueryResultsConfiguration The configuration for storing results in Athena owned storage, which includes whether this feature is enabled;.
             *                                         whether encryption configuration, if any, is used for encrypting query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedQueryResultsConfiguration(software.amazon.awscdk.IResolvable managedQueryResultsConfiguration) {
                this.managedQueryResultsConfiguration = managedQueryResultsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getManagedQueryResultsConfiguration}
             * @param managedQueryResultsConfiguration The configuration for storing results in Athena owned storage, which includes whether this feature is enabled;.
             *                                         whether encryption configuration, if any, is used for encrypting query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedQueryResultsConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.ManagedQueryResultsConfigurationProperty managedQueryResultsConfiguration) {
                this.managedQueryResultsConfiguration = managedQueryResultsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getMonitoringConfiguration}
             * @param monitoringConfiguration Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets, Amazon CloudWatch log groups etc.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringConfiguration(software.amazon.awscdk.IResolvable monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getMonitoringConfiguration}
             * @param monitoringConfiguration Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets, Amazon CloudWatch log groups etc.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.MonitoringConfigurationProperty monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getPublishCloudWatchMetricsEnabled}
             * @param publishCloudWatchMetricsEnabled Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishCloudWatchMetricsEnabled(java.lang.Boolean publishCloudWatchMetricsEnabled) {
                this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getPublishCloudWatchMetricsEnabled}
             * @param publishCloudWatchMetricsEnabled Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishCloudWatchMetricsEnabled(software.amazon.awscdk.IResolvable publishCloudWatchMetricsEnabled) {
                this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getRequesterPaysEnabled}
             * @param requesterPaysEnabled If set to <code>true</code> , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
             *                             If set to <code>false</code> , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code> . For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <em>Amazon Simple Storage Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requesterPaysEnabled(java.lang.Boolean requesterPaysEnabled) {
                this.requesterPaysEnabled = requesterPaysEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getRequesterPaysEnabled}
             * @param requesterPaysEnabled If set to <code>true</code> , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
             *                             If set to <code>false</code> , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is <code>false</code> . For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a> in the <em>Amazon Simple Storage Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requesterPaysEnabled(software.amazon.awscdk.IResolvable requesterPaysEnabled) {
                this.requesterPaysEnabled = requesterPaysEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getResultConfiguration}
             * @param resultConfiguration Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results.
             *                            For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Work with query results and recent queries</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultConfiguration(software.amazon.awscdk.IResolvable resultConfiguration) {
                this.resultConfiguration = resultConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationProperty#getResultConfiguration}
             * @param resultConfiguration Specifies the location in Amazon S3 where query results are stored and the encryption option, if any, used for query results.
             *                            For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Work with query results and recent queries</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.ResultConfigurationProperty resultConfiguration) {
                this.resultConfiguration = resultConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkGroupConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkGroupConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkGroupConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkGroupConfigurationProperty {
            private final java.lang.String additionalConfiguration;
            private final java.lang.Number bytesScannedCutoffPerQuery;
            private final java.lang.Object customerContentEncryptionConfiguration;
            private final java.lang.Object enforceWorkGroupConfiguration;
            private final java.lang.Object engineConfiguration;
            private final java.lang.Object engineVersion;
            private final java.lang.String executionRole;
            private final java.lang.Object managedQueryResultsConfiguration;
            private final java.lang.Object monitoringConfiguration;
            private final java.lang.Object publishCloudWatchMetricsEnabled;
            private final java.lang.Object requesterPaysEnabled;
            private final java.lang.Object resultConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalConfiguration = software.amazon.jsii.Kernel.get(this, "additionalConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bytesScannedCutoffPerQuery = software.amazon.jsii.Kernel.get(this, "bytesScannedCutoffPerQuery", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customerContentEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "customerContentEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enforceWorkGroupConfiguration = software.amazon.jsii.Kernel.get(this, "enforceWorkGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.engineConfiguration = software.amazon.jsii.Kernel.get(this, "engineConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.managedQueryResultsConfiguration = software.amazon.jsii.Kernel.get(this, "managedQueryResultsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoringConfiguration = software.amazon.jsii.Kernel.get(this, "monitoringConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.publishCloudWatchMetricsEnabled = software.amazon.jsii.Kernel.get(this, "publishCloudWatchMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requesterPaysEnabled = software.amazon.jsii.Kernel.get(this, "requesterPaysEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resultConfiguration = software.amazon.jsii.Kernel.get(this, "resultConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalConfiguration = builder.additionalConfiguration;
                this.bytesScannedCutoffPerQuery = builder.bytesScannedCutoffPerQuery;
                this.customerContentEncryptionConfiguration = builder.customerContentEncryptionConfiguration;
                this.enforceWorkGroupConfiguration = builder.enforceWorkGroupConfiguration;
                this.engineConfiguration = builder.engineConfiguration;
                this.engineVersion = builder.engineVersion;
                this.executionRole = builder.executionRole;
                this.managedQueryResultsConfiguration = builder.managedQueryResultsConfiguration;
                this.monitoringConfiguration = builder.monitoringConfiguration;
                this.publishCloudWatchMetricsEnabled = builder.publishCloudWatchMetricsEnabled;
                this.requesterPaysEnabled = builder.requesterPaysEnabled;
                this.resultConfiguration = builder.resultConfiguration;
            }

            @Override
            public final java.lang.String getAdditionalConfiguration() {
                return this.additionalConfiguration;
            }

            @Override
            public final java.lang.Number getBytesScannedCutoffPerQuery() {
                return this.bytesScannedCutoffPerQuery;
            }

            @Override
            public final java.lang.Object getCustomerContentEncryptionConfiguration() {
                return this.customerContentEncryptionConfiguration;
            }

            @Override
            public final java.lang.Object getEnforceWorkGroupConfiguration() {
                return this.enforceWorkGroupConfiguration;
            }

            @Override
            public final java.lang.Object getEngineConfiguration() {
                return this.engineConfiguration;
            }

            @Override
            public final java.lang.Object getEngineVersion() {
                return this.engineVersion;
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.Object getManagedQueryResultsConfiguration() {
                return this.managedQueryResultsConfiguration;
            }

            @Override
            public final java.lang.Object getMonitoringConfiguration() {
                return this.monitoringConfiguration;
            }

            @Override
            public final java.lang.Object getPublishCloudWatchMetricsEnabled() {
                return this.publishCloudWatchMetricsEnabled;
            }

            @Override
            public final java.lang.Object getRequesterPaysEnabled() {
                return this.requesterPaysEnabled;
            }

            @Override
            public final java.lang.Object getResultConfiguration() {
                return this.resultConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalConfiguration() != null) {
                    data.set("additionalConfiguration", om.valueToTree(this.getAdditionalConfiguration()));
                }
                if (this.getBytesScannedCutoffPerQuery() != null) {
                    data.set("bytesScannedCutoffPerQuery", om.valueToTree(this.getBytesScannedCutoffPerQuery()));
                }
                if (this.getCustomerContentEncryptionConfiguration() != null) {
                    data.set("customerContentEncryptionConfiguration", om.valueToTree(this.getCustomerContentEncryptionConfiguration()));
                }
                if (this.getEnforceWorkGroupConfiguration() != null) {
                    data.set("enforceWorkGroupConfiguration", om.valueToTree(this.getEnforceWorkGroupConfiguration()));
                }
                if (this.getEngineConfiguration() != null) {
                    data.set("engineConfiguration", om.valueToTree(this.getEngineConfiguration()));
                }
                if (this.getEngineVersion() != null) {
                    data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
                }
                if (this.getExecutionRole() != null) {
                    data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                }
                if (this.getManagedQueryResultsConfiguration() != null) {
                    data.set("managedQueryResultsConfiguration", om.valueToTree(this.getManagedQueryResultsConfiguration()));
                }
                if (this.getMonitoringConfiguration() != null) {
                    data.set("monitoringConfiguration", om.valueToTree(this.getMonitoringConfiguration()));
                }
                if (this.getPublishCloudWatchMetricsEnabled() != null) {
                    data.set("publishCloudWatchMetricsEnabled", om.valueToTree(this.getPublishCloudWatchMetricsEnabled()));
                }
                if (this.getRequesterPaysEnabled() != null) {
                    data.set("requesterPaysEnabled", om.valueToTree(this.getRequesterPaysEnabled()));
                }
                if (this.getResultConfiguration() != null) {
                    data.set("resultConfiguration", om.valueToTree(this.getResultConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.WorkGroupConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkGroupConfigurationProperty.Jsii$Proxy that = (WorkGroupConfigurationProperty.Jsii$Proxy) o;

                if (this.additionalConfiguration != null ? !this.additionalConfiguration.equals(that.additionalConfiguration) : that.additionalConfiguration != null) return false;
                if (this.bytesScannedCutoffPerQuery != null ? !this.bytesScannedCutoffPerQuery.equals(that.bytesScannedCutoffPerQuery) : that.bytesScannedCutoffPerQuery != null) return false;
                if (this.customerContentEncryptionConfiguration != null ? !this.customerContentEncryptionConfiguration.equals(that.customerContentEncryptionConfiguration) : that.customerContentEncryptionConfiguration != null) return false;
                if (this.enforceWorkGroupConfiguration != null ? !this.enforceWorkGroupConfiguration.equals(that.enforceWorkGroupConfiguration) : that.enforceWorkGroupConfiguration != null) return false;
                if (this.engineConfiguration != null ? !this.engineConfiguration.equals(that.engineConfiguration) : that.engineConfiguration != null) return false;
                if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
                if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
                if (this.managedQueryResultsConfiguration != null ? !this.managedQueryResultsConfiguration.equals(that.managedQueryResultsConfiguration) : that.managedQueryResultsConfiguration != null) return false;
                if (this.monitoringConfiguration != null ? !this.monitoringConfiguration.equals(that.monitoringConfiguration) : that.monitoringConfiguration != null) return false;
                if (this.publishCloudWatchMetricsEnabled != null ? !this.publishCloudWatchMetricsEnabled.equals(that.publishCloudWatchMetricsEnabled) : that.publishCloudWatchMetricsEnabled != null) return false;
                if (this.requesterPaysEnabled != null ? !this.requesterPaysEnabled.equals(that.requesterPaysEnabled) : that.requesterPaysEnabled != null) return false;
                return this.resultConfiguration != null ? this.resultConfiguration.equals(that.resultConfiguration) : that.resultConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalConfiguration != null ? this.additionalConfiguration.hashCode() : 0;
                result = 31 * result + (this.bytesScannedCutoffPerQuery != null ? this.bytesScannedCutoffPerQuery.hashCode() : 0);
                result = 31 * result + (this.customerContentEncryptionConfiguration != null ? this.customerContentEncryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.enforceWorkGroupConfiguration != null ? this.enforceWorkGroupConfiguration.hashCode() : 0);
                result = 31 * result + (this.engineConfiguration != null ? this.engineConfiguration.hashCode() : 0);
                result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
                result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
                result = 31 * result + (this.managedQueryResultsConfiguration != null ? this.managedQueryResultsConfiguration.hashCode() : 0);
                result = 31 * result + (this.monitoringConfiguration != null ? this.monitoringConfiguration.hashCode() : 0);
                result = 31 * result + (this.publishCloudWatchMetricsEnabled != null ? this.publishCloudWatchMetricsEnabled.hashCode() : 0);
                result = 31 * result + (this.requesterPaysEnabled != null ? this.requesterPaysEnabled.hashCode() : 0);
                result = 31 * result + (this.resultConfiguration != null ? this.resultConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.athena.*;
     * WorkGroupConfigurationUpdatesProperty workGroupConfigurationUpdatesProperty = WorkGroupConfigurationUpdatesProperty.builder()
     *         .additionalConfiguration("additionalConfiguration")
     *         .bytesScannedCutoffPerQuery(123)
     *         .customerContentEncryptionConfiguration(CustomerContentEncryptionConfigurationProperty.builder()
     *                 .kmsKey("kmsKey")
     *                 .build())
     *         .enforceWorkGroupConfiguration(false)
     *         .engineConfiguration(EngineConfigurationProperty.builder()
     *                 .additionalConfigs(Map.of(
     *                         "additionalConfigsKey", "additionalConfigs"))
     *                 .classifications(List.of(ClassificationProperty.builder()
     *                         .name("name")
     *                         .properties(Map.of(
     *                                 "propertiesKey", "properties"))
     *                         .build()))
     *                 .coordinatorDpuSize(123)
     *                 .defaultExecutorDpuSize(123)
     *                 .maxConcurrentDpus(123)
     *                 .sparkProperties(Map.of(
     *                         "sparkPropertiesKey", "sparkProperties"))
     *                 .build())
     *         .engineVersion(EngineVersionProperty.builder()
     *                 .effectiveEngineVersion("effectiveEngineVersion")
     *                 .selectedEngineVersion("selectedEngineVersion")
     *                 .build())
     *         .executionRole("executionRole")
     *         .managedQueryResultsConfiguration(ManagedQueryResultsConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .encryptionConfiguration(ManagedStorageEncryptionConfigurationProperty.builder()
     *                         .kmsKey("kmsKey")
     *                         .build())
     *                 .build())
     *         .monitoringConfiguration(MonitoringConfigurationProperty.builder()
     *                 .cloudWatchLoggingConfiguration(CloudWatchLoggingConfigurationProperty.builder()
     *                         .enabled(false)
     *                         .logGroup("logGroup")
     *                         .logStreamNamePrefix("logStreamNamePrefix")
     *                         .logTypes(Map.of(
     *                                 "logTypesKey", List.of("logTypes")))
     *                         .build())
     *                 .managedLoggingConfiguration(ManagedLoggingConfigurationProperty.builder()
     *                         .enabled(false)
     *                         .kmsKey("kmsKey")
     *                         .build())
     *                 .s3LoggingConfiguration(S3LoggingConfigurationProperty.builder()
     *                         .enabled(false)
     *                         .kmsKey("kmsKey")
     *                         .logLocation("logLocation")
     *                         .build())
     *                 .build())
     *         .publishCloudWatchMetricsEnabled(false)
     *         .removeBytesScannedCutoffPerQuery(false)
     *         .removeCustomerContentEncryptionConfiguration(false)
     *         .requesterPaysEnabled(false)
     *         .resultConfigurationUpdates(ResultConfigurationUpdatesProperty.builder()
     *                 .aclConfiguration(AclConfigurationProperty.builder()
     *                         .s3AclOption("s3AclOption")
     *                         .build())
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .encryptionOption("encryptionOption")
     *                         // the properties below are optional
     *                         .kmsKey("kmsKey")
     *                         .build())
     *                 .expectedBucketOwner("expectedBucketOwner")
     *                 .outputLocation("outputLocation")
     *                 .removeAclConfiguration(false)
     *                 .removeEncryptionConfiguration(false)
     *                 .removeExpectedBucketOwner(false)
     *                 .removeOutputLocation(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_athena.CfnWorkGroup.WorkGroupConfigurationUpdatesProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkGroupConfigurationUpdatesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkGroupConfigurationUpdatesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Additional Configuration that are passed to Athena Spark Calculations running in this workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-additionalconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-additionalconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalConfiguration() {
            return null;
        }

        /**
         * The upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-bytesscannedcutoffperquery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-bytesscannedcutoffperquery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBytesScannedCutoffPerQuery() {
            return null;
        }

        /**
         * Indicates the KMS key for encrypting notebook content.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.CustomerContentEncryptionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-customercontentencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-customercontentencryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerContentEncryptionConfiguration() {
            return null;
        }

        /**
         * If set to "true", the settings for the workgroup override client-side settings.
         * <p>
         * If set to "false", client-side settings are used
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-enforceworkgroupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-enforceworkgroupconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnforceWorkGroupConfiguration() {
            return null;
        }

        /**
         * The engine configuration for running queries.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.EngineConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-engineconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-engineconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEngineConfiguration() {
            return null;
        }

        /**
         * The Athena engine version for running queries.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.EngineVersionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-engineversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEngineVersion() {
            return null;
        }

        /**
         * The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled workgroups.
         * <p>
         * This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-executionrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRole() {
            return null;
        }

        /**
         * The configuration for the managed query results and encryption option.
         * <p>
         * ResultConfiguration and ManagedQueryResultsConfiguration cannot be set at the same time
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.ManagedQueryResultsConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-managedqueryresultsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-managedqueryresultsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedQueryResultsConfiguration() {
            return null;
        }

        /**
         * Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets, Amazon CloudWatch log groups etc.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.MonitoringConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-monitoringconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-monitoringconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoringConfiguration() {
            return null;
        }

        /**
         * Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-publishcloudwatchmetricsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-publishcloudwatchmetricsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPublishCloudWatchMetricsEnabled() {
            return null;
        }

        /**
         * Indicates that the data usage control limit per query is removed.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-removebytesscannedcutoffperquery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-removebytesscannedcutoffperquery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveBytesScannedCutoffPerQuery() {
            return null;
        }

        /**
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-removecustomercontentencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-removecustomercontentencryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveCustomerContentEncryptionConfiguration() {
            return null;
        }

        /**
         * If set to true, allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
         * <p>
         * If set to false, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-requesterpaysenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-requesterpaysenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequesterPaysEnabled() {
            return null;
        }

        /**
         * The result configuration information about the queries in this workgroup that will be updated.
         * <p>
         * Includes the updated results location and an updated option for encrypting query results.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.athena.CfnWorkGroup.ResultConfigurationUpdatesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-resultconfigurationupdates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html#cfn-athena-workgroup-workgroupconfigurationupdates-resultconfigurationupdates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResultConfigurationUpdates() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkGroupConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkGroupConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkGroupConfigurationUpdatesProperty> {
            java.lang.String additionalConfiguration;
            java.lang.Number bytesScannedCutoffPerQuery;
            java.lang.Object customerContentEncryptionConfiguration;
            java.lang.Object enforceWorkGroupConfiguration;
            java.lang.Object engineConfiguration;
            java.lang.Object engineVersion;
            java.lang.String executionRole;
            java.lang.Object managedQueryResultsConfiguration;
            java.lang.Object monitoringConfiguration;
            java.lang.Object publishCloudWatchMetricsEnabled;
            java.lang.Object removeBytesScannedCutoffPerQuery;
            java.lang.Object removeCustomerContentEncryptionConfiguration;
            java.lang.Object requesterPaysEnabled;
            java.lang.Object resultConfigurationUpdates;

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getAdditionalConfiguration}
             * @param additionalConfiguration Additional Configuration that are passed to Athena Spark Calculations running in this workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalConfiguration(java.lang.String additionalConfiguration) {
                this.additionalConfiguration = additionalConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getBytesScannedCutoffPerQuery}
             * @param bytesScannedCutoffPerQuery The upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bytesScannedCutoffPerQuery(java.lang.Number bytesScannedCutoffPerQuery) {
                this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getCustomerContentEncryptionConfiguration}
             * @param customerContentEncryptionConfiguration Indicates the KMS key for encrypting notebook content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerContentEncryptionConfiguration(software.amazon.awscdk.IResolvable customerContentEncryptionConfiguration) {
                this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getCustomerContentEncryptionConfiguration}
             * @param customerContentEncryptionConfiguration Indicates the KMS key for encrypting notebook content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerContentEncryptionConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.CustomerContentEncryptionConfigurationProperty customerContentEncryptionConfiguration) {
                this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getEnforceWorkGroupConfiguration}
             * @param enforceWorkGroupConfiguration If set to "true", the settings for the workgroup override client-side settings.
             *                                      If set to "false", client-side settings are used
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceWorkGroupConfiguration(java.lang.Boolean enforceWorkGroupConfiguration) {
                this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getEnforceWorkGroupConfiguration}
             * @param enforceWorkGroupConfiguration If set to "true", the settings for the workgroup override client-side settings.
             *                                      If set to "false", client-side settings are used
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceWorkGroupConfiguration(software.amazon.awscdk.IResolvable enforceWorkGroupConfiguration) {
                this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getEngineConfiguration}
             * @param engineConfiguration The engine configuration for running queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineConfiguration(software.amazon.awscdk.IResolvable engineConfiguration) {
                this.engineConfiguration = engineConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getEngineConfiguration}
             * @param engineConfiguration The engine configuration for running queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.EngineConfigurationProperty engineConfiguration) {
                this.engineConfiguration = engineConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getEngineVersion}
             * @param engineVersion The Athena engine version for running queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineVersion(software.amazon.awscdk.IResolvable engineVersion) {
                this.engineVersion = engineVersion;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getEngineVersion}
             * @param engineVersion The Athena engine version for running queries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engineVersion(software.amazon.awscdk.services.athena.CfnWorkGroup.EngineVersionProperty engineVersion) {
                this.engineVersion = engineVersion;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getExecutionRole}
             * @param executionRole The ARN of the execution role used to access user resources for Spark sessions and Identity Center enabled workgroups.
             *                      This property applies only to Spark enabled workgroups and Identity Center enabled workgroups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getManagedQueryResultsConfiguration}
             * @param managedQueryResultsConfiguration The configuration for the managed query results and encryption option.
             *                                         ResultConfiguration and ManagedQueryResultsConfiguration cannot be set at the same time
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedQueryResultsConfiguration(software.amazon.awscdk.IResolvable managedQueryResultsConfiguration) {
                this.managedQueryResultsConfiguration = managedQueryResultsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getManagedQueryResultsConfiguration}
             * @param managedQueryResultsConfiguration The configuration for the managed query results and encryption option.
             *                                         ResultConfiguration and ManagedQueryResultsConfiguration cannot be set at the same time
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedQueryResultsConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.ManagedQueryResultsConfigurationProperty managedQueryResultsConfiguration) {
                this.managedQueryResultsConfiguration = managedQueryResultsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getMonitoringConfiguration}
             * @param monitoringConfiguration Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets, Amazon CloudWatch log groups etc.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringConfiguration(software.amazon.awscdk.IResolvable monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getMonitoringConfiguration}
             * @param monitoringConfiguration Contains the configuration settings for managed log persistence, delivering logs to Amazon S3 buckets, Amazon CloudWatch log groups etc.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringConfiguration(software.amazon.awscdk.services.athena.CfnWorkGroup.MonitoringConfigurationProperty monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getPublishCloudWatchMetricsEnabled}
             * @param publishCloudWatchMetricsEnabled Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishCloudWatchMetricsEnabled(java.lang.Boolean publishCloudWatchMetricsEnabled) {
                this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getPublishCloudWatchMetricsEnabled}
             * @param publishCloudWatchMetricsEnabled Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishCloudWatchMetricsEnabled(software.amazon.awscdk.IResolvable publishCloudWatchMetricsEnabled) {
                this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRemoveBytesScannedCutoffPerQuery}
             * @param removeBytesScannedCutoffPerQuery Indicates that the data usage control limit per query is removed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeBytesScannedCutoffPerQuery(java.lang.Boolean removeBytesScannedCutoffPerQuery) {
                this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRemoveBytesScannedCutoffPerQuery}
             * @param removeBytesScannedCutoffPerQuery Indicates that the data usage control limit per query is removed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeBytesScannedCutoffPerQuery(software.amazon.awscdk.IResolvable removeBytesScannedCutoffPerQuery) {
                this.removeBytesScannedCutoffPerQuery = removeBytesScannedCutoffPerQuery;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRemoveCustomerContentEncryptionConfiguration}
             * @param removeCustomerContentEncryptionConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeCustomerContentEncryptionConfiguration(java.lang.Boolean removeCustomerContentEncryptionConfiguration) {
                this.removeCustomerContentEncryptionConfiguration = removeCustomerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRemoveCustomerContentEncryptionConfiguration}
             * @param removeCustomerContentEncryptionConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder removeCustomerContentEncryptionConfiguration(software.amazon.awscdk.IResolvable removeCustomerContentEncryptionConfiguration) {
                this.removeCustomerContentEncryptionConfiguration = removeCustomerContentEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRequesterPaysEnabled}
             * @param requesterPaysEnabled If set to true, allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
             *                             If set to false, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requesterPaysEnabled(java.lang.Boolean requesterPaysEnabled) {
                this.requesterPaysEnabled = requesterPaysEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getRequesterPaysEnabled}
             * @param requesterPaysEnabled If set to true, allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
             *                             If set to false, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requesterPaysEnabled(software.amazon.awscdk.IResolvable requesterPaysEnabled) {
                this.requesterPaysEnabled = requesterPaysEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getResultConfigurationUpdates}
             * @param resultConfigurationUpdates The result configuration information about the queries in this workgroup that will be updated.
             *                                   Includes the updated results location and an updated option for encrypting query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultConfigurationUpdates(software.amazon.awscdk.IResolvable resultConfigurationUpdates) {
                this.resultConfigurationUpdates = resultConfigurationUpdates;
                return this;
            }

            /**
             * Sets the value of {@link WorkGroupConfigurationUpdatesProperty#getResultConfigurationUpdates}
             * @param resultConfigurationUpdates The result configuration information about the queries in this workgroup that will be updated.
             *                                   Includes the updated results location and an updated option for encrypting query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultConfigurationUpdates(software.amazon.awscdk.services.athena.CfnWorkGroup.ResultConfigurationUpdatesProperty resultConfigurationUpdates) {
                this.resultConfigurationUpdates = resultConfigurationUpdates;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkGroupConfigurationUpdatesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkGroupConfigurationUpdatesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkGroupConfigurationUpdatesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkGroupConfigurationUpdatesProperty {
            private final java.lang.String additionalConfiguration;
            private final java.lang.Number bytesScannedCutoffPerQuery;
            private final java.lang.Object customerContentEncryptionConfiguration;
            private final java.lang.Object enforceWorkGroupConfiguration;
            private final java.lang.Object engineConfiguration;
            private final java.lang.Object engineVersion;
            private final java.lang.String executionRole;
            private final java.lang.Object managedQueryResultsConfiguration;
            private final java.lang.Object monitoringConfiguration;
            private final java.lang.Object publishCloudWatchMetricsEnabled;
            private final java.lang.Object removeBytesScannedCutoffPerQuery;
            private final java.lang.Object removeCustomerContentEncryptionConfiguration;
            private final java.lang.Object requesterPaysEnabled;
            private final java.lang.Object resultConfigurationUpdates;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.additionalConfiguration = software.amazon.jsii.Kernel.get(this, "additionalConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bytesScannedCutoffPerQuery = software.amazon.jsii.Kernel.get(this, "bytesScannedCutoffPerQuery", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customerContentEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "customerContentEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enforceWorkGroupConfiguration = software.amazon.jsii.Kernel.get(this, "enforceWorkGroupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.engineConfiguration = software.amazon.jsii.Kernel.get(this, "engineConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.managedQueryResultsConfiguration = software.amazon.jsii.Kernel.get(this, "managedQueryResultsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoringConfiguration = software.amazon.jsii.Kernel.get(this, "monitoringConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.publishCloudWatchMetricsEnabled = software.amazon.jsii.Kernel.get(this, "publishCloudWatchMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeBytesScannedCutoffPerQuery = software.amazon.jsii.Kernel.get(this, "removeBytesScannedCutoffPerQuery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.removeCustomerContentEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "removeCustomerContentEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requesterPaysEnabled = software.amazon.jsii.Kernel.get(this, "requesterPaysEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resultConfigurationUpdates = software.amazon.jsii.Kernel.get(this, "resultConfigurationUpdates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.additionalConfiguration = builder.additionalConfiguration;
                this.bytesScannedCutoffPerQuery = builder.bytesScannedCutoffPerQuery;
                this.customerContentEncryptionConfiguration = builder.customerContentEncryptionConfiguration;
                this.enforceWorkGroupConfiguration = builder.enforceWorkGroupConfiguration;
                this.engineConfiguration = builder.engineConfiguration;
                this.engineVersion = builder.engineVersion;
                this.executionRole = builder.executionRole;
                this.managedQueryResultsConfiguration = builder.managedQueryResultsConfiguration;
                this.monitoringConfiguration = builder.monitoringConfiguration;
                this.publishCloudWatchMetricsEnabled = builder.publishCloudWatchMetricsEnabled;
                this.removeBytesScannedCutoffPerQuery = builder.removeBytesScannedCutoffPerQuery;
                this.removeCustomerContentEncryptionConfiguration = builder.removeCustomerContentEncryptionConfiguration;
                this.requesterPaysEnabled = builder.requesterPaysEnabled;
                this.resultConfigurationUpdates = builder.resultConfigurationUpdates;
            }

            @Override
            public final java.lang.String getAdditionalConfiguration() {
                return this.additionalConfiguration;
            }

            @Override
            public final java.lang.Number getBytesScannedCutoffPerQuery() {
                return this.bytesScannedCutoffPerQuery;
            }

            @Override
            public final java.lang.Object getCustomerContentEncryptionConfiguration() {
                return this.customerContentEncryptionConfiguration;
            }

            @Override
            public final java.lang.Object getEnforceWorkGroupConfiguration() {
                return this.enforceWorkGroupConfiguration;
            }

            @Override
            public final java.lang.Object getEngineConfiguration() {
                return this.engineConfiguration;
            }

            @Override
            public final java.lang.Object getEngineVersion() {
                return this.engineVersion;
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.Object getManagedQueryResultsConfiguration() {
                return this.managedQueryResultsConfiguration;
            }

            @Override
            public final java.lang.Object getMonitoringConfiguration() {
                return this.monitoringConfiguration;
            }

            @Override
            public final java.lang.Object getPublishCloudWatchMetricsEnabled() {
                return this.publishCloudWatchMetricsEnabled;
            }

            @Override
            public final java.lang.Object getRemoveBytesScannedCutoffPerQuery() {
                return this.removeBytesScannedCutoffPerQuery;
            }

            @Override
            public final java.lang.Object getRemoveCustomerContentEncryptionConfiguration() {
                return this.removeCustomerContentEncryptionConfiguration;
            }

            @Override
            public final java.lang.Object getRequesterPaysEnabled() {
                return this.requesterPaysEnabled;
            }

            @Override
            public final java.lang.Object getResultConfigurationUpdates() {
                return this.resultConfigurationUpdates;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdditionalConfiguration() != null) {
                    data.set("additionalConfiguration", om.valueToTree(this.getAdditionalConfiguration()));
                }
                if (this.getBytesScannedCutoffPerQuery() != null) {
                    data.set("bytesScannedCutoffPerQuery", om.valueToTree(this.getBytesScannedCutoffPerQuery()));
                }
                if (this.getCustomerContentEncryptionConfiguration() != null) {
                    data.set("customerContentEncryptionConfiguration", om.valueToTree(this.getCustomerContentEncryptionConfiguration()));
                }
                if (this.getEnforceWorkGroupConfiguration() != null) {
                    data.set("enforceWorkGroupConfiguration", om.valueToTree(this.getEnforceWorkGroupConfiguration()));
                }
                if (this.getEngineConfiguration() != null) {
                    data.set("engineConfiguration", om.valueToTree(this.getEngineConfiguration()));
                }
                if (this.getEngineVersion() != null) {
                    data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
                }
                if (this.getExecutionRole() != null) {
                    data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                }
                if (this.getManagedQueryResultsConfiguration() != null) {
                    data.set("managedQueryResultsConfiguration", om.valueToTree(this.getManagedQueryResultsConfiguration()));
                }
                if (this.getMonitoringConfiguration() != null) {
                    data.set("monitoringConfiguration", om.valueToTree(this.getMonitoringConfiguration()));
                }
                if (this.getPublishCloudWatchMetricsEnabled() != null) {
                    data.set("publishCloudWatchMetricsEnabled", om.valueToTree(this.getPublishCloudWatchMetricsEnabled()));
                }
                if (this.getRemoveBytesScannedCutoffPerQuery() != null) {
                    data.set("removeBytesScannedCutoffPerQuery", om.valueToTree(this.getRemoveBytesScannedCutoffPerQuery()));
                }
                if (this.getRemoveCustomerContentEncryptionConfiguration() != null) {
                    data.set("removeCustomerContentEncryptionConfiguration", om.valueToTree(this.getRemoveCustomerContentEncryptionConfiguration()));
                }
                if (this.getRequesterPaysEnabled() != null) {
                    data.set("requesterPaysEnabled", om.valueToTree(this.getRequesterPaysEnabled()));
                }
                if (this.getResultConfigurationUpdates() != null) {
                    data.set("resultConfigurationUpdates", om.valueToTree(this.getResultConfigurationUpdates()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_athena.CfnWorkGroup.WorkGroupConfigurationUpdatesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkGroupConfigurationUpdatesProperty.Jsii$Proxy that = (WorkGroupConfigurationUpdatesProperty.Jsii$Proxy) o;

                if (this.additionalConfiguration != null ? !this.additionalConfiguration.equals(that.additionalConfiguration) : that.additionalConfiguration != null) return false;
                if (this.bytesScannedCutoffPerQuery != null ? !this.bytesScannedCutoffPerQuery.equals(that.bytesScannedCutoffPerQuery) : that.bytesScannedCutoffPerQuery != null) return false;
                if (this.customerContentEncryptionConfiguration != null ? !this.customerContentEncryptionConfiguration.equals(that.customerContentEncryptionConfiguration) : that.customerContentEncryptionConfiguration != null) return false;
                if (this.enforceWorkGroupConfiguration != null ? !this.enforceWorkGroupConfiguration.equals(that.enforceWorkGroupConfiguration) : that.enforceWorkGroupConfiguration != null) return false;
                if (this.engineConfiguration != null ? !this.engineConfiguration.equals(that.engineConfiguration) : that.engineConfiguration != null) return false;
                if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
                if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
                if (this.managedQueryResultsConfiguration != null ? !this.managedQueryResultsConfiguration.equals(that.managedQueryResultsConfiguration) : that.managedQueryResultsConfiguration != null) return false;
                if (this.monitoringConfiguration != null ? !this.monitoringConfiguration.equals(that.monitoringConfiguration) : that.monitoringConfiguration != null) return false;
                if (this.publishCloudWatchMetricsEnabled != null ? !this.publishCloudWatchMetricsEnabled.equals(that.publishCloudWatchMetricsEnabled) : that.publishCloudWatchMetricsEnabled != null) return false;
                if (this.removeBytesScannedCutoffPerQuery != null ? !this.removeBytesScannedCutoffPerQuery.equals(that.removeBytesScannedCutoffPerQuery) : that.removeBytesScannedCutoffPerQuery != null) return false;
                if (this.removeCustomerContentEncryptionConfiguration != null ? !this.removeCustomerContentEncryptionConfiguration.equals(that.removeCustomerContentEncryptionConfiguration) : that.removeCustomerContentEncryptionConfiguration != null) return false;
                if (this.requesterPaysEnabled != null ? !this.requesterPaysEnabled.equals(that.requesterPaysEnabled) : that.requesterPaysEnabled != null) return false;
                return this.resultConfigurationUpdates != null ? this.resultConfigurationUpdates.equals(that.resultConfigurationUpdates) : that.resultConfigurationUpdates == null;
            }

            @Override
            public final int hashCode() {
                int result = this.additionalConfiguration != null ? this.additionalConfiguration.hashCode() : 0;
                result = 31 * result + (this.bytesScannedCutoffPerQuery != null ? this.bytesScannedCutoffPerQuery.hashCode() : 0);
                result = 31 * result + (this.customerContentEncryptionConfiguration != null ? this.customerContentEncryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.enforceWorkGroupConfiguration != null ? this.enforceWorkGroupConfiguration.hashCode() : 0);
                result = 31 * result + (this.engineConfiguration != null ? this.engineConfiguration.hashCode() : 0);
                result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
                result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
                result = 31 * result + (this.managedQueryResultsConfiguration != null ? this.managedQueryResultsConfiguration.hashCode() : 0);
                result = 31 * result + (this.monitoringConfiguration != null ? this.monitoringConfiguration.hashCode() : 0);
                result = 31 * result + (this.publishCloudWatchMetricsEnabled != null ? this.publishCloudWatchMetricsEnabled.hashCode() : 0);
                result = 31 * result + (this.removeBytesScannedCutoffPerQuery != null ? this.removeBytesScannedCutoffPerQuery.hashCode() : 0);
                result = 31 * result + (this.removeCustomerContentEncryptionConfiguration != null ? this.removeCustomerContentEncryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.requesterPaysEnabled != null ? this.requesterPaysEnabled.hashCode() : 0);
                result = 31 * result + (this.resultConfigurationUpdates != null ? this.resultConfigurationUpdates.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.athena.CfnWorkGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.athena.CfnWorkGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.athena.CfnWorkGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.athena.CfnWorkGroupProps.Builder();
        }

        /**
         * The workgroup name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-name</a>
         * @param name The workgroup name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The workgroup description.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-description</a>
         * @param description The workgroup description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
         * <p>
         * The default is false.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption</a>
         * @param recursiveDeleteOption The option to delete a workgroup and its contents even if the workgroup contains any named queries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recursiveDeleteOption(final java.lang.Boolean recursiveDeleteOption) {
            this.props.recursiveDeleteOption(recursiveDeleteOption);
            return this;
        }
        /**
         * The option to delete a workgroup and its contents even if the workgroup contains any named queries.
         * <p>
         * The default is false.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-recursivedeleteoption</a>
         * @param recursiveDeleteOption The option to delete a workgroup and its contents even if the workgroup contains any named queries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recursiveDeleteOption(final software.amazon.awscdk.IResolvable recursiveDeleteOption) {
            this.props.recursiveDeleteOption(recursiveDeleteOption);
            return this;
        }

        /**
         * The state of the workgroup: ENABLED or DISABLED.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-state</a>
         * @param state The state of the workgroup: ENABLED or DISABLED. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(final java.lang.String state) {
            this.props.state(state);
            return this;
        }

        /**
         * The tags (key-value pairs) to associate with this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-tags</a>
         * @param tags The tags (key-value pairs) to associate with this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
         * <p>
         * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration</a>
         * @param workGroupConfiguration The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workGroupConfiguration(final software.amazon.awscdk.IResolvable workGroupConfiguration) {
            this.props.workGroupConfiguration(workGroupConfiguration);
            return this;
        }
        /**
         * The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
         * <p>
         * The <code>EnforceWorkGroupConfiguration</code> option determines whether workgroup settings override client-side query settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfiguration</a>
         * @param workGroupConfiguration The configuration of the workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch Metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workGroupConfiguration(final software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty workGroupConfiguration) {
            this.props.workGroupConfiguration(workGroupConfiguration);
            return this;
        }

        /**
         * (deprecated) The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates</a>
         * @deprecated this property has been deprecated
         * @param workGroupConfigurationUpdates The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder workGroupConfigurationUpdates(final software.amazon.awscdk.IResolvable workGroupConfigurationUpdates) {
            this.props.workGroupConfigurationUpdates(workGroupConfigurationUpdates);
            return this;
        }
        /**
         * (deprecated) The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html#cfn-athena-workgroup-workgroupconfigurationupdates</a>
         * @deprecated this property has been deprecated
         * @param workGroupConfigurationUpdates The configuration information that will be updated for this workgroup, which includes the location in Amazon S3 where query results are stored, the encryption option, if any, used for query results, whether the Amazon CloudWatch Metrics are enabled for the workgroup, whether the workgroup settings override the client-side settings, and the data usage limit for the amount of bytes scanned per query, if it is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder workGroupConfigurationUpdates(final software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationUpdatesProperty workGroupConfigurationUpdates) {
            this.props.workGroupConfigurationUpdates(workGroupConfigurationUpdates);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.athena.CfnWorkGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.athena.CfnWorkGroup build() {
            return new software.amazon.awscdk.services.athena.CfnWorkGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
