package software.amazon.awscdk.services.autoscaling;

/**
 * A Fleet represents a managed set of EC2 instances.
 * <p>
 * The Fleet models a number of AutoScalingGroups, a launch configuration, a
 * security group and an instance role.
 * <p>
 * It allows adding arbitrary commands to the startup scripts of the instances
 * in the fleet.
 * <p>
 * The ASG spans the availability zones specified by vpcSubnets, falling back to
 * the Vpc default strategy if not specified.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * SecurityGroup mySecurityGroup = SecurityGroup.Builder.create(this, "SecurityGroup").vpc(vpc).build();
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.MICRO))
 *         .machineImage(MachineImage.latestAmazonLinux2())
 *         .securityGroup(mySecurityGroup)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:14.728Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.AutoScalingGroup")
public class AutoScalingGroup extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget, software.amazon.awscdk.services.ec2.IConnectable, software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget, software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget, software.amazon.awscdk.services.autoscaling.IAutoScalingGroup {

    protected AutoScalingGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AutoScalingGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscaling.AutoScalingGroup.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AutoScalingGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param autoScalingGroupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.IAutoScalingGroup fromAutoScalingGroupName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String autoScalingGroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.AutoScalingGroup.class, "fromAutoScalingGroupName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(autoScalingGroupName, "autoScalingGroupName is required") });
    }

    /**
     * Send a message to either an SQS queue or SNS topic when instances launch or terminate.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.LifecycleHook addLifecycleHook(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicLifecycleHookProps props) {
        return software.amazon.jsii.Kernel.call(this, "addLifecycleHook", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.LifecycleHook.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add the security group to all instances via the launch template security groups array.
     * <p>
     * @param securityGroup : The security group to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        software.amazon.jsii.Kernel.call(this, "addSecurityGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required") });
    }

    /**
     * Adds a statement to the IAM role assumed by instances of this fleet.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Add command to the startup script of fleet instances.
     * <p>
     * The command must be in the scripting language supported by the fleet's OS (i.e. Linux/Windows).
     * Does nothing for imported ASGs.
     * <p>
     * @param commands This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addUserData(final @org.jetbrains.annotations.NotNull java.lang.String... commands) {
        software.amazon.jsii.Kernel.call(this, "addUserData", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(commands).toArray(Object[]::new));
    }

    /**
     * Add a pool of pre-initialized EC2 instances that sits alongside an Auto Scaling group.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.WarmPool addWarmPool(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.WarmPoolOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addWarmPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.WarmPool.class), new Object[] { options });
    }

    /**
     * Add a pool of pre-initialized EC2 instances that sits alongside an Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.WarmPool addWarmPool() {
        return software.amazon.jsii.Kernel.call(this, "addWarmPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.WarmPool.class));
    }

    /**
     * Use a CloudFormation Init configuration at instance startup.
     * <p>
     * This does the following:
     * <p>
     * <ul>
     * <li>Attaches the CloudFormation Init metadata to the AutoScalingGroup resource.</li>
     * <li>Add commands to the UserData to run <code>cfn-init</code> and <code>cfn-signal</code>.</li>
     * <li>Update the instance's CreationPolicy to wait for <code>cfn-init</code> to finish
     * before reporting success.</li>
     * </ul>
     * <p>
     * @param init This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void applyCloudFormationInit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CloudFormationInit init, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.ApplyCloudFormationInitOptions options) {
        software.amazon.jsii.Kernel.call(this, "applyCloudFormationInit", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(init, "init is required"), options });
    }

    /**
     * Use a CloudFormation Init configuration at instance startup.
     * <p>
     * This does the following:
     * <p>
     * <ul>
     * <li>Attaches the CloudFormation Init metadata to the AutoScalingGroup resource.</li>
     * <li>Add commands to the UserData to run <code>cfn-init</code> and <code>cfn-signal</code>.</li>
     * <li>Update the instance's CreationPolicy to wait for <code>cfn-init</code> to finish
     * before reporting success.</li>
     * </ul>
     * <p>
     * @param init This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void applyCloudFormationInit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CloudFormationInit init) {
        software.amazon.jsii.Kernel.call(this, "applyCloudFormationInit", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(init, "init is required") });
    }

    /**
     * Returns <code>true</code> if newly-launched instances are protected from scale-in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean areNewInstancesProtectedFromScaleIn() {
        return software.amazon.jsii.Kernel.call(this, "areNewInstancesProtectedFromScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Attach to ELBv2 Application Target Group.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToApplicationTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * Attach to a classic load balancer.
     * <p>
     * @param loadBalancer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void attachToClassicLB(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
        software.amazon.jsii.Kernel.call(this, "attachToClassicLB", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * Attach to ELBv2 Application Target Group.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToNetworkTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * Ensures newly-launched instances are protected from scale-in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void protectNewInstancesFromScaleIn() {
        software.amazon.jsii.Kernel.call(this, "protectNewInstancesFromScaleIn", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Scale out or in to achieve a target CPU utilization.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnCpuUtilization(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.CpuUtilizationScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "scaleOnCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in to achieve a target network ingress rate.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnIncomingBytes(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "scaleOnIncomingBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in, in response to a metric.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.StepScalingPolicy scaleOnMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicStepScalingPolicyProps props) {
        return software.amazon.jsii.Kernel.call(this, "scaleOnMetric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.StepScalingPolicy.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in to achieve a target network egress rate.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnOutgoingBytes(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "scaleOnOutgoingBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in to achieve a target request handling rate.
     * <p>
     * The AutoScalingGroup must have been attached to an Application Load Balancer
     * in order to be able to call this.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnRequestCount(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.RequestCountScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "scaleOnRequestCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in based on time.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.ScheduledAction scaleOnSchedule(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicScheduledActionProps props) {
        return software.amazon.jsii.Kernel.call(this, "scaleOnSchedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ScheduledAction.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in in order to keep a metric around a target value.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleToTrackMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.MetricTargetTrackingProps props) {
        return software.amazon.jsii.Kernel.call(this, "scaleToTrackMetric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * Arn of the AutoScalingGroup.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of the AutoScalingGroup.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupName() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The network connections associated with this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * The type of OS instances of this fleet are running.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
        return software.amazon.jsii.Kernel.get(this, "osType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.OperatingSystemType.class));
    }

    /**
     * The IAM Role in the instance profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The Base64-encoded user data to make available to the launched EC2 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.UserData getUserData() {
        return software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
    }

    /**
     * The maximum amount of time that an instance can be in service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxInstanceLifetime() {
        return software.amazon.jsii.Kernel.get(this, "maxInstanceLifetime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * The maximum spot price configured for the autoscaling group.
     * <p>
     * <code>undefined</code>
     * indicates that this group uses on-demand capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
        return software.amazon.jsii.Kernel.get(this, "spotPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getHasCalledScaleOnRequestCount() {
        return software.amazon.jsii.Kernel.get(this, "hasCalledScaleOnRequestCount", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setHasCalledScaleOnRequestCount(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "hasCalledScaleOnRequestCount", java.util.Objects.requireNonNull(value, "hasCalledScaleOnRequestCount is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup getAlbTargetGroup() {
        return software.amazon.jsii.Kernel.get(this, "albTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setAlbTargetGroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup value) {
        software.amazon.jsii.Kernel.set(this, "albTargetGroup", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.Boolean getNewInstancesProtectedFromScaleIn() {
        return software.amazon.jsii.Kernel.get(this, "newInstancesProtectedFromScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setNewInstancesProtectedFromScaleIn(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "newInstancesProtectedFromScaleIn", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscaling.AutoScalingGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscaling.AutoScalingGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscaling.AutoScalingGroupProps.Builder();
        }

        /**
         * Whether the instances can initiate connections to anywhere by default.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether the instances can initiate connections to anywhere by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * Whether instances in the Auto Scaling Group should have public IP addresses associated with them.
         * <p>
         * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * <p>
         * Default: - Use subnet setting.
         * <p>
         * @return {@code this}
         * @param associatePublicIpAddress Whether instances in the Auto Scaling Group should have public IP addresses associated with them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(final java.lang.Boolean associatePublicIpAddress) {
            this.props.associatePublicIpAddress(associatePublicIpAddress);
            return this;
        }

        /**
         * The name of the Auto Scaling group.
         * <p>
         * This name must be unique per Region per account.
         * <p>
         * Default: - Auto generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param autoScalingGroupName The name of the Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(final java.lang.String autoScalingGroupName) {
            this.props.autoScalingGroupName(autoScalingGroupName);
            return this;
        }

        /**
         * The strategy for distributing instances across Availability Zones.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param azCapacityDistributionStrategy The strategy for distributing instances across Availability Zones. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder azCapacityDistributionStrategy(final software.amazon.awscdk.services.autoscaling.CapacityDistributionStrategy azCapacityDistributionStrategy) {
            this.props.azCapacityDistributionStrategy(azCapacityDistributionStrategy);
            return this;
        }

        /**
         * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         * <p>
         * Each instance that is launched has an associated root device volume,
         * either an Amazon EBS volume or an instance store volume.
         * You can use block device mappings to specify additional EBS volumes or
         * instance store volumes to attach to an instance when it is launched.
         * <p>
         * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * <p>
         * Default: - Uses the block device mapping of the AMI
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html</a>
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDevices(final java.util.List<? extends software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices) {
            this.props.blockDevices(blockDevices);
            return this;
        }

        /**
         * Indicates whether Capacity Rebalancing is enabled.
         * <p>
         * When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling
         * attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of
         * interruption. After launching a new instance, it then terminates an old instance.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-capacityrebalance">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-capacityrebalance</a>
         * @param capacityRebalance Indicates whether Capacity Rebalancing is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityRebalance(final java.lang.Boolean capacityRebalance) {
            this.props.capacityRebalance(capacityRebalance);
            return this;
        }

        /**
         * Default scaling cooldown for this AutoScalingGroup.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param cooldown Default scaling cooldown for this AutoScalingGroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(final software.amazon.awscdk.Duration cooldown) {
            this.props.cooldown(cooldown);
            return this;
        }

        /**
         * The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics.
         * <p>
         * This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics,
         * resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource
         * consumption to become stable after an instance reaches the InService state.
         * <p>
         * To optimize the performance of scaling policies that scale continuously, such as target tracking and
         * step scaling policies, we strongly recommend that you enable the default instance warmup, even if its value is set to 0 seconds
         * <p>
         * Default instance warmup will not be added if no value is specified
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html</a>
         * @param defaultInstanceWarmup The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultInstanceWarmup(final software.amazon.awscdk.Duration defaultInstanceWarmup) {
            this.props.defaultInstanceWarmup(defaultInstanceWarmup);
            return this;
        }

        /**
         * Initial amount of instances in the fleet.
         * <p>
         * If this is set to a number, every deployment will reset the amount of
         * instances to this number. It is recommended to leave this value blank.
         * <p>
         * Default: minCapacity, and leave unchanged during deployment
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity</a>
         * @param desiredCapacity Initial amount of instances in the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCapacity(final java.lang.Number desiredCapacity) {
            this.props.desiredCapacity(desiredCapacity);
            return this;
        }

        /**
         * Enable monitoring for group metrics, these metrics describe the group rather than any of its instances.
         * <p>
         * To report all group metrics use <code>GroupMetrics.all()</code>
         * Group metrics are reported in a granularity of 1 minute at no additional charge.
         * <p>
         * Default: - no group metrics will be reported
         * <p>
         * @return {@code this}
         * @param groupMetrics Enable monitoring for group metrics, these metrics describe the group rather than any of its instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupMetrics(final java.util.List<? extends software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics) {
            this.props.groupMetrics(groupMetrics);
            return this;
        }

        /**
         * (deprecated) Configuration for health checks.
         * <p>
         * Default: - HealthCheck.ec2 with no grace period
         * <p>
         * @return {@code this}
         * @deprecated Use <code>healthChecks</code> instead
         * @param healthCheck Configuration for health checks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder healthCheck(final software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * Configuration for EC2 or additional health checks.
         * <p>
         * Even when using <code>HealthChecks.withAdditionalChecks()</code>, the EC2 type is implicitly included.
         * <p>
         * Default: - EC2 type with no grace period
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html</a>
         * @param healthChecks Configuration for EC2 or additional health checks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthChecks(final software.amazon.awscdk.services.autoscaling.HealthChecks healthChecks) {
            this.props.healthChecks(healthChecks);
            return this;
        }

        /**
         * If the ASG has scheduled actions, don't reset unchanged group sizes.
         * <p>
         * Only used if the ASG has scheduled actions (which may scale your ASG up
         * or down regardless of cdk deployments). If true, the size of the group
         * will only be reset if it has been changed in the CDK app. If false, the
         * sizes will always be changed back to what they were in the CDK app
         * on deployment.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param ignoreUnmodifiedSizeProperties If the ASG has scheduled actions, don't reset unchanged group sizes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreUnmodifiedSizeProperties(final java.lang.Boolean ignoreUnmodifiedSizeProperties) {
            this.props.ignoreUnmodifiedSizeProperties(ignoreUnmodifiedSizeProperties);
            return this;
        }

        /**
         * Controls whether instances in this group are launched with detailed or basic monitoring.
         * <p>
         * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account
         * is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes.
         * <p>
         * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * <p>
         * Default: - Monitoring.DETAILED
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics">https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics</a>
         * @param instanceMonitoring Controls whether instances in this group are launched with detailed or basic monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMonitoring(final software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring) {
            this.props.instanceMonitoring(instanceMonitoring);
            return this;
        }

        /**
         * (deprecated) Name of SSH keypair to grant access to instances.
         * <p>
         * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * <p>
         * You can either specify <code>keyPair</code> or <code>keyName</code>, not both.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @deprecated <ul>
         * <li>Use <code>keyPair</code> instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair</li>
         * </ul>
         * @param keyName Name of SSH keypair to grant access to instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder keyName(final java.lang.String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        /**
         * The SSH keypair to grant access to the instance.
         * <p>
         * Feature flag <code>AUTOSCALING_GENERATE_LAUNCH_TEMPLATE</code> must be enabled to use this property.
         * <p>
         * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified.
         * <p>
         * You can either specify <code>keyPair</code> or <code>keyName</code>, not both.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @param keyPair The SSH keypair to grant access to the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(final software.amazon.awscdk.services.ec2.IKeyPair keyPair) {
            this.props.keyPair(keyPair);
            return this;
        }

        /**
         * Maximum number of instances in the fleet.
         * <p>
         * Default: desiredCapacity
         * <p>
         * @return {@code this}
         * @param maxCapacity Maximum number of instances in the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(final java.lang.Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        /**
         * The maximum amount of time that an instance can be in service.
         * <p>
         * The maximum duration applies
         * to all current and future instances in the group. As an instance approaches its maximum duration,
         * it is terminated and replaced, and cannot be used again.
         * <p>
         * You must specify a value of at least 86,400 seconds (one day). To clear a previously set value,
         * leave this property undefined.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html</a>
         * @param maxInstanceLifetime The maximum amount of time that an instance can be in service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInstanceLifetime(final software.amazon.awscdk.Duration maxInstanceLifetime) {
            this.props.maxInstanceLifetime(maxInstanceLifetime);
            return this;
        }

        /**
         * Minimum number of instances in the fleet.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param minCapacity Minimum number of instances in the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(final java.lang.Number minCapacity) {
            this.props.minCapacity(minCapacity);
            return this;
        }

        /**
         * Whether newly-launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
         * <p>
         * By default, Auto Scaling can terminate an instance at any time after launch
         * when scaling in an Auto Scaling Group, subject to the group's termination
         * policy. However, you may wish to protect newly-launched instances from
         * being scaled in if they are going to run critical applications that should
         * not be prematurely terminated.
         * <p>
         * This flag must be enabled if the Auto Scaling Group will be associated with
         * an ECS Capacity Provider with managed termination protection.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param newInstancesProtectedFromScaleIn Whether newly-launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder newInstancesProtectedFromScaleIn(final java.lang.Boolean newInstancesProtectedFromScaleIn) {
            this.props.newInstancesProtectedFromScaleIn(newInstancesProtectedFromScaleIn);
            return this;
        }

        /**
         * Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
         * <p>
         * Default: - No fleet change notifications will be sent.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations</a>
         * @param notifications Configure autoscaling group to send notifications about fleet changes to an SNS topic(s). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifications(final java.util.List<? extends software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications) {
            this.props.notifications(notifications);
            return this;
        }

        /**
         * Configure waiting for signals during deployment.
         * <p>
         * Use this to pause the CloudFormation deployment to wait for the instances
         * in the AutoScalingGroup to report successful startup during
         * creation and updates. The UserData script needs to invoke <code>cfn-signal</code>
         * with a success or failure code after it is done setting up the instance.
         * <p>
         * Without waiting for signals, the CloudFormation deployment will proceed as
         * soon as the AutoScalingGroup has been created or updated but before the
         * instances in the group have been started.
         * <p>
         * For example, to have instances wait for an Elastic Load Balancing health check before
         * they signal success, add a health-check verification by using the
         * cfn-init helper script. For an example, see the verify_instance_health
         * command in the Auto Scaling rolling updates sample template:
         * <p>
         * https://github.com/awslabs/aws-cloudformation-templates/blob/master/aws/services/AutoScaling/AutoScalingRollingUpdates.yaml
         * <p>
         * Default: - Do not wait for signals
         * <p>
         * @return {@code this}
         * @param signals Configure waiting for signals during deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signals(final software.amazon.awscdk.services.autoscaling.Signals signals) {
            this.props.signals(signals);
            return this;
        }

        /**
         * The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request.
         * <p>
         * Spot Instances are
         * launched when the price you specify exceeds the current Spot market price.
         * <p>
         * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param spotPrice The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotPrice(final java.lang.String spotPrice) {
            this.props.spotPrice(spotPrice);
            return this;
        }

        /**
         * Add SSM session permissions to the instance role.
         * <p>
         * Setting this to <code>true</code> adds the necessary permissions to connect
         * to the instance using SSM Session Manager. You can do this
         * from the AWS Console.
         * <p>
         * NOTE: Setting this flag to <code>true</code> may not be enough by itself.
         * You must also use an AMI that comes with the SSM Agent, or install
         * the SSM Agent yourself. See
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-agent.html">Working with SSM Agent</a>
         * in the SSM Developer Guide.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param ssmSessionPermissions Add SSM session permissions to the instance role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ssmSessionPermissions(final java.lang.Boolean ssmSessionPermissions) {
            this.props.ssmSessionPermissions(ssmSessionPermissions);
            return this;
        }

        /**
         * A policy or a list of policies that are used to select the instances to terminate.
         * <p>
         * The policies are executed in the order that you list them.
         * <p>
         * Default: - `TerminationPolicy.DEFAULT`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html</a>
         * @param terminationPolicies A policy or a list of policies that are used to select the instances to terminate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationPolicies(final java.util.List<? extends software.amazon.awscdk.services.autoscaling.TerminationPolicy> terminationPolicies) {
            this.props.terminationPolicies(terminationPolicies);
            return this;
        }

        /**
         * A lambda function Arn that can be used as a custom termination policy to select the instances to terminate.
         * <p>
         * This property must be specified if the TerminationPolicy.CUSTOM_LAMBDA_FUNCTION
         * is used.
         * <p>
         * Default: - No lambda function Arn will be supplied
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lambda-custom-termination-policy.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/lambda-custom-termination-policy.html</a>
         * @param terminationPolicyCustomLambdaFunctionArn A lambda function Arn that can be used as a custom termination policy to select the instances to terminate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationPolicyCustomLambdaFunctionArn(final java.lang.String terminationPolicyCustomLambdaFunctionArn) {
            this.props.terminationPolicyCustomLambdaFunctionArn(terminationPolicyCustomLambdaFunctionArn);
            return this;
        }

        /**
         * What to do when an AutoScalingGroup's instance configuration is changed.
         * <p>
         * This is applied when any of the settings on the ASG are changed that
         * affect how the instances should be created (VPC, instance type, startup
         * scripts, etc.). It indicates how the existing instances should be
         * replaced with new instances matching the new config. By default, nothing
         * is done and only new instances are launched with the new config.
         * <p>
         * Default: - `UpdatePolicy.rollingUpdate()` if using `init`, `UpdatePolicy.none()` otherwise
         * <p>
         * @return {@code this}
         * @param updatePolicy What to do when an AutoScalingGroup's instance configuration is changed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updatePolicy(final software.amazon.awscdk.services.autoscaling.UpdatePolicy updatePolicy) {
            this.props.updatePolicy(updatePolicy);
            return this;
        }

        /**
         * Where to place instances within the VPC.
         * <p>
         * Default: - All Private subnets.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place instances within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * VPC to launch these instances in.
         * <p>
         * @return {@code this}
         * @param vpc VPC to launch these instances in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Apply the given CloudFormation Init configuration to the instances in the AutoScalingGroup at startup.
         * <p>
         * If you specify <code>init</code>, you must also specify <code>signals</code> to configure
         * the number of instances to wait for and the timeout for waiting for the
         * init process.
         * <p>
         * Default: - no CloudFormation init
         * <p>
         * @return {@code this}
         * @param init Apply the given CloudFormation Init configuration to the instances in the AutoScalingGroup at startup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder init(final software.amazon.awscdk.services.ec2.CloudFormationInit init) {
            this.props.init(init);
            return this;
        }

        /**
         * Use the given options for applying CloudFormation Init.
         * <p>
         * Describes the configsets to use and the timeout to wait
         * <p>
         * Default: - default options
         * <p>
         * @return {@code this}
         * @param initOptions Use the given options for applying CloudFormation Init. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initOptions(final software.amazon.awscdk.services.autoscaling.ApplyCloudFormationInitOptions initOptions) {
            this.props.initOptions(initOptions);
            return this;
        }

        /**
         * Type of instance to launch.
         * <p>
         * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * <p>
         * Default: - Do not provide any instance type
         * <p>
         * @return {@code this}
         * @param instanceType Type of instance to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * Launch template to use.
         * <p>
         * Launch configuration related settings and MixedInstancesPolicy must not be specified when a
         * launch template is specified.
         * <p>
         * Default: - Do not provide any launch template
         * <p>
         * @return {@code this}
         * @param launchTemplate Launch template to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(final software.amazon.awscdk.services.ec2.ILaunchTemplate launchTemplate) {
            this.props.launchTemplate(launchTemplate);
            return this;
        }

        /**
         * AMI to launch.
         * <p>
         * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * <p>
         * Default: - Do not provide any machine image
         * <p>
         * @return {@code this}
         * @param machineImage AMI to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        /**
         * Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group.
         * <p>
         * It represents the maximum percentage of the group that can be in service and healthy, or pending,
         * to support your workload when replacing instances.
         * <p>
         * Value range is 0 to 100. After it's set, both <code>minHealthyPercentage</code> and <code>maxHealthyPercentage</code> to
         * -1 will clear the previously set value.
         * <p>
         * Both or neither of <code>minHealthyPercentage</code> and <code>maxHealthyPercentage</code> must be specified, and the
         * difference between them cannot be greater than 100. A large range increases the number of
         * instances that can be replaced at the same time.
         * <p>
         * Default: - No instance maintenance policy.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html</a>
         * @param maxHealthyPercentage Specifies the upper threshold as a percentage of the desired capacity of the Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercentage(final java.lang.Number maxHealthyPercentage) {
            this.props.maxHealthyPercentage(maxHealthyPercentage);
            return this;
        }

        /**
         * Whether safety guardrail should be enforced when migrating to the launch template.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param migrateToLaunchTemplate Whether safety guardrail should be enforced when migrating to the launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder migrateToLaunchTemplate(final java.lang.Boolean migrateToLaunchTemplate) {
            this.props.migrateToLaunchTemplate(migrateToLaunchTemplate);
            return this;
        }

        /**
         * Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group.
         * <p>
         * It represents the minimum percentage of the group to keep in service, healthy, and ready to use
         * to support your workload when replacing instances.
         * <p>
         * Value range is 0 to 100. After it's set, both <code>minHealthyPercentage</code> and <code>maxHealthyPercentage</code> to
         * -1 will clear the previously set value.
         * <p>
         * Both or neither of <code>minHealthyPercentage</code> and <code>maxHealthyPercentage</code> must be specified, and the
         * difference between them cannot be greater than 100. A large range increases the number of
         * instances that can be replaced at the same time.
         * <p>
         * Default: - No instance maintenance policy.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html</a>
         * @param minHealthyPercentage Specifies the lower threshold as a percentage of the desired capacity of the Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercentage(final java.lang.Number minHealthyPercentage) {
            this.props.minHealthyPercentage(minHealthyPercentage);
            return this;
        }

        /**
         * Mixed Instances Policy to use.
         * <p>
         * Launch configuration related settings and Launch Template  must not be specified when a
         * MixedInstancesPolicy is specified.
         * <p>
         * Default: - Do not provide any MixedInstancesPolicy
         * <p>
         * @return {@code this}
         * @param mixedInstancesPolicy Mixed Instances Policy to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mixedInstancesPolicy(final software.amazon.awscdk.services.autoscaling.MixedInstancesPolicy mixedInstancesPolicy) {
            this.props.mixedInstancesPolicy(mixedInstancesPolicy);
            return this;
        }

        /**
         * Whether IMDSv2 should be required on launched instances.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param requireImdsv2 Whether IMDSv2 should be required on launched instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireImdsv2(final java.lang.Boolean requireImdsv2) {
            this.props.requireImdsv2(requireImdsv2);
            return this;
        }

        /**
         * An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
         * <p>
         * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
         * <p>
         * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * <p>
         * Default: A role will automatically be created, it can be accessed via the `role` property
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * Role role = Role.Builder.create(this, "MyRole")
         *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
         *         .build();
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param role An IAM role to associate with the instance profile assigned to this Auto Scaling Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Security group to launch the instances in.
         * <p>
         * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * <p>
         * Default: - A SecurityGroup will be created if none is specified.
         * <p>
         * @return {@code this}
         * @param securityGroup Security group to launch the instances in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * Specific UserData to use.
         * <p>
         * The UserData may still be mutated after creation.
         * <p>
         * <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * <p>
         * Default: - A UserData object appropriate for the MachineImage's
         * Operating System is created.
         * <p>
         * @return {@code this}
         * @param userData Specific UserData to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props.userData(userData);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.autoscaling.AutoScalingGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscaling.AutoScalingGroup build() {
            return new software.amazon.awscdk.services.autoscaling.AutoScalingGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
