package software.amazon.awscdk.services.backup;

/**
 * Properties for a BackupPlanRule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * BackupPlan plan;
 * BackupVault secondaryVault;
 * plan.addRule(BackupPlanRule.Builder.create()
 *         .copyActions(List.of(BackupPlanCopyActionProps.builder()
 *                 .destinationBackupVault(secondaryVault)
 *                 .moveToColdStorageAfter(Duration.days(30))
 *                 .deleteAfter(Duration.days(120))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:14.976Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupPlanRuleProps")
@software.amazon.jsii.Jsii.Proxy(BackupPlanRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BackupPlanRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The backup vault where backups are.
     * <p>
     * Default: - use the vault defined at the plan level. If not defined a new
     * common vault for the plan will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault getBackupVault() {
        return null;
    }

    /**
     * The duration after a backup job is successfully started before it must be completed or it is canceled by AWS Backup.
     * <p>
     * Default: - 7 days
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getCompletionWindow() {
        return null;
    }

    /**
     * Copy operations to perform on recovery points created by this rule.
     * <p>
     * Default: - no copy actions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.backup.BackupPlanCopyActionProps> getCopyActions() {
        return null;
    }

    /**
     * Specifies the duration after creation that a recovery point is deleted.
     * <p>
     * Must be greater than <code>moveToColdStorageAfter</code>.
     * <p>
     * Default: - recovery point is never deleted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getDeleteAfter() {
        return null;
    }

    /**
     * Enables continuous backup and point-in-time restores (PITR).
     * <p>
     * Property <code>deleteAfter</code> defines the retention period for the backup. It is mandatory if PITR is enabled.
     * If no value is specified, the retention period is set to 35 days which is the maximum retention period supported by PITR.
     * <p>
     * Property <code>moveToColdStorageAfter</code> must not be specified because PITR does not support this option.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableContinuousBackup() {
        return null;
    }

    /**
     * Specifies the duration after creation that a recovery point is moved to cold storage.
     * <p>
     * Default: - recovery point is never moved to cold storage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMoveToColdStorageAfter() {
        return null;
    }

    /**
     * To help organize your resources, you can assign your own metadata to the resources that you create.
     * <p>
     * Each tag is a key-value pair.
     * <p>
     * Default: - no recovery point tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getRecoveryPointTags() {
        return null;
    }

    /**
     * A display name for the backup rule.
     * <p>
     * Default: - a CDK generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuleName() {
        return null;
    }

    /**
     * A CRON expression specifying when AWS Backup initiates a backup job.
     * <p>
     * Default: - no schedule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.Schedule getScheduleExpression() {
        return null;
    }

    /**
     * The timezone in which the schedule expression is set.
     * <p>
     * Default: - UTC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.TimeZone getScheduleExpressionTimezone() {
        return null;
    }

    /**
     * The duration after a backup is scheduled before a job is canceled if it doesn't start successfully.
     * <p>
     * Default: - 8 hours
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getStartWindow() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BackupPlanRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackupPlanRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BackupPlanRuleProps> {
        software.amazon.awscdk.services.backup.IBackupVault backupVault;
        software.amazon.awscdk.Duration completionWindow;
        java.util.List<software.amazon.awscdk.services.backup.BackupPlanCopyActionProps> copyActions;
        software.amazon.awscdk.Duration deleteAfter;
        java.lang.Boolean enableContinuousBackup;
        software.amazon.awscdk.Duration moveToColdStorageAfter;
        java.util.Map<java.lang.String, java.lang.String> recoveryPointTags;
        java.lang.String ruleName;
        software.amazon.awscdk.services.events.Schedule scheduleExpression;
        software.amazon.awscdk.TimeZone scheduleExpressionTimezone;
        software.amazon.awscdk.Duration startWindow;

        /**
         * Sets the value of {@link BackupPlanRuleProps#getBackupVault}
         * @param backupVault The backup vault where backups are.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVault(software.amazon.awscdk.services.backup.IBackupVault backupVault) {
            this.backupVault = backupVault;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getCompletionWindow}
         * @param completionWindow The duration after a backup job is successfully started before it must be completed or it is canceled by AWS Backup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder completionWindow(software.amazon.awscdk.Duration completionWindow) {
            this.completionWindow = completionWindow;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getCopyActions}
         * @param copyActions Copy operations to perform on recovery points created by this rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder copyActions(java.util.List<? extends software.amazon.awscdk.services.backup.BackupPlanCopyActionProps> copyActions) {
            this.copyActions = (java.util.List<software.amazon.awscdk.services.backup.BackupPlanCopyActionProps>)copyActions;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getDeleteAfter}
         * @param deleteAfter Specifies the duration after creation that a recovery point is deleted.
         *                    Must be greater than <code>moveToColdStorageAfter</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAfter(software.amazon.awscdk.Duration deleteAfter) {
            this.deleteAfter = deleteAfter;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getEnableContinuousBackup}
         * @param enableContinuousBackup Enables continuous backup and point-in-time restores (PITR).
         *                               Property <code>deleteAfter</code> defines the retention period for the backup. It is mandatory if PITR is enabled.
         *                               If no value is specified, the retention period is set to 35 days which is the maximum retention period supported by PITR.
         *                               <p>
         *                               Property <code>moveToColdStorageAfter</code> must not be specified because PITR does not support this option.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableContinuousBackup(java.lang.Boolean enableContinuousBackup) {
            this.enableContinuousBackup = enableContinuousBackup;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getMoveToColdStorageAfter}
         * @param moveToColdStorageAfter Specifies the duration after creation that a recovery point is moved to cold storage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder moveToColdStorageAfter(software.amazon.awscdk.Duration moveToColdStorageAfter) {
            this.moveToColdStorageAfter = moveToColdStorageAfter;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getRecoveryPointTags}
         * @param recoveryPointTags To help organize your resources, you can assign your own metadata to the resources that you create.
         *                          Each tag is a key-value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryPointTags(java.util.Map<java.lang.String, java.lang.String> recoveryPointTags) {
            this.recoveryPointTags = recoveryPointTags;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getRuleName}
         * @param ruleName A display name for the backup rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getScheduleExpression}
         * @param scheduleExpression A CRON expression specifying when AWS Backup initiates a backup job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpression(software.amazon.awscdk.services.events.Schedule scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getScheduleExpressionTimezone}
         * @param scheduleExpressionTimezone The timezone in which the schedule expression is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpressionTimezone(software.amazon.awscdk.TimeZone scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanRuleProps#getStartWindow}
         * @param startWindow The duration after a backup is scheduled before a job is canceled if it doesn't start successfully.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startWindow(software.amazon.awscdk.Duration startWindow) {
            this.startWindow = startWindow;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackupPlanRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BackupPlanRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BackupPlanRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupPlanRuleProps {
        private final software.amazon.awscdk.services.backup.IBackupVault backupVault;
        private final software.amazon.awscdk.Duration completionWindow;
        private final java.util.List<software.amazon.awscdk.services.backup.BackupPlanCopyActionProps> copyActions;
        private final software.amazon.awscdk.Duration deleteAfter;
        private final java.lang.Boolean enableContinuousBackup;
        private final software.amazon.awscdk.Duration moveToColdStorageAfter;
        private final java.util.Map<java.lang.String, java.lang.String> recoveryPointTags;
        private final java.lang.String ruleName;
        private final software.amazon.awscdk.services.events.Schedule scheduleExpression;
        private final software.amazon.awscdk.TimeZone scheduleExpressionTimezone;
        private final software.amazon.awscdk.Duration startWindow;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backupVault = software.amazon.jsii.Kernel.get(this, "backupVault", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.IBackupVault.class));
            this.completionWindow = software.amazon.jsii.Kernel.get(this, "completionWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.copyActions = software.amazon.jsii.Kernel.get(this, "copyActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlanCopyActionProps.class)));
            this.deleteAfter = software.amazon.jsii.Kernel.get(this, "deleteAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.enableContinuousBackup = software.amazon.jsii.Kernel.get(this, "enableContinuousBackup", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.moveToColdStorageAfter = software.amazon.jsii.Kernel.get(this, "moveToColdStorageAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.recoveryPointTags = software.amazon.jsii.Kernel.get(this, "recoveryPointTags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Schedule.class));
            this.scheduleExpressionTimezone = software.amazon.jsii.Kernel.get(this, "scheduleExpressionTimezone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
            this.startWindow = software.amazon.jsii.Kernel.get(this, "startWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backupVault = builder.backupVault;
            this.completionWindow = builder.completionWindow;
            this.copyActions = (java.util.List<software.amazon.awscdk.services.backup.BackupPlanCopyActionProps>)builder.copyActions;
            this.deleteAfter = builder.deleteAfter;
            this.enableContinuousBackup = builder.enableContinuousBackup;
            this.moveToColdStorageAfter = builder.moveToColdStorageAfter;
            this.recoveryPointTags = builder.recoveryPointTags;
            this.ruleName = builder.ruleName;
            this.scheduleExpression = builder.scheduleExpression;
            this.scheduleExpressionTimezone = builder.scheduleExpressionTimezone;
            this.startWindow = builder.startWindow;
        }

        @Override
        public final software.amazon.awscdk.services.backup.IBackupVault getBackupVault() {
            return this.backupVault;
        }

        @Override
        public final software.amazon.awscdk.Duration getCompletionWindow() {
            return this.completionWindow;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.backup.BackupPlanCopyActionProps> getCopyActions() {
            return this.copyActions;
        }

        @Override
        public final software.amazon.awscdk.Duration getDeleteAfter() {
            return this.deleteAfter;
        }

        @Override
        public final java.lang.Boolean getEnableContinuousBackup() {
            return this.enableContinuousBackup;
        }

        @Override
        public final software.amazon.awscdk.Duration getMoveToColdStorageAfter() {
            return this.moveToColdStorageAfter;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRecoveryPointTags() {
            return this.recoveryPointTags;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final software.amazon.awscdk.services.events.Schedule getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final software.amazon.awscdk.TimeZone getScheduleExpressionTimezone() {
            return this.scheduleExpressionTimezone;
        }

        @Override
        public final software.amazon.awscdk.Duration getStartWindow() {
            return this.startWindow;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBackupVault() != null) {
                data.set("backupVault", om.valueToTree(this.getBackupVault()));
            }
            if (this.getCompletionWindow() != null) {
                data.set("completionWindow", om.valueToTree(this.getCompletionWindow()));
            }
            if (this.getCopyActions() != null) {
                data.set("copyActions", om.valueToTree(this.getCopyActions()));
            }
            if (this.getDeleteAfter() != null) {
                data.set("deleteAfter", om.valueToTree(this.getDeleteAfter()));
            }
            if (this.getEnableContinuousBackup() != null) {
                data.set("enableContinuousBackup", om.valueToTree(this.getEnableContinuousBackup()));
            }
            if (this.getMoveToColdStorageAfter() != null) {
                data.set("moveToColdStorageAfter", om.valueToTree(this.getMoveToColdStorageAfter()));
            }
            if (this.getRecoveryPointTags() != null) {
                data.set("recoveryPointTags", om.valueToTree(this.getRecoveryPointTags()));
            }
            if (this.getRuleName() != null) {
                data.set("ruleName", om.valueToTree(this.getRuleName()));
            }
            if (this.getScheduleExpression() != null) {
                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
            }
            if (this.getScheduleExpressionTimezone() != null) {
                data.set("scheduleExpressionTimezone", om.valueToTree(this.getScheduleExpressionTimezone()));
            }
            if (this.getStartWindow() != null) {
                data.set("startWindow", om.valueToTree(this.getStartWindow()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.BackupPlanRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackupPlanRuleProps.Jsii$Proxy that = (BackupPlanRuleProps.Jsii$Proxy) o;

            if (this.backupVault != null ? !this.backupVault.equals(that.backupVault) : that.backupVault != null) return false;
            if (this.completionWindow != null ? !this.completionWindow.equals(that.completionWindow) : that.completionWindow != null) return false;
            if (this.copyActions != null ? !this.copyActions.equals(that.copyActions) : that.copyActions != null) return false;
            if (this.deleteAfter != null ? !this.deleteAfter.equals(that.deleteAfter) : that.deleteAfter != null) return false;
            if (this.enableContinuousBackup != null ? !this.enableContinuousBackup.equals(that.enableContinuousBackup) : that.enableContinuousBackup != null) return false;
            if (this.moveToColdStorageAfter != null ? !this.moveToColdStorageAfter.equals(that.moveToColdStorageAfter) : that.moveToColdStorageAfter != null) return false;
            if (this.recoveryPointTags != null ? !this.recoveryPointTags.equals(that.recoveryPointTags) : that.recoveryPointTags != null) return false;
            if (this.ruleName != null ? !this.ruleName.equals(that.ruleName) : that.ruleName != null) return false;
            if (this.scheduleExpression != null ? !this.scheduleExpression.equals(that.scheduleExpression) : that.scheduleExpression != null) return false;
            if (this.scheduleExpressionTimezone != null ? !this.scheduleExpressionTimezone.equals(that.scheduleExpressionTimezone) : that.scheduleExpressionTimezone != null) return false;
            return this.startWindow != null ? this.startWindow.equals(that.startWindow) : that.startWindow == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backupVault != null ? this.backupVault.hashCode() : 0;
            result = 31 * result + (this.completionWindow != null ? this.completionWindow.hashCode() : 0);
            result = 31 * result + (this.copyActions != null ? this.copyActions.hashCode() : 0);
            result = 31 * result + (this.deleteAfter != null ? this.deleteAfter.hashCode() : 0);
            result = 31 * result + (this.enableContinuousBackup != null ? this.enableContinuousBackup.hashCode() : 0);
            result = 31 * result + (this.moveToColdStorageAfter != null ? this.moveToColdStorageAfter.hashCode() : 0);
            result = 31 * result + (this.recoveryPointTags != null ? this.recoveryPointTags.hashCode() : 0);
            result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
            result = 31 * result + (this.scheduleExpression != null ? this.scheduleExpression.hashCode() : 0);
            result = 31 * result + (this.scheduleExpressionTimezone != null ? this.scheduleExpressionTimezone.hashCode() : 0);
            result = 31 * result + (this.startWindow != null ? this.startWindow.hashCode() : 0);
            return result;
        }
    }
}
