package software.amazon.awscdk.services.backup;

/**
 * Options for a BackupSelection.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * BackupPlan plan;
 * Vpc vpc;
 * ITable myTable = Table.fromTableName(this, "Table", "myTableName");
 * DatabaseInstance myDatabaseInstance = DatabaseInstance.Builder.create(this, "DatabaseInstance")
 *         .engine(DatabaseInstanceEngine.mysql(MySqlInstanceEngineProps.builder().version(MysqlEngineVersion.VER_8_0_26).build()))
 *         .vpc(vpc)
 *         .build();
 * DatabaseCluster myDatabaseCluster = DatabaseCluster.Builder.create(this, "DatabaseCluster")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder().version(AuroraMysqlEngineVersion.VER_2_08_1).build()))
 *         .credentials(Credentials.fromGeneratedSecret("clusteradmin"))
 *         .instanceProps(InstanceProps.builder()
 *                 .vpc(vpc)
 *                 .build())
 *         .build();
 * ServerlessCluster myServerlessCluster = ServerlessCluster.Builder.create(this, "ServerlessCluster")
 *         .engine(DatabaseClusterEngine.AURORA_POSTGRESQL)
 *         .parameterGroup(ParameterGroup.fromParameterGroupName(this, "ParameterGroup", "default.aurora-postgresql11"))
 *         .vpc(vpc)
 *         .build();
 * Construct myCoolConstruct = new Construct(this, "MyCoolConstruct");
 * plan.addSelection("Selection", BackupSelectionOptions.builder()
 *         .resources(List.of(BackupResource.fromDynamoDbTable(myTable), BackupResource.fromRdsDatabaseInstance(myDatabaseInstance), BackupResource.fromRdsDatabaseCluster(myDatabaseCluster), BackupResource.fromRdsServerlessCluster(myServerlessCluster), BackupResource.fromTag("stage", "prod"), BackupResource.fromConstruct(myCoolConstruct)))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:14.979Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupSelectionOptions")
@software.amazon.jsii.Jsii.Proxy(BackupSelectionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BackupSelectionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The resources to backup.
     * <p>
     * Use the helper static methods defined on <code>BackupResource</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.backup.BackupResource> getResources();

    /**
     * Whether to automatically give restores permissions to the role that AWS Backup uses.
     * <p>
     * If <code>true</code>, the <code>AWSBackupServiceRolePolicyForRestores</code> managed
     * policy will be attached to the role.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowRestores() {
        return null;
    }

    /**
     * The name for this selection.
     * <p>
     * Default: - a CDK generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBackupSelectionName() {
        return null;
    }

    /**
     * Whether to disable automatically assigning default backup permissions to the role that AWS Backup uses.
     * <p>
     * If <code>false</code>, the <code>AWSBackupServiceRolePolicyForBackup</code> managed policy will be
     * attached to the role.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableDefaultBackupPolicy() {
        return null;
    }

    /**
     * The role that AWS Backup uses to authenticate when backuping or restoring the resources.
     * <p>
     * The <code>AWSBackupServiceRolePolicyForBackup</code> managed policy
     * will be attached to this role unless <code>disableDefaultBackupPolicy</code>
     * is set to <code>true</code>.
     * <p>
     * Default: - a new role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BackupSelectionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackupSelectionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BackupSelectionOptions> {
        java.util.List<software.amazon.awscdk.services.backup.BackupResource> resources;
        java.lang.Boolean allowRestores;
        java.lang.String backupSelectionName;
        java.lang.Boolean disableDefaultBackupPolicy;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link BackupSelectionOptions#getResources}
         * @param resources The resources to backup. This parameter is required.
         *                  Use the helper static methods defined on <code>BackupResource</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resources(java.util.List<? extends software.amazon.awscdk.services.backup.BackupResource> resources) {
            this.resources = (java.util.List<software.amazon.awscdk.services.backup.BackupResource>)resources;
            return this;
        }

        /**
         * Sets the value of {@link BackupSelectionOptions#getAllowRestores}
         * @param allowRestores Whether to automatically give restores permissions to the role that AWS Backup uses.
         *                      If <code>true</code>, the <code>AWSBackupServiceRolePolicyForRestores</code> managed
         *                      policy will be attached to the role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowRestores(java.lang.Boolean allowRestores) {
            this.allowRestores = allowRestores;
            return this;
        }

        /**
         * Sets the value of {@link BackupSelectionOptions#getBackupSelectionName}
         * @param backupSelectionName The name for this selection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupSelectionName(java.lang.String backupSelectionName) {
            this.backupSelectionName = backupSelectionName;
            return this;
        }

        /**
         * Sets the value of {@link BackupSelectionOptions#getDisableDefaultBackupPolicy}
         * @param disableDefaultBackupPolicy Whether to disable automatically assigning default backup permissions to the role that AWS Backup uses.
         *                                   If <code>false</code>, the <code>AWSBackupServiceRolePolicyForBackup</code> managed policy will be
         *                                   attached to the role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableDefaultBackupPolicy(java.lang.Boolean disableDefaultBackupPolicy) {
            this.disableDefaultBackupPolicy = disableDefaultBackupPolicy;
            return this;
        }

        /**
         * Sets the value of {@link BackupSelectionOptions#getRole}
         * @param role The role that AWS Backup uses to authenticate when backuping or restoring the resources.
         *             The <code>AWSBackupServiceRolePolicyForBackup</code> managed policy
         *             will be attached to this role unless <code>disableDefaultBackupPolicy</code>
         *             is set to <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackupSelectionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BackupSelectionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BackupSelectionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupSelectionOptions {
        private final java.util.List<software.amazon.awscdk.services.backup.BackupResource> resources;
        private final java.lang.Boolean allowRestores;
        private final java.lang.String backupSelectionName;
        private final java.lang.Boolean disableDefaultBackupPolicy;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class)));
            this.allowRestores = software.amazon.jsii.Kernel.get(this, "allowRestores", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.backupSelectionName = software.amazon.jsii.Kernel.get(this, "backupSelectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableDefaultBackupPolicy = software.amazon.jsii.Kernel.get(this, "disableDefaultBackupPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resources = (java.util.List<software.amazon.awscdk.services.backup.BackupResource>)java.util.Objects.requireNonNull(builder.resources, "resources is required");
            this.allowRestores = builder.allowRestores;
            this.backupSelectionName = builder.backupSelectionName;
            this.disableDefaultBackupPolicy = builder.disableDefaultBackupPolicy;
            this.role = builder.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.backup.BackupResource> getResources() {
            return this.resources;
        }

        @Override
        public final java.lang.Boolean getAllowRestores() {
            return this.allowRestores;
        }

        @Override
        public final java.lang.String getBackupSelectionName() {
            return this.backupSelectionName;
        }

        @Override
        public final java.lang.Boolean getDisableDefaultBackupPolicy() {
            return this.disableDefaultBackupPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resources", om.valueToTree(this.getResources()));
            if (this.getAllowRestores() != null) {
                data.set("allowRestores", om.valueToTree(this.getAllowRestores()));
            }
            if (this.getBackupSelectionName() != null) {
                data.set("backupSelectionName", om.valueToTree(this.getBackupSelectionName()));
            }
            if (this.getDisableDefaultBackupPolicy() != null) {
                data.set("disableDefaultBackupPolicy", om.valueToTree(this.getDisableDefaultBackupPolicy()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.BackupSelectionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackupSelectionOptions.Jsii$Proxy that = (BackupSelectionOptions.Jsii$Proxy) o;

            if (!resources.equals(that.resources)) return false;
            if (this.allowRestores != null ? !this.allowRestores.equals(that.allowRestores) : that.allowRestores != null) return false;
            if (this.backupSelectionName != null ? !this.backupSelectionName.equals(that.backupSelectionName) : that.backupSelectionName != null) return false;
            if (this.disableDefaultBackupPolicy != null ? !this.disableDefaultBackupPolicy.equals(that.disableDefaultBackupPolicy) : that.disableDefaultBackupPolicy != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resources.hashCode();
            result = 31 * result + (this.allowRestores != null ? this.allowRestores.hashCode() : 0);
            result = 31 * result + (this.backupSelectionName != null ? this.backupSelectionName.hashCode() : 0);
            result = 31 * result + (this.disableDefaultBackupPolicy != null ? this.disableDefaultBackupPolicy.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
