package software.amazon.awscdk.services.bedrockagentcore;

/**
 * Properties for defining a <code>CfnGateway</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrockagentcore.*;
 * CfnGatewayProps cfnGatewayProps = CfnGatewayProps.builder()
 *         .authorizerType("authorizerType")
 *         .name("name")
 *         .protocolType("protocolType")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .authorizerConfiguration(AuthorizerConfigurationProperty.builder()
 *                 .customJwtAuthorizer(CustomJWTAuthorizerConfigurationProperty.builder()
 *                         .discoveryUrl("discoveryUrl")
 *                         // the properties below are optional
 *                         .allowedAudience(List.of("allowedAudience"))
 *                         .allowedClients(List.of("allowedClients"))
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .exceptionLevel("exceptionLevel")
 *         .kmsKeyArn("kmsKeyArn")
 *         .protocolConfiguration(GatewayProtocolConfigurationProperty.builder()
 *                 .mcp(MCPGatewayConfigurationProperty.builder()
 *                         .instructions("instructions")
 *                         .searchType("searchType")
 *                         .supportedVersions(List.of("supportedVersions"))
 *                         .build())
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:15.637Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayProps")
@software.amazon.jsii.Jsii.Proxy(CfnGatewayProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGatewayProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The authorizer type for the gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-authorizertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-authorizertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerType();

    /**
     * The name for the gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The protocol type for the gateway target.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-protocoltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-protocoltype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProtocolType();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGateway.AuthorizerConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-authorizerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-authorizerconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizerConfiguration() {
        return null;
    }

    /**
     * The description for the gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The exception level for the gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-exceptionlevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-exceptionlevel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExceptionLevel() {
        return null;
    }

    /**
     * The KMS key ARN for the gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-kmskeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * The protocol configuration for the gateway target.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGateway.GatewayProtocolConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-protocolconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-protocolconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProtocolConfiguration() {
        return null;
    }

    /**
     * The tags for the gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gateway.html#cfn-bedrockagentcore-gateway-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGatewayProps> {
        java.lang.String authorizerType;
        java.lang.String name;
        java.lang.String protocolType;
        java.lang.String roleArn;
        java.lang.Object authorizerConfiguration;
        java.lang.String description;
        java.lang.String exceptionLevel;
        java.lang.String kmsKeyArn;
        java.lang.Object protocolConfiguration;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnGatewayProps#getAuthorizerType}
         * @param authorizerType The authorizer type for the gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerType(java.lang.String authorizerType) {
            this.authorizerType = authorizerType;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getName}
         * @param name The name for the gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getProtocolType}
         * @param protocolType The protocol type for the gateway target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolType(java.lang.String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getRoleArn}
         * @param roleArn the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getAuthorizerConfiguration}
         * @param authorizerConfiguration the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfiguration(software.amazon.awscdk.IResolvable authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getAuthorizerConfiguration}
         * @param authorizerConfiguration the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfiguration(software.amazon.awscdk.services.bedrockagentcore.CfnGateway.AuthorizerConfigurationProperty authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getDescription}
         * @param description The description for the gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getExceptionLevel}
         * @param exceptionLevel The exception level for the gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exceptionLevel(java.lang.String exceptionLevel) {
            this.exceptionLevel = exceptionLevel;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getKmsKeyArn}
         * @param kmsKeyArn The KMS key ARN for the gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getProtocolConfiguration}
         * @param protocolConfiguration The protocol configuration for the gateway target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolConfiguration(software.amazon.awscdk.IResolvable protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getProtocolConfiguration}
         * @param protocolConfiguration The protocol configuration for the gateway target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolConfiguration(software.amazon.awscdk.services.bedrockagentcore.CfnGateway.GatewayProtocolConfigurationProperty protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getTags}
         * @param tags The tags for the gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGatewayProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGatewayProps {
        private final java.lang.String authorizerType;
        private final java.lang.String name;
        private final java.lang.String protocolType;
        private final java.lang.String roleArn;
        private final java.lang.Object authorizerConfiguration;
        private final java.lang.String description;
        private final java.lang.String exceptionLevel;
        private final java.lang.String kmsKeyArn;
        private final java.lang.Object protocolConfiguration;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizerType = software.amazon.jsii.Kernel.get(this, "authorizerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocolType = software.amazon.jsii.Kernel.get(this, "protocolType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerConfiguration = software.amazon.jsii.Kernel.get(this, "authorizerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.exceptionLevel = software.amazon.jsii.Kernel.get(this, "exceptionLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocolConfiguration = software.amazon.jsii.Kernel.get(this, "protocolConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizerType = java.util.Objects.requireNonNull(builder.authorizerType, "authorizerType is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.protocolType = java.util.Objects.requireNonNull(builder.protocolType, "protocolType is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.authorizerConfiguration = builder.authorizerConfiguration;
            this.description = builder.description;
            this.exceptionLevel = builder.exceptionLevel;
            this.kmsKeyArn = builder.kmsKeyArn;
            this.protocolConfiguration = builder.protocolConfiguration;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getAuthorizerType() {
            return this.authorizerType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getProtocolType() {
            return this.protocolType;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getAuthorizerConfiguration() {
            return this.authorizerConfiguration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExceptionLevel() {
            return this.exceptionLevel;
        }

        @Override
        public final java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final java.lang.Object getProtocolConfiguration() {
            return this.protocolConfiguration;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authorizerType", om.valueToTree(this.getAuthorizerType()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("protocolType", om.valueToTree(this.getProtocolType()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getAuthorizerConfiguration() != null) {
                data.set("authorizerConfiguration", om.valueToTree(this.getAuthorizerConfiguration()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExceptionLevel() != null) {
                data.set("exceptionLevel", om.valueToTree(this.getExceptionLevel()));
            }
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getProtocolConfiguration() != null) {
                data.set("protocolConfiguration", om.valueToTree(this.getProtocolConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGatewayProps.Jsii$Proxy that = (CfnGatewayProps.Jsii$Proxy) o;

            if (!authorizerType.equals(that.authorizerType)) return false;
            if (!name.equals(that.name)) return false;
            if (!protocolType.equals(that.protocolType)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.authorizerConfiguration != null ? !this.authorizerConfiguration.equals(that.authorizerConfiguration) : that.authorizerConfiguration != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.exceptionLevel != null ? !this.exceptionLevel.equals(that.exceptionLevel) : that.exceptionLevel != null) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            if (this.protocolConfiguration != null ? !this.protocolConfiguration.equals(that.protocolConfiguration) : that.protocolConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizerType.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.protocolType.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.authorizerConfiguration != null ? this.authorizerConfiguration.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.exceptionLevel != null ? this.exceptionLevel.hashCode() : 0);
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.protocolConfiguration != null ? this.protocolConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
