package software.amazon.awscdk.services.bedrockagentcore;

/**
 * After creating a gateway, you can add targets, which define the tools that your gateway will host.
 * <p>
 * For more information about adding gateway targets, see <a href="https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/gateway-building-adding-targets.html">Add targets to an existing gateway</a> .
 * <p>
 * See the <em>Properties</em> section below for descriptions of both the required and optional properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrockagentcore.*;
 * SchemaDefinitionProperty schemaDefinitionProperty_;
 * CfnGatewayTarget cfnGatewayTarget = CfnGatewayTarget.Builder.create(this, "MyCfnGatewayTarget")
 *         .credentialProviderConfigurations(List.of(CredentialProviderConfigurationProperty.builder()
 *                 .credentialProviderType("credentialProviderType")
 *                 // the properties below are optional
 *                 .credentialProvider(CredentialProviderProperty.builder()
 *                         .apiKeyCredentialProvider(ApiKeyCredentialProviderProperty.builder()
 *                                 .providerArn("providerArn")
 *                                 // the properties below are optional
 *                                 .credentialLocation("credentialLocation")
 *                                 .credentialParameterName("credentialParameterName")
 *                                 .credentialPrefix("credentialPrefix")
 *                                 .build())
 *                         .oauthCredentialProvider(OAuthCredentialProviderProperty.builder()
 *                                 .providerArn("providerArn")
 *                                 .scopes(List.of("scopes"))
 *                                 // the properties below are optional
 *                                 .customParameters(Map.of(
 *                                         "customParametersKey", "customParameters"))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .name("name")
 *         .targetConfiguration(TargetConfigurationProperty.builder()
 *                 .mcp(McpTargetConfigurationProperty.builder()
 *                         .lambda(McpLambdaTargetConfigurationProperty.builder()
 *                                 .lambdaArn("lambdaArn")
 *                                 .toolSchema(ToolSchemaProperty.builder()
 *                                         .inlinePayload(List.of(ToolDefinitionProperty.builder()
 *                                                 .description("description")
 *                                                 .inputSchema(SchemaDefinitionProperty.builder()
 *                                                         .type("type")
 *                                                         // the properties below are optional
 *                                                         .description("description")
 *                                                         .items(schemaDefinitionProperty_)
 *                                                         .properties(Map.of(
 *                                                                 "propertiesKey", schemaDefinitionProperty_))
 *                                                         .required(List.of("required"))
 *                                                         .build())
 *                                                 .name("name")
 *                                                 // the properties below are optional
 *                                                 .outputSchema(SchemaDefinitionProperty.builder()
 *                                                         .type("type")
 *                                                         // the properties below are optional
 *                                                         .description("description")
 *                                                         .items(schemaDefinitionProperty_)
 *                                                         .properties(Map.of(
 *                                                                 "propertiesKey", schemaDefinitionProperty_))
 *                                                         .required(List.of("required"))
 *                                                         .build())
 *                                                 .build()))
 *                                         .s3(S3ConfigurationProperty.builder()
 *                                                 .bucketOwnerAccountId("bucketOwnerAccountId")
 *                                                 .uri("uri")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .mcpServer(McpServerTargetConfigurationProperty.builder()
 *                                 .endpoint("endpoint")
 *                                 .build())
 *                         .openApiSchema(ApiSchemaConfigurationProperty.builder()
 *                                 .inlinePayload("inlinePayload")
 *                                 .s3(S3ConfigurationProperty.builder()
 *                                         .bucketOwnerAccountId("bucketOwnerAccountId")
 *                                         .uri("uri")
 *                                         .build())
 *                                 .build())
 *                         .smithyModel(ApiSchemaConfigurationProperty.builder()
 *                                 .inlinePayload("inlinePayload")
 *                                 .s3(S3ConfigurationProperty.builder()
 *                                         .bucketOwnerAccountId("bucketOwnerAccountId")
 *                                         .uri("uri")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .gatewayIdentifier("gatewayIdentifier")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:15.639Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget")
public class CfnGatewayTarget extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.bedrockagentcore.IGatewayTargetRef {

    protected CfnGatewayTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGatewayTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::BedrockAgentCore::GatewayTarget</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGatewayTarget(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTargetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Checks whether the given object is a CfnGatewayTarget.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnGatewayTarget(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.class, "isCfnGatewayTarget", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The date and time at which the gateway target was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGatewayArn() {
        return software.amazon.jsii.Kernel.get(this, "attrGatewayArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastSynchronizedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrLastSynchronizedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status for the gateway target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status reasons for the gateway target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrStatusReasons() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrStatusReasons", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The target ID for the gateway target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTargetId() {
        return software.amazon.jsii.Kernel.get(this, "attrTargetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time at which the resource was updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a GatewayTarget resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.bedrockagentcore.GatewayTargetReference getGatewayTargetRef() {
        return software.amazon.jsii.Kernel.get(this, "gatewayTargetRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.bedrockagentcore.GatewayTargetReference.class));
    }

    /**
     * The OAuth credential provider configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.CredentialProviderConfigurationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCredentialProviderConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "credentialProviderConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The OAuth credential provider configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCredentialProviderConfigurations(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "credentialProviderConfigurations", java.util.Objects.requireNonNull(value, "credentialProviderConfigurations is required"));
    }

    /**
     * The OAuth credential provider configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCredentialProviderConfigurations(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.CredentialProviderConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.CredentialProviderConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "credentialProviderConfigurations", java.util.Objects.requireNonNull(value, "credentialProviderConfigurations is required"));
    }

    /**
     * The name for the gateway target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the gateway target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The target configuration for the Smithy model target.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.TargetConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTargetConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "targetConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The target configuration for the Smithy model target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetConfiguration", java.util.Objects.requireNonNull(value, "targetConfiguration is required"));
    }

    /**
     * The target configuration for the Smithy model target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.TargetConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetConfiguration", java.util.Objects.requireNonNull(value, "targetConfiguration is required"));
    }

    /**
     * The description for the gateway target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description for the gateway target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The gateway ID for the gateway target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGatewayIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "gatewayIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The gateway ID for the gateway target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatewayIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "gatewayIdentifier", value);
    }
    /**
     * The API key credential provider for the gateway target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * ApiKeyCredentialProviderProperty apiKeyCredentialProviderProperty = ApiKeyCredentialProviderProperty.builder()
     *         .providerArn("providerArn")
     *         // the properties below are optional
     *         .credentialLocation("credentialLocation")
     *         .credentialParameterName("credentialParameterName")
     *         .credentialPrefix("credentialPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apikeycredentialprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apikeycredentialprovider.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.ApiKeyCredentialProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(ApiKeyCredentialProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApiKeyCredentialProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The provider ARN for the gateway target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apikeycredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-apikeycredentialprovider-providerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apikeycredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-apikeycredentialprovider-providerarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProviderArn();

        /**
         * The credential location for the gateway target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apikeycredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-apikeycredentialprovider-credentiallocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apikeycredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-apikeycredentialprovider-credentiallocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCredentialLocation() {
            return null;
        }

        /**
         * The credential parameter name for the provider for the gateway target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apikeycredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-apikeycredentialprovider-credentialparametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apikeycredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-apikeycredentialprovider-credentialparametername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCredentialParameterName() {
            return null;
        }

        /**
         * The API key credential provider for the gateway target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apikeycredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-apikeycredentialprovider-credentialprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apikeycredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-apikeycredentialprovider-credentialprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCredentialPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApiKeyCredentialProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiKeyCredentialProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApiKeyCredentialProviderProperty> {
            java.lang.String providerArn;
            java.lang.String credentialLocation;
            java.lang.String credentialParameterName;
            java.lang.String credentialPrefix;

            /**
             * Sets the value of {@link ApiKeyCredentialProviderProperty#getProviderArn}
             * @param providerArn The provider ARN for the gateway target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerArn(java.lang.String providerArn) {
                this.providerArn = providerArn;
                return this;
            }

            /**
             * Sets the value of {@link ApiKeyCredentialProviderProperty#getCredentialLocation}
             * @param credentialLocation The credential location for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialLocation(java.lang.String credentialLocation) {
                this.credentialLocation = credentialLocation;
                return this;
            }

            /**
             * Sets the value of {@link ApiKeyCredentialProviderProperty#getCredentialParameterName}
             * @param credentialParameterName The credential parameter name for the provider for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialParameterName(java.lang.String credentialParameterName) {
                this.credentialParameterName = credentialParameterName;
                return this;
            }

            /**
             * Sets the value of {@link ApiKeyCredentialProviderProperty#getCredentialPrefix}
             * @param credentialPrefix The API key credential provider for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialPrefix(java.lang.String credentialPrefix) {
                this.credentialPrefix = credentialPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiKeyCredentialProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApiKeyCredentialProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApiKeyCredentialProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiKeyCredentialProviderProperty {
            private final java.lang.String providerArn;
            private final java.lang.String credentialLocation;
            private final java.lang.String credentialParameterName;
            private final java.lang.String credentialPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.providerArn = software.amazon.jsii.Kernel.get(this, "providerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialLocation = software.amazon.jsii.Kernel.get(this, "credentialLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialParameterName = software.amazon.jsii.Kernel.get(this, "credentialParameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialPrefix = software.amazon.jsii.Kernel.get(this, "credentialPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.providerArn = java.util.Objects.requireNonNull(builder.providerArn, "providerArn is required");
                this.credentialLocation = builder.credentialLocation;
                this.credentialParameterName = builder.credentialParameterName;
                this.credentialPrefix = builder.credentialPrefix;
            }

            @Override
            public final java.lang.String getProviderArn() {
                return this.providerArn;
            }

            @Override
            public final java.lang.String getCredentialLocation() {
                return this.credentialLocation;
            }

            @Override
            public final java.lang.String getCredentialParameterName() {
                return this.credentialParameterName;
            }

            @Override
            public final java.lang.String getCredentialPrefix() {
                return this.credentialPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("providerArn", om.valueToTree(this.getProviderArn()));
                if (this.getCredentialLocation() != null) {
                    data.set("credentialLocation", om.valueToTree(this.getCredentialLocation()));
                }
                if (this.getCredentialParameterName() != null) {
                    data.set("credentialParameterName", om.valueToTree(this.getCredentialParameterName()));
                }
                if (this.getCredentialPrefix() != null) {
                    data.set("credentialPrefix", om.valueToTree(this.getCredentialPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.ApiKeyCredentialProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiKeyCredentialProviderProperty.Jsii$Proxy that = (ApiKeyCredentialProviderProperty.Jsii$Proxy) o;

                if (!providerArn.equals(that.providerArn)) return false;
                if (this.credentialLocation != null ? !this.credentialLocation.equals(that.credentialLocation) : that.credentialLocation != null) return false;
                if (this.credentialParameterName != null ? !this.credentialParameterName.equals(that.credentialParameterName) : that.credentialParameterName != null) return false;
                return this.credentialPrefix != null ? this.credentialPrefix.equals(that.credentialPrefix) : that.credentialPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.providerArn.hashCode();
                result = 31 * result + (this.credentialLocation != null ? this.credentialLocation.hashCode() : 0);
                result = 31 * result + (this.credentialParameterName != null ? this.credentialParameterName.hashCode() : 0);
                result = 31 * result + (this.credentialPrefix != null ? this.credentialPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The API schema configuration for the gateway target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * ApiSchemaConfigurationProperty apiSchemaConfigurationProperty = ApiSchemaConfigurationProperty.builder()
     *         .inlinePayload("inlinePayload")
     *         .s3(S3ConfigurationProperty.builder()
     *                 .bucketOwnerAccountId("bucketOwnerAccountId")
     *                 .uri("uri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apischemaconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apischemaconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.ApiSchemaConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ApiSchemaConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApiSchemaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The inline payload for the gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apischemaconfiguration.html#cfn-bedrockagentcore-gatewaytarget-apischemaconfiguration-inlinepayload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apischemaconfiguration.html#cfn-bedrockagentcore-gatewaytarget-apischemaconfiguration-inlinepayload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInlinePayload() {
            return null;
        }

        /**
         * The API schema configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.S3ConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apischemaconfiguration.html#cfn-bedrockagentcore-gatewaytarget-apischemaconfiguration-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-apischemaconfiguration.html#cfn-bedrockagentcore-gatewaytarget-apischemaconfiguration-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApiSchemaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiSchemaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApiSchemaConfigurationProperty> {
            java.lang.String inlinePayload;
            java.lang.Object s3;

            /**
             * Sets the value of {@link ApiSchemaConfigurationProperty#getInlinePayload}
             * @param inlinePayload The inline payload for the gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inlinePayload(java.lang.String inlinePayload) {
                this.inlinePayload = inlinePayload;
                return this;
            }

            /**
             * Sets the value of {@link ApiSchemaConfigurationProperty#getS3}
             * @param s3 The API schema configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link ApiSchemaConfigurationProperty#getS3}
             * @param s3 The API schema configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.S3ConfigurationProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiSchemaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApiSchemaConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApiSchemaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiSchemaConfigurationProperty {
            private final java.lang.String inlinePayload;
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inlinePayload = software.amazon.jsii.Kernel.get(this, "inlinePayload", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inlinePayload = builder.inlinePayload;
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.String getInlinePayload() {
                return this.inlinePayload;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInlinePayload() != null) {
                    data.set("inlinePayload", om.valueToTree(this.getInlinePayload()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.ApiSchemaConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiSchemaConfigurationProperty.Jsii$Proxy that = (ApiSchemaConfigurationProperty.Jsii$Proxy) o;

                if (this.inlinePayload != null ? !this.inlinePayload.equals(that.inlinePayload) : that.inlinePayload != null) return false;
                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inlinePayload != null ? this.inlinePayload.hashCode() : 0;
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The credential provider configuration for the gateway target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * CredentialProviderConfigurationProperty credentialProviderConfigurationProperty = CredentialProviderConfigurationProperty.builder()
     *         .credentialProviderType("credentialProviderType")
     *         // the properties below are optional
     *         .credentialProvider(CredentialProviderProperty.builder()
     *                 .apiKeyCredentialProvider(ApiKeyCredentialProviderProperty.builder()
     *                         .providerArn("providerArn")
     *                         // the properties below are optional
     *                         .credentialLocation("credentialLocation")
     *                         .credentialParameterName("credentialParameterName")
     *                         .credentialPrefix("credentialPrefix")
     *                         .build())
     *                 .oauthCredentialProvider(OAuthCredentialProviderProperty.builder()
     *                         .providerArn("providerArn")
     *                         .scopes(List.of("scopes"))
     *                         // the properties below are optional
     *                         .customParameters(Map.of(
     *                                 "customParametersKey", "customParameters"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialproviderconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialproviderconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.CredentialProviderConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CredentialProviderConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CredentialProviderConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The credential provider type for the gateway target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialproviderconfiguration.html#cfn-bedrockagentcore-gatewaytarget-credentialproviderconfiguration-credentialprovidertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialproviderconfiguration.html#cfn-bedrockagentcore-gatewaytarget-credentialproviderconfiguration-credentialprovidertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialProviderType();

        /**
         * The credential provider for the gateway target.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.CredentialProviderProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialproviderconfiguration.html#cfn-bedrockagentcore-gatewaytarget-credentialproviderconfiguration-credentialprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialproviderconfiguration.html#cfn-bedrockagentcore-gatewaytarget-credentialproviderconfiguration-credentialprovider</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCredentialProvider() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CredentialProviderConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CredentialProviderConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CredentialProviderConfigurationProperty> {
            java.lang.String credentialProviderType;
            java.lang.Object credentialProvider;

            /**
             * Sets the value of {@link CredentialProviderConfigurationProperty#getCredentialProviderType}
             * @param credentialProviderType The credential provider type for the gateway target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialProviderType(java.lang.String credentialProviderType) {
                this.credentialProviderType = credentialProviderType;
                return this;
            }

            /**
             * Sets the value of {@link CredentialProviderConfigurationProperty#getCredentialProvider}
             * @param credentialProvider The credential provider for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialProvider(software.amazon.awscdk.IResolvable credentialProvider) {
                this.credentialProvider = credentialProvider;
                return this;
            }

            /**
             * Sets the value of {@link CredentialProviderConfigurationProperty#getCredentialProvider}
             * @param credentialProvider The credential provider for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialProvider(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.CredentialProviderProperty credentialProvider) {
                this.credentialProvider = credentialProvider;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CredentialProviderConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CredentialProviderConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CredentialProviderConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CredentialProviderConfigurationProperty {
            private final java.lang.String credentialProviderType;
            private final java.lang.Object credentialProvider;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credentialProviderType = software.amazon.jsii.Kernel.get(this, "credentialProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentialProvider = software.amazon.jsii.Kernel.get(this, "credentialProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credentialProviderType = java.util.Objects.requireNonNull(builder.credentialProviderType, "credentialProviderType is required");
                this.credentialProvider = builder.credentialProvider;
            }

            @Override
            public final java.lang.String getCredentialProviderType() {
                return this.credentialProviderType;
            }

            @Override
            public final java.lang.Object getCredentialProvider() {
                return this.credentialProvider;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("credentialProviderType", om.valueToTree(this.getCredentialProviderType()));
                if (this.getCredentialProvider() != null) {
                    data.set("credentialProvider", om.valueToTree(this.getCredentialProvider()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.CredentialProviderConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CredentialProviderConfigurationProperty.Jsii$Proxy that = (CredentialProviderConfigurationProperty.Jsii$Proxy) o;

                if (!credentialProviderType.equals(that.credentialProviderType)) return false;
                return this.credentialProvider != null ? this.credentialProvider.equals(that.credentialProvider) : that.credentialProvider == null;
            }

            @Override
            public final int hashCode() {
                int result = this.credentialProviderType.hashCode();
                result = 31 * result + (this.credentialProvider != null ? this.credentialProvider.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * CredentialProviderProperty credentialProviderProperty = CredentialProviderProperty.builder()
     *         .apiKeyCredentialProvider(ApiKeyCredentialProviderProperty.builder()
     *                 .providerArn("providerArn")
     *                 // the properties below are optional
     *                 .credentialLocation("credentialLocation")
     *                 .credentialParameterName("credentialParameterName")
     *                 .credentialPrefix("credentialPrefix")
     *                 .build())
     *         .oauthCredentialProvider(OAuthCredentialProviderProperty.builder()
     *                 .providerArn("providerArn")
     *                 .scopes(List.of("scopes"))
     *                 // the properties below are optional
     *                 .customParameters(Map.of(
     *                         "customParametersKey", "customParameters"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialprovider.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.CredentialProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(CredentialProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CredentialProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The API key credential provider.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.ApiKeyCredentialProviderProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialprovider.html#cfn-bedrockagentcore-gatewaytarget-credentialprovider-apikeycredentialprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialprovider.html#cfn-bedrockagentcore-gatewaytarget-credentialprovider-apikeycredentialprovider</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApiKeyCredentialProvider() {
            return null;
        }

        /**
         * The OAuth credential provider for the gateway target.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.OAuthCredentialProviderProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialprovider.html#cfn-bedrockagentcore-gatewaytarget-credentialprovider-oauthcredentialprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-credentialprovider.html#cfn-bedrockagentcore-gatewaytarget-credentialprovider-oauthcredentialprovider</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOauthCredentialProvider() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CredentialProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CredentialProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CredentialProviderProperty> {
            java.lang.Object apiKeyCredentialProvider;
            java.lang.Object oauthCredentialProvider;

            /**
             * Sets the value of {@link CredentialProviderProperty#getApiKeyCredentialProvider}
             * @param apiKeyCredentialProvider The API key credential provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKeyCredentialProvider(software.amazon.awscdk.IResolvable apiKeyCredentialProvider) {
                this.apiKeyCredentialProvider = apiKeyCredentialProvider;
                return this;
            }

            /**
             * Sets the value of {@link CredentialProviderProperty#getApiKeyCredentialProvider}
             * @param apiKeyCredentialProvider The API key credential provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKeyCredentialProvider(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.ApiKeyCredentialProviderProperty apiKeyCredentialProvider) {
                this.apiKeyCredentialProvider = apiKeyCredentialProvider;
                return this;
            }

            /**
             * Sets the value of {@link CredentialProviderProperty#getOauthCredentialProvider}
             * @param oauthCredentialProvider The OAuth credential provider for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oauthCredentialProvider(software.amazon.awscdk.IResolvable oauthCredentialProvider) {
                this.oauthCredentialProvider = oauthCredentialProvider;
                return this;
            }

            /**
             * Sets the value of {@link CredentialProviderProperty#getOauthCredentialProvider}
             * @param oauthCredentialProvider The OAuth credential provider for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oauthCredentialProvider(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.OAuthCredentialProviderProperty oauthCredentialProvider) {
                this.oauthCredentialProvider = oauthCredentialProvider;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CredentialProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CredentialProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CredentialProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CredentialProviderProperty {
            private final java.lang.Object apiKeyCredentialProvider;
            private final java.lang.Object oauthCredentialProvider;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKeyCredentialProvider = software.amazon.jsii.Kernel.get(this, "apiKeyCredentialProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oauthCredentialProvider = software.amazon.jsii.Kernel.get(this, "oauthCredentialProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKeyCredentialProvider = builder.apiKeyCredentialProvider;
                this.oauthCredentialProvider = builder.oauthCredentialProvider;
            }

            @Override
            public final java.lang.Object getApiKeyCredentialProvider() {
                return this.apiKeyCredentialProvider;
            }

            @Override
            public final java.lang.Object getOauthCredentialProvider() {
                return this.oauthCredentialProvider;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApiKeyCredentialProvider() != null) {
                    data.set("apiKeyCredentialProvider", om.valueToTree(this.getApiKeyCredentialProvider()));
                }
                if (this.getOauthCredentialProvider() != null) {
                    data.set("oauthCredentialProvider", om.valueToTree(this.getOauthCredentialProvider()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.CredentialProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CredentialProviderProperty.Jsii$Proxy that = (CredentialProviderProperty.Jsii$Proxy) o;

                if (this.apiKeyCredentialProvider != null ? !this.apiKeyCredentialProvider.equals(that.apiKeyCredentialProvider) : that.apiKeyCredentialProvider != null) return false;
                return this.oauthCredentialProvider != null ? this.oauthCredentialProvider.equals(that.oauthCredentialProvider) : that.oauthCredentialProvider == null;
            }

            @Override
            public final int hashCode() {
                int result = this.apiKeyCredentialProvider != null ? this.apiKeyCredentialProvider.hashCode() : 0;
                result = 31 * result + (this.oauthCredentialProvider != null ? this.oauthCredentialProvider.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Lambda target configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SchemaDefinitionProperty schemaDefinitionProperty_;
     * McpLambdaTargetConfigurationProperty mcpLambdaTargetConfigurationProperty = McpLambdaTargetConfigurationProperty.builder()
     *         .lambdaArn("lambdaArn")
     *         .toolSchema(ToolSchemaProperty.builder()
     *                 .inlinePayload(List.of(ToolDefinitionProperty.builder()
     *                         .description("description")
     *                         .inputSchema(SchemaDefinitionProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .description("description")
     *                                 .items(schemaDefinitionProperty_)
     *                                 .properties(Map.of(
     *                                         "propertiesKey", schemaDefinitionProperty_))
     *                                 .required(List.of("required"))
     *                                 .build())
     *                         .name("name")
     *                         // the properties below are optional
     *                         .outputSchema(SchemaDefinitionProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .description("description")
     *                                 .items(schemaDefinitionProperty_)
     *                                 .properties(Map.of(
     *                                         "propertiesKey", schemaDefinitionProperty_))
     *                                 .required(List.of("required"))
     *                                 .build())
     *                         .build()))
     *                 .s3(S3ConfigurationProperty.builder()
     *                         .bucketOwnerAccountId("bucketOwnerAccountId")
     *                         .uri("uri")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcplambdatargetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcplambdatargetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.McpLambdaTargetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(McpLambdaTargetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface McpLambdaTargetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Lambda target configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcplambdatargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcplambdatargetconfiguration-lambdaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcplambdatargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcplambdatargetconfiguration-lambdaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaArn();

        /**
         * The tool schema configuration for the gateway target MCP configuration for Lambda.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.ToolSchemaProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcplambdatargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcplambdatargetconfiguration-toolschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcplambdatargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcplambdatargetconfiguration-toolschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getToolSchema();

        /**
         * @return a {@link Builder} of {@link McpLambdaTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link McpLambdaTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<McpLambdaTargetConfigurationProperty> {
            java.lang.String lambdaArn;
            java.lang.Object toolSchema;

            /**
             * Sets the value of {@link McpLambdaTargetConfigurationProperty#getLambdaArn}
             * @param lambdaArn The ARN of the Lambda target configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Sets the value of {@link McpLambdaTargetConfigurationProperty#getToolSchema}
             * @param toolSchema The tool schema configuration for the gateway target MCP configuration for Lambda. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toolSchema(software.amazon.awscdk.IResolvable toolSchema) {
                this.toolSchema = toolSchema;
                return this;
            }

            /**
             * Sets the value of {@link McpLambdaTargetConfigurationProperty#getToolSchema}
             * @param toolSchema The tool schema configuration for the gateway target MCP configuration for Lambda. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toolSchema(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.ToolSchemaProperty toolSchema) {
                this.toolSchema = toolSchema;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link McpLambdaTargetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public McpLambdaTargetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link McpLambdaTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements McpLambdaTargetConfigurationProperty {
            private final java.lang.String lambdaArn;
            private final java.lang.Object toolSchema;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.toolSchema = software.amazon.jsii.Kernel.get(this, "toolSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaArn = java.util.Objects.requireNonNull(builder.lambdaArn, "lambdaArn is required");
                this.toolSchema = java.util.Objects.requireNonNull(builder.toolSchema, "toolSchema is required");
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            public final java.lang.Object getToolSchema() {
                return this.toolSchema;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));
                data.set("toolSchema", om.valueToTree(this.getToolSchema()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.McpLambdaTargetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                McpLambdaTargetConfigurationProperty.Jsii$Proxy that = (McpLambdaTargetConfigurationProperty.Jsii$Proxy) o;

                if (!lambdaArn.equals(that.lambdaArn)) return false;
                return this.toolSchema.equals(that.toolSchema);
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaArn.hashCode();
                result = 31 * result + (this.toolSchema.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * McpServerTargetConfigurationProperty mcpServerTargetConfigurationProperty = McpServerTargetConfigurationProperty.builder()
     *         .endpoint("endpoint")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcpservertargetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcpservertargetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.McpServerTargetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(McpServerTargetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface McpServerTargetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcpservertargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcpservertargetconfiguration-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcpservertargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcpservertargetconfiguration-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

        /**
         * @return a {@link Builder} of {@link McpServerTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link McpServerTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<McpServerTargetConfigurationProperty> {
            java.lang.String endpoint;

            /**
             * Sets the value of {@link McpServerTargetConfigurationProperty#getEndpoint}
             * @param endpoint the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(java.lang.String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link McpServerTargetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public McpServerTargetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link McpServerTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements McpServerTargetConfigurationProperty {
            private final java.lang.String endpoint;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
            }

            @Override
            public final java.lang.String getEndpoint() {
                return this.endpoint;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpoint", om.valueToTree(this.getEndpoint()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.McpServerTargetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                McpServerTargetConfigurationProperty.Jsii$Proxy that = (McpServerTargetConfigurationProperty.Jsii$Proxy) o;

                return this.endpoint.equals(that.endpoint);
            }

            @Override
            public final int hashCode() {
                int result = this.endpoint.hashCode();
                return result;
            }
        }
    }
    /**
     * The MCP target configuration for the gateway target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SchemaDefinitionProperty schemaDefinitionProperty_;
     * McpTargetConfigurationProperty mcpTargetConfigurationProperty = McpTargetConfigurationProperty.builder()
     *         .lambda(McpLambdaTargetConfigurationProperty.builder()
     *                 .lambdaArn("lambdaArn")
     *                 .toolSchema(ToolSchemaProperty.builder()
     *                         .inlinePayload(List.of(ToolDefinitionProperty.builder()
     *                                 .description("description")
     *                                 .inputSchema(SchemaDefinitionProperty.builder()
     *                                         .type("type")
     *                                         // the properties below are optional
     *                                         .description("description")
     *                                         .items(schemaDefinitionProperty_)
     *                                         .properties(Map.of(
     *                                                 "propertiesKey", schemaDefinitionProperty_))
     *                                         .required(List.of("required"))
     *                                         .build())
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .outputSchema(SchemaDefinitionProperty.builder()
     *                                         .type("type")
     *                                         // the properties below are optional
     *                                         .description("description")
     *                                         .items(schemaDefinitionProperty_)
     *                                         .properties(Map.of(
     *                                                 "propertiesKey", schemaDefinitionProperty_))
     *                                         .required(List.of("required"))
     *                                         .build())
     *                                 .build()))
     *                         .s3(S3ConfigurationProperty.builder()
     *                                 .bucketOwnerAccountId("bucketOwnerAccountId")
     *                                 .uri("uri")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .mcpServer(McpServerTargetConfigurationProperty.builder()
     *                 .endpoint("endpoint")
     *                 .build())
     *         .openApiSchema(ApiSchemaConfigurationProperty.builder()
     *                 .inlinePayload("inlinePayload")
     *                 .s3(S3ConfigurationProperty.builder()
     *                         .bucketOwnerAccountId("bucketOwnerAccountId")
     *                         .uri("uri")
     *                         .build())
     *                 .build())
     *         .smithyModel(ApiSchemaConfigurationProperty.builder()
     *                 .inlinePayload("inlinePayload")
     *                 .s3(S3ConfigurationProperty.builder()
     *                         .bucketOwnerAccountId("bucketOwnerAccountId")
     *                         .uri("uri")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcptargetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcptargetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.McpTargetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(McpTargetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface McpTargetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Lambda MCP configuration for the gateway target.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.McpLambdaTargetConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcptargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcptargetconfiguration-lambda">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcptargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcptargetconfiguration-lambda</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambda() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.McpServerTargetConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcptargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcptargetconfiguration-mcpserver">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcptargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcptargetconfiguration-mcpserver</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMcpServer() {
            return null;
        }

        /**
         * The OpenApi schema for the gateway target MCP configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.ApiSchemaConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcptargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcptargetconfiguration-openapischema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcptargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcptargetconfiguration-openapischema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpenApiSchema() {
            return null;
        }

        /**
         * The target configuration for the Smithy model target.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.ApiSchemaConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcptargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcptargetconfiguration-smithymodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-mcptargetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-mcptargetconfiguration-smithymodel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmithyModel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link McpTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link McpTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<McpTargetConfigurationProperty> {
            java.lang.Object lambda;
            java.lang.Object mcpServer;
            java.lang.Object openApiSchema;
            java.lang.Object smithyModel;

            /**
             * Sets the value of {@link McpTargetConfigurationProperty#getLambda}
             * @param lambda The Lambda MCP configuration for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.IResolvable lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link McpTargetConfigurationProperty#getLambda}
             * @param lambda The Lambda MCP configuration for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.McpLambdaTargetConfigurationProperty lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link McpTargetConfigurationProperty#getMcpServer}
             * @param mcpServer the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mcpServer(software.amazon.awscdk.IResolvable mcpServer) {
                this.mcpServer = mcpServer;
                return this;
            }

            /**
             * Sets the value of {@link McpTargetConfigurationProperty#getMcpServer}
             * @param mcpServer the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mcpServer(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.McpServerTargetConfigurationProperty mcpServer) {
                this.mcpServer = mcpServer;
                return this;
            }

            /**
             * Sets the value of {@link McpTargetConfigurationProperty#getOpenApiSchema}
             * @param openApiSchema The OpenApi schema for the gateway target MCP configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openApiSchema(software.amazon.awscdk.IResolvable openApiSchema) {
                this.openApiSchema = openApiSchema;
                return this;
            }

            /**
             * Sets the value of {@link McpTargetConfigurationProperty#getOpenApiSchema}
             * @param openApiSchema The OpenApi schema for the gateway target MCP configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openApiSchema(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.ApiSchemaConfigurationProperty openApiSchema) {
                this.openApiSchema = openApiSchema;
                return this;
            }

            /**
             * Sets the value of {@link McpTargetConfigurationProperty#getSmithyModel}
             * @param smithyModel The target configuration for the Smithy model target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smithyModel(software.amazon.awscdk.IResolvable smithyModel) {
                this.smithyModel = smithyModel;
                return this;
            }

            /**
             * Sets the value of {@link McpTargetConfigurationProperty#getSmithyModel}
             * @param smithyModel The target configuration for the Smithy model target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smithyModel(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.ApiSchemaConfigurationProperty smithyModel) {
                this.smithyModel = smithyModel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link McpTargetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public McpTargetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link McpTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements McpTargetConfigurationProperty {
            private final java.lang.Object lambda;
            private final java.lang.Object mcpServer;
            private final java.lang.Object openApiSchema;
            private final java.lang.Object smithyModel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambda = software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mcpServer = software.amazon.jsii.Kernel.get(this, "mcpServer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.openApiSchema = software.amazon.jsii.Kernel.get(this, "openApiSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.smithyModel = software.amazon.jsii.Kernel.get(this, "smithyModel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambda = builder.lambda;
                this.mcpServer = builder.mcpServer;
                this.openApiSchema = builder.openApiSchema;
                this.smithyModel = builder.smithyModel;
            }

            @Override
            public final java.lang.Object getLambda() {
                return this.lambda;
            }

            @Override
            public final java.lang.Object getMcpServer() {
                return this.mcpServer;
            }

            @Override
            public final java.lang.Object getOpenApiSchema() {
                return this.openApiSchema;
            }

            @Override
            public final java.lang.Object getSmithyModel() {
                return this.smithyModel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLambda() != null) {
                    data.set("lambda", om.valueToTree(this.getLambda()));
                }
                if (this.getMcpServer() != null) {
                    data.set("mcpServer", om.valueToTree(this.getMcpServer()));
                }
                if (this.getOpenApiSchema() != null) {
                    data.set("openApiSchema", om.valueToTree(this.getOpenApiSchema()));
                }
                if (this.getSmithyModel() != null) {
                    data.set("smithyModel", om.valueToTree(this.getSmithyModel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.McpTargetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                McpTargetConfigurationProperty.Jsii$Proxy that = (McpTargetConfigurationProperty.Jsii$Proxy) o;

                if (this.lambda != null ? !this.lambda.equals(that.lambda) : that.lambda != null) return false;
                if (this.mcpServer != null ? !this.mcpServer.equals(that.mcpServer) : that.mcpServer != null) return false;
                if (this.openApiSchema != null ? !this.openApiSchema.equals(that.openApiSchema) : that.openApiSchema != null) return false;
                return this.smithyModel != null ? this.smithyModel.equals(that.smithyModel) : that.smithyModel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lambda != null ? this.lambda.hashCode() : 0;
                result = 31 * result + (this.mcpServer != null ? this.mcpServer.hashCode() : 0);
                result = 31 * result + (this.openApiSchema != null ? this.openApiSchema.hashCode() : 0);
                result = 31 * result + (this.smithyModel != null ? this.smithyModel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The OAuth credential provider for the gateway target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * OAuthCredentialProviderProperty oAuthCredentialProviderProperty = OAuthCredentialProviderProperty.builder()
     *         .providerArn("providerArn")
     *         .scopes(List.of("scopes"))
     *         // the properties below are optional
     *         .customParameters(Map.of(
     *                 "customParametersKey", "customParameters"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-oauthcredentialprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-oauthcredentialprovider.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.OAuthCredentialProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuthCredentialProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuthCredentialProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The provider ARN for the gateway target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-oauthcredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-oauthcredentialprovider-providerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-oauthcredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-oauthcredentialprovider-providerarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProviderArn();

        /**
         * The OAuth credential provider scopes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-oauthcredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-oauthcredentialprovider-scopes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-oauthcredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-oauthcredentialprovider-scopes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getScopes();

        /**
         * The OAuth credential provider.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-oauthcredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-oauthcredentialprovider-customparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-oauthcredentialprovider.html#cfn-bedrockagentcore-gatewaytarget-oauthcredentialprovider-customparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuthCredentialProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuthCredentialProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuthCredentialProviderProperty> {
            java.lang.String providerArn;
            java.util.List<java.lang.String> scopes;
            java.lang.Object customParameters;

            /**
             * Sets the value of {@link OAuthCredentialProviderProperty#getProviderArn}
             * @param providerArn The provider ARN for the gateway target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerArn(java.lang.String providerArn) {
                this.providerArn = providerArn;
                return this;
            }

            /**
             * Sets the value of {@link OAuthCredentialProviderProperty#getScopes}
             * @param scopes The OAuth credential provider scopes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scopes(java.util.List<java.lang.String> scopes) {
                this.scopes = scopes;
                return this;
            }

            /**
             * Sets the value of {@link OAuthCredentialProviderProperty#getCustomParameters}
             * @param customParameters The OAuth credential provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customParameters(java.util.Map<java.lang.String, java.lang.String> customParameters) {
                this.customParameters = customParameters;
                return this;
            }

            /**
             * Sets the value of {@link OAuthCredentialProviderProperty#getCustomParameters}
             * @param customParameters The OAuth credential provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customParameters(software.amazon.awscdk.IResolvable customParameters) {
                this.customParameters = customParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuthCredentialProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuthCredentialProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuthCredentialProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuthCredentialProviderProperty {
            private final java.lang.String providerArn;
            private final java.util.List<java.lang.String> scopes;
            private final java.lang.Object customParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.providerArn = software.amazon.jsii.Kernel.get(this, "providerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scopes = software.amazon.jsii.Kernel.get(this, "scopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.customParameters = software.amazon.jsii.Kernel.get(this, "customParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.providerArn = java.util.Objects.requireNonNull(builder.providerArn, "providerArn is required");
                this.scopes = java.util.Objects.requireNonNull(builder.scopes, "scopes is required");
                this.customParameters = builder.customParameters;
            }

            @Override
            public final java.lang.String getProviderArn() {
                return this.providerArn;
            }

            @Override
            public final java.util.List<java.lang.String> getScopes() {
                return this.scopes;
            }

            @Override
            public final java.lang.Object getCustomParameters() {
                return this.customParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("providerArn", om.valueToTree(this.getProviderArn()));
                data.set("scopes", om.valueToTree(this.getScopes()));
                if (this.getCustomParameters() != null) {
                    data.set("customParameters", om.valueToTree(this.getCustomParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.OAuthCredentialProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuthCredentialProviderProperty.Jsii$Proxy that = (OAuthCredentialProviderProperty.Jsii$Proxy) o;

                if (!providerArn.equals(that.providerArn)) return false;
                if (!scopes.equals(that.scopes)) return false;
                return this.customParameters != null ? this.customParameters.equals(that.customParameters) : that.customParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.providerArn.hashCode();
                result = 31 * result + (this.scopes.hashCode());
                result = 31 * result + (this.customParameters != null ? this.customParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The S3 configuration for the gateway target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * S3ConfigurationProperty s3ConfigurationProperty = S3ConfigurationProperty.builder()
     *         .bucketOwnerAccountId("bucketOwnerAccountId")
     *         .uri("uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-s3configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-s3configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.S3ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 configuration bucket owner account ID for the gateway target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-s3configuration.html#cfn-bedrockagentcore-gatewaytarget-s3configuration-bucketowneraccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-s3configuration.html#cfn-bedrockagentcore-gatewaytarget-s3configuration-bucketowneraccountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketOwnerAccountId() {
            return null;
        }

        /**
         * The configuration URI for the gateway target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-s3configuration.html#cfn-bedrockagentcore-gatewaytarget-s3configuration-uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-s3configuration.html#cfn-bedrockagentcore-gatewaytarget-s3configuration-uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ConfigurationProperty> {
            java.lang.String bucketOwnerAccountId;
            java.lang.String uri;

            /**
             * Sets the value of {@link S3ConfigurationProperty#getBucketOwnerAccountId}
             * @param bucketOwnerAccountId The S3 configuration bucket owner account ID for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketOwnerAccountId(java.lang.String bucketOwnerAccountId) {
                this.bucketOwnerAccountId = bucketOwnerAccountId;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigurationProperty#getUri}
             * @param uri The configuration URI for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uri(java.lang.String uri) {
                this.uri = uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ConfigurationProperty {
            private final java.lang.String bucketOwnerAccountId;
            private final java.lang.String uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketOwnerAccountId = software.amazon.jsii.Kernel.get(this, "bucketOwnerAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketOwnerAccountId = builder.bucketOwnerAccountId;
                this.uri = builder.uri;
            }

            @Override
            public final java.lang.String getBucketOwnerAccountId() {
                return this.bucketOwnerAccountId;
            }

            @Override
            public final java.lang.String getUri() {
                return this.uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketOwnerAccountId() != null) {
                    data.set("bucketOwnerAccountId", om.valueToTree(this.getBucketOwnerAccountId()));
                }
                if (this.getUri() != null) {
                    data.set("uri", om.valueToTree(this.getUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.S3ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ConfigurationProperty.Jsii$Proxy that = (S3ConfigurationProperty.Jsii$Proxy) o;

                if (this.bucketOwnerAccountId != null ? !this.bucketOwnerAccountId.equals(that.bucketOwnerAccountId) : that.bucketOwnerAccountId != null) return false;
                return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketOwnerAccountId != null ? this.bucketOwnerAccountId.hashCode() : 0;
                result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The schema definition for the gateway target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SchemaDefinitionProperty schemaDefinitionProperty_;
     * SchemaDefinitionProperty schemaDefinitionProperty = SchemaDefinitionProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .description("description")
     *         .items(schemaDefinitionProperty_)
     *         .properties(Map.of(
     *                 "propertiesKey", schemaDefinitionProperty_))
     *         .required(List.of("required"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.SchemaDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The scheme definition type for the gateway target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html#cfn-bedrockagentcore-gatewaytarget-schemadefinition-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html#cfn-bedrockagentcore-gatewaytarget-schemadefinition-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The workload identity details for the gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html#cfn-bedrockagentcore-gatewaytarget-schemadefinition-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html#cfn-bedrockagentcore-gatewaytarget-schemadefinition-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.SchemaDefinitionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html#cfn-bedrockagentcore-gatewaytarget-schemadefinition-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html#cfn-bedrockagentcore-gatewaytarget-schemadefinition-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getItems() {
            return null;
        }

        /**
         * The schema definition properties for the gateway target.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.SchemaDefinitionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html#cfn-bedrockagentcore-gatewaytarget-schemadefinition-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html#cfn-bedrockagentcore-gatewaytarget-schemadefinition-properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProperties() {
            return null;
        }

        /**
         * The schema definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html#cfn-bedrockagentcore-gatewaytarget-schemadefinition-required">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-schemadefinition.html#cfn-bedrockagentcore-gatewaytarget-schemadefinition-required</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRequired() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaDefinitionProperty> {
            java.lang.String type;
            java.lang.String description;
            java.lang.Object items;
            java.lang.Object properties;
            java.util.List<java.lang.String> required;

            /**
             * Sets the value of {@link SchemaDefinitionProperty#getType}
             * @param type The scheme definition type for the gateway target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SchemaDefinitionProperty#getDescription}
             * @param description The workload identity details for the gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link SchemaDefinitionProperty#getItems}
             * @param items the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link SchemaDefinitionProperty#getItems}
             * @param items the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.SchemaDefinitionProperty items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link SchemaDefinitionProperty#getProperties}
             * @param properties The schema definition properties for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link SchemaDefinitionProperty#getProperties}
             * @param properties The schema definition properties for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link SchemaDefinitionProperty#getRequired}
             * @param required The schema definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(java.util.List<java.lang.String> required) {
                this.required = required;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaDefinitionProperty {
            private final java.lang.String type;
            private final java.lang.String description;
            private final java.lang.Object items;
            private final java.lang.Object properties;
            private final java.util.List<java.lang.String> required;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.required = software.amazon.jsii.Kernel.get(this, "required", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.description = builder.description;
                this.items = builder.items;
                this.properties = builder.properties;
                this.required = builder.required;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getItems() {
                return this.items;
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            public final java.util.List<java.lang.String> getRequired() {
                return this.required;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getItems() != null) {
                    data.set("items", om.valueToTree(this.getItems()));
                }
                if (this.getProperties() != null) {
                    data.set("properties", om.valueToTree(this.getProperties()));
                }
                if (this.getRequired() != null) {
                    data.set("required", om.valueToTree(this.getRequired()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.SchemaDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaDefinitionProperty.Jsii$Proxy that = (SchemaDefinitionProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.items != null ? !this.items.equals(that.items) : that.items != null) return false;
                if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) return false;
                return this.required != null ? this.required.equals(that.required) : that.required == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
                result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
                result = 31 * result + (this.required != null ? this.required.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The target configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SchemaDefinitionProperty schemaDefinitionProperty_;
     * TargetConfigurationProperty targetConfigurationProperty = TargetConfigurationProperty.builder()
     *         .mcp(McpTargetConfigurationProperty.builder()
     *                 .lambda(McpLambdaTargetConfigurationProperty.builder()
     *                         .lambdaArn("lambdaArn")
     *                         .toolSchema(ToolSchemaProperty.builder()
     *                                 .inlinePayload(List.of(ToolDefinitionProperty.builder()
     *                                         .description("description")
     *                                         .inputSchema(SchemaDefinitionProperty.builder()
     *                                                 .type("type")
     *                                                 // the properties below are optional
     *                                                 .description("description")
     *                                                 .items(schemaDefinitionProperty_)
     *                                                 .properties(Map.of(
     *                                                         "propertiesKey", schemaDefinitionProperty_))
     *                                                 .required(List.of("required"))
     *                                                 .build())
     *                                         .name("name")
     *                                         // the properties below are optional
     *                                         .outputSchema(SchemaDefinitionProperty.builder()
     *                                                 .type("type")
     *                                                 // the properties below are optional
     *                                                 .description("description")
     *                                                 .items(schemaDefinitionProperty_)
     *                                                 .properties(Map.of(
     *                                                         "propertiesKey", schemaDefinitionProperty_))
     *                                                 .required(List.of("required"))
     *                                                 .build())
     *                                         .build()))
     *                                 .s3(S3ConfigurationProperty.builder()
     *                                         .bucketOwnerAccountId("bucketOwnerAccountId")
     *                                         .uri("uri")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .mcpServer(McpServerTargetConfigurationProperty.builder()
     *                         .endpoint("endpoint")
     *                         .build())
     *                 .openApiSchema(ApiSchemaConfigurationProperty.builder()
     *                         .inlinePayload("inlinePayload")
     *                         .s3(S3ConfigurationProperty.builder()
     *                                 .bucketOwnerAccountId("bucketOwnerAccountId")
     *                                 .uri("uri")
     *                                 .build())
     *                         .build())
     *                 .smithyModel(ApiSchemaConfigurationProperty.builder()
     *                         .inlinePayload("inlinePayload")
     *                         .s3(S3ConfigurationProperty.builder()
     *                                 .bucketOwnerAccountId("bucketOwnerAccountId")
     *                                 .uri("uri")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-targetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-targetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.TargetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target configuration definition for MCP.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.McpTargetConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-targetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-targetconfiguration-mcp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-targetconfiguration.html#cfn-bedrockagentcore-gatewaytarget-targetconfiguration-mcp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMcp();

        /**
         * @return a {@link Builder} of {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetConfigurationProperty> {
            java.lang.Object mcp;

            /**
             * Sets the value of {@link TargetConfigurationProperty#getMcp}
             * @param mcp The target configuration definition for MCP. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mcp(software.amazon.awscdk.IResolvable mcp) {
                this.mcp = mcp;
                return this;
            }

            /**
             * Sets the value of {@link TargetConfigurationProperty#getMcp}
             * @param mcp The target configuration definition for MCP. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mcp(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.McpTargetConfigurationProperty mcp) {
                this.mcp = mcp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetConfigurationProperty {
            private final java.lang.Object mcp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mcp = software.amazon.jsii.Kernel.get(this, "mcp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mcp = java.util.Objects.requireNonNull(builder.mcp, "mcp is required");
            }

            @Override
            public final java.lang.Object getMcp() {
                return this.mcp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mcp", om.valueToTree(this.getMcp()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.TargetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetConfigurationProperty.Jsii$Proxy that = (TargetConfigurationProperty.Jsii$Proxy) o;

                return this.mcp.equals(that.mcp);
            }

            @Override
            public final int hashCode() {
                int result = this.mcp.hashCode();
                return result;
            }
        }
    }
    /**
     * The tool definition for the gateway.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SchemaDefinitionProperty schemaDefinitionProperty_;
     * ToolDefinitionProperty toolDefinitionProperty = ToolDefinitionProperty.builder()
     *         .description("description")
     *         .inputSchema(SchemaDefinitionProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .items(schemaDefinitionProperty_)
     *                 .properties(Map.of(
     *                         "propertiesKey", schemaDefinitionProperty_))
     *                 .required(List.of("required"))
     *                 .build())
     *         .name("name")
     *         // the properties below are optional
     *         .outputSchema(SchemaDefinitionProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .items(schemaDefinitionProperty_)
     *                 .properties(Map.of(
     *                         "propertiesKey", schemaDefinitionProperty_))
     *                 .required(List.of("required"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-tooldefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-tooldefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.ToolDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(ToolDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ToolDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-tooldefinition.html#cfn-bedrockagentcore-gatewaytarget-tooldefinition-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-tooldefinition.html#cfn-bedrockagentcore-gatewaytarget-tooldefinition-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDescription();

        /**
         * The input schema for the gateway target.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.SchemaDefinitionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-tooldefinition.html#cfn-bedrockagentcore-gatewaytarget-tooldefinition-inputschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-tooldefinition.html#cfn-bedrockagentcore-gatewaytarget-tooldefinition-inputschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInputSchema();

        /**
         * The tool name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-tooldefinition.html#cfn-bedrockagentcore-gatewaytarget-tooldefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-tooldefinition.html#cfn-bedrockagentcore-gatewaytarget-tooldefinition-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The tool definition output schema for the gateway target.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.SchemaDefinitionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-tooldefinition.html#cfn-bedrockagentcore-gatewaytarget-tooldefinition-outputschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-tooldefinition.html#cfn-bedrockagentcore-gatewaytarget-tooldefinition-outputschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputSchema() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ToolDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ToolDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ToolDefinitionProperty> {
            java.lang.String description;
            java.lang.Object inputSchema;
            java.lang.String name;
            java.lang.Object outputSchema;

            /**
             * Sets the value of {@link ToolDefinitionProperty#getDescription}
             * @param description the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ToolDefinitionProperty#getInputSchema}
             * @param inputSchema The input schema for the gateway target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputSchema(software.amazon.awscdk.IResolvable inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            /**
             * Sets the value of {@link ToolDefinitionProperty#getInputSchema}
             * @param inputSchema The input schema for the gateway target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputSchema(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.SchemaDefinitionProperty inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            /**
             * Sets the value of {@link ToolDefinitionProperty#getName}
             * @param name The tool name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ToolDefinitionProperty#getOutputSchema}
             * @param outputSchema The tool definition output schema for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputSchema(software.amazon.awscdk.IResolvable outputSchema) {
                this.outputSchema = outputSchema;
                return this;
            }

            /**
             * Sets the value of {@link ToolDefinitionProperty#getOutputSchema}
             * @param outputSchema The tool definition output schema for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputSchema(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.SchemaDefinitionProperty outputSchema) {
                this.outputSchema = outputSchema;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ToolDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ToolDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ToolDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ToolDefinitionProperty {
            private final java.lang.String description;
            private final java.lang.Object inputSchema;
            private final java.lang.String name;
            private final java.lang.Object outputSchema;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputSchema = software.amazon.jsii.Kernel.get(this, "inputSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputSchema = software.amazon.jsii.Kernel.get(this, "outputSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
                this.inputSchema = java.util.Objects.requireNonNull(builder.inputSchema, "inputSchema is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.outputSchema = builder.outputSchema;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getInputSchema() {
                return this.inputSchema;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getOutputSchema() {
                return this.outputSchema;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("description", om.valueToTree(this.getDescription()));
                data.set("inputSchema", om.valueToTree(this.getInputSchema()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getOutputSchema() != null) {
                    data.set("outputSchema", om.valueToTree(this.getOutputSchema()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.ToolDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ToolDefinitionProperty.Jsii$Proxy that = (ToolDefinitionProperty.Jsii$Proxy) o;

                if (!description.equals(that.description)) return false;
                if (!inputSchema.equals(that.inputSchema)) return false;
                if (!name.equals(that.name)) return false;
                return this.outputSchema != null ? this.outputSchema.equals(that.outputSchema) : that.outputSchema == null;
            }

            @Override
            public final int hashCode() {
                int result = this.description.hashCode();
                result = 31 * result + (this.inputSchema.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.outputSchema != null ? this.outputSchema.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The tool schema for the gateway target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrockagentcore.*;
     * SchemaDefinitionProperty schemaDefinitionProperty_;
     * ToolSchemaProperty toolSchemaProperty = ToolSchemaProperty.builder()
     *         .inlinePayload(List.of(ToolDefinitionProperty.builder()
     *                 .description("description")
     *                 .inputSchema(SchemaDefinitionProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .description("description")
     *                         .items(schemaDefinitionProperty_)
     *                         .properties(Map.of(
     *                                 "propertiesKey", schemaDefinitionProperty_))
     *                         .required(List.of("required"))
     *                         .build())
     *                 .name("name")
     *                 // the properties below are optional
     *                 .outputSchema(SchemaDefinitionProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .description("description")
     *                         .items(schemaDefinitionProperty_)
     *                         .properties(Map.of(
     *                                 "propertiesKey", schemaDefinitionProperty_))
     *                         .required(List.of("required"))
     *                         .build())
     *                 .build()))
     *         .s3(S3ConfigurationProperty.builder()
     *                 .bucketOwnerAccountId("bucketOwnerAccountId")
     *                 .uri("uri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-toolschema.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-toolschema.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.ToolSchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(ToolSchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ToolSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The inline payload for the gateway target.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.ToolDefinitionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-toolschema.html#cfn-bedrockagentcore-gatewaytarget-toolschema-inlinepayload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-toolschema.html#cfn-bedrockagentcore-gatewaytarget-toolschema-inlinepayload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInlinePayload() {
            return null;
        }

        /**
         * The S3 tool schema for the gateway target.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.S3ConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-toolschema.html#cfn-bedrockagentcore-gatewaytarget-toolschema-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrockagentcore-gatewaytarget-toolschema.html#cfn-bedrockagentcore-gatewaytarget-toolschema-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ToolSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ToolSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ToolSchemaProperty> {
            java.lang.Object inlinePayload;
            java.lang.Object s3;

            /**
             * Sets the value of {@link ToolSchemaProperty#getInlinePayload}
             * @param inlinePayload The inline payload for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inlinePayload(software.amazon.awscdk.IResolvable inlinePayload) {
                this.inlinePayload = inlinePayload;
                return this;
            }

            /**
             * Sets the value of {@link ToolSchemaProperty#getInlinePayload}
             * @param inlinePayload The inline payload for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inlinePayload(java.util.List<? extends java.lang.Object> inlinePayload) {
                this.inlinePayload = inlinePayload;
                return this;
            }

            /**
             * Sets the value of {@link ToolSchemaProperty#getS3}
             * @param s3 The S3 tool schema for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link ToolSchemaProperty#getS3}
             * @param s3 The S3 tool schema for the gateway target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.S3ConfigurationProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ToolSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ToolSchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ToolSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ToolSchemaProperty {
            private final java.lang.Object inlinePayload;
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inlinePayload = software.amazon.jsii.Kernel.get(this, "inlinePayload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inlinePayload = builder.inlinePayload;
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.Object getInlinePayload() {
                return this.inlinePayload;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInlinePayload() != null) {
                    data.set("inlinePayload", om.valueToTree(this.getInlinePayload()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnGatewayTarget.ToolSchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ToolSchemaProperty.Jsii$Proxy that = (ToolSchemaProperty.Jsii$Proxy) o;

                if (this.inlinePayload != null ? !this.inlinePayload.equals(that.inlinePayload) : that.inlinePayload != null) return false;
                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inlinePayload != null ? this.inlinePayload.hashCode() : 0;
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTargetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTargetProps.Builder();
        }

        /**
         * The OAuth credential provider configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-credentialproviderconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-credentialproviderconfigurations</a>
         * @param credentialProviderConfigurations The OAuth credential provider configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialProviderConfigurations(final software.amazon.awscdk.IResolvable credentialProviderConfigurations) {
            this.props.credentialProviderConfigurations(credentialProviderConfigurations);
            return this;
        }
        /**
         * The OAuth credential provider configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-credentialproviderconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-credentialproviderconfigurations</a>
         * @param credentialProviderConfigurations The OAuth credential provider configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialProviderConfigurations(final java.util.List<? extends java.lang.Object> credentialProviderConfigurations) {
            this.props.credentialProviderConfigurations(credentialProviderConfigurations);
            return this;
        }

        /**
         * The name for the gateway target.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-name</a>
         * @param name The name for the gateway target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The target configuration for the Smithy model target.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-targetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-targetconfiguration</a>
         * @param targetConfiguration The target configuration for the Smithy model target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetConfiguration(final software.amazon.awscdk.IResolvable targetConfiguration) {
            this.props.targetConfiguration(targetConfiguration);
            return this;
        }
        /**
         * The target configuration for the Smithy model target.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-targetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-targetconfiguration</a>
         * @param targetConfiguration The target configuration for the Smithy model target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetConfiguration(final software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget.TargetConfigurationProperty targetConfiguration) {
            this.props.targetConfiguration(targetConfiguration);
            return this;
        }

        /**
         * The description for the gateway target.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-description</a>
         * @param description The description for the gateway target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The gateway ID for the gateway target.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-gatewayidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-gatewaytarget.html#cfn-bedrockagentcore-gatewaytarget-gatewayidentifier</a>
         * @param gatewayIdentifier The gateway ID for the gateway target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayIdentifier(final java.lang.String gatewayIdentifier) {
            this.props.gatewayIdentifier(gatewayIdentifier);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget build() {
            return new software.amazon.awscdk.services.bedrockagentcore.CfnGatewayTarget(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
