package software.amazon.awscdk.services.bedrockagentcore;

/**
 * Properties for defining a <code>CfnMemory</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrockagentcore.*;
 * CfnMemoryProps cfnMemoryProps = CfnMemoryProps.builder()
 *         .eventExpiryDuration(123)
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .encryptionKeyArn("encryptionKeyArn")
 *         .memoryExecutionRoleArn("memoryExecutionRoleArn")
 *         .memoryStrategies(List.of(MemoryStrategyProperty.builder()
 *                 .customMemoryStrategy(CustomMemoryStrategyProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .configuration(CustomConfigurationInputProperty.builder()
 *                                 .selfManagedConfiguration(SelfManagedConfigurationProperty.builder()
 *                                         .historicalContextWindowSize(123)
 *                                         .invocationConfiguration(InvocationConfigurationInputProperty.builder()
 *                                                 .payloadDeliveryBucketName("payloadDeliveryBucketName")
 *                                                 .topicArn("topicArn")
 *                                                 .build())
 *                                         .triggerConditions(List.of(TriggerConditionInputProperty.builder()
 *                                                 .messageBasedTrigger(MessageBasedTriggerInputProperty.builder()
 *                                                         .messageCount(123)
 *                                                         .build())
 *                                                 .timeBasedTrigger(TimeBasedTriggerInputProperty.builder()
 *                                                         .idleSessionTimeout(123)
 *                                                         .build())
 *                                                 .tokenBasedTrigger(TokenBasedTriggerInputProperty.builder()
 *                                                         .tokenCount(123)
 *                                                         .build())
 *                                                 .build()))
 *                                         .build())
 *                                 .semanticOverride(SemanticOverrideProperty.builder()
 *                                         .consolidation(SemanticOverrideConsolidationConfigurationInputProperty.builder()
 *                                                 .appendToPrompt("appendToPrompt")
 *                                                 .modelId("modelId")
 *                                                 .build())
 *                                         .extraction(SemanticOverrideExtractionConfigurationInputProperty.builder()
 *                                                 .appendToPrompt("appendToPrompt")
 *                                                 .modelId("modelId")
 *                                                 .build())
 *                                         .build())
 *                                 .summaryOverride(SummaryOverrideProperty.builder()
 *                                         .consolidation(SummaryOverrideConsolidationConfigurationInputProperty.builder()
 *                                                 .appendToPrompt("appendToPrompt")
 *                                                 .modelId("modelId")
 *                                                 .build())
 *                                         .build())
 *                                 .userPreferenceOverride(UserPreferenceOverrideProperty.builder()
 *                                         .consolidation(UserPreferenceOverrideConsolidationConfigurationInputProperty.builder()
 *                                                 .appendToPrompt("appendToPrompt")
 *                                                 .modelId("modelId")
 *                                                 .build())
 *                                         .extraction(UserPreferenceOverrideExtractionConfigurationInputProperty.builder()
 *                                                 .appendToPrompt("appendToPrompt")
 *                                                 .modelId("modelId")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .createdAt("createdAt")
 *                         .description("description")
 *                         .namespaces(List.of("namespaces"))
 *                         .status("status")
 *                         .strategyId("strategyId")
 *                         .type("type")
 *                         .updatedAt("updatedAt")
 *                         .build())
 *                 .semanticMemoryStrategy(SemanticMemoryStrategyProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .createdAt("createdAt")
 *                         .description("description")
 *                         .namespaces(List.of("namespaces"))
 *                         .status("status")
 *                         .strategyId("strategyId")
 *                         .type("type")
 *                         .updatedAt("updatedAt")
 *                         .build())
 *                 .summaryMemoryStrategy(SummaryMemoryStrategyProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .createdAt("createdAt")
 *                         .description("description")
 *                         .namespaces(List.of("namespaces"))
 *                         .status("status")
 *                         .strategyId("strategyId")
 *                         .type("type")
 *                         .updatedAt("updatedAt")
 *                         .build())
 *                 .userPreferenceMemoryStrategy(UserPreferenceMemoryStrategyProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .createdAt("createdAt")
 *                         .description("description")
 *                         .namespaces(List.of("namespaces"))
 *                         .status("status")
 *                         .strategyId("strategyId")
 *                         .type("type")
 *                         .updatedAt("updatedAt")
 *                         .build())
 *                 .build()))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:15.680Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnMemoryProps")
@software.amazon.jsii.Jsii.Proxy(CfnMemoryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMemoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The event expiry configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-eventexpiryduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-eventexpiryduration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getEventExpiryDuration();

    /**
     * The memory name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Description of the Memory resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The memory encryption key Amazon Resource Name (ARN).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-encryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-encryptionkeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyArn() {
        return null;
    }

    /**
     * The memory role ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-memoryexecutionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-memoryexecutionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMemoryExecutionRoleArn() {
        return null;
    }

    /**
     * The memory strategies.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnMemory.MemoryStrategyProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-memorystrategies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-memorystrategies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryStrategies() {
        return null;
    }

    /**
     * The tags for the resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-memory.html#cfn-bedrockagentcore-memory-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMemoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMemoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMemoryProps> {
        java.lang.Number eventExpiryDuration;
        java.lang.String name;
        java.lang.String description;
        java.lang.String encryptionKeyArn;
        java.lang.String memoryExecutionRoleArn;
        java.lang.Object memoryStrategies;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnMemoryProps#getEventExpiryDuration}
         * @param eventExpiryDuration The event expiry configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventExpiryDuration(java.lang.Number eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemoryProps#getName}
         * @param name The memory name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemoryProps#getDescription}
         * @param description Description of the Memory resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemoryProps#getEncryptionKeyArn}
         * @param encryptionKeyArn The memory encryption key Amazon Resource Name (ARN).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKeyArn(java.lang.String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemoryProps#getMemoryExecutionRoleArn}
         * @param memoryExecutionRoleArn The memory role ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryExecutionRoleArn(java.lang.String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemoryProps#getMemoryStrategies}
         * @param memoryStrategies The memory strategies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryStrategies(software.amazon.awscdk.IResolvable memoryStrategies) {
            this.memoryStrategies = memoryStrategies;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemoryProps#getMemoryStrategies}
         * @param memoryStrategies The memory strategies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryStrategies(java.util.List<? extends java.lang.Object> memoryStrategies) {
            this.memoryStrategies = memoryStrategies;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemoryProps#getTags}
         * @param tags The tags for the resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMemoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMemoryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMemoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMemoryProps {
        private final java.lang.Number eventExpiryDuration;
        private final java.lang.String name;
        private final java.lang.String description;
        private final java.lang.String encryptionKeyArn;
        private final java.lang.String memoryExecutionRoleArn;
        private final java.lang.Object memoryStrategies;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventExpiryDuration = software.amazon.jsii.Kernel.get(this, "eventExpiryDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKeyArn = software.amazon.jsii.Kernel.get(this, "encryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.memoryExecutionRoleArn = software.amazon.jsii.Kernel.get(this, "memoryExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.memoryStrategies = software.amazon.jsii.Kernel.get(this, "memoryStrategies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventExpiryDuration = java.util.Objects.requireNonNull(builder.eventExpiryDuration, "eventExpiryDuration is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.description = builder.description;
            this.encryptionKeyArn = builder.encryptionKeyArn;
            this.memoryExecutionRoleArn = builder.memoryExecutionRoleArn;
            this.memoryStrategies = builder.memoryStrategies;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Number getEventExpiryDuration() {
            return this.eventExpiryDuration;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        @Override
        public final java.lang.String getMemoryExecutionRoleArn() {
            return this.memoryExecutionRoleArn;
        }

        @Override
        public final java.lang.Object getMemoryStrategies() {
            return this.memoryStrategies;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventExpiryDuration", om.valueToTree(this.getEventExpiryDuration()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEncryptionKeyArn() != null) {
                data.set("encryptionKeyArn", om.valueToTree(this.getEncryptionKeyArn()));
            }
            if (this.getMemoryExecutionRoleArn() != null) {
                data.set("memoryExecutionRoleArn", om.valueToTree(this.getMemoryExecutionRoleArn()));
            }
            if (this.getMemoryStrategies() != null) {
                data.set("memoryStrategies", om.valueToTree(this.getMemoryStrategies()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnMemoryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMemoryProps.Jsii$Proxy that = (CfnMemoryProps.Jsii$Proxy) o;

            if (!eventExpiryDuration.equals(that.eventExpiryDuration)) return false;
            if (!name.equals(that.name)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.encryptionKeyArn != null ? !this.encryptionKeyArn.equals(that.encryptionKeyArn) : that.encryptionKeyArn != null) return false;
            if (this.memoryExecutionRoleArn != null ? !this.memoryExecutionRoleArn.equals(that.memoryExecutionRoleArn) : that.memoryExecutionRoleArn != null) return false;
            if (this.memoryStrategies != null ? !this.memoryStrategies.equals(that.memoryStrategies) : that.memoryStrategies != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventExpiryDuration.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.encryptionKeyArn != null ? this.encryptionKeyArn.hashCode() : 0);
            result = 31 * result + (this.memoryExecutionRoleArn != null ? this.memoryExecutionRoleArn.hashCode() : 0);
            result = 31 * result + (this.memoryStrategies != null ? this.memoryStrategies.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
