package software.amazon.awscdk.services.bedrockagentcore;

/**
 * Properties for defining a <code>CfnRuntime</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrockagentcore.*;
 * CfnRuntimeProps cfnRuntimeProps = CfnRuntimeProps.builder()
 *         .agentRuntimeArtifact(AgentRuntimeArtifactProperty.builder()
 *                 .codeConfiguration(CodeConfigurationProperty.builder()
 *                         .code(CodeProperty.builder()
 *                                 .s3(S3LocationProperty.builder()
 *                                         .bucket("bucket")
 *                                         .prefix("prefix")
 *                                         // the properties below are optional
 *                                         .versionId("versionId")
 *                                         .build())
 *                                 .build())
 *                         .entryPoint(List.of("entryPoint"))
 *                         .runtime("runtime")
 *                         .build())
 *                 .containerConfiguration(ContainerConfigurationProperty.builder()
 *                         .containerUri("containerUri")
 *                         .build())
 *                 .build())
 *         .agentRuntimeName("agentRuntimeName")
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .networkMode("networkMode")
 *                 // the properties below are optional
 *                 .networkModeConfig(VpcConfigProperty.builder()
 *                         .securityGroups(List.of("securityGroups"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .authorizerConfiguration(AuthorizerConfigurationProperty.builder()
 *                 .customJwtAuthorizer(CustomJWTAuthorizerConfigurationProperty.builder()
 *                         .discoveryUrl("discoveryUrl")
 *                         // the properties below are optional
 *                         .allowedAudience(List.of("allowedAudience"))
 *                         .allowedClients(List.of("allowedClients"))
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .environmentVariables(Map.of(
 *                 "environmentVariablesKey", "environmentVariables"))
 *         .lifecycleConfiguration(LifecycleConfigurationProperty.builder()
 *                 .idleRuntimeSessionTimeout(123)
 *                 .maxLifetime(123)
 *                 .build())
 *         .protocolConfiguration("protocolConfiguration")
 *         .requestHeaderConfiguration(RequestHeaderConfigurationProperty.builder()
 *                 .requestHeaderAllowlist(List.of("requestHeaderAllowlist"))
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:15.689Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrockagentcore.CfnRuntimeProps")
@software.amazon.jsii.Jsii.Proxy(CfnRuntimeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRuntimeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The artifact of the agent.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnRuntime.AgentRuntimeArtifactProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-agentruntimeartifact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-agentruntimeartifact</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAgentRuntimeArtifact();

    /**
     * The name of the AgentCore Runtime endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-agentruntimename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-agentruntimename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgentRuntimeName();

    /**
     * The network configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnRuntime.NetworkConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-networkconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getNetworkConfiguration();

    /**
     * The Amazon Resource Name (ARN) for for the role.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * Represents inbound authorization configuration options used to authenticate incoming requests.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnRuntime.AuthorizerConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-authorizerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-authorizerconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizerConfiguration() {
        return null;
    }

    /**
     * The agent runtime description.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The environment variables for the agent.
     * <p>
     * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-environmentvariables</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
        return null;
    }

    /**
     * Configuration for managing the lifecycle of runtime sessions and resources.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnRuntime.LifecycleConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-lifecycleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-lifecycleconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLifecycleConfiguration() {
        return null;
    }

    /**
     * The protocol configuration for an agent runtime.
     * <p>
     * This structure defines how the agent runtime communicates with clients.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-protocolconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-protocolconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProtocolConfiguration() {
        return null;
    }

    /**
     * Configuration for HTTP request headers.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.bedrockagentcore.CfnRuntime.RequestHeaderConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-requestheaderconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-requestheaderconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRequestHeaderConfiguration() {
        return null;
    }

    /**
     * The tags for the agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrockagentcore-runtime.html#cfn-bedrockagentcore-runtime-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRuntimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRuntimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRuntimeProps> {
        java.lang.Object agentRuntimeArtifact;
        java.lang.String agentRuntimeName;
        java.lang.Object networkConfiguration;
        java.lang.String roleArn;
        java.lang.Object authorizerConfiguration;
        java.lang.String description;
        java.lang.Object environmentVariables;
        java.lang.Object lifecycleConfiguration;
        java.lang.String protocolConfiguration;
        java.lang.Object requestHeaderConfiguration;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnRuntimeProps#getAgentRuntimeArtifact}
         * @param agentRuntimeArtifact The artifact of the agent. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentRuntimeArtifact(software.amazon.awscdk.IResolvable agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getAgentRuntimeArtifact}
         * @param agentRuntimeArtifact The artifact of the agent. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentRuntimeArtifact(software.amazon.awscdk.services.bedrockagentcore.CfnRuntime.AgentRuntimeArtifactProperty agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getAgentRuntimeName}
         * @param agentRuntimeName The name of the AgentCore Runtime endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentRuntimeName(java.lang.String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getNetworkConfiguration}
         * @param networkConfiguration The network configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getNetworkConfiguration}
         * @param networkConfiguration The network configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.services.bedrockagentcore.CfnRuntime.NetworkConfigurationProperty networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) for for the role. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getAuthorizerConfiguration}
         * @param authorizerConfiguration Represents inbound authorization configuration options used to authenticate incoming requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfiguration(software.amazon.awscdk.IResolvable authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getAuthorizerConfiguration}
         * @param authorizerConfiguration Represents inbound authorization configuration options used to authenticate incoming requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerConfiguration(software.amazon.awscdk.services.bedrockagentcore.CfnRuntime.AuthorizerConfigurationProperty authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getDescription}
         * @param description The agent runtime description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getEnvironmentVariables}
         * @param environmentVariables The environment variables for the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getEnvironmentVariables}
         * @param environmentVariables The environment variables for the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(software.amazon.awscdk.IResolvable environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getLifecycleConfiguration}
         * @param lifecycleConfiguration Configuration for managing the lifecycle of runtime sessions and resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(software.amazon.awscdk.IResolvable lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getLifecycleConfiguration}
         * @param lifecycleConfiguration Configuration for managing the lifecycle of runtime sessions and resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(software.amazon.awscdk.services.bedrockagentcore.CfnRuntime.LifecycleConfigurationProperty lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getProtocolConfiguration}
         * @param protocolConfiguration The protocol configuration for an agent runtime.
         *                              This structure defines how the agent runtime communicates with clients.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolConfiguration(java.lang.String protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getRequestHeaderConfiguration}
         * @param requestHeaderConfiguration Configuration for HTTP request headers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestHeaderConfiguration(software.amazon.awscdk.IResolvable requestHeaderConfiguration) {
            this.requestHeaderConfiguration = requestHeaderConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getRequestHeaderConfiguration}
         * @param requestHeaderConfiguration Configuration for HTTP request headers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestHeaderConfiguration(software.amazon.awscdk.services.bedrockagentcore.CfnRuntime.RequestHeaderConfigurationProperty requestHeaderConfiguration) {
            this.requestHeaderConfiguration = requestHeaderConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuntimeProps#getTags}
         * @param tags The tags for the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRuntimeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRuntimeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRuntimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRuntimeProps {
        private final java.lang.Object agentRuntimeArtifact;
        private final java.lang.String agentRuntimeName;
        private final java.lang.Object networkConfiguration;
        private final java.lang.String roleArn;
        private final java.lang.Object authorizerConfiguration;
        private final java.lang.String description;
        private final java.lang.Object environmentVariables;
        private final java.lang.Object lifecycleConfiguration;
        private final java.lang.String protocolConfiguration;
        private final java.lang.Object requestHeaderConfiguration;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.agentRuntimeArtifact = software.amazon.jsii.Kernel.get(this, "agentRuntimeArtifact", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.agentRuntimeName = software.amazon.jsii.Kernel.get(this, "agentRuntimeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerConfiguration = software.amazon.jsii.Kernel.get(this, "authorizerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lifecycleConfiguration = software.amazon.jsii.Kernel.get(this, "lifecycleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.protocolConfiguration = software.amazon.jsii.Kernel.get(this, "protocolConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requestHeaderConfiguration = software.amazon.jsii.Kernel.get(this, "requestHeaderConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.agentRuntimeArtifact = java.util.Objects.requireNonNull(builder.agentRuntimeArtifact, "agentRuntimeArtifact is required");
            this.agentRuntimeName = java.util.Objects.requireNonNull(builder.agentRuntimeName, "agentRuntimeName is required");
            this.networkConfiguration = java.util.Objects.requireNonNull(builder.networkConfiguration, "networkConfiguration is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.authorizerConfiguration = builder.authorizerConfiguration;
            this.description = builder.description;
            this.environmentVariables = builder.environmentVariables;
            this.lifecycleConfiguration = builder.lifecycleConfiguration;
            this.protocolConfiguration = builder.protocolConfiguration;
            this.requestHeaderConfiguration = builder.requestHeaderConfiguration;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getAgentRuntimeArtifact() {
            return this.agentRuntimeArtifact;
        }

        @Override
        public final java.lang.String getAgentRuntimeName() {
            return this.agentRuntimeName;
        }

        @Override
        public final java.lang.Object getNetworkConfiguration() {
            return this.networkConfiguration;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getAuthorizerConfiguration() {
            return this.authorizerConfiguration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final java.lang.Object getLifecycleConfiguration() {
            return this.lifecycleConfiguration;
        }

        @Override
        public final java.lang.String getProtocolConfiguration() {
            return this.protocolConfiguration;
        }

        @Override
        public final java.lang.Object getRequestHeaderConfiguration() {
            return this.requestHeaderConfiguration;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("agentRuntimeArtifact", om.valueToTree(this.getAgentRuntimeArtifact()));
            data.set("agentRuntimeName", om.valueToTree(this.getAgentRuntimeName()));
            data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getAuthorizerConfiguration() != null) {
                data.set("authorizerConfiguration", om.valueToTree(this.getAuthorizerConfiguration()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getLifecycleConfiguration() != null) {
                data.set("lifecycleConfiguration", om.valueToTree(this.getLifecycleConfiguration()));
            }
            if (this.getProtocolConfiguration() != null) {
                data.set("protocolConfiguration", om.valueToTree(this.getProtocolConfiguration()));
            }
            if (this.getRequestHeaderConfiguration() != null) {
                data.set("requestHeaderConfiguration", om.valueToTree(this.getRequestHeaderConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrockagentcore.CfnRuntimeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRuntimeProps.Jsii$Proxy that = (CfnRuntimeProps.Jsii$Proxy) o;

            if (!agentRuntimeArtifact.equals(that.agentRuntimeArtifact)) return false;
            if (!agentRuntimeName.equals(that.agentRuntimeName)) return false;
            if (!networkConfiguration.equals(that.networkConfiguration)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.authorizerConfiguration != null ? !this.authorizerConfiguration.equals(that.authorizerConfiguration) : that.authorizerConfiguration != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.lifecycleConfiguration != null ? !this.lifecycleConfiguration.equals(that.lifecycleConfiguration) : that.lifecycleConfiguration != null) return false;
            if (this.protocolConfiguration != null ? !this.protocolConfiguration.equals(that.protocolConfiguration) : that.protocolConfiguration != null) return false;
            if (this.requestHeaderConfiguration != null ? !this.requestHeaderConfiguration.equals(that.requestHeaderConfiguration) : that.requestHeaderConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.agentRuntimeArtifact.hashCode();
            result = 31 * result + (this.agentRuntimeName.hashCode());
            result = 31 * result + (this.networkConfiguration.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.authorizerConfiguration != null ? this.authorizerConfiguration.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.lifecycleConfiguration != null ? this.lifecycleConfiguration.hashCode() : 0);
            result = 31 * result + (this.protocolConfiguration != null ? this.protocolConfiguration.hashCode() : 0);
            result = 31 * result + (this.requestHeaderConfiguration != null ? this.requestHeaderConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
