package software.amazon.awscdk.services.certificatemanager;

/**
 * (deprecated) A certificate managed by AWS Certificate Manager.
 * <p>
 * Will be automatically
 * validated using DNS validation against the specified Route 53 hosted zone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.route53.*;
 * CertificateValidation certificateValidation;
 * HostedZone hostedZone;
 * KeyAlgorithm keyAlgorithm;
 * Role role;
 * DnsValidatedCertificate dnsValidatedCertificate = DnsValidatedCertificate.Builder.create(this, "MyDnsValidatedCertificate")
 *         .domainName("domainName")
 *         .hostedZone(hostedZone)
 *         // the properties below are optional
 *         .allowExport(false)
 *         .certificateName("certificateName")
 *         .cleanupRoute53Records(false)
 *         .customResourceRole(role)
 *         .keyAlgorithm(keyAlgorithm)
 *         .region("region")
 *         .route53Endpoint("route53Endpoint")
 *         .subjectAlternativeNames(List.of("subjectAlternativeNames"))
 *         .transparencyLoggingEnabled(false)
 *         .validation(certificateValidation)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @deprecated use {@link Certificate } instead
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:15.809Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
@Deprecated
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_certificatemanager.DnsValidatedCertificate")
public class DnsValidatedCertificate extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.certificatemanager.ICertificate, software.amazon.awscdk.ITaggable {

    protected DnsValidatedCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DnsValidatedCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public DnsValidatedCertificate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (deprecated) Apply the given removal policy to this resource.
     * <p>
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     * <p>
     * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
     * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
     * <p>
     * @param policy This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
        software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * (deprecated) Return the DaysToExpiry metric for this AWS Certificate Manager Certificate. By default, this is the minimum value over 1 day.
     * <p>
     * This metric is no longer emitted once the certificate has effectively
     * expired, so alarms configured on this metric should probably treat missing
     * data as "breaching".
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDaysToExpiry(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricDaysToExpiry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (deprecated) Return the DaysToExpiry metric for this AWS Certificate Manager Certificate. By default, this is the minimum value over 1 day.
     * <p>
     * This metric is no longer emitted once the certificate has effectively
     * expired, so alarms configured on this metric should probably treat missing
     * data as "breaching".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDaysToExpiry() {
        return software.amazon.jsii.Kernel.call(this, "metricDaysToExpiry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (deprecated) Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * (deprecated) The certificate's ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull java.lang.String getCertificateArn() {
        return software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) Resource Tags.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-tags">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-tags</a>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * (deprecated) If the certificate is provisionned in a different region than the containing stack, this should be the region in which the certificate lives so we can correctly create <code>Metric</code> instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) A fluent builder for {@link software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps.Builder();
        }

        /**
         * Fully-qualified domain name to request a certificate for.
         * <p>
         * May contain wildcards, such as <code>*.domain.com</code>.
         * <p>
         * @return {@code this}
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * Enable or disable export of this certificate.
         * <p>
         * If you issue an exportable public certificate, there is a charge at certificate issuance and again when the certificate renews.
         * Ref: https://aws.amazon.com/certificate-manager/pricing
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param allowExport Enable or disable export of this certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowExport(final java.lang.Boolean allowExport) {
            this.props.allowExport(allowExport);
            return this;
        }

        /**
         * The Certificate name.
         * <p>
         * Since the Certificate resource doesn't support providing a physical name, the value provided here will be recorded in the <code>Name</code> tag
         * <p>
         * Default: the full, absolute path of this construct
         * <p>
         * @return {@code this}
         * @param certificateName The Certificate name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateName(final java.lang.String certificateName) {
            this.props.certificateName(certificateName);
            return this;
        }

        /**
         * Specifies the algorithm of the public and private key pair that your certificate uses to encrypt data.
         * <p>
         * Default: KeyAlgorithm.RSA_2048
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-certificate.html#algorithms.title">https://docs.aws.amazon.com/acm/latest/userguide/acm-certificate.html#algorithms.title</a>
         * @param keyAlgorithm Specifies the algorithm of the public and private key pair that your certificate uses to encrypt data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyAlgorithm(final software.amazon.awscdk.services.certificatemanager.KeyAlgorithm keyAlgorithm) {
            this.props.keyAlgorithm(keyAlgorithm);
            return this;
        }

        /**
         * Alternative domain names on your certificate.
         * <p>
         * Use this to register alternative domain names that represent the same site.
         * <p>
         * Default: - No additional FQDNs will be included as alternative domain names.
         * <p>
         * @return {@code this}
         * @param subjectAlternativeNames Alternative domain names on your certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(final java.util.List<java.lang.String> subjectAlternativeNames) {
            this.props.subjectAlternativeNames(subjectAlternativeNames);
            return this;
        }

        /**
         * Enable or disable transparency logging for this certificate.
         * <p>
         * Once a certificate has been logged, it cannot be removed from the log.
         * Opting out at that point will have no effect. If you opt out of logging
         * when you request a certificate and then choose later to opt back in,
         * your certificate will not be logged until it is renewed.
         * If you want the certificate to be logged immediately, we recommend that you issue a new one.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency">https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency</a>
         * @param transparencyLoggingEnabled Enable or disable transparency logging for this certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transparencyLoggingEnabled(final java.lang.Boolean transparencyLoggingEnabled) {
            this.props.transparencyLoggingEnabled(transparencyLoggingEnabled);
            return this;
        }

        /**
         * How to validate this certificate.
         * <p>
         * Default: CertificateValidation.fromEmail()
         * <p>
         * @return {@code this}
         * @param validation How to validate this certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validation(final software.amazon.awscdk.services.certificatemanager.CertificateValidation validation) {
            this.props.validation(validation);
            return this;
        }

        /**
         * Route 53 Hosted Zone used to perform DNS validation of the request.
         * <p>
         * The zone
         * must be authoritative for the domain name specified in the Certificate Request.
         * <p>
         * @return {@code this}
         * @param hostedZone Route 53 Hosted Zone used to perform DNS validation of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZone(final software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.props.hostedZone(hostedZone);
            return this;
        }

        /**
         * When set to true, when the DnsValidatedCertificate is deleted, the associated Route53 validation records are removed.
         * <p>
         * CAUTION: If multiple certificates share the same domains (and same validation records),
         * this can cause the other certificates to fail renewal and/or not validate.
         * Not recommended for production use.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param cleanupRoute53Records When set to true, when the DnsValidatedCertificate is deleted, the associated Route53 validation records are removed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cleanupRoute53Records(final java.lang.Boolean cleanupRoute53Records) {
            this.props.cleanupRoute53Records(cleanupRoute53Records);
            return this;
        }

        /**
         * Role to use for the custom resource that creates the validated certificate.
         * <p>
         * Default: - A new role will be created
         * <p>
         * @return {@code this}
         * @param customResourceRole Role to use for the custom resource that creates the validated certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customResourceRole(final software.amazon.awscdk.services.iam.IRole customResourceRole) {
            this.props.customResourceRole(customResourceRole);
            return this;
        }

        /**
         * AWS region that will host the certificate.
         * <p>
         * This is needed especially
         * for certificates used for CloudFront distributions, which require the region
         * to be us-east-1.
         * <p>
         * Default: the region the stack is deployed in.
         * <p>
         * @return {@code this}
         * @param region AWS region that will host the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * An endpoint of Route53 service, which is not necessary as AWS SDK could figure out the right endpoints for most regions, but for some regions such as those in aws-cn partition, the default endpoint is not working now, hence the right endpoint need to be specified through this prop.
         * <p>
         * Route53 is not been officially launched in China, it is only available for AWS
         * internal accounts now. To make DnsValidatedCertificate work for internal accounts
         * now, a special endpoint needs to be provided.
         * <p>
         * Default: - The AWS SDK will determine the Route53 endpoint to use based on region
         * <p>
         * @return {@code this}
         * @param route53Endpoint An endpoint of Route53 service, which is not necessary as AWS SDK could figure out the right endpoints for most regions, but for some regions such as those in aws-cn partition, the default endpoint is not working now, hence the right endpoint need to be specified through this prop. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder route53Endpoint(final java.lang.String route53Endpoint) {
            this.props.route53Endpoint(route53Endpoint);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @Override
        public software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate build() {
            return new software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
