package software.amazon.awscdk.services.cloudfront;

/**
 * The level of permissions granted to the CloudFront Distribution when configuring OAC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create the simple Origin
 * Bucket myBucket = new Bucket(this, "myBucket");
 * IOrigin s3Origin = S3BucketOrigin.withOriginAccessControl(myBucket, S3BucketOriginWithOACProps.builder()
 *         .originAccessLevels(List.of(AccessLevel.READ, AccessLevel.LIST))
 *         .build());
 * // Create the Distribution construct
 * Distribution myMultiTenantDistribution = Distribution.Builder.create(this, "distribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(s3Origin)
 *                 .build())
 *         .defaultRootObject("index.html")
 *         .build();
 * // Access the underlying L1 CfnDistribution to configure SaaS Manager properties which are not yet available in the L2 Distribution construct
 * CfnDistribution cfnDistribution = (CfnDistribution)myMultiTenantDistribution.getNode().getDefaultChild();
 * DefaultCacheBehaviorProperty defaultCacheBehavior = DefaultCacheBehaviorProperty.builder()
 *         .targetOriginId(myBucket.getBucketArn())
 *         .viewerProtocolPolicy("allow-all")
 *         .compress(false)
 *         .allowedMethods(List.of("GET", "HEAD"))
 *         .cachePolicyId(CachePolicy.CACHING_OPTIMIZED.getCachePolicyId())
 *         .build();
 * // Create the updated distributionConfig
 * DistributionConfigProperty distributionConfig = DistributionConfigProperty.builder()
 *         .defaultCacheBehavior(defaultCacheBehavior)
 *         .enabled(true)
 *         // the properties below are optional
 *         .connectionMode("tenant-only")
 *         .origins(List.of(OriginProperty.builder()
 *                 .id(myBucket.getBucketArn())
 *                 .domainName(myBucket.getBucketDomainName())
 *                 .s3OriginConfig(S3OriginConfigProperty.builder().build())
 *                 .originPath("/{{tenantName}}")
 *                 .build()))
 *         .tenantConfig(TenantConfigProperty.builder()
 *                 .parameterDefinitions(List.of(ParameterDefinitionProperty.builder()
 *                         .definition(DefinitionProperty.builder()
 *                                 .stringSchema(StringSchemaProperty.builder()
 *                                         .required(false)
 *                                         // the properties below are optional
 *                                         .comment("tenantName")
 *                                         .defaultValue("root")
 *                                         .build())
 *                                 .build())
 *                         .name("tenantName")
 *                         .build()))
 *                 .build())
 *         .build();
 * // Override the distribution configuration to enable multi-tenancy.
 * cfnDistribution.getDistributionConfig() = distributionConfig;
 * // Create a distribution tenant using an existing ACM certificate
 * CfnDistributionTenant cfnDistributionTenant = CfnDistributionTenant.Builder.create(this, "distribution-tenant")
 *         .distributionId(myMultiTenantDistribution.getDistributionId())
 *         .domains(List.of("my-tenant.my.domain.com"))
 *         .name("my-tenant")
 *         .enabled(true)
 *         .parameters(List.of(ParameterProperty.builder()
 *                 .name("tenantName")
 *                 .value("app")
 *                 .build()))
 *         .customizations(CustomizationsProperty.builder()
 *                 .certificate(CertificateProperty.builder()
 *                         .arn("REPLACE_WITH_ARN")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.028Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.AccessLevel")
public enum AccessLevel {
    /**
     * Grants read permissions to CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    READ,
    /**
     * Grants versioned read permissions to CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    READ_VERSIONED,
    /**
     * Grants list permissions to CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LIST,
    /**
     * Grants write permission to CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WRITE,
    /**
     * Grants delete permission to CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELETE,
}
