package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a <code>CfnConnectionFunction</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnConnectionFunctionProps cfnConnectionFunctionProps = CfnConnectionFunctionProps.builder()
 *         .connectionFunctionCode("connectionFunctionCode")
 *         .connectionFunctionConfig(ConnectionFunctionConfigProperty.builder()
 *                 .comment("comment")
 *                 .runtime("runtime")
 *                 // the properties below are optional
 *                 .keyValueStoreAssociations(List.of(KeyValueStoreAssociationProperty.builder()
 *                         .keyValueStoreArn("keyValueStoreArn")
 *                         .build()))
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .autoPublish(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.065Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnConnectionFunctionProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectionFunctionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectionFunctionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The code for the connection function.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html#cfn-cloudfront-connectionfunction-connectionfunctioncode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html#cfn-cloudfront-connectionfunction-connectionfunctioncode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectionFunctionCode();

    /**
     * Contains configuration information about a CloudFront function.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.cloudfront.CfnConnectionFunction.ConnectionFunctionConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html#cfn-cloudfront-connectionfunction-connectionfunctionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html#cfn-cloudfront-connectionfunction-connectionfunctionconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConnectionFunctionConfig();

    /**
     * The connection function name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html#cfn-cloudfront-connectionfunction-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html#cfn-cloudfront-connectionfunction-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A flag that determines whether to automatically publish the function to the <code>LIVE</code> stage when it’s created.
     * <p>
     * To automatically publish to the <code>LIVE</code> stage, set this property to <code>true</code> .
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html#cfn-cloudfront-connectionfunction-autopublish">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html#cfn-cloudfront-connectionfunction-autopublish</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoPublish() {
        return null;
    }

    /**
     * A complex type that contains zero or more <code>Tag</code> elements.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html#cfn-cloudfront-connectionfunction-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectionfunction.html#cfn-cloudfront-connectionfunction-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectionFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectionFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectionFunctionProps> {
        java.lang.String connectionFunctionCode;
        java.lang.Object connectionFunctionConfig;
        java.lang.String name;
        java.lang.Object autoPublish;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnConnectionFunctionProps#getConnectionFunctionCode}
         * @param connectionFunctionCode The code for the connection function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionFunctionCode(java.lang.String connectionFunctionCode) {
            this.connectionFunctionCode = connectionFunctionCode;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionFunctionProps#getConnectionFunctionConfig}
         * @param connectionFunctionConfig Contains configuration information about a CloudFront function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionFunctionConfig(software.amazon.awscdk.IResolvable connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionFunctionProps#getConnectionFunctionConfig}
         * @param connectionFunctionConfig Contains configuration information about a CloudFront function. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionFunctionConfig(software.amazon.awscdk.services.cloudfront.CfnConnectionFunction.ConnectionFunctionConfigProperty connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionFunctionProps#getName}
         * @param name The connection function name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionFunctionProps#getAutoPublish}
         * @param autoPublish A flag that determines whether to automatically publish the function to the <code>LIVE</code> stage when it’s created.
         *                    To automatically publish to the <code>LIVE</code> stage, set this property to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPublish(java.lang.Boolean autoPublish) {
            this.autoPublish = autoPublish;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionFunctionProps#getAutoPublish}
         * @param autoPublish A flag that determines whether to automatically publish the function to the <code>LIVE</code> stage when it’s created.
         *                    To automatically publish to the <code>LIVE</code> stage, set this property to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPublish(software.amazon.awscdk.IResolvable autoPublish) {
            this.autoPublish = autoPublish;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionFunctionProps#getTags}
         * @param tags A complex type that contains zero or more <code>Tag</code> elements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectionFunctionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectionFunctionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectionFunctionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectionFunctionProps {
        private final java.lang.String connectionFunctionCode;
        private final java.lang.Object connectionFunctionConfig;
        private final java.lang.String name;
        private final java.lang.Object autoPublish;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectionFunctionCode = software.amazon.jsii.Kernel.get(this, "connectionFunctionCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionFunctionConfig = software.amazon.jsii.Kernel.get(this, "connectionFunctionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoPublish = software.amazon.jsii.Kernel.get(this, "autoPublish", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionFunctionCode = java.util.Objects.requireNonNull(builder.connectionFunctionCode, "connectionFunctionCode is required");
            this.connectionFunctionConfig = java.util.Objects.requireNonNull(builder.connectionFunctionConfig, "connectionFunctionConfig is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.autoPublish = builder.autoPublish;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getConnectionFunctionCode() {
            return this.connectionFunctionCode;
        }

        @Override
        public final java.lang.Object getConnectionFunctionConfig() {
            return this.connectionFunctionConfig;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getAutoPublish() {
            return this.autoPublish;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectionFunctionCode", om.valueToTree(this.getConnectionFunctionCode()));
            data.set("connectionFunctionConfig", om.valueToTree(this.getConnectionFunctionConfig()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAutoPublish() != null) {
                data.set("autoPublish", om.valueToTree(this.getAutoPublish()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnConnectionFunctionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectionFunctionProps.Jsii$Proxy that = (CfnConnectionFunctionProps.Jsii$Proxy) o;

            if (!connectionFunctionCode.equals(that.connectionFunctionCode)) return false;
            if (!connectionFunctionConfig.equals(that.connectionFunctionConfig)) return false;
            if (!name.equals(that.name)) return false;
            if (this.autoPublish != null ? !this.autoPublish.equals(that.autoPublish) : that.autoPublish != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectionFunctionCode.hashCode();
            result = 31 * result + (this.connectionFunctionConfig.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.autoPublish != null ? this.autoPublish.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
