package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a <code>CfnConnectionGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.route53.*;
 * // Create the simple Origin
 * Bucket myBucket = new Bucket(this, "myBucket");
 * IOrigin s3Origin = S3BucketOrigin.withOriginAccessControl(myBucket, S3BucketOriginWithOACProps.builder()
 *         .originAccessLevels(List.of(AccessLevel.READ, AccessLevel.LIST))
 *         .build());
 * // Create the Distribution construct
 * Distribution myMultiTenantDistribution = Distribution.Builder.create(this, "cf-hosted-distribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(s3Origin)
 *                 .build())
 *         .defaultRootObject("index.html")
 *         .build();
 * // Access the underlying L1 CfnDistribution to configure SaaS Manager properties which are not yet available in the L2 Distribution construct
 * CfnDistribution cfnDistribution = (CfnDistribution)myMultiTenantDistribution.getNode().getDefaultChild();
 * DefaultCacheBehaviorProperty defaultCacheBehavior = DefaultCacheBehaviorProperty.builder()
 *         .targetOriginId(myBucket.getBucketArn())
 *         .viewerProtocolPolicy("allow-all")
 *         .compress(false)
 *         .allowedMethods(List.of("GET", "HEAD"))
 *         .cachePolicyId(CachePolicy.CACHING_OPTIMIZED.getCachePolicyId())
 *         .build();
 * // Create the updated distributionConfig
 * DistributionConfigProperty distributionConfig = DistributionConfigProperty.builder()
 *         .defaultCacheBehavior(defaultCacheBehavior)
 *         .enabled(true)
 *         // the properties below are optional
 *         .connectionMode("tenant-only")
 *         .origins(List.of(OriginProperty.builder()
 *                 .id(myBucket.getBucketArn())
 *                 .domainName(myBucket.getBucketDomainName())
 *                 .s3OriginConfig(S3OriginConfigProperty.builder().build())
 *                 .originPath("/{{tenantName}}")
 *                 .build()))
 *         .tenantConfig(TenantConfigProperty.builder()
 *                 .parameterDefinitions(List.of(ParameterDefinitionProperty.builder()
 *                         .definition(DefinitionProperty.builder()
 *                                 .stringSchema(StringSchemaProperty.builder()
 *                                         .required(false)
 *                                         // the properties below are optional
 *                                         .comment("tenantName")
 *                                         .defaultValue("root")
 *                                         .build())
 *                                 .build())
 *                         .name("tenantName")
 *                         .build()))
 *                 .build())
 *         .build();
 * // Override the distribution configuration to enable multi-tenancy.
 * cfnDistribution.getDistributionConfig() = distributionConfig;
 * // Create a connection group and a cname record in an existing hosted zone to validate domain ownership
 * CfnConnectionGroup connectionGroup = CfnConnectionGroup.Builder.create(this, "cf-hosted-connection-group")
 *         .enabled(true)
 *         .ipv6Enabled(true)
 *         .name("my-connection-group")
 *         .build();
 * // Import the existing hosted zone info, replacing with your hostedZoneId and zoneName
 * String hostedZoneId = "YOUR_HOSTED_ZONE_ID";
 * String zoneName = "my.domain.com";
 * IHostedZone hostedZone = HostedZone.fromHostedZoneAttributes(this, "hosted-zone", HostedZoneAttributes.builder()
 *         .hostedZoneId(hostedZoneId)
 *         .zoneName(zoneName)
 *         .build());
 * CnameRecord record = CnameRecord.Builder.create(this, "cname-record")
 *         .domainName(connectionGroup.getAttrRoutingEndpoint())
 *         .zone(hostedZone)
 *         .recordName("cf-hosted-tenant.my.domain.com")
 *         .build();
 * // Create the cloudfront-hosted tenant, passing in the previously created connection group
 * CfnDistributionTenant cloudfrontHostedTenant = CfnDistributionTenant.Builder.create(this, "cf-hosted-tenant")
 *         .distributionId(myMultiTenantDistribution.getDistributionId())
 *         .name("cf-hosted-tenant")
 *         .domains(List.of("cf-hosted-tenant.my.domain.com"))
 *         .connectionGroupId(connectionGroup.getAttrId())
 *         .enabled(true)
 *         .managedCertificateRequest(ManagedCertificateRequestProperty.builder()
 *                 .validationTokenHost("cloudfront")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.067Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnConnectionGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectionGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectionGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the connection group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html#cfn-cloudfront-connectiongroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html#cfn-cloudfront-connectiongroup-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The ID of the Anycast static IP list.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html#cfn-cloudfront-connectiongroup-anycastiplistid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html#cfn-cloudfront-connectiongroup-anycastiplistid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAnycastIpListId() {
        return null;
    }

    /**
     * Whether the connection group is enabled.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html#cfn-cloudfront-connectiongroup-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html#cfn-cloudfront-connectiongroup-enabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return null;
    }

    /**
     * IPv6 is enabled for the connection group.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html#cfn-cloudfront-connectiongroup-ipv6enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html#cfn-cloudfront-connectiongroup-ipv6enabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Enabled() {
        return null;
    }

    /**
     * A complex type that contains zero or more <code>Tag</code> elements.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html#cfn-cloudfront-connectiongroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-connectiongroup.html#cfn-cloudfront-connectiongroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectionGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectionGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectionGroupProps> {
        java.lang.String name;
        java.lang.String anycastIpListId;
        java.lang.Object enabled;
        java.lang.Object ipv6Enabled;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnConnectionGroupProps#getName}
         * @param name The name of the connection group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionGroupProps#getAnycastIpListId}
         * @param anycastIpListId The ID of the Anycast static IP list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anycastIpListId(java.lang.String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionGroupProps#getEnabled}
         * @param enabled Whether the connection group is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionGroupProps#getEnabled}
         * @param enabled Whether the connection group is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionGroupProps#getIpv6Enabled}
         * @param ipv6Enabled IPv6 is enabled for the connection group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Enabled(java.lang.Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionGroupProps#getIpv6Enabled}
         * @param ipv6Enabled IPv6 is enabled for the connection group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Enabled(software.amazon.awscdk.IResolvable ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionGroupProps#getTags}
         * @param tags A complex type that contains zero or more <code>Tag</code> elements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectionGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectionGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectionGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectionGroupProps {
        private final java.lang.String name;
        private final java.lang.String anycastIpListId;
        private final java.lang.Object enabled;
        private final java.lang.Object ipv6Enabled;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.anycastIpListId = software.amazon.jsii.Kernel.get(this, "anycastIpListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ipv6Enabled = software.amazon.jsii.Kernel.get(this, "ipv6Enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.anycastIpListId = builder.anycastIpListId;
            this.enabled = builder.enabled;
            this.ipv6Enabled = builder.ipv6Enabled;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getAnycastIpListId() {
            return this.anycastIpListId;
        }

        @Override
        public final java.lang.Object getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.Object getIpv6Enabled() {
            return this.ipv6Enabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getAnycastIpListId() != null) {
                data.set("anycastIpListId", om.valueToTree(this.getAnycastIpListId()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getIpv6Enabled() != null) {
                data.set("ipv6Enabled", om.valueToTree(this.getIpv6Enabled()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnConnectionGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectionGroupProps.Jsii$Proxy that = (CfnConnectionGroupProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.anycastIpListId != null ? !this.anycastIpListId.equals(that.anycastIpListId) : that.anycastIpListId != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.ipv6Enabled != null ? !this.ipv6Enabled.equals(that.ipv6Enabled) : that.ipv6Enabled != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.anycastIpListId != null ? this.anycastIpListId.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.ipv6Enabled != null ? this.ipv6Enabled.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
