package software.amazon.awscdk.services.cloudfront;

/**
 * Represents a distribution origin, that describes the Amazon S3 bucket, HTTP server (for example, a web server), Amazon MediaStore, or other server from which CloudFront gets your files.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.245Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.OriginBase")
public abstract class OriginBase extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudfront.IOrigin {

    protected OriginBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OriginBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param domainName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected OriginBase(final @org.jetbrains.annotations.NotNull java.lang.String domainName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(domainName, "domainName is required"), props });
    }

    /**
     * @param domainName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected OriginBase(final @org.jetbrains.annotations.NotNull java.lang.String domainName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(domainName, "domainName is required") });
    }

    /**
     * Binds the origin to the associated Distribution.
     * <p>
     * Can be used to grant permissions, create dependent resources, etc.
     * <p>
     * @param scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginBindConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.OriginBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginBindConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomOriginConfigProperty renderCustomOriginConfig() {
        return software.amazon.jsii.Kernel.call(this, "renderCustomOriginConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomOriginConfigProperty.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistribution.S3OriginConfigProperty renderS3OriginConfig() {
        return software.amazon.jsii.Kernel.call(this, "renderS3OriginConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CfnDistribution.S3OriginConfigProperty.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistribution.VpcOriginConfigProperty renderVpcOriginConfig() {
        return software.amazon.jsii.Kernel.call(this, "renderVpcOriginConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CfnDistribution.VpcOriginConfigProperty.class));
    }

    /**
     * Validates that responseCompletionTimeout is greater than or equal to readTimeout when both are specified.
     * <p>
     * This method should be called by subclasses that support readTimeout.
     * <p>
     * @param responseCompletionTimeout
     * @param readTimeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void validateResponseCompletionTimeoutWithReadTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration responseCompletionTimeout, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration readTimeout) {
        software.amazon.jsii.Kernel.call(this, "validateResponseCompletionTimeoutWithReadTimeout", software.amazon.jsii.NativeType.VOID, new Object[] { responseCompletionTimeout, readTimeout });
    }

    /**
     * Validates that responseCompletionTimeout is greater than or equal to readTimeout when both are specified.
     * <p>
     * This method should be called by subclasses that support readTimeout.
     * <p>
     * @param responseCompletionTimeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void validateResponseCompletionTimeoutWithReadTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration responseCompletionTimeout) {
        software.amazon.jsii.Kernel.call(this, "validateResponseCompletionTimeoutWithReadTimeout", software.amazon.jsii.NativeType.VOID, new Object[] { responseCompletionTimeout });
    }

    /**
     * Validates that responseCompletionTimeout is greater than or equal to readTimeout when both are specified.
     * <p>
     * This method should be called by subclasses that support readTimeout.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void validateResponseCompletionTimeoutWithReadTimeout() {
        software.amazon.jsii.Kernel.call(this, "validateResponseCompletionTimeoutWithReadTimeout", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.cloudfront.OriginBase implements software.amazon.awscdk.services.cloudfront.IOrigin.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
