package software.amazon.awscdk.services.cloudwatch;

/**
 * The sort possibilities for AlarmStatusWidgets.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * Alarm errorAlarm;
 * dashboard.addWidgets(AlarmStatusWidget.Builder.create()
 *         .title("Errors")
 *         .alarms(List.of(errorAlarm))
 *         .sortBy(AlarmStatusWidgetSortBy.STATE_UPDATED_TIMESTAMP)
 *         .states(List.of(AlarmState.ALARM))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.445Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.AlarmStatusWidgetSortBy")
public enum AlarmStatusWidgetSortBy {
    /**
     * Choose DEFAULT to sort them in alphabetical order by alarm name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFAULT,
    /**
     * Choose STATE_UPDATED_TIMESTAMP to sort them first by alarm state, with alarms in ALARM state first, INSUFFICIENT_DATA alarms next, and OK alarms last.
     * <p>
     * Within each group, the alarms are sorted by when they last changed state, with more recent state changes listed first.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STATE_UPDATED_TIMESTAMP,
    /**
     * Choose TIMESTAMP to sort them by the time when the alarms most recently changed state, no matter the current alarm state.
     * <p>
     * The alarm that changed state most recently is listed first.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TIMESTAMP,
}
