package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for defining a <code>CfnCompositeAlarm</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * CfnCompositeAlarmProps cfnCompositeAlarmProps = CfnCompositeAlarmProps.builder()
 *         .alarmRule("alarmRule")
 *         // the properties below are optional
 *         .actionsEnabled(false)
 *         .actionsSuppressor("actionsSuppressor")
 *         .actionsSuppressorExtensionPeriod(123)
 *         .actionsSuppressorWaitPeriod(123)
 *         .alarmActions(List.of("alarmActions"))
 *         .alarmDescription("alarmDescription")
 *         .alarmName("alarmName")
 *         .insufficientDataActions(List.of("insufficientDataActions"))
 *         .okActions(List.of("okActions"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.481Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnCompositeAlarmProps")
@software.amazon.jsii.Jsii.Proxy(CfnCompositeAlarmProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCompositeAlarmProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state.
     * <p>
     * For each alarm that you reference, you designate a function that specifies whether that alarm needs to be in ALARM state, OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR and NOT) to combine multiple functions in a single expression. You can use parenthesis to logically group the functions in your expression.
     * <p>
     * You can use either alarm names or ARNs to reference the other alarms that are to be evaluated.
     * <p>
     * Functions can include the following:
     * <p>
     * <ul>
     * <li>ALARM("alarm-name or alarm-ARN") is TRUE if the named alarm is in ALARM state.</li>
     * <li>OK("alarm-name or alarm-ARN") is TRUE if the named alarm is in OK state.</li>
     * <li>INSUFFICIENT_DATA("alarm-name or alarm-ARN") is TRUE if the named alarm is in INSUFFICIENT_DATA state.</li>
     * <li>TRUE always evaluates to TRUE.</li>
     * <li>FALSE always evaluates to FALSE.</li>
     * </ul>
     * <p>
     * TRUE and FALSE are useful for testing a complex AlarmRule structure, and for testing your alarm actions.
     * <p>
     * For more information about <code>AlarmRule</code> syntax, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmrule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAlarmRule();

    /**
     * Indicates whether actions should be executed during any changes to the alarm state of the composite alarm.
     * <p>
     * The default is TRUE.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getActionsEnabled() {
        return null;
    }

    /**
     * Actions will be suppressed if the suppressor alarm is in the <code>ALARM</code> state.
     * <p>
     * <code>ActionsSuppressor</code> can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.cloudwatch.IAlarmRef} or {@link software.amazon.awscdk.interfaces.cloudwatch.ICompositeAlarmRef}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressor</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getActionsSuppressor() {
        return null;
    }

    /**
     * The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the <code>ALARM</code> state.
     * <p>
     * After this time, the composite alarm performs its actions.
     * <p>
     * <blockquote>
     * <p>
     * <code>ExtensionPeriod</code> is required only when <code>ActionsSuppressor</code> is specified.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressorextensionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressorextensionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getActionsSuppressorExtensionPeriod() {
        return null;
    }

    /**
     * The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the <code>ALARM</code> state.
     * <p>
     * After this time, the composite alarm performs its actions.
     * <p>
     * <blockquote>
     * <p>
     * <code>WaitPeriod</code> is required only when <code>ActionsSuppressor</code> is specified.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressorwaitperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressorwaitperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getActionsSuppressorWaitPeriod() {
        return null;
    }

    /**
     * The actions to execute when this alarm transitions to the ALARM state from any other state.
     * <p>
     * Each action is specified as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
     * <p>
     * Returns union: List<either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.sns.ITopicRef}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmactions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> getAlarmActions() {
        return null;
    }

    /**
     * The description for the composite alarm.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmdescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmDescription() {
        return null;
    }

    /**
     * The name for the composite alarm.
     * <p>
     * This name must be unique within your AWS account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmName() {
        return null;
    }

    /**
     * The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state.
     * <p>
     * Each action is specified as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-insufficientdataactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-insufficientdataactions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInsufficientDataActions() {
        return null;
    }

    /**
     * The actions to execute when this alarm transitions to the OK state from any other state.
     * <p>
     * Each action is specified as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
     * <p>
     * Returns union: List<either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.sns.ITopicRef}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-okactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-okactions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> getOkActions() {
        return null;
    }

    /**
     * A list of key-value pairs to associate with the alarm.
     * <p>
     * You can associate as many as 50 tags with an alarm. To be able to associate tags with the alarm when you create the alarm, you must have the <code>cloudwatch:TagResource</code> permission.
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCompositeAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCompositeAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCompositeAlarmProps> {
        java.lang.String alarmRule;
        java.lang.Object actionsEnabled;
        java.lang.Object actionsSuppressor;
        java.lang.Number actionsSuppressorExtensionPeriod;
        java.lang.Number actionsSuppressorWaitPeriod;
        java.util.List<java.lang.Object> alarmActions;
        java.lang.String alarmDescription;
        java.lang.String alarmName;
        java.util.List<java.lang.String> insufficientDataActions;
        java.util.List<java.lang.Object> okActions;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getAlarmRule}
         * @param alarmRule An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. This parameter is required.
         *                  For each alarm that you reference, you designate a function that specifies whether that alarm needs to be in ALARM state, OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR and NOT) to combine multiple functions in a single expression. You can use parenthesis to logically group the functions in your expression.
         *                  <p>
         *                  You can use either alarm names or ARNs to reference the other alarms that are to be evaluated.
         *                  <p>
         *                  Functions can include the following:
         *                  <p>
         *                  <ul>
         *                  <li>ALARM("alarm-name or alarm-ARN") is TRUE if the named alarm is in ALARM state.</li>
         *                  <li>OK("alarm-name or alarm-ARN") is TRUE if the named alarm is in OK state.</li>
         *                  <li>INSUFFICIENT_DATA("alarm-name or alarm-ARN") is TRUE if the named alarm is in INSUFFICIENT_DATA state.</li>
         *                  <li>TRUE always evaluates to TRUE.</li>
         *                  <li>FALSE always evaluates to FALSE.</li>
         *                  </ul>
         *                  <p>
         *                  TRUE and FALSE are useful for testing a complex AlarmRule structure, and for testing your alarm actions.
         *                  <p>
         *                  For more information about <code>AlarmRule</code> syntax, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmRule(java.lang.String alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getActionsEnabled}
         * @param actionsEnabled Indicates whether actions should be executed during any changes to the alarm state of the composite alarm.
         *                       The default is TRUE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(java.lang.Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getActionsEnabled}
         * @param actionsEnabled Indicates whether actions should be executed during any changes to the alarm state of the composite alarm.
         *                       The default is TRUE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(software.amazon.awscdk.IResolvable actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getActionsSuppressor}
         * @param actionsSuppressor Actions will be suppressed if the suppressor alarm is in the <code>ALARM</code> state.
         *                          <code>ActionsSuppressor</code> can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressor(java.lang.String actionsSuppressor) {
            this.actionsSuppressor = actionsSuppressor;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getActionsSuppressor}
         * @param actionsSuppressor Actions will be suppressed if the suppressor alarm is in the <code>ALARM</code> state.
         *                          <code>ActionsSuppressor</code> can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressor(software.amazon.awscdk.interfaces.cloudwatch.IAlarmRef actionsSuppressor) {
            this.actionsSuppressor = actionsSuppressor;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getActionsSuppressor}
         * @param actionsSuppressor Actions will be suppressed if the suppressor alarm is in the <code>ALARM</code> state.
         *                          <code>ActionsSuppressor</code> can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressor(software.amazon.awscdk.interfaces.cloudwatch.ICompositeAlarmRef actionsSuppressor) {
            this.actionsSuppressor = actionsSuppressor;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getActionsSuppressorExtensionPeriod}
         * @param actionsSuppressorExtensionPeriod The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the <code>ALARM</code> state.
         *                                         After this time, the composite alarm performs its actions.
         *                                         <p>
         *                                         <blockquote>
         *                                         <p>
         *                                         <code>ExtensionPeriod</code> is required only when <code>ActionsSuppressor</code> is specified.
         *                                         <p>
         *                                         </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressorExtensionPeriod(java.lang.Number actionsSuppressorExtensionPeriod) {
            this.actionsSuppressorExtensionPeriod = actionsSuppressorExtensionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getActionsSuppressorWaitPeriod}
         * @param actionsSuppressorWaitPeriod The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the <code>ALARM</code> state.
         *                                    After this time, the composite alarm performs its actions.
         *                                    <p>
         *                                    <blockquote>
         *                                    <p>
         *                                    <code>WaitPeriod</code> is required only when <code>ActionsSuppressor</code> is specified.
         *                                    <p>
         *                                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressorWaitPeriod(java.lang.Number actionsSuppressorWaitPeriod) {
            this.actionsSuppressorWaitPeriod = actionsSuppressorWaitPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getAlarmActions}
         * @param alarmActions The actions to execute when this alarm transitions to the ALARM state from any other state.
         *                     Each action is specified as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder alarmActions(java.util.List<? extends java.lang.Object> alarmActions) {
            this.alarmActions = (java.util.List<java.lang.Object>)alarmActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getAlarmDescription}
         * @param alarmDescription The description for the composite alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmDescription(java.lang.String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getAlarmName}
         * @param alarmName The name for the composite alarm.
         *                  This name must be unique within your AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmName(java.lang.String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getInsufficientDataActions}
         * @param insufficientDataActions The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state.
         *                                Each action is specified as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insufficientDataActions(java.util.List<java.lang.String> insufficientDataActions) {
            this.insufficientDataActions = insufficientDataActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getOkActions}
         * @param okActions The actions to execute when this alarm transitions to the OK state from any other state.
         *                  Each action is specified as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder okActions(java.util.List<? extends java.lang.Object> okActions) {
            this.okActions = (java.util.List<java.lang.Object>)okActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCompositeAlarmProps#getTags}
         * @param tags A list of key-value pairs to associate with the alarm.
         *             You can associate as many as 50 tags with an alarm. To be able to associate tags with the alarm when you create the alarm, you must have the <code>cloudwatch:TagResource</code> permission.
         *             <p>
         *             Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCompositeAlarmProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCompositeAlarmProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCompositeAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCompositeAlarmProps {
        private final java.lang.String alarmRule;
        private final java.lang.Object actionsEnabled;
        private final java.lang.Object actionsSuppressor;
        private final java.lang.Number actionsSuppressorExtensionPeriod;
        private final java.lang.Number actionsSuppressorWaitPeriod;
        private final java.util.List<java.lang.Object> alarmActions;
        private final java.lang.String alarmDescription;
        private final java.lang.String alarmName;
        private final java.util.List<java.lang.String> insufficientDataActions;
        private final java.util.List<java.lang.Object> okActions;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alarmRule = software.amazon.jsii.Kernel.get(this, "alarmRule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.actionsEnabled = software.amazon.jsii.Kernel.get(this, "actionsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.actionsSuppressor = software.amazon.jsii.Kernel.get(this, "actionsSuppressor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.actionsSuppressorExtensionPeriod = software.amazon.jsii.Kernel.get(this, "actionsSuppressorExtensionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.actionsSuppressorWaitPeriod = software.amazon.jsii.Kernel.get(this, "actionsSuppressorWaitPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.alarmActions = software.amazon.jsii.Kernel.get(this, "alarmActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.alarmDescription = software.amazon.jsii.Kernel.get(this, "alarmDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.insufficientDataActions = software.amazon.jsii.Kernel.get(this, "insufficientDataActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.okActions = software.amazon.jsii.Kernel.get(this, "okActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alarmRule = java.util.Objects.requireNonNull(builder.alarmRule, "alarmRule is required");
            this.actionsEnabled = builder.actionsEnabled;
            this.actionsSuppressor = builder.actionsSuppressor;
            this.actionsSuppressorExtensionPeriod = builder.actionsSuppressorExtensionPeriod;
            this.actionsSuppressorWaitPeriod = builder.actionsSuppressorWaitPeriod;
            this.alarmActions = (java.util.List<java.lang.Object>)builder.alarmActions;
            this.alarmDescription = builder.alarmDescription;
            this.alarmName = builder.alarmName;
            this.insufficientDataActions = builder.insufficientDataActions;
            this.okActions = (java.util.List<java.lang.Object>)builder.okActions;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAlarmRule() {
            return this.alarmRule;
        }

        @Override
        public final java.lang.Object getActionsEnabled() {
            return this.actionsEnabled;
        }

        @Override
        public final java.lang.Object getActionsSuppressor() {
            return this.actionsSuppressor;
        }

        @Override
        public final java.lang.Number getActionsSuppressorExtensionPeriod() {
            return this.actionsSuppressorExtensionPeriod;
        }

        @Override
        public final java.lang.Number getActionsSuppressorWaitPeriod() {
            return this.actionsSuppressorWaitPeriod;
        }

        @Override
        public final java.util.List<java.lang.Object> getAlarmActions() {
            return this.alarmActions;
        }

        @Override
        public final java.lang.String getAlarmDescription() {
            return this.alarmDescription;
        }

        @Override
        public final java.lang.String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final java.util.List<java.lang.String> getInsufficientDataActions() {
            return this.insufficientDataActions;
        }

        @Override
        public final java.util.List<java.lang.Object> getOkActions() {
            return this.okActions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alarmRule", om.valueToTree(this.getAlarmRule()));
            if (this.getActionsEnabled() != null) {
                data.set("actionsEnabled", om.valueToTree(this.getActionsEnabled()));
            }
            if (this.getActionsSuppressor() != null) {
                data.set("actionsSuppressor", om.valueToTree(this.getActionsSuppressor()));
            }
            if (this.getActionsSuppressorExtensionPeriod() != null) {
                data.set("actionsSuppressorExtensionPeriod", om.valueToTree(this.getActionsSuppressorExtensionPeriod()));
            }
            if (this.getActionsSuppressorWaitPeriod() != null) {
                data.set("actionsSuppressorWaitPeriod", om.valueToTree(this.getActionsSuppressorWaitPeriod()));
            }
            if (this.getAlarmActions() != null) {
                data.set("alarmActions", om.valueToTree(this.getAlarmActions()));
            }
            if (this.getAlarmDescription() != null) {
                data.set("alarmDescription", om.valueToTree(this.getAlarmDescription()));
            }
            if (this.getAlarmName() != null) {
                data.set("alarmName", om.valueToTree(this.getAlarmName()));
            }
            if (this.getInsufficientDataActions() != null) {
                data.set("insufficientDataActions", om.valueToTree(this.getInsufficientDataActions()));
            }
            if (this.getOkActions() != null) {
                data.set("okActions", om.valueToTree(this.getOkActions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnCompositeAlarmProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCompositeAlarmProps.Jsii$Proxy that = (CfnCompositeAlarmProps.Jsii$Proxy) o;

            if (!alarmRule.equals(that.alarmRule)) return false;
            if (this.actionsEnabled != null ? !this.actionsEnabled.equals(that.actionsEnabled) : that.actionsEnabled != null) return false;
            if (this.actionsSuppressor != null ? !this.actionsSuppressor.equals(that.actionsSuppressor) : that.actionsSuppressor != null) return false;
            if (this.actionsSuppressorExtensionPeriod != null ? !this.actionsSuppressorExtensionPeriod.equals(that.actionsSuppressorExtensionPeriod) : that.actionsSuppressorExtensionPeriod != null) return false;
            if (this.actionsSuppressorWaitPeriod != null ? !this.actionsSuppressorWaitPeriod.equals(that.actionsSuppressorWaitPeriod) : that.actionsSuppressorWaitPeriod != null) return false;
            if (this.alarmActions != null ? !this.alarmActions.equals(that.alarmActions) : that.alarmActions != null) return false;
            if (this.alarmDescription != null ? !this.alarmDescription.equals(that.alarmDescription) : that.alarmDescription != null) return false;
            if (this.alarmName != null ? !this.alarmName.equals(that.alarmName) : that.alarmName != null) return false;
            if (this.insufficientDataActions != null ? !this.insufficientDataActions.equals(that.insufficientDataActions) : that.insufficientDataActions != null) return false;
            if (this.okActions != null ? !this.okActions.equals(that.okActions) : that.okActions != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alarmRule.hashCode();
            result = 31 * result + (this.actionsEnabled != null ? this.actionsEnabled.hashCode() : 0);
            result = 31 * result + (this.actionsSuppressor != null ? this.actionsSuppressor.hashCode() : 0);
            result = 31 * result + (this.actionsSuppressorExtensionPeriod != null ? this.actionsSuppressorExtensionPeriod.hashCode() : 0);
            result = 31 * result + (this.actionsSuppressorWaitPeriod != null ? this.actionsSuppressorWaitPeriod.hashCode() : 0);
            result = 31 * result + (this.alarmActions != null ? this.alarmActions.hashCode() : 0);
            result = 31 * result + (this.alarmDescription != null ? this.alarmDescription.hashCode() : 0);
            result = 31 * result + (this.alarmName != null ? this.alarmName.hashCode() : 0);
            result = 31 * result + (this.insufficientDataActions != null ? this.insufficientDataActions.hashCode() : 0);
            result = 31 * result + (this.okActions != null ? this.okActions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
