package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for a GraphWidget.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * dashboard.addWidgets(GraphWidget.Builder.create()
 *         // ...
 *         .accountId("123456789012")
 *         .build());
 * dashboard.addWidgets(LogQueryWidget.Builder.create()
 *         .logGroupNames(List.of("my-log-group"))
 *         // ...
 *         .accountId("123456789012")
 *         .queryLines(List.of("fields &#64;message"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.519Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.GraphWidgetProps")
@software.amazon.jsii.Jsii.Proxy(GraphWidgetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GraphWidgetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.MetricWidgetProps {

    /**
     * Whether the graph should show labels on the chart.
     * <p>
     * Currently only applicable for Pie charts.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisplayLabelsOnChart() {
        return null;
    }

    /**
     * The end of the time range to use for each widget independently from those of the dashboard.
     * <p>
     * If you specify a value for end, you must also specify a value for start.
     * Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
     * <p>
     * Default: When the dashboard loads, the end date will be the current time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnd() {
        return null;
    }

    /**
     * Metrics to display on left Y axis.
     * <p>
     * Default: - No metrics
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getLeft() {
        return null;
    }

    /**
     * Annotations for the left Y axis.
     * <p>
     * Default: - No annotations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> getLeftAnnotations() {
        return null;
    }

    /**
     * Left Y axis.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.YAxisProps getLeftYAxis() {
        return null;
    }

    /**
     * Position of the legend.
     * <p>
     * Default: - bottom
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.LegendPosition getLegendPosition() {
        return null;
    }

    /**
     * Whether the graph should show live data.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLiveData() {
        return null;
    }

    /**
     * The default period for all metrics in this widget.
     * <p>
     * The period is the length of time represented by one data point on the graph.
     * This default can be overridden within each metric definition.
     * <p>
     * Default: cdk.Duration.seconds(300)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getPeriod() {
        return null;
    }

    /**
     * Metrics to display on right Y axis.
     * <p>
     * Default: - No metrics
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getRight() {
        return null;
    }

    /**
     * Annotations for the right Y axis.
     * <p>
     * Default: - No annotations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> getRightAnnotations() {
        return null;
    }

    /**
     * Right Y axis.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.YAxisProps getRightYAxis() {
        return null;
    }

    /**
     * Whether to show the value from the entire time range. Only applicable for Bar and Pie charts.
     * <p>
     * If false, values will be from the most recent period of your chosen time range;
     * if true, shows the value from the entire time range.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSetPeriodToTimeRange() {
        return null;
    }

    /**
     * Whether the graph should be shown as stacked lines.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStacked() {
        return null;
    }

    /**
     * The start of the time range to use for each widget independently from those of the dashboard.
     * <p>
     * You can specify start without specifying end to specify a relative time range that ends with the current time.
     * In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for
     * minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months.
     * You can also use start along with an end field, to specify an absolute time range.
     * When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
     * <p>
     * Default: When the dashboard loads, the start time will be the default time range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStart() {
        return null;
    }

    /**
     * The default statistic to be displayed for each metric.
     * <p>
     * This default can be overridden within the definition of each individual metric
     * <p>
     * Default: - The statistic for each metric is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
        return null;
    }

    /**
     * Annotations for the X axis.
     * <p>
     * Default: - No annotations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.VerticalAnnotation> getVerticalAnnotations() {
        return null;
    }

    /**
     * Display this metric.
     * <p>
     * Default: TimeSeries
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.GraphWidgetView getView() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GraphWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GraphWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GraphWidgetProps> {
        java.lang.Boolean displayLabelsOnChart;
        java.lang.String end;
        java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> left;
        java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> leftAnnotations;
        software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis;
        software.amazon.awscdk.services.cloudwatch.LegendPosition legendPosition;
        java.lang.Boolean liveData;
        software.amazon.awscdk.Duration period;
        java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> right;
        java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> rightAnnotations;
        software.amazon.awscdk.services.cloudwatch.YAxisProps rightYAxis;
        java.lang.Boolean setPeriodToTimeRange;
        java.lang.Boolean stacked;
        java.lang.String start;
        java.lang.String statistic;
        java.util.List<software.amazon.awscdk.services.cloudwatch.VerticalAnnotation> verticalAnnotations;
        software.amazon.awscdk.services.cloudwatch.GraphWidgetView view;
        java.lang.String accountId;
        java.lang.Number height;
        java.lang.String region;
        java.lang.String title;
        java.lang.Number width;

        /**
         * Sets the value of {@link GraphWidgetProps#getDisplayLabelsOnChart}
         * @param displayLabelsOnChart Whether the graph should show labels on the chart.
         *                             Currently only applicable for Pie charts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayLabelsOnChart(java.lang.Boolean displayLabelsOnChart) {
            this.displayLabelsOnChart = displayLabelsOnChart;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getEnd}
         * @param end The end of the time range to use for each widget independently from those of the dashboard.
         *            If you specify a value for end, you must also specify a value for start.
         *            Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder end(java.lang.String end) {
            this.end = end;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getLeft}
         * @param left Metrics to display on left Y axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder left(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IMetric> left) {
            this.left = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)left;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getLeftAnnotations}
         * @param leftAnnotations Annotations for the left Y axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder leftAnnotations(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> leftAnnotations) {
            this.leftAnnotations = (java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation>)leftAnnotations;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getLeftYAxis}
         * @param leftYAxis Left Y axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder leftYAxis(software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis) {
            this.leftYAxis = leftYAxis;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getLegendPosition}
         * @param legendPosition Position of the legend.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder legendPosition(software.amazon.awscdk.services.cloudwatch.LegendPosition legendPosition) {
            this.legendPosition = legendPosition;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getLiveData}
         * @param liveData Whether the graph should show live data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder liveData(java.lang.Boolean liveData) {
            this.liveData = liveData;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getPeriod}
         * @param period The default period for all metrics in this widget.
         *               The period is the length of time represented by one data point on the graph.
         *               This default can be overridden within each metric definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getRight}
         * @param right Metrics to display on right Y axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder right(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IMetric> right) {
            this.right = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)right;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getRightAnnotations}
         * @param rightAnnotations Annotations for the right Y axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder rightAnnotations(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> rightAnnotations) {
            this.rightAnnotations = (java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation>)rightAnnotations;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getRightYAxis}
         * @param rightYAxis Right Y axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rightYAxis(software.amazon.awscdk.services.cloudwatch.YAxisProps rightYAxis) {
            this.rightYAxis = rightYAxis;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getSetPeriodToTimeRange}
         * @param setPeriodToTimeRange Whether to show the value from the entire time range. Only applicable for Bar and Pie charts.
         *                             If false, values will be from the most recent period of your chosen time range;
         *                             if true, shows the value from the entire time range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setPeriodToTimeRange(java.lang.Boolean setPeriodToTimeRange) {
            this.setPeriodToTimeRange = setPeriodToTimeRange;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getStacked}
         * @param stacked Whether the graph should be shown as stacked lines.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stacked(java.lang.Boolean stacked) {
            this.stacked = stacked;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getStart}
         * @param start The start of the time range to use for each widget independently from those of the dashboard.
         *              You can specify start without specifying end to specify a relative time range that ends with the current time.
         *              In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for
         *              minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months.
         *              You can also use start along with an end field, to specify an absolute time range.
         *              When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder start(java.lang.String start) {
            this.start = start;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getStatistic}
         * @param statistic The default statistic to be displayed for each metric.
         *                  This default can be overridden within the definition of each individual metric
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getVerticalAnnotations}
         * @param verticalAnnotations Annotations for the X axis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder verticalAnnotations(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.VerticalAnnotation> verticalAnnotations) {
            this.verticalAnnotations = (java.util.List<software.amazon.awscdk.services.cloudwatch.VerticalAnnotation>)verticalAnnotations;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getView}
         * @param view Display this metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder view(software.amazon.awscdk.services.cloudwatch.GraphWidgetView view) {
            this.view = view;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getAccountId}
         * @param accountId The AWS account ID where the metrics are located.
         *                  This enables cross-account functionality for CloudWatch dashboards.
         *                  Before using this feature, ensure that proper cross-account sharing is configured
         *                  between the monitoring account and source account.
         *                  <p>
         *                  For more information, see:
         *                  https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountId(java.lang.String accountId) {
            this.accountId = accountId;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getHeight}
         * @param height Height of the widget.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(java.lang.Number height) {
            this.height = height;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getRegion}
         * @param region The region the metrics of this graph should be taken from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getTitle}
         * @param title Title for the graph.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(java.lang.String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the value of {@link GraphWidgetProps#getWidth}
         * @param width Width of the widget, in a grid of 24 units wide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(java.lang.Number width) {
            this.width = width;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GraphWidgetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GraphWidgetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GraphWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GraphWidgetProps {
        private final java.lang.Boolean displayLabelsOnChart;
        private final java.lang.String end;
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> left;
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> leftAnnotations;
        private final software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis;
        private final software.amazon.awscdk.services.cloudwatch.LegendPosition legendPosition;
        private final java.lang.Boolean liveData;
        private final software.amazon.awscdk.Duration period;
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> right;
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> rightAnnotations;
        private final software.amazon.awscdk.services.cloudwatch.YAxisProps rightYAxis;
        private final java.lang.Boolean setPeriodToTimeRange;
        private final java.lang.Boolean stacked;
        private final java.lang.String start;
        private final java.lang.String statistic;
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.VerticalAnnotation> verticalAnnotations;
        private final software.amazon.awscdk.services.cloudwatch.GraphWidgetView view;
        private final java.lang.String accountId;
        private final java.lang.Number height;
        private final java.lang.String region;
        private final java.lang.String title;
        private final java.lang.Number width;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.displayLabelsOnChart = software.amazon.jsii.Kernel.get(this, "displayLabelsOnChart", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.left = software.amazon.jsii.Kernel.get(this, "left", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class)));
            this.leftAnnotations = software.amazon.jsii.Kernel.get(this, "leftAnnotations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation.class)));
            this.leftYAxis = software.amazon.jsii.Kernel.get(this, "leftYAxis", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.YAxisProps.class));
            this.legendPosition = software.amazon.jsii.Kernel.get(this, "legendPosition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.LegendPosition.class));
            this.liveData = software.amazon.jsii.Kernel.get(this, "liveData", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.right = software.amazon.jsii.Kernel.get(this, "right", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class)));
            this.rightAnnotations = software.amazon.jsii.Kernel.get(this, "rightAnnotations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation.class)));
            this.rightYAxis = software.amazon.jsii.Kernel.get(this, "rightYAxis", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.YAxisProps.class));
            this.setPeriodToTimeRange = software.amazon.jsii.Kernel.get(this, "setPeriodToTimeRange", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.stacked = software.amazon.jsii.Kernel.get(this, "stacked", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.verticalAnnotations = software.amazon.jsii.Kernel.get(this, "verticalAnnotations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.VerticalAnnotation.class)));
            this.view = software.amazon.jsii.Kernel.get(this, "view", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.GraphWidgetView.class));
            this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.height = software.amazon.jsii.Kernel.get(this, "height", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.width = software.amazon.jsii.Kernel.get(this, "width", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.displayLabelsOnChart = builder.displayLabelsOnChart;
            this.end = builder.end;
            this.left = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)builder.left;
            this.leftAnnotations = (java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation>)builder.leftAnnotations;
            this.leftYAxis = builder.leftYAxis;
            this.legendPosition = builder.legendPosition;
            this.liveData = builder.liveData;
            this.period = builder.period;
            this.right = (java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric>)builder.right;
            this.rightAnnotations = (java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation>)builder.rightAnnotations;
            this.rightYAxis = builder.rightYAxis;
            this.setPeriodToTimeRange = builder.setPeriodToTimeRange;
            this.stacked = builder.stacked;
            this.start = builder.start;
            this.statistic = builder.statistic;
            this.verticalAnnotations = (java.util.List<software.amazon.awscdk.services.cloudwatch.VerticalAnnotation>)builder.verticalAnnotations;
            this.view = builder.view;
            this.accountId = builder.accountId;
            this.height = builder.height;
            this.region = builder.region;
            this.title = builder.title;
            this.width = builder.width;
        }

        @Override
        public final java.lang.Boolean getDisplayLabelsOnChart() {
            return this.displayLabelsOnChart;
        }

        @Override
        public final java.lang.String getEnd() {
            return this.end;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getLeft() {
            return this.left;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> getLeftAnnotations() {
            return this.leftAnnotations;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.YAxisProps getLeftYAxis() {
            return this.leftYAxis;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.LegendPosition getLegendPosition() {
            return this.legendPosition;
        }

        @Override
        public final java.lang.Boolean getLiveData() {
            return this.liveData;
        }

        @Override
        public final software.amazon.awscdk.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.IMetric> getRight() {
            return this.right;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> getRightAnnotations() {
            return this.rightAnnotations;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.YAxisProps getRightYAxis() {
            return this.rightYAxis;
        }

        @Override
        public final java.lang.Boolean getSetPeriodToTimeRange() {
            return this.setPeriodToTimeRange;
        }

        @Override
        public final java.lang.Boolean getStacked() {
            return this.stacked;
        }

        @Override
        public final java.lang.String getStart() {
            return this.start;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.VerticalAnnotation> getVerticalAnnotations() {
            return this.verticalAnnotations;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.GraphWidgetView getView() {
            return this.view;
        }

        @Override
        public final java.lang.String getAccountId() {
            return this.accountId;
        }

        @Override
        public final java.lang.Number getHeight() {
            return this.height;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getTitle() {
            return this.title;
        }

        @Override
        public final java.lang.Number getWidth() {
            return this.width;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDisplayLabelsOnChart() != null) {
                data.set("displayLabelsOnChart", om.valueToTree(this.getDisplayLabelsOnChart()));
            }
            if (this.getEnd() != null) {
                data.set("end", om.valueToTree(this.getEnd()));
            }
            if (this.getLeft() != null) {
                data.set("left", om.valueToTree(this.getLeft()));
            }
            if (this.getLeftAnnotations() != null) {
                data.set("leftAnnotations", om.valueToTree(this.getLeftAnnotations()));
            }
            if (this.getLeftYAxis() != null) {
                data.set("leftYAxis", om.valueToTree(this.getLeftYAxis()));
            }
            if (this.getLegendPosition() != null) {
                data.set("legendPosition", om.valueToTree(this.getLegendPosition()));
            }
            if (this.getLiveData() != null) {
                data.set("liveData", om.valueToTree(this.getLiveData()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getRight() != null) {
                data.set("right", om.valueToTree(this.getRight()));
            }
            if (this.getRightAnnotations() != null) {
                data.set("rightAnnotations", om.valueToTree(this.getRightAnnotations()));
            }
            if (this.getRightYAxis() != null) {
                data.set("rightYAxis", om.valueToTree(this.getRightYAxis()));
            }
            if (this.getSetPeriodToTimeRange() != null) {
                data.set("setPeriodToTimeRange", om.valueToTree(this.getSetPeriodToTimeRange()));
            }
            if (this.getStacked() != null) {
                data.set("stacked", om.valueToTree(this.getStacked()));
            }
            if (this.getStart() != null) {
                data.set("start", om.valueToTree(this.getStart()));
            }
            if (this.getStatistic() != null) {
                data.set("statistic", om.valueToTree(this.getStatistic()));
            }
            if (this.getVerticalAnnotations() != null) {
                data.set("verticalAnnotations", om.valueToTree(this.getVerticalAnnotations()));
            }
            if (this.getView() != null) {
                data.set("view", om.valueToTree(this.getView()));
            }
            if (this.getAccountId() != null) {
                data.set("accountId", om.valueToTree(this.getAccountId()));
            }
            if (this.getHeight() != null) {
                data.set("height", om.valueToTree(this.getHeight()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getTitle() != null) {
                data.set("title", om.valueToTree(this.getTitle()));
            }
            if (this.getWidth() != null) {
                data.set("width", om.valueToTree(this.getWidth()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.GraphWidgetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GraphWidgetProps.Jsii$Proxy that = (GraphWidgetProps.Jsii$Proxy) o;

            if (this.displayLabelsOnChart != null ? !this.displayLabelsOnChart.equals(that.displayLabelsOnChart) : that.displayLabelsOnChart != null) return false;
            if (this.end != null ? !this.end.equals(that.end) : that.end != null) return false;
            if (this.left != null ? !this.left.equals(that.left) : that.left != null) return false;
            if (this.leftAnnotations != null ? !this.leftAnnotations.equals(that.leftAnnotations) : that.leftAnnotations != null) return false;
            if (this.leftYAxis != null ? !this.leftYAxis.equals(that.leftYAxis) : that.leftYAxis != null) return false;
            if (this.legendPosition != null ? !this.legendPosition.equals(that.legendPosition) : that.legendPosition != null) return false;
            if (this.liveData != null ? !this.liveData.equals(that.liveData) : that.liveData != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.right != null ? !this.right.equals(that.right) : that.right != null) return false;
            if (this.rightAnnotations != null ? !this.rightAnnotations.equals(that.rightAnnotations) : that.rightAnnotations != null) return false;
            if (this.rightYAxis != null ? !this.rightYAxis.equals(that.rightYAxis) : that.rightYAxis != null) return false;
            if (this.setPeriodToTimeRange != null ? !this.setPeriodToTimeRange.equals(that.setPeriodToTimeRange) : that.setPeriodToTimeRange != null) return false;
            if (this.stacked != null ? !this.stacked.equals(that.stacked) : that.stacked != null) return false;
            if (this.start != null ? !this.start.equals(that.start) : that.start != null) return false;
            if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
            if (this.verticalAnnotations != null ? !this.verticalAnnotations.equals(that.verticalAnnotations) : that.verticalAnnotations != null) return false;
            if (this.view != null ? !this.view.equals(that.view) : that.view != null) return false;
            if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) return false;
            if (this.height != null ? !this.height.equals(that.height) : that.height != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
            return this.width != null ? this.width.equals(that.width) : that.width == null;
        }

        @Override
        public final int hashCode() {
            int result = this.displayLabelsOnChart != null ? this.displayLabelsOnChart.hashCode() : 0;
            result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
            result = 31 * result + (this.left != null ? this.left.hashCode() : 0);
            result = 31 * result + (this.leftAnnotations != null ? this.leftAnnotations.hashCode() : 0);
            result = 31 * result + (this.leftYAxis != null ? this.leftYAxis.hashCode() : 0);
            result = 31 * result + (this.legendPosition != null ? this.legendPosition.hashCode() : 0);
            result = 31 * result + (this.liveData != null ? this.liveData.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
            result = 31 * result + (this.rightAnnotations != null ? this.rightAnnotations.hashCode() : 0);
            result = 31 * result + (this.rightYAxis != null ? this.rightYAxis.hashCode() : 0);
            result = 31 * result + (this.setPeriodToTimeRange != null ? this.setPeriodToTimeRange.hashCode() : 0);
            result = 31 * result + (this.stacked != null ? this.stacked.hashCode() : 0);
            result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
            result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
            result = 31 * result + (this.verticalAnnotations != null ? this.verticalAnnotations.hashCode() : 0);
            result = 31 * result + (this.view != null ? this.view.hashCode() : 0);
            result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
            result = 31 * result + (this.height != null ? this.height.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
            return result;
        }
    }
}
