package software.amazon.awscdk.services.cloudwatch;

/**
 * Logs Query Language.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * dashboard.addWidgets(LogQueryWidget.Builder.create()
 *         .logGroupNames(List.of("my-log-group"))
 *         .view(LogQueryVisualizationType.TABLE)
 *         .queryString("SELECT count(*) as count FROM 'my-log-group'")
 *         .queryLanguage(LogQueryLanguage.SQL)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.523Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.LogQueryLanguage")
public enum LogQueryLanguage {
    /**
     * Logs Insights QL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LOGS_INSIGHTS,
    /**
     * OpenSearch SQL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SQL,
    /**
     * OpenSearch PPL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PPL,
}
