package software.amazon.awscdk.services.codebuild;

/**
 * The compute fleet overflow behavior.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Fleet fleet = Fleet.Builder.create(this, "Fleet")
 *         .computeType(FleetComputeType.MEDIUM)
 *         .environmentType(EnvironmentType.LINUX_CONTAINER)
 *         .baseCapacity(1)
 *         .overflowBehavior(FleetOverflowBehavior.ON_DEMAND)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.694Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.FleetOverflowBehavior")
public enum FleetOverflowBehavior {
    /**
     * Overflow builds wait for existing fleet instances to become available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    QUEUE,
    /**
     * Overflow builds run on CodeBuild on-demand instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ON_DEMAND,
}
