package software.amazon.awscdk.services.codebuild;

/**
 * Construction properties of a CodeBuild Fleet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.Size;
 * Fleet fleet = Fleet.Builder.create(this, "MyFleet")
 *         .baseCapacity(1)
 *         .computeType(FleetComputeType.CUSTOM_INSTANCE_TYPE)
 *         .environmentType(EnvironmentType.LINUX_CONTAINER)
 *         .computeConfiguration(ComputeConfiguration.builder()
 *                 .instanceType(InstanceType.of(InstanceClass.T3, InstanceSize.MEDIUM))
 *                 // By default, 64 GiB of disk space is included. Any value optionally
 *                 // specified here is _incremental_ on top of the included disk space.
 *                 .disk(Size.gibibytes(10))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.694Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.FleetProps")
@software.amazon.jsii.Jsii.Proxy(FleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of machines allocated to the compute ﬂeet. Deﬁnes the number of builds that can run in parallel.
     * <p>
     * Minimum value of 1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getBaseCapacity();

    /**
     * The instance type of the compute fleet.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_codebuild.ComputeType.html">https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_codebuild.ComputeType.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FleetComputeType getComputeType();

    /**
     * The build environment (operating system/architecture/accelerator) type made available to projects using this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.EnvironmentType getEnvironmentType();

    /**
     * The compute configuration of the compute fleet.
     * <p>
     * This is only permitted if <code>computeType</code> is set to ATTRIBUTE_BASED or
     * CUSTOM_INSTANCE_TYPE. In such cases, this is required.
     * <p>
     * Default: - do not specify compute configuration
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.types">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment-reserved-capacity.types</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ComputeConfiguration getComputeConfiguration() {
        return null;
    }

    /**
     * The name of the Fleet.
     * <p>
     * Default: - CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFleetName() {
        return null;
    }

    /**
     * The compute fleet overflow behavior.
     * <p>
     * For overflow behavior <code>QUEUE</code>, overflow builds need to wait on the existing fleet instances to become available.
     * <p>
     * For overflow behavior <code>ON_DEMAND</code>, overflow builds run on CodeBuild on-demand.
     * <p>
     * Default: undefined - AWS CodeBuild default behavior is QUEUE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.FleetOverflowBehavior getOverflowBehavior() {
        return null;
    }

    /**
     * Service Role assumed by Fleet instances.
     * <p>
     * This Role is not used by Project builds running on Fleet instances; Project
     * builds assume the <code>role</code> on Project instead.
     * <p>
     * Default: - A role will be created if any permissions are granted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * What security groups to associate with the fleet's network interfaces. If none are provided, one will be created automatically.
     * <p>
     * Only used if <code>vpc</code> is supplied.
     * <p>
     * Default: - A security group will be automatically created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * Where to place the network interfaces within the VPC.
     * <p>
     * To access AWS services, your fleet needs to be in one of the following types of subnets:
     * <p>
     * <ol>
     * <li>Subnets with access to the internet (of type PRIVATE_WITH_EGRESS).</li>
     * <li>Private subnets unconnected to the internet, but with <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/use-vpc-endpoints-with-codebuild.html">VPC endpoints</a> for the necessary services.</li>
     * </ol>
     * <p>
     * If you don't specify a subnet selection, the default behavior is to use PRIVATE_WITH_EGRESS subnets first if they exist,
     * then PRIVATE_WITHOUT_EGRESS, and finally PUBLIC subnets. If your VPC doesn't have PRIVATE_WITH_EGRESS subnets but you need
     * AWS service access, add VPC Endpoints to your private subnets.
     * <p>
     * Default: - private subnets if available else public subnets
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html">https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * VPC network to place fleet instance network interfaces.
     * <p>
     * Specify this if the fleet needs to access resources in a VPC.
     * <p>
     * Default: - No VPC is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FleetProps> {
        java.lang.Number baseCapacity;
        software.amazon.awscdk.services.codebuild.FleetComputeType computeType;
        software.amazon.awscdk.services.codebuild.EnvironmentType environmentType;
        software.amazon.awscdk.services.codebuild.ComputeConfiguration computeConfiguration;
        java.lang.String fleetName;
        software.amazon.awscdk.services.codebuild.FleetOverflowBehavior overflowBehavior;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link FleetProps#getBaseCapacity}
         * @param baseCapacity The number of machines allocated to the compute ﬂeet. Deﬁnes the number of builds that can run in parallel. This parameter is required.
         *                     Minimum value of 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseCapacity(java.lang.Number baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getComputeType}
         * @param computeType The instance type of the compute fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeType(software.amazon.awscdk.services.codebuild.FleetComputeType computeType) {
            this.computeType = computeType;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getEnvironmentType}
         * @param environmentType The build environment (operating system/architecture/accelerator) type made available to projects using this fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentType(software.amazon.awscdk.services.codebuild.EnvironmentType environmentType) {
            this.environmentType = environmentType;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getComputeConfiguration}
         * @param computeConfiguration The compute configuration of the compute fleet.
         *                             This is only permitted if <code>computeType</code> is set to ATTRIBUTE_BASED or
         *                             CUSTOM_INSTANCE_TYPE. In such cases, this is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeConfiguration(software.amazon.awscdk.services.codebuild.ComputeConfiguration computeConfiguration) {
            this.computeConfiguration = computeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getFleetName}
         * @param fleetName The name of the Fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetName(java.lang.String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getOverflowBehavior}
         * @param overflowBehavior The compute fleet overflow behavior.
         *                         For overflow behavior <code>QUEUE</code>, overflow builds need to wait on the existing fleet instances to become available.
         *                         <p>
         *                         For overflow behavior <code>ON_DEMAND</code>, overflow builds run on CodeBuild on-demand.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overflowBehavior(software.amazon.awscdk.services.codebuild.FleetOverflowBehavior overflowBehavior) {
            this.overflowBehavior = overflowBehavior;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getRole}
         * @param role Service Role assumed by Fleet instances.
         *             This Role is not used by Project builds running on Fleet instances; Project
         *             builds assume the <code>role</code> on Project instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getSecurityGroups}
         * @param securityGroups What security groups to associate with the fleet's network interfaces. If none are provided, one will be created automatically.
         *                       Only used if <code>vpc</code> is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getSubnetSelection}
         * @param subnetSelection Where to place the network interfaces within the VPC.
         *                        To access AWS services, your fleet needs to be in one of the following types of subnets:
         *                        <p>
         *                        <ol>
         *                        <li>Subnets with access to the internet (of type PRIVATE_WITH_EGRESS).</li>
         *                        <li>Private subnets unconnected to the internet, but with <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/use-vpc-endpoints-with-codebuild.html">VPC endpoints</a> for the necessary services.</li>
         *                        </ol>
         *                        <p>
         *                        If you don't specify a subnet selection, the default behavior is to use PRIVATE_WITH_EGRESS subnets first if they exist,
         *                        then PRIVATE_WITHOUT_EGRESS, and finally PUBLIC subnets. If your VPC doesn't have PRIVATE_WITH_EGRESS subnets but you need
         *                        AWS service access, add VPC Endpoints to your private subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link FleetProps#getVpc}
         * @param vpc VPC network to place fleet instance network interfaces.
         *            Specify this if the fleet needs to access resources in a VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetProps {
        private final java.lang.Number baseCapacity;
        private final software.amazon.awscdk.services.codebuild.FleetComputeType computeType;
        private final software.amazon.awscdk.services.codebuild.EnvironmentType environmentType;
        private final software.amazon.awscdk.services.codebuild.ComputeConfiguration computeConfiguration;
        private final java.lang.String fleetName;
        private final software.amazon.awscdk.services.codebuild.FleetOverflowBehavior overflowBehavior;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.baseCapacity = software.amazon.jsii.Kernel.get(this, "baseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.computeType = software.amazon.jsii.Kernel.get(this, "computeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FleetComputeType.class));
            this.environmentType = software.amazon.jsii.Kernel.get(this, "environmentType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.EnvironmentType.class));
            this.computeConfiguration = software.amazon.jsii.Kernel.get(this, "computeConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ComputeConfiguration.class));
            this.fleetName = software.amazon.jsii.Kernel.get(this, "fleetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.overflowBehavior = software.amazon.jsii.Kernel.get(this, "overflowBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FleetOverflowBehavior.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.baseCapacity = java.util.Objects.requireNonNull(builder.baseCapacity, "baseCapacity is required");
            this.computeType = java.util.Objects.requireNonNull(builder.computeType, "computeType is required");
            this.environmentType = java.util.Objects.requireNonNull(builder.environmentType, "environmentType is required");
            this.computeConfiguration = builder.computeConfiguration;
            this.fleetName = builder.fleetName;
            this.overflowBehavior = builder.overflowBehavior;
            this.role = builder.role;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.subnetSelection = builder.subnetSelection;
            this.vpc = builder.vpc;
        }

        @Override
        public final java.lang.Number getBaseCapacity() {
            return this.baseCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.FleetComputeType getComputeType() {
            return this.computeType;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.EnvironmentType getEnvironmentType() {
            return this.environmentType;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.ComputeConfiguration getComputeConfiguration() {
            return this.computeConfiguration;
        }

        @Override
        public final java.lang.String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.FleetOverflowBehavior getOverflowBehavior() {
            return this.overflowBehavior;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("baseCapacity", om.valueToTree(this.getBaseCapacity()));
            data.set("computeType", om.valueToTree(this.getComputeType()));
            data.set("environmentType", om.valueToTree(this.getEnvironmentType()));
            if (this.getComputeConfiguration() != null) {
                data.set("computeConfiguration", om.valueToTree(this.getComputeConfiguration()));
            }
            if (this.getFleetName() != null) {
                data.set("fleetName", om.valueToTree(this.getFleetName()));
            }
            if (this.getOverflowBehavior() != null) {
                data.set("overflowBehavior", om.valueToTree(this.getOverflowBehavior()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.FleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FleetProps.Jsii$Proxy that = (FleetProps.Jsii$Proxy) o;

            if (!baseCapacity.equals(that.baseCapacity)) return false;
            if (!computeType.equals(that.computeType)) return false;
            if (!environmentType.equals(that.environmentType)) return false;
            if (this.computeConfiguration != null ? !this.computeConfiguration.equals(that.computeConfiguration) : that.computeConfiguration != null) return false;
            if (this.fleetName != null ? !this.fleetName.equals(that.fleetName) : that.fleetName != null) return false;
            if (this.overflowBehavior != null ? !this.overflowBehavior.equals(that.overflowBehavior) : that.overflowBehavior != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.baseCapacity.hashCode();
            result = 31 * result + (this.computeType.hashCode());
            result = 31 * result + (this.environmentType.hashCode());
            result = 31 * result + (this.computeConfiguration != null ? this.computeConfiguration.hashCode() : 0);
            result = 31 * result + (this.fleetName != null ? this.fleetName.hashCode() : 0);
            result = 31 * result + (this.overflowBehavior != null ? this.overflowBehavior.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
