package software.amazon.awscdk.services.codebuild;

/**
 * Environment type for Windows Docker images.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Repository ecrRepository;
 * Project.Builder.create(this, "Project")
 *         .environment(BuildEnvironment.builder()
 *                 .buildImage(WindowsBuildImage.fromEcrRepository(ecrRepository, "v1.0", WindowsImageType.SERVER_2019))
 *                 // optional certificate to include in the build image
 *                 .certificate(BuildEnvironmentCertificate.builder()
 *                         .bucket(Bucket.fromBucketName(this, "Bucket", "amzn-s3-demo-bucket"))
 *                         .objectKey("path/to/cert.pem")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.760Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.WindowsImageType")
public enum WindowsImageType {
    /**
     * The standard environment type, WINDOWS_CONTAINER.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * The WINDOWS_SERVER_2019_CONTAINER environment type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SERVER_2019,
    /**
     * The WINDOWS_SERVER_2022_CONTAINER environment type.
     * <p>
     * Notice: Cannot be used with on-demand compute, only with a {@link BuildEnvironment.fleet}.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/fleets.html">https://docs.aws.amazon.com/codebuild/latest/userguide/fleets.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SERVER_2022,
}
