package software.amazon.awscdk.services.codedeploy;

/**
 * Minimum number of healthy hosts for a server deployment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ServerDeploymentConfig deploymentConfig = ServerDeploymentConfig.Builder.create(this, "DeploymentConfiguration")
 *         .deploymentConfigName("MyDeploymentConfiguration") // optional property
 *         // one of these is required, but both cannot be specified at the same time
 *         .minimumHealthyHosts(MinimumHealthyHosts.count(2))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.865Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.MinimumHealthyHosts")
public class MinimumHealthyHosts extends software.amazon.jsii.JsiiObject {

    protected MinimumHealthyHosts(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MinimumHealthyHosts(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * The minimum healthy hosts threshold expressed as an absolute number.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts count(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class, "count", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * The minimum healthy hosts threshold expressed as a percentage of the fleet.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts percentage(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class, "percentage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }
}
